/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    public static final int FORMAT = 0;
    public static final int STANDALONE = 1;
    public static final int WIDE = 4;
    public static final int ABBREVIATED = 3;
    public static final int NARROW = 5;
    String[] eras = null;
    String[] eraNames = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] narrowMonths = null;
    String[] standaloneMonths = null;
    String[] standaloneShortMonths = null;
    String[] standaloneNarrowMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] narrowWeekdays = null;
    String[] standaloneWeekdays = null;
    String[] standaloneShortWeekdays = null;
    String[] standaloneNarrowWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    static final String patternChars = "GyMdkHmsSEDFwWahKzYeugAZvcL";
    String localPatternChars = null;
    private static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private ULocale validLocale;
    private ULocale actualLocale;

    public DateFormatSymbols() {
        this.initializeData(ULocale.getDefault(), "");
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(ULocale.forLocale(locale), "");
    }

    public DateFormatSymbols(ULocale locale) {
        this.initializeData(locale, "");
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] newEras) {
        this.eras = this.duplicate(newEras);
    }

    public String[] getEraNames() {
        return this.duplicate(this.eraNames);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public String[] getMonths(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 4: {
                        returnValue = this.months;
                        break;
                    }
                    case 3: {
                        returnValue = this.shortMonths;
                        break;
                    }
                    case 5: {
                        returnValue = this.narrowMonths;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 4: {
                        returnValue = this.standaloneMonths;
                        break block0;
                    }
                    case 3: {
                        returnValue = this.standaloneShortMonths;
                        break block0;
                    }
                    case 5: {
                        returnValue = this.standaloneNarrowMonths;
                    }
                }
            }
        }
        return this.duplicate(returnValue);
    }

    public void setMonths(String[] newMonths) {
        this.months = this.duplicate(newMonths);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = this.duplicate(newShortMonths);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public String[] getWeekdays(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 4: {
                        returnValue = this.weekdays;
                        break;
                    }
                    case 3: {
                        returnValue = this.shortWeekdays;
                        break;
                    }
                    case 5: {
                        returnValue = this.narrowWeekdays;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 4: {
                        returnValue = this.standaloneWeekdays;
                        break block0;
                    }
                    case 3: {
                        returnValue = this.standaloneShortWeekdays;
                        break block0;
                    }
                    case 5: {
                        returnValue = this.standaloneNarrowWeekdays;
                    }
                }
            }
        }
        return this.duplicate(returnValue);
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = this.duplicate(newWeekdays);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = this.duplicate(newShortWeekdays);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = this.duplicate(newAmpms);
    }

    public String[][] getZoneStrings() {
        return this.duplicate(this.zoneStrings);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        this.zoneStrings = this.duplicate(newZoneStrings);
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars;
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            this.copyMembers(this, other);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hashcode = 0;
        for (int index = 0; index < this.zoneStrings[0].length; ++index) {
            hashcode ^= this.zoneStrings[0][index].hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Utility.arrayEquals(this.eras, (Object)that.eras) && Utility.arrayEquals(this.eraNames, (Object)that.eraNames) && Utility.arrayEquals(this.months, (Object)that.months) && Utility.arrayEquals(this.shortMonths, (Object)that.shortMonths) && Utility.arrayEquals(this.narrowMonths, (Object)that.narrowMonths) && Utility.arrayEquals(this.standaloneMonths, (Object)that.standaloneMonths) && Utility.arrayEquals(this.standaloneShortMonths, (Object)that.standaloneShortMonths) && Utility.arrayEquals(this.standaloneNarrowMonths, (Object)that.standaloneNarrowMonths) && Utility.arrayEquals(this.weekdays, (Object)that.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)that.shortWeekdays) && Utility.arrayEquals(this.narrowWeekdays, (Object)that.narrowWeekdays) && Utility.arrayEquals(this.standaloneWeekdays, (Object)that.standaloneWeekdays) && Utility.arrayEquals(this.standaloneShortWeekdays, (Object)that.standaloneShortWeekdays) && Utility.arrayEquals(this.standaloneNarrowWeekdays, (Object)that.standaloneNarrowWeekdays) && Utility.arrayEquals(this.ampms, (Object)that.ampms) && Utility.arrayEquals((Object[])this.zoneStrings, (Object)that.zoneStrings) && Utility.arrayEquals(this.localPatternChars, (Object)that.localPatternChars);
    }

    protected void initializeData(ULocale desiredLocale, String type) {
        CalendarData calData = new CalendarData(desiredLocale, type);
        this.initializeData(desiredLocale, calData);
    }

    protected void initializeData(ULocale desiredLocale, CalendarData calData) {
        ICUResourceBundle rb;
        this.eras = calData.getEras("abbreviated");
        try {
            this.eraNames = calData.getEras("wide");
        }
        catch (MissingResourceException e) {
            this.eraNames = calData.getEras("abbreviated");
        }
        this.months = calData.getStringArray("monthNames", "wide");
        this.shortMonths = calData.getStringArray("monthNames", "abbreviated");
        try {
            this.narrowMonths = calData.getStringArray("monthNames", "narrow");
        }
        catch (MissingResourceException e) {
            this.narrowMonths = calData.getStringArray("monthNames", "abbreviated");
        }
        try {
            this.standaloneMonths = calData.getStringArray("monthNames", "stand-alone", "wide");
        }
        catch (MissingResourceException e) {
            this.standaloneMonths = calData.getStringArray("monthNames", "format", "wide");
        }
        try {
            this.standaloneShortMonths = calData.getStringArray("monthNames", "stand-alone", "abbreviated");
        }
        catch (MissingResourceException e) {
            this.standaloneShortMonths = calData.getStringArray("monthNames", "format", "abbreviated");
        }
        try {
            this.standaloneNarrowMonths = calData.getStringArray("monthNames", "stand-alone", "narrow");
        }
        catch (MissingResourceException e) {
            try {
                this.standaloneNarrowMonths = calData.getStringArray("monthNames", "format", "narrow");
            }
            catch (MissingResourceException e1) {
                this.standaloneNarrowMonths = calData.getStringArray("monthNames", "format", "abbreviated");
            }
        }
        String[] lWeekdays = calData.getStringArray("dayNames", "wide");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        System.arraycopy(lWeekdays, 0, this.weekdays, 1, lWeekdays.length);
        String[] sWeekdays = calData.getStringArray("dayNames", "abbreviated");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        System.arraycopy(sWeekdays, 0, this.shortWeekdays, 1, sWeekdays.length);
        String[] nWeekdays = null;
        try {
            nWeekdays = calData.getStringArray("dayNames", "narrow");
        }
        catch (MissingResourceException e) {
            nWeekdays = calData.getStringArray("dayNames", "abbreviated");
        }
        this.narrowWeekdays = new String[8];
        this.narrowWeekdays[0] = "";
        System.arraycopy(nWeekdays, 0, this.narrowWeekdays, 1, nWeekdays.length);
        String[] saWeekdays = null;
        try {
            saWeekdays = calData.getStringArray("dayNames", "stand-alone", "wide");
        }
        catch (MissingResourceException e) {
            saWeekdays = calData.getStringArray("dayNames", "format", "wide");
        }
        this.standaloneWeekdays = new String[8];
        this.standaloneWeekdays[0] = "";
        System.arraycopy(saWeekdays, 0, this.standaloneWeekdays, 1, saWeekdays.length);
        String[] ssWeekdays = null;
        try {
            ssWeekdays = calData.getStringArray("dayNames", "stand-alone", "abbreviated");
        }
        catch (MissingResourceException e) {
            ssWeekdays = calData.getStringArray("dayNames", "format", "abbreviated");
        }
        this.standaloneShortWeekdays = new String[8];
        this.standaloneShortWeekdays[0] = "";
        System.arraycopy(ssWeekdays, 0, this.standaloneShortWeekdays, 1, ssWeekdays.length);
        String[] snWeekdays = null;
        try {
            snWeekdays = calData.getStringArray("dayNames", "stand-alone", "narrow");
        }
        catch (MissingResourceException e) {
            try {
                snWeekdays = calData.getStringArray("dayNames", "format", "narrow");
            }
            catch (MissingResourceException e1) {
                snWeekdays = calData.getStringArray("dayNames", "format", "abbreviated");
            }
        }
        this.standaloneNarrowWeekdays = new String[8];
        this.standaloneNarrowWeekdays[0] = "";
        System.arraycopy(snWeekdays, 0, this.standaloneNarrowWeekdays, 1, snWeekdays.length);
        this.ampms = calData.getStringArray("AmPmMarkers");
        LinkedHashMap<String, String[]> results = new LinkedHashMap<String, String[]>();
        for (ULocale tempLocale = desiredLocale; tempLocale != null; tempLocale = tempLocale.getFallback()) {
            rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", tempLocale);
            if (rb.getLoadingStatus() == 2) continue;
            if (rb.getLoadingStatus() == 3) continue;
            ICUResourceBundle zoneObject = rb.get("zoneStrings");
            for (int i = 0; i < zoneObject.getSize(); ++i) {
                ICUResourceBundle zoneArr = zoneObject.get(i);
                String[] strings = new String[zoneArr.getSize()];
                for (int j = 0; j < zoneArr.getSize(); ++j) {
                    strings[j] = zoneArr.get(j).getString();
                }
                if (results.containsKey(strings[0])) continue;
                results.put(strings[0], strings);
            }
        }
        this.zoneStrings = new String[results.size()][];
        int i = 0;
        Iterator it = results.keySet().iterator();
        while (it.hasNext()) {
            String[] temp = (String[])results.get(it.next());
            this.zoneStrings[i++] = temp;
        }
        rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", desiredLocale);
        this.localPatternChars = rb.getString("localPatternChars");
        ULocale uloc = rb.getULocale();
        this.setLocale(uloc, uloc);
    }

    final int getZoneIndex(String ID) {
        int result = this._getZoneIndex(ID);
        if (result >= 0) {
            return result;
        }
        int n = ZoneMeta.countEquivalentIDs(ID);
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                int equivResult;
                String equivID = ZoneMeta.getEquivalentID(ID, i);
                if (equivID.equals(ID) || (equivResult = this._getZoneIndex(equivID)) < 0) continue;
                return equivResult;
            }
        }
        return -1;
    }

    private int _getZoneIndex(String ID) {
        for (int index = 0; index < this.zoneStrings.length; ++index) {
            if (!ID.equalsIgnoreCase(this.zoneStrings[index][0])) continue;
            return index;
        }
        return -1;
    }

    private final String[] duplicate(String[] srcArray) {
        return (String[])srcArray.clone();
    }

    private final String[][] duplicate(String[][] srcArray) {
        String[][] aCopy = new String[srcArray.length][];
        for (int i = 0; i < srcArray.length; ++i) {
            aCopy[i] = this.duplicate(srcArray[i]);
        }
        return aCopy;
    }

    private final void copyMembers(DateFormatSymbols src, DateFormatSymbols dst) {
        dst.eras = this.duplicate(src.eras);
        dst.eraNames = this.duplicate(src.eraNames);
        dst.months = this.duplicate(src.months);
        dst.shortMonths = this.duplicate(src.shortMonths);
        dst.narrowMonths = this.duplicate(src.narrowMonths);
        dst.standaloneMonths = this.duplicate(src.standaloneMonths);
        dst.standaloneShortMonths = this.duplicate(src.standaloneShortMonths);
        dst.standaloneNarrowMonths = this.duplicate(src.standaloneNarrowMonths);
        dst.weekdays = this.duplicate(src.weekdays);
        dst.shortWeekdays = this.duplicate(src.shortWeekdays);
        dst.narrowWeekdays = this.duplicate(src.narrowWeekdays);
        dst.standaloneWeekdays = this.duplicate(src.standaloneWeekdays);
        dst.standaloneShortWeekdays = this.duplicate(src.standaloneShortWeekdays);
        dst.standaloneNarrowWeekdays = this.duplicate(src.standaloneNarrowWeekdays);
        dst.ampms = this.duplicate(src.ampms);
        dst.zoneStrings = this.duplicate(src.zoneStrings);
        dst.localPatternChars = new String(src.localPatternChars);
    }

    public DateFormatSymbols(Calendar cal, Locale locale) {
        this.initializeData(ULocale.forLocale(locale), cal.getType());
    }

    public DateFormatSymbols(Calendar cal, ULocale locale) {
        this.initializeData(locale, cal.getType());
    }

    public DateFormatSymbols(Class calendarClass, Locale locale) {
        this(calendarClass, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(Class calendarClass, ULocale locale) {
        String fullName = calendarClass.getName();
        int lastDot = fullName.lastIndexOf(46);
        String className = fullName.substring(lastDot + 1);
        String calType = className.replaceAll("Calendar", "").toLowerCase();
        this.initializeData(locale, calType);
    }

    public DateFormatSymbols(ResourceBundle bundle, Locale locale) {
        this(bundle, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(ResourceBundle bundle, ULocale locale) {
        this.initializeData(locale, new CalendarData((ICUResourceBundle)bundle, null));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(calendarClass, ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, ULocale locale) throws MissingResourceException {
        ResourceBundle result;
        block2: {
            String fullName = calendarClass.getName();
            int lastDot = fullName.lastIndexOf(46);
            String className = fullName.substring(lastDot + 1);
            String bundleName = className + "Symbols";
            result = null;
            try {
                result = ICULocaleData.getResourceBundle(bundleName, locale);
            }
            catch (MissingResourceException e) {
                if (GregorianCalendar.class.isAssignableFrom(calendarClass)) break block2;
                throw e;
            }
        }
        return result;
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, ULocale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), locale);
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }
}

