/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.fmt.PkPkcsEventFormatter;
import com.ibm.security.certclient.util.PkArray;
import com.ibm.security.certclient.util.PkBase64InputStream;
import com.ibm.security.certclient.util.PkBase64OutputStream;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.util.DerValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PkBase64PkcsEventFormatter
extends PkPkcsEventFormatter
implements PkConstants {
    private static final String sccsid = "%Z% %M% %I%    %W% %G% %U%";
    private static final String BEGIN_STR = "-----BEGIN ";
    private static final String END_REP_STR = "-----END CERTIFICATE-----\r\n";
    private static final String END_REQ_STR = "-----END NEW CERTIFICATE REQUEST-----\r\n";
    private static final String REPLY_STR = "CERTIFICATE-----\r\n";
    private static final String REQUEST_STR = "NEW CERTIFICATE RE";
    private static final String REQUEST_2_STR = "QUEST-----\r\n";
    private static final byte[] BEGIN = PkString.toUtf("-----BEGIN ");
    private static final byte[] END_REP = PkString.toUtf("-----END CERTIFICATE-----\r\n");
    private static final byte[] END_REQ = PkString.toUtf("-----END NEW CERTIFICATE REQUEST-----\r\n");
    private static final byte[] REPLY = PkString.toUtf("CERTIFICATE-----\r\n");
    private static final byte[] REQUEST = PkString.toUtf("NEW CERTIFICATE RE");
    private static final byte[] REQUEST_2 = PkString.toUtf("QUEST-----\r\n");
    private static final byte[] BEGIN_REQ = PkString.toUtf("-----BEGIN NEW CERTIFICATE REQUEST-----\r\n");
    private static final byte[] BEGIN_REP = PkString.toUtf("-----BEGIN CERTIFICATE-----\r\n");
    private static int UNKNOWN_TYPE = 0;
    private static int REQUEST_TYPE = 1;
    private static int REPLY_TYPE = 2;

    public PkEvent readEvent(Object source, InputStream in, PkReqEvent req) throws PkException, IOException {
        byte[] buffer = new byte[END_REQ.length];
        int numberRead = in.read(buffer, 0, BEGIN.length);
        if (numberRead == -1) {
            throw new EOFException();
        }
        if (!PkArray.isPrefix(BEGIN, buffer)) {
            this.throwExpected(BEGIN_STR, buffer, BEGIN.length);
        }
        in.read(buffer, 0, REPLY.length);
        int type = UNKNOWN_TYPE;
        if (PkArray.isPrefix(REPLY, buffer)) {
            type = REPLY_TYPE;
        } else if (PkArray.isPrefix(REQUEST, buffer)) {
            in.read(buffer, 0, REQUEST_2.length);
            if (!PkArray.isPrefix(REQUEST_2, buffer)) {
                this.throwExpected(REQUEST_2_STR, buffer, REQUEST_2.length);
            }
            type = REQUEST_TYPE;
        } else {
            this.throwExpected("CERTIFICATE-----\r\n\" or \"NEW CERTIFICATE REQUEST-----\r\n", buffer, REPLY.length);
        }
        DerValue der = new DerValue((InputStream)new PkBase64InputStream(in));
        buffer[0] = 45;
        if (type == REQUEST_TYPE) {
            in.read(buffer, 1, END_REQ.length - 1);
            return this.readCertReqEvent(source, der);
        }
        in.read(buffer, 1, END_REP.length - 1);
        return this.readCertRepEvent(source, der, req);
    }

    public void writeCertReq(PkCertReqEvent req, OutputStream out) throws IOException {
        out.write(BEGIN_REQ);
        PkBase64OutputStream b64out = new PkBase64OutputStream(out);
        super.writeCertReq(req, b64out);
        b64out.end();
        out.write(END_REQ);
    }

    public void writeCertRep(PkCertRepEvent rep, OutputStream out) throws IOException {
        out.write(BEGIN_REP);
        PkBase64OutputStream b64out = new PkBase64OutputStream(out);
        super.writeCertRep(rep, b64out);
        b64out.end();
        out.write(END_REP);
    }

    private void throwExpected(String expected, byte[] received, int length) throws PkIoException {
        throw new PkIoException(PkNLSConstants.BASE64TOPKCS_EXPECTED + expected);
    }
}

