/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.base;

import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkRepEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public class PkCertRepEvent
extends PkRepEvent {
    private Certificate cert;

    public PkCertRepEvent(Object source, Object msg, PkReqEvent req, Certificate cert) {
        super(source, msg, req);
        this.cert = cert;
    }

    public Certificate getCert() {
        return this.cert;
    }

    public String getSubjectDn() {
        return this.getSubjectX500Name().toString();
    }

    private X500Name getSubjectX500Name() {
        return (X500Name)((X509CertImpl)this.cert).getSubjectDN();
    }

    public BigInteger getSerialNumber() {
        return ((X509CertImpl)this.cert).getSerialNumber();
    }

    public byte[] getEncodedCert() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    public void write(PkEventFormatter formatter, OutputStream outputStream) throws IOException, PkException {
        formatter.writeCertRep(this, outputStream);
    }

    public String toString() {
        if (this.cert != null) {
            return super.toString() + "\n" + this.cert.toString();
        }
        return super.toString() + "\n" + "Either no cert present or encrypted cert could not be decrypted";
    }
}

