/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeCertReqFactory;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.PkEeReqTransaction;
import com.ibm.security.certclient.base.PkActiveSource;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.beans.PkEeXMgr;
import com.ibm.security.certclient.beans.PkTcpClient;
import com.ibm.security.certclient.util.JPKI;
import com.ibm.security.certclient.util.PkConnector;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.pkcs10.CertificationRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class PkEeCertReq10Factory
extends PkEeFactory {
    private PkEeCertReq10Factory() {
        throw new UnsupportedOperationException();
    }

    public static PkEeReqTransaction newCertRequestPKCS10(String certFile, String iaFile, String revoPwd) throws PkException {
        return new CertRequestPKCS10Impl(certFile, iaFile, revoPwd);
    }

    private static final class CertRequestPKCS10Impl
    implements PkEeReqTransaction {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private PkEe3 ee = new PkEe3();
        private boolean eeRun = false;

        CertRequestPKCS10Impl(String certFile, String iaFile, String revoPwd) throws PkException {
            this.ee.setCertReqFileName(certFile);
            this.ee.setiafile(iaFile);
            this.ee.setrevoPwd(revoPwd);
            this.ee.setCaDn(PkEeFactory.caDn);
            this.ee.setCaPort(PkEeFactory.caPort);
        }

        public void actionRequest() throws PkException {
            this.runCertReqPkcs10();
        }

        public X509Certificate getSignedCert() {
            if (this.eeRun) {
                return this.ee.getSignedCert();
            }
            return null;
        }

        public byte[] getPKCS10CertReq() throws PkRejectionException {
            PkAttrs attrs = this.ee.getAttributes();
            String provider = (String)attrs.get("cert.oper.PROVIDER").getValue();
            try {
                CertificationRequest cr = new CertificationRequest(this.ee.getCertReqFileName(), true, provider);
                return cr.encode();
            }
            catch (IOException ioe) {
                throw new PkRejectionException(ioe.getMessage());
            }
        }

        private void runCertReqPkcs10() throws PkException {
            try {
                String host = this.ee.getCaDn();
                int port = this.ee.getCaPort();
                if (debug != null) {
                    debug.text(1L, this.className, "runCertReqPkcs10", "CARA_HOST={0}", (Object)host);
                    debug.text(1L, this.className, "runCertReqPkcs10", "RA_CMP_PORT={0}", (Object)new Integer(port));
                }
                PkTcpClient client = new PkTcpClient(host, port, PkEeFactory.getCmpFmt(), 1);
                PkConnector.connect((PkActiveSource)this.ee, new PkPipe[]{new PkEeXMgr(), client}).run();
                if (this.ee.getRunFailed()) {
                    throw this.ee.getRunException();
                }
                this.eeRun = true;
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(4L, this.className, "runCertReqPkcs10()", (Throwable)e);
                }
                throw new PkException(e);
            }
        }
    }

    static final class PkEe3
    extends PkActiveSource
    implements PkConstants {
        private String certReqFileName;
        private String refNumber;
        private String passPhrase;
        private String iafile;
        private String revoPwd;
        private String caDn;
        private int caPort;
        private Exception runException = null;
        private boolean runFailed = false;
        private X509Certificate signedCert = null;
        private PkAttrs attributes = null;
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        protected PkEe3() {
            if (debug != null) {
                debug.text(1L, this.className, "PkEe3", "Begin");
            }
        }

        protected boolean getRunFailed() {
            return this.runFailed;
        }

        protected Exception getRunException() {
            return this.runException;
        }

        protected void setCertReqFileName(String fileName) throws PkException {
            if (fileName == null || fileName.length() <= 0) {
                if (debug != null) {
                    debug.text(1L, this.className, "setCertReqFileName", "CertReqFileName cannot be null");
                }
                throw new PkException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED);
            }
            this.certReqFileName = fileName;
        }

        protected void setrevoPwd(String revoPwd) {
            this.revoPwd = revoPwd;
        }

        protected void setrefNumber(String refNumber) {
            this.refNumber = refNumber;
        }

        protected void setpassPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
        }

        protected void setiafile(String iafile) throws PkException {
            this.iafile = iafile;
            this.readIAFile(this.iafile);
        }

        protected void setCaDn(String caDn) {
            this.caDn = caDn != null && caDn.length() != 0 ? caDn : PkEeFactory.caDn;
        }

        protected void setCaPort(int caPort) {
            this.caPort = caPort != 0 ? caPort : PkEeFactory.caPort;
        }

        protected String getCertReqFileName() {
            return this.certReqFileName;
        }

        protected X509Certificate getSignedCert() {
            return this.signedCert;
        }

        protected PkAttrs getAttributes() throws PkRejectionException {
            this.attributes = this.getAttrs();
            return this.attributes;
        }

        protected String getCaDn() {
            return this.caDn;
        }

        protected int getCaPort() {
            return this.caPort;
        }

        protected PkAttrs getAttrs() throws PkRejectionException {
            String domain = PkEeCertReqFactory.CA_DN;
            String refNumber = this.refNumber;
            String passPhrase = this.passPhrase;
            PkAttrs attrs = new PkAttrs();
            String notBefore = new Long(new Date().getTime()).toString();
            long tmp1 = 6L;
            tmp1 = tmp1 * 31L * 24L * 60L * 60L;
            String issuedCertValidity = new Long(tmp1 *= 1000L).toString();
            if (debug != null) {
                debug.text(1L, this.className, "PkAttrs", "issuedCertValidity {0}", (Object)issuedCertValidity);
            }
            JPKI jpki = new JPKI();
            String[] values = new String[]{domain, "3", refNumber, passPhrase, notBefore, issuedCertValidity};
            byte[] ba = null;
            try {
                FileInputStream fIn = new FileInputStream(this.certReqFileName);
                ba = new byte[fIn.available()];
                fIn.read(ba);
                fIn.close();
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(4L, this.className, "PkAttrs", (Throwable)e);
                }
                throw new PkRejectionException(PkNLSConstants.FILE_IO_FAILED, e);
            }
            try {
                attrs = jpki.initialCertRequest(ba, values);
                PkEeFactory.provider = (String)attrs.get("cert.oper.PROVIDER").getValue();
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(4L, this.className, "PkAttrs", (Throwable)e);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_CERTREQ_FROM_PKCS10_FAILED, e);
            }
            return attrs;
        }

        public void run() {
            PkCertRepEvent repTmp = null;
            this.runFailed = false;
            this.runException = null;
            try {
                if (this.attributes == null) {
                    this.attributes = this.getAttrs();
                }
                PkInitReqEvent req = new PkInitReqEvent(this, null, this.attributes);
                repTmp = this.propagate((PkCertReqEvent)req);
                this.signedCert = (X509Certificate)repTmp.getCert();
            }
            catch (Exception e) {
                this.runFailed = true;
                this.runException = e;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe3.run", (Throwable)e);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe3.run", "propagated cert-request");
            }
            PKIMessage msg = (PKIMessage)repTmp.getMsg();
            PKIHeader head = msg.getHeader();
            Object[] values1 = new Object[]{head, this.passPhrase, this.refNumber, this.revoPwd};
            JPKI jpki = new JPKI();
            try {
                PkConfReqEvent req1 = new PkConfReqEvent(this, null, jpki.confRequest(values1, null));
                this.propagate(req1);
            }
            catch (Exception e) {
                this.runFailed = true;
                this.runException = e;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe3.run", (Throwable)e);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe3.run", "propagated conf-request");
            }
        }

        private void readIAFile(String fileName) throws PkException {
            File tstFile;
            if (fileName == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "readIAFile", "iafile cannot be null");
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
            try {
                tstFile = new File(fileName);
            }
            catch (NullPointerException npe) {
                if (debug != null) {
                    debug.exception(4L, this.className, "readIAFile", (Throwable)npe);
                }
                throw new PkException("", npe);
            }
            if (tstFile.exists()) {
                try {
                    if (debug != null) {
                        debug.text(1L, this.className, "readIAFile", "file found now processing");
                    }
                    BufferedReader myRdr = new BufferedReader(new FileReader(fileName));
                    String lineData = myRdr.readLine();
                    this.refNumber = new String(lineData);
                    this.passPhrase = new String(myRdr.readLine());
                    myRdr.close();
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.text(1L, this.className, "readIAFile", "file processing failed");
                    }
                    throw new PkException(e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.text(4L, this.className, "readIAFile", PkNLSConstants.IA_FILE_FORMAT_FAILURE);
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
        }
    }
}

