/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.IkeymanLogger;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class NewProviderDialog
extends JDialog
implements IkeymanConstants,
ActionListener,
ItemListener {
    private static final boolean debug = false;
    private KMButton okButton;
    private KMButton cancelButton;
    private JLabel providersLabel;
    private JComboBox providerChoice;
    private String[] types;
    private JLabel provNameLabel;
    private JTextField provNameField;
    private int mode;
    private int dbType = 0;
    private String browserFileName;
    private String browserDirName;
    private String providerName = null;
    private String providerSelected;
    private JPanel fileNamePanel;
    private JDialog diagInstance = this;

    public NewProviderDialog(JFrame jFrame, String string) {
        super(jFrame, string, true);
        this.populateFields();
        this.fileNamePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fileNamePanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.providersLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.providerChoice, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.provNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.provNameField, gridBagConstraints);
        this.fileNamePanel.add(this.providersLabel);
        this.fileNamePanel.add(this.providerChoice);
        this.fileNamePanel.add(this.provNameLabel);
        this.fileNamePanel.add(this.provNameField);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.equalizeButtons();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.fileNamePanel, "Center");
        jPanel.add((Component)kMHorizontalButtonPanel, "South");
        BevelBorder bevelBorder = new BevelBorder(0);
        jPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        this.provNameField.requestFocus();
    }

    protected void populateFields() {
        this.populateInputFields();
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateInputFields() {
        int n;
        this.providersLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_PROVIDERS"));
        this.providerChoice = new JComboBox();
        this.providerChoice.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_PROVIDERS"));
        this.types = KeyStoreManager.listProviders();
        if (this.types.length != 0) {
            n = 0;
            while (n < this.types.length) {
                int n2 = n + 1;
                this.providerChoice.addItem(n2 + ".  " + this.types[n]);
                ++n;
            }
            this.providerChoice.addItemListener(this);
            this.providerSelected = this.types[0];
        }
        n = 40;
        String string = Locale.getDefault().getLanguage();
        if (string.equals("ja")) {
            n *= 2;
        }
        this.provNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_NEWPROVIDER"));
        this.provNameLabel.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_NEWPROVIDER"));
        this.provNameField = new JTextField(n);
        this.provNameField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_NEWPROVIDER"));
        this.provNameField.setMinimumSize(this.provNameField.getPreferredSize());
        if (string.equals("ko") || string.equals("ja")) {
            this.provNameField.setFont(Ikeyman.defaultMonospacedFont);
        }
    }

    protected void populateButtons() {
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    protected void setToolTips() {
        this.providerChoice.setToolTipText(Ikeyman.getNLSResString("GUI_LABEL_PROVIDERS"));
        this.provNameField.setToolTipText(Ikeyman.getNLSResString("GUI_LABEL_NEWPROVIDER"));
    }

    public String getProviderName() {
        return KMUtil.trimBlankSpace(this.providerName);
    }

    public static String getKeyDbTypeNLSName(int n) {
        return Ikeyman.getDatabaseNLSTypeName(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.providerName = this.provNameField.getText();
            if (!this.providerName.equals("") && this.providerName.indexOf(42) < 0 && KMUtil.trimBlankSpace(this.providerName) != null) {
                try {
                    Class<?> clazz;
                    Object obj;
                    int n = this.providerName.indexOf(" ");
                    if (n > 0) {
                        this.providerName = this.providerName.substring(0, n);
                    }
                    if ((obj = (clazz = Class.forName(this.providerName)).newInstance()) instanceof Provider) {
                        Security.addProvider((Provider)obj);
                        try {
                            Set<Object> set = ((Provider)obj).keySet();
                            Iterator<Object> iterator = set.iterator();
                            while (iterator.hasNext()) {
                                Object object2 = iterator.next();
                                String string2 = ((String)object2).substring(9);
                                KeyStore keyStore = KeyStore.getInstance(string2);
                            }
                            throw new Exception("");
                        }
                        catch (Error error) {
                            Security.removeProvider(((Provider)obj).getName());
                            ((Component)this).setVisible(false);
                            KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_PROVIDER_CMS_LIBRARIES_NOTFOUND"));
                        }
                    } else {
                        IkeymanLogger.error("NewProviderDialog", "actionPerformed() Line 281", "Could not add provider " + clazz.getName() + " which is not an instance of Provider.");
                        throw new IOException("not an instance of Provider:" + clazz.getName());
                    }
                    ((Component)this).setVisible(false);
                }
                catch (Exception exception) {
                    IkeymanLogger.error("NewProviderDialog", "actionPerformed() Line 290", "Could not add provider: " + this.providerName);
                    ((Component)this).setVisible(false);
                }
            } else {
                String string3 = KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT");
                Object[] objectArray = new Object[]{this.provNameLabel.getText()};
                String string4 = MessageFormat.format(string3, objectArray);
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), string4);
                this.provNameField.requestFocus();
            }
        } else if (string.equals("Cancel")) {
            KMUtil.debugMsg("Cancel button is hit\n");
            this.providerName = null;
            ((Component)this).setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        int n = this.providerChoice.getSelectedIndex();
        KMUtil.debugMsg("getItem=" + object + ", getSource=" + object2 + itemEvent.getStateChange() + ", selectedIndex=" + n);
        if (n < 0) {
            n = 0;
        }
        this.providerSelected = this.types[n];
        this.provNameField.setText("");
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            NewProviderDialog.this.providerName = null;
            ((Component)NewProviderDialog.this).setVisible(false);
        }
    }
}

