/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMVerticalButtonPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KMChangeKeyLabelsDialog
extends JDialog {
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton applyButton;
    private JList list;
    private JTextField labelEditor;
    private JLabel changeLabel;
    public static final int OK = 0;
    public static final int CANCEL = -1;
    private int retvalue = 0;

    public KMChangeKeyLabelsDialog(JFrame jFrame, String string, String[] stringArray) {
        super(jFrame, string, true);
        this.setupButtons();
        this.setupList(stringArray);
        this.setupTextField();
        this.setupLayouts();
        this.setToolTips();
        this.addWindowListener(new DiagAdapter());
    }

    public String[] getLabels() {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        Object[] objectArray = new String[defaultListModel.getSize()];
        defaultListModel.copyInto(objectArray);
        return objectArray;
    }

    public int getRetVal() {
        return this.retvalue;
    }

    private void setupButtons() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("OK") || actionEvent.getActionCommand().equals("Apply")) {
                    String string = KMChangeKeyLabelsDialog.this.labelEditor.getText();
                    if (string == null || string.equals("")) {
                        KMChangeKeyLabelsDialog.this.list.clearSelection();
                        KMChangeKeyLabelsDialog.this.labelEditor.setEditable(false);
                    } else {
                        DefaultListModel defaultListModel = (DefaultListModel)KMChangeKeyLabelsDialog.this.list.getModel();
                        defaultListModel.set(KMChangeKeyLabelsDialog.this.list.getSelectedIndex(), string);
                        KMChangeKeyLabelsDialog.this.list.repaint();
                    }
                }
                if (actionEvent.getActionCommand().equals("OK")) {
                    KMChangeKeyLabelsDialog.this.retvalue = 0;
                    ((Component)KMChangeKeyLabelsDialog.this).setVisible(false);
                } else if (actionEvent.getActionCommand().equals("Cancel")) {
                    KMChangeKeyLabelsDialog.this.retvalue = -1;
                    ((Component)KMChangeKeyLabelsDialog.this).setVisible(false);
                }
            }
        };
        this.okButton = new KMButton(actionListener, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(actionListener, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.applyButton = new KMButton(actionListener, Ikeyman.getNLSResString("GUI_BUTTON_APPLY"));
        this.okButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        this.applyButton.addActionListener(actionListener);
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.applyButton.setActionCommand("Apply");
    }

    private void setupList(String[] stringArray) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        int n = 0;
        while (n < stringArray.length) {
            defaultListModel.addElement(stringArray[n]);
            ++n;
        }
        this.list = new JList(defaultListModel);
        this.list.setSelectionMode(0);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = (String)KMChangeKeyLabelsDialog.this.list.getSelectedValue();
                KMChangeKeyLabelsDialog.this.labelEditor.setText(string);
                if (string != null) {
                    KMChangeKeyLabelsDialog.this.labelEditor.setEditable(true);
                    KMChangeKeyLabelsDialog.this.labelEditor.requestFocus();
                    KMChangeKeyLabelsDialog.this.changeLabel.setEnabled(true);
                } else {
                    KMChangeKeyLabelsDialog.this.labelEditor.setEditable(false);
                    KMChangeKeyLabelsDialog.this.changeLabel.setEnabled(false);
                }
            }
        };
        this.list.addListSelectionListener(listSelectionListener);
    }

    private void setupTextField() {
        this.labelEditor = new JTextField();
        this.labelEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = KMChangeKeyLabelsDialog.this.labelEditor.getText();
                if (string == null || string.equals("")) {
                    KMChangeKeyLabelsDialog.this.list.clearSelection();
                    KMChangeKeyLabelsDialog.this.labelEditor.setEditable(false);
                    KMChangeKeyLabelsDialog.this.changeLabel.setEnabled(false);
                    return;
                }
                DefaultListModel defaultListModel = (DefaultListModel)KMChangeKeyLabelsDialog.this.list.getModel();
                defaultListModel.set(KMChangeKeyLabelsDialog.this.list.getSelectedIndex(), string);
                KMChangeKeyLabelsDialog.this.list.repaint();
            }
        });
    }

    private void setupLayouts() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 10);
        String string = Ikeyman.getNLSResString("GUI_LABEL_QST_CHANGE_LABELS");
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        String string2 = Ikeyman.getNLSResString("GUI_LABEL_SELECT");
        jPanel.add((Component)new JLabel(string2), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        jPanel.add((Component)new JScrollPane(this.list), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        String string3 = Ikeyman.getNLSResString("GUI_LABEL_ENTER_NEW_LABEL");
        this.changeLabel = new JLabel(string3);
        this.changeLabel.setEnabled(false);
        jPanel.add((Component)this.changeLabel, gridBagConstraints);
        jPanel.add((Component)this.labelEditor, gridBagConstraints);
        KMVerticalButtonPanel kMVerticalButtonPanel = new KMVerticalButtonPanel();
        kMVerticalButtonPanel.addButton(this.okButton);
        kMVerticalButtonPanel.addButton(this.cancelButton);
        kMVerticalButtonPanel.equalizeButtons();
        KMVerticalButtonPanel kMVerticalButtonPanel2 = new KMVerticalButtonPanel();
        kMVerticalButtonPanel2.add(this.applyButton);
        kMVerticalButtonPanel2.equalizeButtons();
        jPanel.add(kMVerticalButtonPanel2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(20, 20));
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)kMVerticalButtonPanel, "East");
        BevelBorder bevelBorder = new BevelBorder(0);
        jPanel2.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel2, "Center");
        this.pack();
    }

    protected void setToolTips() {
        this.list.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CHANGE_LABEL_LIST"));
        this.labelEditor.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_CHANGE_LABEL_TEXT"));
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            KMChangeKeyLabelsDialog.this.retvalue = -1;
            ((Component)KMChangeKeyLabelsDialog.this).setVisible(false);
        }
    }
}

