/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;

public abstract class SOAPConnectionFactory {
    private static final String DEFAULT_SOAP_CONNECTION_FACTORY = "com.ibm.ws.webservices.engine.soap.SOAPConnectionFactoryImpl";
    private static final String SF_PROPERTY = "javax.xml.soap.SOAPConnectionFactory";
    private static Class factoryClass = null;

    public static synchronized SOAPConnectionFactory newInstance() throws SOAPException, UnsupportedOperationException {
        try {
            Object var0 = null;
            if (factoryClass == null) {
                String string = SF_PROPERTY;
                String string2 = DEFAULT_SOAP_CONNECTION_FACTORY;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string3 = System.getProperty(string);
                if (string3 == null) {
                    String string4 = "META-INF/services/" + string;
                    InputStream inputStream = null;
                    inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string4) : classLoader.getResourceAsStream(string4);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        string3 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                }
                if (string3 == null) {
                    string3 = string2;
                }
                if (string3 == null) {
                    throw new SOAPException("Provider for " + string + " cannot be found", null);
                }
                factoryClass = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
            }
            var0 = factoryClass.newInstance();
            return var0;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "javax.xml.soap.SOAPConnectionFactory.newInstance", "79");
            throw new SOAPException("Unable to create SOAP connection factory: " + exception.getMessage());
        }
    }

    public abstract SOAPConnection createConnection() throws SOAPException;
}

