/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.XMLString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class XMLStringBuffer {
    private static final int CHUNK_SHIFT = 14;
    private static final int CHUNK_SIZE = 16384;
    private static final int CHUNK_MASK = 16383;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private final DataBufferFactory fBufferFactory;
    private DataBuffer[] fBuffers;
    private byte[] fData;
    private int fChunk;
    private int fOffset;

    public XMLStringBuffer(DataBufferFactory dataBufferFactory) {
        this.fBufferFactory = dataBufferFactory;
        this.fBuffers = new DataBuffer[4];
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer();
        if (dataBuffer.bytes == null) {
            dataBuffer.bytes = new byte[16385];
        } else if (dataBuffer.bytes.length <= 16384) {
            dataBuffer.bytes = new byte[16385];
        }
        dataBuffer.startOffset = 0;
        dataBuffer.endOffset = 16384;
        this.fBuffers[0] = dataBuffer;
        this.fData = dataBuffer.bytes;
        this.fData[0] = 0;
        this.fData[16384] = 0;
        this.fChunk = 0;
        this.fOffset = 1;
    }

    public void reset(boolean bl) {
        this.fData = this.fBuffers[0].bytes;
        this.fChunk = 0;
        this.fOffset = 1;
        if (!bl) {
            int n = 1;
            while (n < this.fBuffers.length) {
                if (this.fBuffers[n] != null) {
                    this.fBuffers[n].removeReference();
                    this.fBuffers[n] = null;
                }
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public CharConversionError appendString(String var1_1) {
        var2_2 = var1_1.length();
        var3_3 = 0;
        if (this.fOffset + var2_2 >= 16384) ** GOTO lbl29
        while (var3_3 < var2_2) {
            var4_4 = var1_1.charAt(var3_3);
            if (var4_4 >= 128) break;
            ++var3_3;
            this.fData[this.fOffset] = (byte)var4_4;
            ++this.fOffset;
        }
        if (var3_3 != var2_2) ** GOTO lbl29
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = var1_1.charAt(var3_3);
            ++var3_3;
            if (var4_4 < 55296 || var4_4 >= 57344) {
                this.appendChar(var4_4);
                continue;
            }
            if (var4_4 < 56320) {
                if (var3_3 == var2_2) {
                    return CharConversionError.missingSecondHalfOfSurrogatePair();
                }
                var5_5 = var1_1.charAt(var3_3);
                ++var3_3;
                if (var5_5 < '\udc00' || var5_5 >= '\ue000') {
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                var4_4 = 65536 + (var4_4 - 55296 << 10) + (var5_5 - 56320);
                this.appendChar(var4_4);
                continue;
            }
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
lbl29:
            // 4 sources

            ** while (var3_3 < var2_2)
        }
lbl30:
        // 1 sources

        return null;
    }

    public int getOffset() {
        return this.fChunk << 14 | this.fOffset;
    }

    public void appendChar(int n) {
        if (n < 128) {
            this.appendByte((byte)n);
        } else {
            this.appendMultibyteChar(n);
        }
    }

    private void appendMultibyteChar(int n) {
        if (n < 2048) {
            this.appendByte((byte)(0xC0 | n >> 6));
            this.appendByte((byte)(0x80 | 0x3F & n));
        } else if (n < 65536) {
            this.appendByte((byte)(0xE0 | n >> 12));
            this.appendByte((byte)(0x80 | 0x3F & n >> 6));
            this.appendByte((byte)(0x80 | 0x3F & n));
        } else {
            this.appendByte((byte)(0xF0 | n >> 18));
            this.appendByte((byte)(0x80 | 0x3F & n >> 12));
            this.appendByte((byte)(0x80 | 0x3F & n >> 6));
            this.appendByte((byte)(0x80 | 0x3F & n));
        }
    }

    public void appendBytes(byte[] byArray, int n, int n2, boolean bl) {
        if (!bl) {
            int n3 = n2 - n;
            int n4 = 16384 - this.fOffset;
            while (n3 >= n4) {
                System.arraycopy(byArray, n, this.fData, this.fOffset, n4);
                n += n4;
                n3 -= n4;
                this.extend();
                n4 = 16384 - this.fOffset;
            }
            System.arraycopy(byArray, n, this.fData, this.fOffset, n3);
            this.fOffset += n3;
        } else {
            boolean bl2 = false;
            int n5 = n2 - n;
            int n6 = 16384 - this.fOffset;
            while (n5 > 0) {
                int n7 = n5 >= n6 ? n + n6 : n2;
                while (n < n7) {
                    int n8 = byArray[n];
                    ++n;
                    if (n8 >= 0) {
                        if (bl2) {
                            bl2 = false;
                            if (n8 == 10) continue;
                        }
                        if (n8 == 13) {
                            bl2 = true;
                            n8 = 10;
                        }
                    } else {
                        bl2 = false;
                    }
                    this.fData[this.fOffset] = (byte)n8;
                    ++this.fOffset;
                }
                n6 = 16384 - this.fOffset;
                if (n6 == 0) {
                    this.extend();
                    n6 = 16384 - this.fOffset;
                }
                n5 = n2 - n;
            }
        }
    }

    public void appendXMLString(XMLString xMLString) {
        if (xMLString.bytes != null) {
            this.appendBytes(xMLString.bytes, xMLString.startOffset, xMLString.endOffset, (xMLString.flags & 4) != 0);
        } else if ((xMLString.flags & 4) == 0) {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            this.appendBytes(dataBuffer.bytes, xMLString.startOffset, dataBuffer.endOffset, false);
            while ((dataBuffer = dataBuffer.next) != xMLString.lastBuffer) {
                this.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset, false);
            }
            this.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, xMLString.endOffset, false);
        } else {
            boolean bl = false;
            DataBuffer dataBuffer = xMLString.firstBuffer;
            byte[] byArray = dataBuffer.bytes;
            int n = xMLString.startOffset;
            int n2 = dataBuffer.endOffset;
            int n3 = 16384 - this.fOffset;
            while (true) {
                int n4 = n2 > n + n3 ? n + n3 : n2;
                while (n < n4) {
                    int n5 = byArray[n];
                    ++n;
                    if (n5 >= 0) {
                        if (bl) {
                            bl = false;
                            if (n5 == 10) continue;
                        }
                        if (n5 == 13) {
                            bl = true;
                            n5 = 10;
                        }
                    } else {
                        bl = false;
                    }
                    this.fData[this.fOffset] = n5;
                    ++this.fOffset;
                }
                if (this.fOffset == 16384) {
                    this.extend();
                }
                n3 = 16384 - this.fOffset;
                if (n != n2) continue;
                if (dataBuffer == xMLString.lastBuffer) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == xMLString.lastBuffer ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
    }

    public void appendQName(QName qName) {
        if (qName.bytes != null) {
            this.appendBytes(qName.bytes, qName.startOffset, qName.endOffset, false);
        } else {
            DataBuffer dataBuffer = qName.firstBuffer;
            this.appendBytes(dataBuffer.bytes, qName.startOffset, dataBuffer.endOffset, false);
            while ((dataBuffer = dataBuffer.next) != qName.lastBuffer) {
                this.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset, false);
            }
            this.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, qName.endOffset, false);
        }
    }

    public void appendToBuffer(int n, int n2, XMLStringBuffer xMLStringBuffer) {
        int n3 = n2 - n;
        int n4 = n >>> 14;
        int n5 = n & 0x3FFF;
        if (n5 + n3 <= 16384) {
            xMLStringBuffer.appendBytes(this.fBuffers[n4].bytes, n5, n5 + n3, false);
        } else {
            DataBuffer dataBuffer = this.fBuffers[n4];
            int n6 = n2 >>> 14;
            xMLStringBuffer.appendBytes(dataBuffer.bytes, n5, dataBuffer.endOffset, false);
            dataBuffer = this.fBuffers[++n4];
            while (n4 < n6) {
                xMLStringBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset, false);
                dataBuffer = this.fBuffers[++n4];
            }
            xMLStringBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n2 & 0x3FFF, false);
        }
    }

    public void setEmptyStringValues(XMLString xMLString) {
        xMLString.setValues(this.fBuffers[0], 0, 0, 0);
    }

    public void setStringValues(int n, int n2, XMLString xMLString) {
        int n3 = n2 - n;
        int n4 = n >>> 14;
        int n5 = n & 0x3FFF;
        if (n5 + n3 <= 16384) {
            xMLString.setValues(this.fBuffers[n4], n5, n5 + n3, 0);
        } else {
            xMLString.setStartPos(this.fBuffers[n4], n5);
            n4 = n2 >>> 14;
            n5 = n2 & 0x3FFF;
            if (n5 == 0) {
                --n4;
                n5 = 16384;
            }
            xMLString.setEndPos(this.fBuffers[n4], n5, 0);
        }
    }

    public void setQNameValues(int n, int n2, QName qName) {
        int n3 = n2 - n;
        int n4 = n >>> 14;
        int n5 = n & 0x3FFF;
        if (n5 + n3 <= 16384) {
            qName.setValues(this.fBuffers[n4], n5, n5 + n3);
        } else {
            qName.setStartPos(this.fBuffers[n4], n5);
            n4 = n2 >>> 14;
            n5 = n2 & 0x3FFF;
            if (n5 == 0) {
                --n4;
                n5 = 16384;
            }
            qName.setEndPos(this.fBuffers[n4], n5);
        }
    }

    public void normalizedAppend(XMLString xMLString) {
        int n = this.fChunk;
        int n2 = this.fOffset;
        this.appendXMLString(xMLString);
        int n3 = this.fChunk;
        int n4 = this.fOffset;
        while (n <= n3) {
            byte[] byArray = this.fBuffers[n].bytes;
            int n5 = n < n3 ? 16384 : n4;
            int n6 = n2;
            while (n6 < n5) {
                byte by = byArray[n6];
                if (by == 10 || by == 9 || by == 13) {
                    byArray[n6] = 32;
                }
                ++n6;
            }
            ++n;
            n2 = 0;
        }
    }

    public CharConversionError normalizeTextValue(XMLString xMLString, XMLString xMLString2) {
        if (xMLString.isNormalized()) {
            return null;
        }
        byte[] byArray = xMLString.bytes;
        if (xMLString2 != null) {
            xMLString2.setValues(xMLString);
        }
        if (byArray != null) {
            boolean bl = true;
            int n = this.getOffset();
            int n2 = xMLString.startOffset;
            int n3 = xMLString.endOffset;
            int n4 = xMLString.length;
            int n5 = 16384 - this.fOffset;
            int n6 = 0;
            while (n4 > 0) {
                int n7 = n4 >= n5 ? n2 + n5 : n3;
                block1: while (n2 < n7) {
                    byte by;
                    if (n6 == 0) {
                        while (n2 < n7) {
                            by = byArray[n2];
                            if (by != 32) {
                                n6 = 1;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (n6 == 1) {
                        if (!bl) {
                            this.fData[this.fOffset] = 32;
                            ++this.fOffset;
                            n4 = n3 - n2;
                            n5 = 16384 - this.fOffset;
                            n7 = n4 >= n5 ? n2 + n5 : n3;
                        }
                        bl = false;
                        n6 = 2;
                    }
                    if (n6 != 2) continue;
                    while (n2 < n7) {
                        by = byArray[n2];
                        if (by != 32) {
                            this.fData[this.fOffset] = by;
                            ++n2;
                            ++this.fOffset;
                            continue;
                        }
                        n6 = 0;
                        continue block1;
                    }
                }
                n5 = 16384 - this.fOffset;
                if (n5 == 0) {
                    this.extend();
                    n5 = 16384 - this.fOffset;
                }
                n4 = n3 - n2;
            }
            this.setStringValues(n, this.getOffset(), xMLString);
            return null;
        }
        boolean bl = true;
        int n = this.getOffset();
        int n8 = xMLString.startOffset;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer;
        int n9 = xMLString.length;
        int n10 = 16384 - this.fOffset;
        int n11 = 0;
        byArray = dataBuffer.bytes;
        int n12 = dataBuffer.endOffset;
        while (n9 > 0) {
            int n13 = n12 >= n8 + n10 ? n8 + n10 : n12;
            block5: while (n8 < n13) {
                byte by;
                if (n11 == 0) {
                    while (n8 < n13) {
                        by = byArray[n8];
                        if (by != 32) {
                            n11 = 1;
                            break;
                        }
                        ++n8;
                        --n9;
                    }
                }
                if (n11 == 1) {
                    if (!bl) {
                        this.fData[this.fOffset] = 32;
                        ++this.fOffset;
                        n10 = 16384 - this.fOffset;
                        n13 = n12 >= n8 + n10 ? n8 + n10 : n12;
                    }
                    bl = false;
                    n11 = 2;
                }
                if (n11 != 2) continue;
                while (n8 < n13) {
                    by = byArray[n8];
                    if (by != 32) {
                        this.fData[this.fOffset] = by;
                        ++n8;
                        --n9;
                        ++this.fOffset;
                        continue;
                    }
                    n11 = 0;
                    continue block5;
                }
            }
            n10 = 16384 - this.fOffset;
            if (n10 == 0) {
                this.extend();
                n10 = 16384 - this.fOffset;
            }
            if (n8 != n12) continue;
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n8 = dataBuffer.startOffset;
            int n14 = n12 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : xMLString.endOffset;
        }
        this.setStringValues(n, this.getOffset(), xMLString);
        return null;
    }

    public void normalizePublicID(XMLString xMLString) {
        if (xMLString.isNormalized()) {
            return;
        }
        byte[] byArray = xMLString.bytes;
        if (byArray != null) {
            boolean bl = true;
            int n = this.getOffset();
            int n2 = xMLString.startOffset;
            int n3 = xMLString.endOffset;
            int n4 = xMLString.length;
            int n5 = 16384 - this.fOffset;
            int n6 = 0;
            while (n4 > 0) {
                int n7 = n4 >= n5 ? n2 + n5 : n3;
                block1: while (n2 < n7) {
                    byte by;
                    if (n6 == 0) {
                        while (n2 < n7) {
                            by = byArray[n2];
                            if (by < 0 || by > 32) {
                                n6 = 1;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (n6 == 1) {
                        if (!bl) {
                            this.fData[this.fOffset] = 32;
                            ++this.fOffset;
                            n4 = n3 - n2;
                            n5 = 16384 - this.fOffset;
                            n7 = n4 >= n5 ? n2 + n5 : n3;
                        }
                        bl = false;
                        n6 = 2;
                    }
                    if (n6 != 2) continue;
                    while (n2 < n7) {
                        by = byArray[n2];
                        if (by < 0 || by > 32) {
                            this.fData[this.fOffset] = by;
                            ++n2;
                            ++this.fOffset;
                            continue;
                        }
                        n6 = 0;
                        continue block1;
                    }
                }
                n5 = 16384 - this.fOffset;
                if (n5 == 0) {
                    this.extend();
                    n5 = 16384 - this.fOffset;
                }
                n4 = n3 - n2;
            }
            this.setStringValues(n, this.getOffset(), xMLString);
        } else {
            boolean bl = true;
            int n = this.getOffset();
            int n8 = xMLString.startOffset;
            DataBuffer dataBuffer = xMLString.firstBuffer;
            DataBuffer dataBuffer2 = xMLString.lastBuffer;
            int n9 = xMLString.length;
            int n10 = 16384 - this.fOffset;
            int n11 = 0;
            byArray = dataBuffer.bytes;
            int n12 = dataBuffer.endOffset;
            while (n9 > 0) {
                int n13 = n12 >= n8 + n10 ? n8 + n10 : n12;
                block5: while (n8 < n13) {
                    byte by;
                    if (n11 == 0) {
                        while (n8 < n13) {
                            by = byArray[n8];
                            if (by < 0 || by > 32) {
                                n11 = 1;
                                break;
                            }
                            ++n8;
                            --n9;
                        }
                    }
                    if (n11 == 1) {
                        if (!bl) {
                            this.fData[this.fOffset] = 32;
                            ++this.fOffset;
                            n10 = 16384 - this.fOffset;
                            n13 = n12 >= n8 + n10 ? n8 + n10 : n12;
                        }
                        bl = false;
                        n11 = 2;
                    }
                    if (n11 != 2) continue;
                    while (n8 < n13) {
                        by = byArray[n8];
                        if (by < 0 || by > 32) {
                            this.fData[this.fOffset] = by;
                            ++n8;
                            --n9;
                            ++this.fOffset;
                            continue;
                        }
                        n11 = 0;
                        continue block5;
                    }
                }
                n10 = 16384 - this.fOffset;
                if (n10 == 0) {
                    this.extend();
                    n10 = 16384 - this.fOffset;
                }
                if (n8 != n12) continue;
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n8 = dataBuffer.startOffset;
                int n14 = n12 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : xMLString.endOffset;
            }
            this.setStringValues(n, this.getOffset(), xMLString);
        }
    }

    public boolean save(OutputStream outputStream) throws IOException {
        DataBuffer dataBuffer;
        int n = this.fChunk << 14 | this.fOffset;
        outputStream.write(n >> 24);
        outputStream.write(n >> 16);
        outputStream.write(n >> 8);
        outputStream.write(n);
        int n2 = 0;
        while (n2 < this.fChunk) {
            dataBuffer = this.fBuffers[n2];
            outputStream.write(dataBuffer.bytes, 0, 16384);
            ++n2;
        }
        dataBuffer = this.fBuffers[n2];
        outputStream.write(dataBuffer.bytes, 0, this.fOffset);
        return true;
    }

    public boolean restore(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        this.fData = this.fBuffers[0].bytes;
        this.fChunk = 0;
        while (n >= 16384) {
            inputStream.read(this.fData, 0, 16384);
            n -= 16384;
            this.extend();
        }
        if (n > 0) {
            inputStream.read(this.fData, 0, n);
        }
        this.fOffset = n;
        return true;
    }

    public void addString(String string, XMLString xMLString) {
        int n = this.getOffset();
        this.appendString(string);
        this.setStringValues(n, this.getOffset(), xMLString);
        this.appendByte((byte)0);
    }

    public void addXMLString(XMLString xMLString, XMLString xMLString2) {
        int n = this.getOffset();
        this.appendXMLString(xMLString);
        this.setStringValues(n, this.getOffset(), xMLString2);
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(XMLString var1_1) {
        block2: {
            if (var1_1.firstBuffer == null) break block2;
            var2_2 = 0;
            while (var2_2 <= this.fChunk) {
                block3: {
                    if (this.fBuffers[var2_2] != var1_1.firstBuffer) break block3;
                    v0 = var3_3 = var2_2 == this.fChunk ? this.fOffset : 16384;
                    if (var1_1.startOffset > var3_3) break block3;
                    if (var1_1.lastBuffer != null) ** GOTO lbl12
                    return var1_1.endOffset <= var3_3;
lbl-1000:
                    // 1 sources

                    {
                        if (var1_1.lastBuffer != this.fBuffers[var2_2]) continue;
                        var3_3 = var2_2 == this.fChunk ? this.fOffset : 16384;
                        return var1_1.endOffset <= var3_3;
lbl12:
                        // 2 sources

                        ** while (++var2_2 <= this.fChunk)
                    }
                }
                ++var2_2;
            }
        }
        return false;
    }

    private void extend() {
        DataBuffer dataBuffer;
        DataBuffer dataBuffer2 = this.fBuffers[this.fChunk];
        if (++this.fChunk == this.fBuffers.length) {
            DataBuffer[] dataBufferArray = new DataBuffer[this.fChunk << 1];
            System.arraycopy(this.fBuffers, 0, dataBufferArray, 0, this.fChunk);
            this.fBuffers = dataBufferArray;
        }
        if ((dataBuffer = this.fBuffers[this.fChunk]) == null) {
            dataBuffer = this.fBuffers[this.fChunk] = this.fBufferFactory.createBuffer();
        }
        dataBuffer2.next = dataBuffer;
        dataBuffer.addReference();
        this.fData = dataBuffer.bytes;
        if (this.fData == null) {
            dataBuffer.bytes = new byte[16385];
            this.fData = dataBuffer.bytes;
        } else if (this.fData.length <= 16384) {
            dataBuffer.bytes = new byte[16385];
            this.fData = dataBuffer.bytes;
        }
        dataBuffer.startOffset = 0;
        dataBuffer.endOffset = 16384;
        this.fData[16384] = 0;
        this.fOffset = 0;
    }

    private void appendByte(byte by) {
        this.fData[this.fOffset] = by;
        if (++this.fOffset == 16384) {
            this.extend();
        }
    }
}

