/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;

public class XMLString {
    public static final int FLAGS_NOTWHITESPACE = 1;
    public static final int FLAGS_ALLWHITESPACE = 2;
    public static final int FLAGS_NORMALIZE_EOL = 4;
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public int flags;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;
    protected char[][] fConvertedChars;
    protected int[] fConvertedCharsOffset;
    protected int[] fMultiByteCharInfo;

    public XMLString() {
    }

    public XMLString(XMLString xMLString) {
        this.bytes = xMLString.bytes;
        this.startOffset = xMLString.startOffset;
        this.endOffset = xMLString.endOffset;
        this.length = xMLString.length;
        this.flags = xMLString.flags;
        this.firstBuffer = xMLString.firstBuffer;
        this.lastBuffer = xMLString.lastBuffer;
        if (this.firstBuffer != null) {
            this.firstBuffer.addReference();
            if (this.lastBuffer != null) {
                DataBuffer dataBuffer = this.firstBuffer;
                do {
                    dataBuffer = dataBuffer.next;
                    dataBuffer.addReference();
                } while (dataBuffer != this.lastBuffer);
            }
        }
    }

    public void clear() {
        if (this.firstBuffer != null) {
            this.bytes = null;
            this.startOffset = 0;
            this.endOffset = 0;
            this.length = 0;
            this.flags = 0;
            this.dropBufferReferences();
        }
    }

    protected final void dropBufferReferences() {
        if (this.lastBuffer == null) {
            this.firstBuffer.removeReference();
        } else {
            DataBuffer dataBuffer;
            DataBuffer dataBuffer2 = this.firstBuffer;
            do {
                dataBuffer = dataBuffer2;
                dataBuffer2 = dataBuffer.next;
                dataBuffer.removeReference();
            } while (dataBuffer != this.lastBuffer);
            this.lastBuffer = null;
        }
        this.firstBuffer = null;
    }

    public final void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        this.setValues(dataBuffer, dataBuffer2, n, n2, 0);
    }

    public final void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, int n3) {
        if (dataBuffer2 == null) {
            this.setValues(dataBuffer, n, n2, n3);
        } else {
            this.setStartPos(dataBuffer, n);
            this.setEndPos(dataBuffer2, n2, n3);
        }
    }

    public final void setValues(DataBuffer dataBuffer, int n, int n2) {
        this.setValues(dataBuffer, n, n2, 0);
    }

    public final void setValues(DataBuffer dataBuffer, int n, int n2, int n3) {
        if (this.lastBuffer == null) {
            if (n < dataBuffer.endOffset) {
                if (this.firstBuffer == null) {
                    dataBuffer.addReference();
                    this.firstBuffer = dataBuffer;
                } else if (this.firstBuffer != dataBuffer) {
                    this.firstBuffer.removeReference();
                    dataBuffer.addReference();
                    this.firstBuffer = dataBuffer;
                }
                this.startOffset = n;
                this.endOffset = n2;
                this.length = n2 - n;
                this.bytes = dataBuffer.bytes;
                this.flags = n3;
            } else {
                UntestedCode.needTest("XMLString.setValues");
                this.setValuesSlowly(dataBuffer, n, n2, n3);
            }
        } else {
            this.setValuesSlowly(dataBuffer, n, n2, n3);
        }
    }

    private final void setValuesSlowly(DataBuffer dataBuffer, int n, int n2, int n3) {
        this.setStartPos(dataBuffer, n);
        this.setEndPos(dataBuffer, n2, n3);
    }

    public final void setStartPos(DataBuffer dataBuffer, int n) {
        this.flags = 0;
        this.bytes = null;
        if (this.lastBuffer != null) {
            DataBuffer dataBuffer2 = this.firstBuffer.next;
            while (true) {
                DataBuffer dataBuffer3 = dataBuffer2.next;
                dataBuffer2.removeReference();
                if (dataBuffer2 == this.lastBuffer) break;
                dataBuffer2 = dataBuffer3;
            }
            this.lastBuffer = null;
        }
        if (dataBuffer != this.firstBuffer) {
            if (this.firstBuffer != null) {
                this.firstBuffer.removeReference();
            }
            dataBuffer.addReference();
            this.firstBuffer = dataBuffer;
        }
        this.startOffset = n;
    }

    public final void setEndPos(DataBuffer dataBuffer, int n) {
        this.setEndPos(dataBuffer, n, 0);
    }

    public final void setEndPos(DataBuffer dataBuffer, int n, int n2) {
        this.flags = n2;
        while (dataBuffer != this.firstBuffer) {
            if (this.startOffset < this.firstBuffer.endOffset) {
                if (n > dataBuffer.startOffset) {
                    this.bytes = null;
                    this.setEndPosAcrossBuffers(dataBuffer, n);
                    return;
                }
                dataBuffer = this.fixEndPos(dataBuffer);
                n = dataBuffer.endOffset;
                continue;
            }
            this.fixStartPos();
        }
        this.endOffset = n;
        this.length = n - this.startOffset;
        this.bytes = dataBuffer.bytes;
        if (this.lastBuffer != null) {
            DataBuffer dataBuffer2 = this.firstBuffer.next;
            while (true) {
                DataBuffer dataBuffer3 = dataBuffer2.next;
                dataBuffer2.removeReference();
                if (dataBuffer2 == this.lastBuffer) break;
                dataBuffer2 = dataBuffer3;
            }
            this.lastBuffer = null;
        }
    }

    private final void setEndPosAcrossBuffers(DataBuffer dataBuffer, int n) {
        if (this.lastBuffer == null) {
            DataBuffer dataBuffer2 = this.firstBuffer;
            this.endOffset = n;
            this.length = dataBuffer2.endOffset - this.startOffset;
            dataBuffer2 = dataBuffer2.next;
            while (dataBuffer2 != dataBuffer) {
                dataBuffer2.addReference();
                this.length += dataBuffer2.endOffset - dataBuffer2.startOffset;
                dataBuffer2 = dataBuffer2.next;
            }
            this.length += n - dataBuffer2.startOffset;
            dataBuffer2.addReference();
            this.lastBuffer = dataBuffer2;
        } else if (this.lastBuffer == dataBuffer) {
            this.endOffset = n;
        } else {
            DataBuffer dataBuffer3 = this.lastBuffer;
            this.length += dataBuffer3.endOffset - this.endOffset;
            dataBuffer3 = dataBuffer3.next;
            while (dataBuffer3 != dataBuffer) {
                dataBuffer3.addReference();
                this.length += dataBuffer3.endOffset - dataBuffer3.startOffset;
                dataBuffer3 = dataBuffer3.next;
            }
            this.length += n - dataBuffer3.startOffset;
            dataBuffer3.addReference();
            this.lastBuffer = dataBuffer3;
            this.endOffset = n;
        }
    }

    private final void fixStartPos() {
        DataBuffer dataBuffer = this.firstBuffer;
        this.firstBuffer = dataBuffer.next;
        this.firstBuffer.addReference();
        dataBuffer.removeReference();
        this.startOffset = this.firstBuffer.startOffset;
    }

    private final DataBuffer fixEndPos(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        while (dataBuffer2.next != dataBuffer) {
            dataBuffer2 = dataBuffer2.next;
        }
        return dataBuffer2;
    }

    /*
     * Unable to fully structure code
     */
    public void setValues(XMLString var1_1) {
        block17: {
            block11: {
                block13: {
                    block15: {
                        block16: {
                            block14: {
                                block12: {
                                    if (var1_1 == null || var1_1.firstBuffer == null) break block11;
                                    this.bytes = var1_1.bytes;
                                    this.startOffset = var1_1.startOffset;
                                    this.endOffset = var1_1.endOffset;
                                    this.length = var1_1.length;
                                    this.flags = var1_1.flags;
                                    if (this.firstBuffer != null) break block12;
                                    this.firstBuffer = var1_1.firstBuffer;
                                    this.firstBuffer.addReference();
                                    if (var1_1.lastBuffer != null) {
                                        var2_2 = this.firstBuffer;
                                        do {
                                            var2_2 = var2_2.next;
                                            var2_2.addReference();
                                        } while (var2_2 != var1_1.lastBuffer);
                                    }
                                    break block13;
                                }
                                if (this.firstBuffer == var1_1.firstBuffer) break block14;
                                var2_3 = var1_1.firstBuffer;
                                var2_3.addReference();
                                if (var1_1.lastBuffer != null) {
                                    do {
                                        var2_3 = var2_3.next;
                                        var2_3.addReference();
                                    } while (var2_3 != var1_1.lastBuffer);
                                }
                                this.dropBufferReferences();
                                this.firstBuffer = var1_1.firstBuffer;
                                break block13;
                            }
                            if (this.lastBuffer == var1_1.lastBuffer) break block15;
                            var2_4 = this.firstBuffer;
                            if (this.lastBuffer != null) break block16;
                            do {
                                var2_4 = var2_4.next;
                                var2_4.addReference();
                            } while (var2_4 != var1_1.lastBuffer);
                            break block13;
                        }
                        if (var1_1.lastBuffer != null) ** GOTO lbl49
                        var3_5 = var2_4.next;
                        do {
                            var2_4 = var3_5;
                            var3_5 = var2_4.next;
                            var2_4.removeReference();
                        } while (var2_4 != this.lastBuffer);
                        break block13;
lbl-1000:
                        // 1 sources

                        {
                            var2_4 = var2_4.next;
lbl49:
                            // 2 sources

                            ** while (var2_4 != this.lastBuffer && var2_4 != var1_1.lastBuffer)
                        }
lbl50:
                        // 1 sources

                        if (var2_4 == this.lastBuffer) {
                            do {
                                var2_4 = var2_4.next;
                                var2_4.addReference();
                            } while (var2_4 != var1_1.lastBuffer);
                        } else {
                            var3_6 = var2_4.next;
                            do {
                                var2_4 = var3_6;
                                var3_6 = var2_4.next;
                                var2_4.removeReference();
                            } while (var2_4 != this.lastBuffer);
                        }
                        break block13;
                    }
                    return;
                }
                this.lastBuffer = var1_1.lastBuffer;
                break block17;
            }
            this.clear();
        }
    }

    public final boolean isAllWhitespace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        return this.checkWhitespace();
    }

    private boolean checkWhitespace() {
        if (this.length > 0) {
            int n = this.startOffset;
            if (this.bytes != null) {
                while (n < this.endOffset) {
                    byte by;
                    if ((by = this.bytes[n++]) == 32 || by == 10 || by == 9 || by == 13) continue;
                    this.flags |= 1;
                    return false;
                }
            } else {
                DataBuffer dataBuffer = this.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n2 = dataBuffer.endOffset;
                while (true) {
                    if (n < n2) {
                        byte by;
                        if ((by = byArray[n++]) == 32 || by == 10 || by == 9 || by == 13) continue;
                        this.flags |= 1;
                        return false;
                    }
                    if (dataBuffer == this.lastBuffer) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    if (dataBuffer == this.lastBuffer) {
                        n2 = this.endOffset;
                        continue;
                    }
                    n2 = dataBuffer.endOffset;
                }
            }
        }
        this.flags |= 2;
        return true;
    }

    public final boolean isNormalized() {
        byte by;
        if (this.length == 0) {
            return true;
        }
        if (this.bytes != null) {
            int n = this.startOffset;
            while (n < this.endOffset) {
                byte by2 = this.bytes[n];
                if (by2 < 0 || by2 > 32) {
                    while ((by2 < 0 || by2 > 32) && ++n < this.endOffset) {
                        by2 = this.bytes[n];
                    }
                    if (n >= this.endOffset || by2 >= 32 && ++n != this.endOffset) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n = this.startOffset;
        int n2 = dataBuffer.endOffset;
        while ((by = byArray[n]) < 0 || by > 32) {
            while (by < 0 || by > 32) {
                if (++n < n2) {
                    by = byArray[n];
                    continue;
                }
                if (dataBuffer == this.lastBuffer) {
                    return true;
                }
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                by = byArray[n];
            }
            if (by < 32) {
                return false;
            }
            if (++n != n2) continue;
            if (dataBuffer == this.lastBuffer) {
                return false;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n = dataBuffer.startOffset;
            if (dataBuffer == this.lastBuffer) {
                n2 = this.endOffset;
                continue;
            }
            n2 = dataBuffer.endOffset;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected final boolean equalsXMLString(XMLString var1_1) {
        block5: {
            block6: {
                if (this.length <= 0 || this.length != var1_1.length) break block5;
                if (this.bytes == null || var1_1.bytes == null) break block6;
                var2_2 = this.length;
                if (this.bytes[this.startOffset] == var1_1.bytes[var1_1.startOffset]) ** GOTO lbl8
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.bytes[this.startOffset + var2_2] == var1_1.bytes[var1_1.startOffset + var2_2]) continue;
                    return false;
lbl8:
                    // 2 sources

                    ** while (--var2_2 > 0)
                }
lbl9:
                // 1 sources

                return true;
            }
            var2_3 = this.firstBuffer;
            var3_4 = var1_1.firstBuffer;
            var4_5 = var2_3.bytes;
            var6_7 = this.startOffset;
            var5_6 = var3_4.bytes;
            var7_8 = var1_1.startOffset;
            if (var4_5[var6_7] != var5_6[var7_8]) {
                return false;
            }
            var8_9 = this.lastBuffer != null ? this.lastBuffer : var2_3;
            var9_10 = var1_1.lastBuffer != null ? var1_1.lastBuffer : var3_4;
            var10_11 = this.lastBuffer != null ? var2_3.endOffset : this.endOffset;
            var11_12 = var1_1.lastBuffer != null ? var3_4.endOffset : var1_1.endOffset;
            var12_13 = this.length;
            while (--var12_13 > 0) {
                if (++var6_7 == var10_11) {
                    var2_3 = var2_3.next;
                    var4_5 = var2_3.bytes;
                    var6_7 = var2_3.startOffset;
                    v0 = var10_11 = var2_3 != var8_9 ? var2_3.endOffset : this.endOffset;
                }
                if (++var7_8 == var11_12) {
                    var3_4 = var3_4.next;
                    var5_6 = var3_4.bytes;
                    var7_8 = var3_4.startOffset;
                    v1 = var11_12 = var3_4 != var9_10 ? var3_4.endOffset : var1_1.endOffset;
                }
                if (var4_5[var6_7] == var5_6[var7_8]) continue;
                return false;
            }
            return true;
        }
        return this.length == var1_1.length;
    }

    protected final boolean equalsString(String string) {
        int n = this.startOffset;
        if (this.bytes != null) {
            int n2 = string.length();
            int n3 = 0;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c == this.bytes[n]) {
                    ++n;
                } else {
                    if (c < '\u0080') {
                        return false;
                    }
                    return this.toString().equals(string);
                }
                ++n3;
            }
            return true;
        }
        return this.toString().equals(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n = this.startOffset;
        int n2 = 0;
        if (this.bytes != null) {
            while (n < this.endOffset) {
                CharConversionError charConversionError;
                byte by = this.bytes[n];
                if (by >= 0) {
                    n2 = n2 * 31 + by;
                    ++n;
                    continue;
                }
                if (this.fMultiByteCharInfo == null) {
                    this.fMultiByteCharInfo = new int[2];
                }
                if ((charConversionError = UTF8Support.decodeCharacter(this.bytes, n, this.endOffset, this.fMultiByteCharInfo)) == null) {
                    int n3 = this.fMultiByteCharInfo[0];
                    if (n3 < 65536) {
                        n2 = n2 * 31 + n3;
                    } else {
                        int n4 = n3 - 65536;
                        n3 = 55296 + (n4 >> 10);
                        n2 = n2 * 31 + n3;
                        n3 = 56320 + (n4 & 0x3FF);
                        n2 = n2 * 31 + n3;
                    }
                    n += this.fMultiByteCharInfo[1];
                    continue;
                }
                UntestedCode.needTest("error?");
                throw new RuntimeException("need test");
            }
            return n2;
        } else {
            DataBuffer dataBuffer = this.firstBuffer;
            block1: while (true) {
                int n5;
                byte[] byArray = dataBuffer.bytes;
                int n6 = n5 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                while (true) {
                    CharConversionError charConversionError;
                    byte by;
                    if ((by = byArray[n]) >= 0) {
                        n2 = n2 * 31 + by;
                        if (++n != n5) continue;
                        if (dataBuffer == this.lastBuffer) return n2;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                        continue block1;
                    }
                    if (this.fMultiByteCharInfo == null) {
                        this.fMultiByteCharInfo = new int[2];
                    }
                    if ((charConversionError = UTF8Support.decodeCharacter(dataBuffer, n, this.lastBuffer, this.endOffset, this.fMultiByteCharInfo)) != null) break block1;
                    int n7 = this.fMultiByteCharInfo[0];
                    if (n7 < 65536) {
                        n2 = n2 * 31 + n7;
                    } else {
                        int n8 = n7 - 65536;
                        n7 = 55296 + (n8 >> 10);
                        n2 = n2 * 31 + n7;
                        n7 = 56320 + (n8 & 0x3FF);
                        n2 = n2 * 31 + n7;
                    }
                    if ((n += this.fMultiByteCharInfo[1]) == n5) {
                        if (dataBuffer == this.lastBuffer) return n2;
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                        continue block1;
                    }
                    if (n >= n5) break;
                }
                if (dataBuffer == this.lastBuffer) return n2;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset + (n - n5);
                if (dataBuffer == this.lastBuffer && n == this.endOffset) return n2;
            }
            UntestedCode.needTest("error?");
            throw new RuntimeException("need test");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XMLString) {
            return this.equalsXMLString((XMLString)object);
        }
        if (object instanceof String) {
            return this.equalsString((String)object);
        }
        return false;
    }

    public void normalizeLineBreaks(XMLStringBuffer xMLStringBuffer) {
        if (this.firstBuffer != null && (this.flags & 4) != 0) {
            int n = xMLStringBuffer.getOffset();
            xMLStringBuffer.appendXMLString(this);
            xMLStringBuffer.setStringValues(n, xMLStringBuffer.getOffset(), this);
        }
    }

    public final CharConversionError getChars(char[][] cArray, int[] nArray) {
        if (this.firstBuffer != null && (this.bytes != null || this.lastBuffer != null)) {
            if ((this.flags & 4) != 0) {
                return UTF8Support.normalizeBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
            }
            return UTF8Support.convertBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
        }
        return null;
    }

    public final String toString() {
        if (this.firstBuffer != null && (this.bytes != null || this.lastBuffer != null)) {
            CharConversionError charConversionError = this.convertToChars();
            if (charConversionError == null) {
                return new String(this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]);
            }
            return null;
        }
        return null;
    }

    protected final CharConversionError convertToChars() {
        if (this.fConvertedChars == null) {
            int n = 16;
            while (n < this.length) {
                n <<= 1;
            }
            this.fConvertedChars = new char[1][];
            this.fConvertedChars[0] = new char[n];
            this.fConvertedCharsOffset = new int[1];
        }
        this.fConvertedCharsOffset[0] = 0;
        return this.getChars(this.fConvertedChars, this.fConvertedCharsOffset);
    }
}

