/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.encoding.RewindableInputStream;
import java.io.IOException;

public final class EncodingDeclReader {
    public static final int UNKNOWN = 0;
    public static final int UTF8N = 1;
    public static final int UTF16BE = 2;
    public static final int UTF16LE = 3;
    public static final int UTF32BE = 4;
    public static final int UTF32LE = 5;
    public static final int LATIN = 6;
    public static final int EBCDIC = 7;
    public static final int UCS2BE = 8;
    public static final int UCS2LE = 9;
    public static final int UCS4BE = 10;
    public static final int UCS4LE = 11;
    private String fEncodingName;
    private char[] fEncodingNameBuffer;
    private RewindableInputStream fSource;
    private boolean fIsDocumentEntity;
    private int fBytesPerChar;
    private boolean fIsBigEndian;
    private static final int CODEPOINT_ILLEGAL = 0;
    private static final int CODEPOINT_WHITESPACE = 1;
    private static final int CODEPOINT_EQUALSIGN = 2;
    private static final int CODEPOINT_SINGLEQUOTE = 3;
    private static final int CODEPOINT_DOUBLEQUOTE = 4;
    private static final int CODEPOINT_LETTER = 5;
    private static final int CODEPOINT_DIGIT = 6;
    private static final int CODEPOINT_HYPHEN = 7;
    private static final int CODEPOINT_UNDERSCORE = 8;
    private static final int CODEPOINT_PERIOD = 9;
    private static final int CODEPOINT_LESSTHAN = 10;
    private static final int CODEPOINT_GREATERTHAN = 11;
    private static final int CODEPOINT_QUESTIONMARK = 12;
    private static final int LITERAL_STARTPIXML = 0;
    private static final int LITERAL_VERSION = 1;
    private static final int LITERAL_VERSION10 = 2;
    private static final int LITERAL_ENCODING = 3;
    private static final int LITERAL_STANDALONE = 4;
    private static final int LITERAL_YES = 5;
    private static final int LITERAL_NO = 6;
    private static final int LITERAL_ENDPI = 7;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;
    private static final byte ___ = 0;
    private static final byte WSP = 1;
    private static final byte PER = 9;
    private static final byte LSS = 10;
    private static final byte HYP = 7;
    private static final byte USC = 8;
    private static final byte GTR = 11;
    private static final byte QST = 12;
    private static final byte SQT = 3;
    private static final byte EQL = 2;
    private static final byte DQT = 4;
    private static final byte LTR = 5;
    private static final byte DIG = 6;
    private static final byte[] fgCodePointMapEBCDIC = new byte[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 4, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0};
    private static final char ____ = '\u0000';
    private static final char[] fgEncodingNameMapEBCDIC = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '.', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '_', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final int[] STARTPIXML_EBCDIC = new int[]{76, 111, 167, 148, 147};
    private static final int[] VERSION_EBCDIC = new int[]{165, 133, 153, 162, 137, 150, 149};
    private static final int[] VERSION10_EBCDIC = new int[]{241, 75, 240};
    private static final int[] ENCODING_EBCDIC = new int[]{133, 149, 131, 150, 132, 137, 149, 135};
    private static final int[] STANDALONE_EBCDIC = new int[]{162, 163, 129, 149, 132, 129, 147, 150, 149, 133};
    private static final int[] YES_EBCDIC = new int[]{168, 133, 162};
    private static final int[] NO_EBCDIC = new int[]{149, 150};
    private static final int[] ENDPI_EBCDIC = new int[]{111, 110};
    private static final int[] STARTPIXML_Latin = new int[]{60, 63, 120, 109, 108};
    private static final int[] VERSION_Latin = new int[]{118, 101, 114, 115, 105, 111, 110};
    private static final int[] VERSION10_Latin = new int[]{49, 46, 48};
    private static final int[] ENCODING_Latin = new int[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final int[] STANDALONE_Latin = new int[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final int[] YES_Latin = new int[]{121, 101, 115};
    private static final int[] NO_Latin = new int[]{110, 111};
    private static final byte[] encNameCharMapLatin = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};

    public void setSource(RewindableInputStream rewindableInputStream, boolean bl) {
        this.fSource = rewindableInputStream;
        this.fIsDocumentEntity = bl;
    }

    public String getEncodingName() {
        return this.fEncodingName;
    }

    private int readByte() throws IOException {
        return this.fSource.read();
    }

    public int detectEncoding() throws IOException {
        int n = this.readByte();
        switch (n) {
            case 60: {
                n = this.readByte();
                if (n == 63) {
                    n = this.readByte();
                    if (n != 120 || (n = this.readByte()) != 109) break;
                    this.fSource.rewind();
                    return 6;
                }
                if (n != 0) break;
                n = this.readByte();
                if (n == 63) {
                    n = this.readByte();
                    if (n != 0) break;
                    this.fSource.rewind();
                    return 9;
                }
                if (n != 0 || (n = this.readByte()) != 0) break;
                this.fSource.rewind();
                return 11;
            }
            case 239: {
                n = this.readByte();
                if (n != 187 || (n = this.readByte()) != 191) break;
                this.fSource.setStartOffset(3);
                return 1;
            }
            case 0: {
                n = this.readByte();
                if (n == 60) {
                    n = this.readByte();
                    if (n != 0 || (n = this.readByte()) != 63) break;
                    this.fSource.rewind();
                    return 8;
                }
                if (n != 0) break;
                n = this.readByte();
                if (n == 0) {
                    n = this.readByte();
                    if (n != 60) break;
                    this.fSource.rewind();
                    return 10;
                }
                if (n != 254 || (n = this.readByte()) != 255) break;
                this.fSource.setStartOffset(4);
                return 4;
            }
            case 254: {
                n = this.readByte();
                if (n != 255) break;
                this.fSource.setStartOffset(2);
                return 2;
            }
            case 255: {
                n = this.readByte();
                if (n != 254) break;
                this.fSource.setStartOffset(2);
                n = this.readByte();
                if (n == 0 && (n = this.readByte()) == 0) {
                    this.fSource.setStartOffset(4);
                    return 5;
                }
                this.fSource.rewind();
                return 3;
            }
            case 76: {
                n = this.readByte();
                if (n != 111 || (n = this.readByte()) != 167 || (n = this.readByte()) != 148) break;
                this.fSource.rewind();
                return 7;
            }
        }
        this.fSource.rewind();
        return 0;
    }

    public String getEBCDICEncoding() throws IOException {
        this.fEncodingName = null;
        if (!this.readEBCDICEncodingDecl()) {
            return null;
        }
        return this.fEncodingName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readEBCDICEncodingDecl() throws IOException {
        int n = 0;
        if (!this.skipEBCDICLiteral(0)) {
            return true;
        }
        this.skipEBCDICSpaces();
        do {
            if (!this.fIsDocumentEntity) {
                if (n == 0 && this.skipEBCDICLiteral(1)) {
                    n = 1;
                } else {
                    if (!this.skipEBCDICLiteral(3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipEBCDICLiteral(1)) return false;
                n = 1;
            } else if (n != 1 || !this.skipEBCDICLiteral(3)) {
                if (!this.skipEBCDICLiteral(4)) return this.skipEBCDICLiteral(7);
                n = 3;
            } else {
                n = 2;
            }
            this.skipEBCDICSpaces();
            if (!this.skipEBCDICCodePoint(2)) {
                return false;
            }
            this.skipEBCDICSpaces();
            boolean bl = this.skipEBCDICCodePoint(3);
            if (!bl && !this.skipEBCDICCodePoint(4)) {
                return false;
            }
            int n2 = bl ? 3 : 4;
            switch (n) {
                case 1: {
                    if (!this.skipEBCDICLiteral(2) || !this.skipEBCDICCodePoint(n2)) {
                        return false;
                    }
                    if (this.skipEBCDICSpaces()) break;
                    if (!this.fIsDocumentEntity) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.scanEBCDICEncodingName(n2)) {
                        return false;
                    }
                    this.skipEBCDICCodePoint(n2);
                    if (!this.skipEBCDICSpaces()) {
                        n = 4;
                        break;
                    }
                    if (this.fIsDocumentEntity) break;
                    n = 4;
                    break;
                }
                case 3: {
                    if (!this.skipEBCDICLiteral(5) && !this.skipEBCDICLiteral(6) || !this.skipEBCDICCodePoint(n2)) {
                        return false;
                    }
                    this.skipEBCDICSpaces();
                    n = 4;
                }
            }
        } while (n != 4);
        return this.skipEBCDICLiteral(7);
    }

    protected boolean skipEBCDICCodePoint(int n) throws IOException {
        this.fSource.mark(1);
        int n2 = this.readByte();
        if (n2 == -1) {
            return false;
        }
        byte by = fgCodePointMapEBCDIC[n2];
        if (by != n) {
            this.fSource.reset();
            return false;
        }
        return true;
    }

    protected boolean skipEBCDICLiteral(int n) throws IOException {
        int n2;
        int[] nArray;
        switch (n) {
            case 0: {
                int n3;
                int[] nArray2 = STARTPIXML_EBCDIC;
                this.fSource.mark(6);
                int n4 = 0;
                while (n4 < 5) {
                    n3 = this.readByte();
                    if (n3 != nArray2[n4]) {
                        this.fSource.reset();
                        return false;
                    }
                    ++n4;
                }
                n3 = this.readByte();
                if (n3 == -1) {
                    this.fSource.reset();
                    return false;
                }
                byte by = fgCodePointMapEBCDIC[n3];
                if (by != 1) {
                    this.fSource.reset();
                    return false;
                }
                return true;
            }
            case 1: {
                nArray = VERSION_EBCDIC;
                n2 = 7;
                break;
            }
            case 2: {
                nArray = VERSION10_EBCDIC;
                n2 = 3;
                break;
            }
            case 3: {
                nArray = ENCODING_EBCDIC;
                n2 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE_EBCDIC;
                n2 = 10;
                break;
            }
            case 5: {
                nArray = YES_EBCDIC;
                n2 = 3;
                break;
            }
            case 6: {
                nArray = NO_EBCDIC;
                n2 = 2;
                break;
            }
            case 7: {
                nArray = ENDPI_EBCDIC;
                n2 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        this.fSource.mark(n2);
        int n5 = 0;
        while (n5 < n2) {
            int n6 = this.readByte();
            if (n6 != nArray[n5]) {
                this.fSource.reset();
                return false;
            }
            ++n5;
        }
        return true;
    }

    protected boolean skipEBCDICSpaces() throws IOException {
        boolean bl = false;
        while (this.skipEBCDICCodePoint(1)) {
            bl = true;
        }
        return bl;
    }

    protected boolean scanEBCDICEncodingName(int n) throws IOException {
        int n2;
        char[] cArray;
        block9: {
            this.fSource.mark(1);
            int n3 = this.readByte();
            if (n3 == -1) {
                this.fSource.reset();
                return false;
            }
            byte by = fgCodePointMapEBCDIC[n3];
            if (by != 5) {
                this.fSource.reset();
                return false;
            }
            cArray = this.fEncodingNameBuffer;
            if (cArray == null) {
                cArray = this.fEncodingNameBuffer = new char[64];
            }
            n2 = 0;
            cArray[n2++] = fgEncodingNameMapEBCDIC[n3];
            block3: while (true) {
                this.fSource.mark(1);
                n3 = this.readByte();
                if (n3 == -1) {
                    this.fSource.reset();
                    return false;
                }
                by = fgCodePointMapEBCDIC[n3];
                if (by == n) break block9;
                switch (by) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        if (n2 == cArray.length) {
                            this.fEncodingNameBuffer = new char[n2 << 1];
                            System.arraycopy(cArray, 0, this.fEncodingNameBuffer, 0, n2);
                            cArray = this.fEncodingNameBuffer;
                        }
                        cArray[n2++] = fgEncodingNameMapEBCDIC[n3];
                        continue block3;
                    }
                }
                break;
            }
            this.fSource.reset();
            return false;
        }
        this.fSource.reset();
        this.fEncodingName = new String(cArray, 0, n2);
        return true;
    }

    public String getLatinEncoding() throws IOException {
        this.fEncodingName = null;
        if (this.readLatinEncodingDecl()) {
            return this.fEncodingName;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readLatinEncodingDecl() throws IOException {
        int n = 0;
        int n2 = this.readByte();
        if (!this.skipLatinLiteral(n2, 0)) {
            return true;
        }
        n2 = this.skipLatinSpaces();
        do {
            boolean bl;
            if (!this.fIsDocumentEntity) {
                if (n == 0 && n2 == 118) {
                    if (!this.skipLatinLiteral(n2, 1)) return false;
                    n = 1;
                } else {
                    if (!this.skipLatinLiteral(n2, 3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipLatinLiteral(n2, 1)) return false;
                n = 1;
            } else if (n == 1 && n2 == 101) {
                if (!this.skipLatinLiteral(n2, 3)) return false;
                n = 2;
            } else {
                if (n2 != 115) return n2 == 63 && this.readByte() == 62;
                if (!this.skipLatinLiteral(n2, 4)) return false;
                n = 3;
            }
            n2 = this.skipLatinSpaces();
            if (n2 != 61) {
                return false;
            }
            n2 = this.skipLatinSpaces();
            boolean bl2 = bl = n2 == 34;
            if (!bl && n2 != 39) {
                return false;
            }
            int n3 = n2;
            n2 = this.readByte();
            switch (n) {
                case 1: {
                    if (!this.skipLatinLiteral(n2, 2) || this.readByte() != n3) {
                        return false;
                    }
                    n2 = this.readByte();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipLatinSpaces();
                        break;
                    }
                    if (!this.fIsDocumentEntity) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.scanLatinEncodingName(n2, n3)) {
                        return false;
                    }
                    n2 = this.readByte();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipLatinSpaces();
                        if (this.fIsDocumentEntity) break;
                        n = 4;
                        break;
                    }
                    n = 4;
                    break;
                }
                case 3: {
                    if (n2 == 121 ? !this.skipLatinLiteral(n2, 5) || this.readByte() != n3 : !this.skipLatinLiteral(n2, 6) || this.readByte() != n3) {
                        return false;
                    }
                    n2 = this.skipLatinSpaces();
                    n = 4;
                }
            }
        } while (n != 4);
        return n2 == 63 && this.readByte() == 62;
    }

    private boolean skipLatinLiteral(int n, int n2) throws IOException {
        int n3;
        int n4;
        int[] nArray;
        switch (n2) {
            case 0: {
                nArray = STARTPIXML_Latin;
                n4 = 5;
                break;
            }
            case 1: {
                nArray = VERSION_Latin;
                n4 = 7;
                break;
            }
            case 2: {
                nArray = VERSION10_Latin;
                n4 = 3;
                break;
            }
            case 3: {
                nArray = ENCODING_Latin;
                n4 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE_Latin;
                n4 = 10;
                break;
            }
            case 5: {
                nArray = YES_Latin;
                n4 = 3;
                break;
            }
            case 6: {
                nArray = NO_Latin;
                n4 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (n != nArray[0]) {
            return false;
        }
        int n5 = 1;
        while (n5 < n4) {
            n3 = this.readByte();
            if (n3 != nArray[n5]) {
                return false;
            }
            ++n5;
        }
        return n2 != 0 || (n3 = this.readByte()) == 32 || n3 == 10 || n3 == 9 || n3 == 13;
    }

    private int skipLatinSpaces() throws IOException {
        int n;
        while ((n = this.readByte()) == 32 || n == 10 || n == 9 || n == 13) {
        }
        return n;
    }

    private boolean scanLatinEncodingName(int n, int n2) throws IOException {
        int n3 = n;
        if (n3 == -1) {
            return false;
        }
        if (n3 >= 128 || encNameCharMapLatin[n3] != 1) {
            return false;
        }
        char[] cArray = this.fEncodingNameBuffer;
        if (cArray == null) {
            cArray = this.fEncodingNameBuffer = new char[64];
        }
        int n4 = 0;
        while (true) {
            cArray[n4++] = (char)n3;
            n3 = this.readByte();
            if (n3 == n2) break;
            if (n3 == -1) {
                return false;
            }
            if (n3 >= 128 || encNameCharMapLatin[n3] == 0) {
                return false;
            }
            if (n4 != cArray.length) continue;
            this.fEncodingNameBuffer = new char[n4 << 1];
            System.arraycopy(cArray, 0, this.fEncodingNameBuffer, 0, n4);
            cArray = this.fEncodingNameBuffer;
        }
        this.fEncodingName = new String(cArray, 0, n4);
        return true;
    }

    public String getUCSEncoding(int n, boolean bl) throws IOException {
        this.fBytesPerChar = n;
        this.fIsBigEndian = bl;
        this.fEncodingName = null;
        if (this.readUCSEncodingDecl()) {
            return this.fEncodingName;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readUCSEncodingDecl() throws IOException {
        int n = 0;
        int n2 = this.readUCSChar();
        if (!this.skipUCSLiteral(n2, 0)) {
            return true;
        }
        n2 = this.skipUCSSpaces();
        do {
            boolean bl;
            if (!this.fIsDocumentEntity) {
                if (n == 0 && n2 == 118) {
                    if (!this.skipUCSLiteral(n2, 1)) return false;
                    n = 1;
                } else {
                    if (!this.skipUCSLiteral(n2, 3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipUCSLiteral(n2, 1)) return false;
                n = 1;
            } else if (n == 1 && n2 == 101) {
                if (!this.skipUCSLiteral(n2, 3)) return false;
                n = 2;
            } else {
                if (n2 != 115) return n2 == 63 && this.readUCSChar() == 62;
                if (!this.skipUCSLiteral(n2, 4)) return false;
                n = 3;
            }
            n2 = this.skipUCSSpaces();
            if (n2 != 61) {
                return false;
            }
            n2 = this.skipUCSSpaces();
            boolean bl2 = bl = n2 == 34;
            if (!bl && n2 != 39) {
                return false;
            }
            int n3 = n2;
            n2 = this.readUCSChar();
            switch (n) {
                case 1: {
                    if (!this.skipUCSLiteral(n2, 2) || this.readUCSChar() != n3) {
                        return false;
                    }
                    n2 = this.readUCSChar();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipUCSSpaces();
                        break;
                    }
                    if (!this.fIsDocumentEntity) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.scanUCSEncodingName(n2, n3)) {
                        return false;
                    }
                    n2 = this.readUCSChar();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipUCSSpaces();
                        if (this.fIsDocumentEntity) break;
                        n = 4;
                        break;
                    }
                    n = 4;
                    break;
                }
                case 3: {
                    if (n2 == 121 ? !this.skipUCSLiteral(n2, 5) || this.readUCSChar() != n3 : !this.skipUCSLiteral(n2, 6) || this.readUCSChar() != n3) {
                        return false;
                    }
                    n2 = this.skipUCSSpaces();
                    n = 4;
                }
            }
        } while (n != 4);
        return n2 == 63 && this.readUCSChar() == 62;
    }

    private int readUCSChar() throws IOException {
        int n = this.readByte();
        if (n == -1) {
            return -1;
        }
        int n2 = this.readByte();
        if (n2 == -1) {
            return -1;
        }
        if (this.fBytesPerChar == 2) {
            if (this.fIsBigEndian) {
                return (n << 8) + n2;
            }
            return (n2 << 8) + n;
        }
        int n3 = this.readByte();
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.readByte();
        if (n4 == -1) {
            return -1;
        }
        if (this.fIsBigEndian) {
            return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private boolean skipUCSLiteral(int n, int n2) throws IOException {
        int n3;
        int n4;
        int[] nArray;
        switch (n2) {
            case 0: {
                nArray = STARTPIXML_Latin;
                n4 = 5;
                break;
            }
            case 1: {
                nArray = VERSION_Latin;
                n4 = 7;
                break;
            }
            case 2: {
                nArray = VERSION10_Latin;
                n4 = 3;
                break;
            }
            case 3: {
                nArray = ENCODING_Latin;
                n4 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE_Latin;
                n4 = 10;
                break;
            }
            case 5: {
                nArray = YES_Latin;
                n4 = 3;
                break;
            }
            case 6: {
                nArray = NO_Latin;
                n4 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (n != nArray[0]) {
            return false;
        }
        int n5 = 1;
        while (n5 < n4) {
            n3 = this.readUCSChar();
            if (n3 != nArray[n5]) {
                return false;
            }
            ++n5;
        }
        return n2 != 0 || (n3 = this.readUCSChar()) == 32 || n3 == 10 || n3 == 9 || n3 == 13;
    }

    private int skipUCSSpaces() throws IOException {
        int n;
        while ((n = this.readUCSChar()) == 32 || n == 10 || n == 9 || n == 13) {
        }
        return n;
    }

    private boolean scanUCSEncodingName(int n, int n2) throws IOException {
        int n3 = n;
        if (n3 == -1) {
            return false;
        }
        if (n3 >= 128 || encNameCharMapLatin[n3] != 1) {
            return false;
        }
        char[] cArray = this.fEncodingNameBuffer;
        if (cArray == null) {
            cArray = this.fEncodingNameBuffer = new char[64];
        }
        int n4 = 0;
        while (true) {
            cArray[n4++] = (char)n3;
            n3 = this.readUCSChar();
            if (n3 == n2) break;
            if (n3 == -1) {
                return false;
            }
            if (n3 >= 128 || encNameCharMapLatin[n3] == 0) {
                return false;
            }
            if (n4 != cArray.length) continue;
            this.fEncodingNameBuffer = new char[n4 << 1];
            System.arraycopy(cArray, 0, this.fEncodingNameBuffer, 0, n4);
            cArray = this.fEncodingNameBuffer;
        }
        this.fEncodingName = new String(cArray, 0, n4);
        return true;
    }
}

