/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import java.io.PrintStream;

public class XMLTracer {
    private PrintStream fPrintStream;
    private SymbolTable fSymbolTable;
    private XMLString fTempString;
    private int fIndentDepth;

    public XMLTracer(PrintStream printStream, SymbolTable symbolTable) {
        this.fPrintStream = printStream;
        this.fSymbolTable = symbolTable;
        this.fTempString = new XMLString();
    }

    private String handleToString(int n) {
        this.fSymbolTable.setStringValues(n, this.fTempString);
        return this.fTempString.toString();
    }

    public void traceStartDocument() {
        this.printMethod("startDocument");
    }

    public void traceEndDocument() {
        this.printMethod("endDocument");
    }

    public void traceXMLDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        this.printMethodName("xmlDecl");
        this.printParameter("version", xMLString);
        this.printParameter("encName", xMLString2);
        this.printParameter("standalone", xMLString3);
        this.finishEmptyElementTag();
    }

    public void traceTextDecl(XMLString xMLString, XMLString xMLString2) {
        this.printMethodName("textDecl");
        this.printParameter("version", xMLString);
        this.printParameter("encName", xMLString2);
        this.finishEmptyElementTag();
    }

    protected void traceNSDecls(NSDeclList nSDeclList) {
        int n = nSDeclList.nsDeclCount();
        if (n > 0) {
            this.printMethodName("nsDecls");
            this.printParameter("count", n);
            this.finishStartTagEnd(true);
            int n2 = 0;
            while (n2 < n) {
                this.printMethodName("nsDecl");
                this.printParameter("rawName", this.handleToString(nSDeclList.nsDeclQName(n2)));
                this.printParameter("prefix", this.handleToString(nSDeclList.nsDeclPrefix(n2)));
                this.finishStartTagEnd(false);
                this.printValue(this.handleToString(nSDeclList.nsDeclURI(n2)));
                this.printEndTag("nsDecl", false);
                ++n2;
            }
            this.printEndTag("nsDecls", true);
        }
    }

    protected void traceAttrs(AttrList attrList) {
        int n = attrList.attributeCount();
        if (n > 0) {
            this.printMethodName("attributes");
            this.printParameter("count", n);
            this.finishStartTagEnd(true);
            int n2 = 0;
            while (n2 < n) {
                int n3 = attrList.attributeType(n2);
                if (n3 == 0) {
                    n3 = 14;
                }
                this.printMethodName("attribute");
                this.printParameter("rawName", this.handleToString(attrList.attributeName((int)n2).handle));
                this.printParameter("type", n3);
                this.finishStartTagEnd(true);
                QName qName = attrList.attributeName(n2);
                String string = this.handleToString(qName.prefixHandle);
                String string2 = this.handleToString(qName.nsHandle);
                String string3 = this.handleToString(qName.localHandle);
                this.printQName(string, string2, string3);
                this.printMethodName("value");
                this.finishStartTagEnd(false);
                this.printValue(attrList.normalizedAttributeValue(n2).toString());
                this.printEndTag("value", false);
                this.printEndTag("attribute", true);
                ++n2;
            }
            this.printEndTag("attributes", true);
        }
    }

    public void traceEmptyElement(QName qName, NSDeclList nSDeclList, AttrList attrList) {
        this.printMethodName("emptyElement");
        this.printParameter("rawName", this.handleToString(qName.handle));
        this.finishStartTagEnd(true);
        this.printQName(this.handleToString(qName.prefixHandle), this.handleToString(qName.nsHandle), this.handleToString(qName.localHandle));
        this.traceNSDecls(nSDeclList);
        this.traceAttrs(attrList);
        this.printEndTag("emptyElement", true);
    }

    public void traceStartElement(QName qName, NSDeclList nSDeclList, AttrList attrList) {
        this.printMethodName("startElement");
        this.printParameter("rawName", this.handleToString(qName.handle));
        this.finishStartTagEnd(true);
        this.printQName(this.handleToString(qName.prefixHandle), this.handleToString(qName.nsHandle), this.handleToString(qName.localHandle));
        this.traceNSDecls(nSDeclList);
        this.traceAttrs(attrList);
        this.printEndTag("startElement", true);
    }

    public void traceLeafElement(QName qName, NSDeclList nSDeclList, AttrList attrList) {
        this.printMethodName("leafElement");
        this.printParameter("rawName", this.handleToString(qName.handle));
        this.finishStartTagEnd(true);
        this.printQName(this.handleToString(qName.prefixHandle), this.handleToString(qName.nsHandle), this.handleToString(qName.localHandle));
        this.traceNSDecls(nSDeclList);
        this.traceAttrs(attrList);
        this.printEndTag("leafElement", true);
    }

    public void traceEndElement(QName qName, NSDeclList nSDeclList) {
        this.printMethodName("endElement");
        this.printParameter("rawName", this.handleToString(qName.handle));
        this.finishStartTagEnd(true);
        this.printQName(this.handleToString(qName.prefixHandle), this.handleToString(qName.nsHandle), this.handleToString(qName.localHandle));
        this.traceNSDecls(nSDeclList);
        this.printEndTag("endElement", true);
    }

    public void traceCharacters(XMLString xMLString) {
        this.printMethodName("characters");
        this.finishStartTagEnd(false);
        this.printValue(xMLString.toString());
        this.printEndTag("characters", false);
    }

    public void traceWhitespace(XMLString xMLString) {
        this.printMethodName("whitespace");
        this.finishStartTagEnd(false);
        this.printValue(xMLString.toString());
        this.printEndTag("whitespace", false);
    }

    public void traceCharacter(int n) {
        this.printMethodName("character");
        this.printParameter("value", Integer.toString(n, 10));
        this.printParameter("hexValue", Integer.toString(n, 16));
        this.finishEmptyElementTag();
    }

    public void tracePredefinedEntity(XMLString xMLString, int n) {
        this.printMethodName("predefinedEntity");
        this.printParameter("name", xMLString.toString());
        this.printParameter("value", Integer.toString(n, 10));
        this.printParameter("hexValue", Integer.toString(n, 16));
        this.finishEmptyElementTag();
    }

    public void traceProcessingInstruction(XMLString xMLString, XMLString xMLString2) {
        this.printMethodName("processingInstruction");
        this.printParameter("target", xMLString.toString());
        this.finishStartTagEnd(false);
        this.printValue(xMLString2.toString());
        this.printEndTag("processingInstruction", false);
    }

    public void traceComment(XMLString xMLString) {
        this.printMethodName("comment");
        this.finishStartTagEnd(false);
        this.printValue(xMLString.toString());
        this.printEndTag("comment", false);
    }

    public void traceStartCDATASection() {
        this.printMethod("startCDATASection");
    }

    public void traceEndCDATASection() {
        this.printMethod("endCDATASection");
    }

    public void traceDoctype(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        this.printMethodName("doctype");
        this.printParameter("rootElementType", xMLString.toString());
        this.printParameter("publicID", xMLString2.toString());
        this.printParameter("systemID", xMLString3.toString());
        this.printParameter("internalSubset", String.valueOf(bl));
        this.finishEmptyElementTag();
    }

    public void traceStartEntity(XMLString xMLString) {
        this.printMethodName("startEntity");
        this.printParameter("name", xMLString.toString());
        this.finishEmptyElementTag();
    }

    public void traceEndEntity(XMLString xMLString) {
        this.printMethodName("endEntity");
        this.printParameter("name", xMLString.toString());
        this.finishEmptyElementTag();
    }

    public void traceEntityReference(XMLString xMLString) {
        this.printMethodName("entityReference");
        this.printParameter("name", xMLString.toString());
        this.finishEmptyElementTag();
    }

    public void traceWarning(String string, int n, int n2, XMLString[] xMLStringArray, long l) {
        this.printMethodName("warning");
        this.printParameter("errorURI", string);
        this.printParameter("errorCode", n);
        this.printParameter("errorOffset", Long.toString(l));
        if (n2 == 0) {
            this.finishEmptyElementTag();
        } else {
            this.printParameter("errorParamsCount", n2);
            this.finishStartTagEnd(true);
            int n3 = 0;
            while (n3 < n2) {
                this.printMethodName("errorParam");
                this.finishStartTagEnd(false);
                this.printValue(xMLStringArray[n3].toString());
                this.printEndTag("errorParam", false);
                ++n3;
            }
            this.printEndTag("warning", true);
        }
    }

    public void traceRecoverableError(String string, int n, int n2, XMLString[] xMLStringArray, long l) {
        this.printMethodName("recoverableError");
        this.printParameter("errorURI", string);
        this.printParameter("errorCode", n);
        this.printParameter("errorOffset", Long.toString(l));
        if (n2 == 0) {
            this.finishEmptyElementTag();
        } else {
            this.printParameter("errorParamsCount", n2);
            this.finishStartTagEnd(true);
            int n3 = 0;
            while (n3 < n2) {
                this.printMethodName("errorParam");
                this.finishStartTagEnd(false);
                this.printValue(xMLStringArray[n3].toString());
                this.printEndTag("errorParam", false);
                ++n3;
            }
            this.printEndTag("recoverableError", true);
        }
    }

    public void traceFatalError(String string, int n, int n2, XMLString[] xMLStringArray, long l) {
        this.printMethodName("fatalError");
        this.printParameter("errorURI", string);
        this.printParameter("errorCode", n);
        this.printParameter("errorOffset", Long.toString(l));
        if (n2 == 0) {
            this.finishEmptyElementTag();
        } else {
            this.printParameter("errorParamsCount", n2);
            this.finishStartTagEnd(true);
            int n3 = 0;
            while (n3 < n2) {
                this.printMethodName("errorParam");
                this.finishStartTagEnd(false);
                this.printValue(xMLStringArray[n3].toString());
                this.printEndTag("errorParam", false);
                ++n3;
            }
            this.printEndTag("fatalError", true);
        }
    }

    public void traceExtension(Object object) {
        this.printMethodName("extension");
        this.printParameter("state", object.toString());
        this.finishEmptyElementTag();
    }

    private void printMethod(String string) {
        this.printIndent();
        this.fPrintStream.println("<" + string + "/>");
        this.fPrintStream.flush();
    }

    private void printMethodName(String string) {
        this.printIndent();
        this.fPrintStream.print("<" + string);
        ++this.fIndentDepth;
    }

    private void printParameter(String string, int n) {
        this.printParameter(string, Integer.toString(n));
    }

    private void printParameter(String string, XMLString xMLString) {
        this.printParameter(string, xMLString.toString());
    }

    private void printParameter(String string, String string2) {
        if (string2 != null) {
            String string3 = XMLTracer.quote(string2);
            this.fPrintStream.print(" " + string + "=\"" + string3 + "\"");
        }
    }

    private void printQName(String string, String string2, String string3) {
        this.printMethodName("qName");
        this.printParameter("prefix", string);
        this.printParameter("uri", string2);
        this.printParameter("localName", string3);
        this.finishEmptyElementTag();
    }

    private void printValue(String string) {
        String string2 = XMLTracer.quote(string);
        this.fPrintStream.print(string2);
    }

    private void printIndent() {
        int n = 0;
        while (n < this.fIndentDepth) {
            this.fPrintStream.print("  ");
            ++n;
        }
    }

    private void finishStartTagEnd(boolean bl) {
        if (bl) {
            this.fPrintStream.println(">");
            this.fPrintStream.flush();
        } else {
            this.fPrintStream.print(">");
        }
    }

    private void printEndTag(String string, boolean bl) {
        --this.fIndentDepth;
        if (bl) {
            this.printIndent();
        }
        this.fPrintStream.println("</" + string + ">");
        this.fPrintStream.flush();
    }

    private void finishEmptyElementTag() {
        this.fPrintStream.println("/>");
        this.fPrintStream.flush();
        --this.fIndentDepth;
    }

    private static String quote(String string) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer = XMLTracer.append(stringBuffer, string, n2, "&amp;");
                    break;
                }
                case '<': {
                    stringBuffer = XMLTracer.append(stringBuffer, string, n2, "&lt;");
                    break;
                }
                case '>': {
                    stringBuffer = XMLTracer.append(stringBuffer, string, n2, "&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer = XMLTracer.append(stringBuffer, string, n2, "&quot;");
                    break;
                }
                case '\t': {
                    stringBuffer = XMLTracer.append(stringBuffer, string, n2, "&#9;");
                    break;
                }
                case '\n': {
                    stringBuffer = XMLTracer.append(stringBuffer, string, n2, "&#10;");
                    break;
                }
                case '\r': {
                    stringBuffer = XMLTracer.append(stringBuffer, string, n2, "&#13;");
                    break;
                }
                default: {
                    if (c >= '\u0080') {
                        String string2 = "&#" + c + ";";
                        stringBuffer = XMLTracer.append(stringBuffer, string, n2, string2);
                        break;
                    }
                    if (stringBuffer == null) break;
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer append(StringBuffer stringBuffer, String string, int n, String string2) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }
}

