/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.sax.impl;

import com.ibm.xml.xlxp.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.api.util.SymbolStringMappings;
import com.ibm.xml.xlxp.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class SAX2ParserBase
implements Attributes,
Locator,
XMLReader {
    private static final boolean RETAIN_OBJECTS_ACROSS_RESET = true;
    private static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    private static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    private static final String fgEmptyString = "".intern();
    protected DataBufferFactory fBufferFactory = new SimpleDataBufferFactory();
    protected SymbolTable fSymbolTable = new SymbolTable(this.fBufferFactory);
    protected XMLStringBuffer fStringBuffer = new XMLStringBuffer(this.fBufferFactory);
    protected SymbolStringMappings fSymbolStringMappings = new SymbolStringMappings(this.fSymbolTable);
    protected InputSource fInputSource = new InputSource();
    protected ErrorHandler fErrorHandler;
    protected ContentHandler fContentHandler;
    protected LexicalHandler fLexicalHandler;
    protected char[][] fCharBuffer = new char[1][256];
    protected int[] fCharBufferOffset = new int[1];
    protected boolean fValidation;
    protected boolean fNamespaces = true;
    protected boolean fNamespacePrefixes;
    protected boolean fSeenEnumeration;
    protected XMLString fEnumeration;
    protected boolean fNeedReset;
    protected int fAttrCount;
    protected int fAttrOffset;
    protected NSDeclList fNamespaceDecls;
    protected AttrList fAttributes;
    protected int fElementDepth;
    protected boolean fInElementContent;
    protected String[] fQNameStringStack = new String[48];
    protected int fQNameStackDepth;
    private XMLString fPartialContent;

    protected abstract void parseEvents(InputSource var1);

    protected abstract void pushElement(QName var1);

    protected abstract void popElement();

    protected abstract boolean getScanExternalGeneralEntities(String var1);

    protected abstract void setScanExternalGeneralEntities(String var1, boolean var2);

    protected abstract boolean getScanExternalParameterEntities(String var1);

    protected abstract void setScanExternalParameterEntities(String var1, boolean var2);

    protected abstract DeclHandler getDeclHandler();

    protected abstract void setDeclHandler(DeclHandler var1);

    public abstract DTDHandler getDTDHandler();

    public abstract void setDTDHandler(DTDHandler var1);

    public abstract EntityResolver getEntityResolver();

    public abstract void setEntityResolver(EntityResolver var1);

    protected SAX2ParserBase() {
    }

    protected void reset(boolean bl) {
        this.fSymbolStringMappings.reset(bl);
        this.fElementDepth = 0;
        this.fQNameStackDepth = 0;
    }

    protected final String handleToString(int n) {
        if (n > 0) {
            return this.fSymbolStringMappings.toString(n);
        }
        if (n == 0) {
            return fgEmptyString;
        }
        return null;
    }

    public void xmlDeclEvent() {
    }

    protected void textDeclEvent() {
    }

    protected void startDTD(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startDTD(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3 == null ? null : xMLString3.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    protected void startPrefixMappings(NSDeclList nSDeclList) {
        int n = nSDeclList.nsDeclCount();
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3 = nSDeclList.nsDeclPrefix(n2);
                int n4 = nSDeclList.nsDeclURI(n2);
                this.fContentHandler.startPrefixMapping(this.handleToString(n3), this.handleToString(n4));
                ++n2;
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    protected void endPrefixMappings(NSDeclList nSDeclList) {
        int n = nSDeclList.nsDeclCount();
        try {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = nSDeclList.nsDeclPrefix(n2);
                this.fContentHandler.endPrefixMapping(this.handleToString(n3));
                --n2;
            }
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    public void startElementEvent(QName qName, NSDeclList nSDeclList, AttrList attrList, boolean bl) {
        this.fNamespaceDecls = nSDeclList;
        this.fAttributes = attrList;
        this.startElementAction(qName, bl);
        if (!bl) {
            this.pushElement(qName);
            ++this.fElementDepth;
        }
    }

    protected void startElementAction(QName qName, boolean bl) {
        this.fAttrCount = -1;
        if (this.fContentHandler != null) {
            try {
                String string = this.handleToString(qName.nsHandle);
                String string2 = this.handleToString(qName.localHandle);
                String string3 = this.handleToString(qName.handle);
                this.startPrefixMappings(this.fNamespaceDecls);
                this.fContentHandler.startElement(string, string2, string3, this);
                if (bl) {
                    this.fContentHandler.endElement(string, string2, string3);
                    this.endPrefixMappings(this.fNamespaceDecls);
                } else {
                    if (this.fQNameStackDepth == this.fQNameStringStack.length) {
                        String[] stringArray = new String[this.fQNameStackDepth << 1];
                        System.arraycopy(this.fQNameStringStack, 0, stringArray, 0, this.fQNameStackDepth);
                        this.fQNameStringStack = stringArray;
                    }
                    this.fQNameStringStack[this.fQNameStackDepth] = string;
                    this.fQNameStringStack[this.fQNameStackDepth + 1] = string2;
                    this.fQNameStringStack[this.fQNameStackDepth + 2] = string3;
                    this.fQNameStackDepth += 3;
                }
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endElementEvent(QName qName, NSDeclList nSDeclList) {
        --this.fElementDepth;
        this.popElement();
        if (this.fContentHandler != null) {
            this.fNamespaceDecls = nSDeclList;
            this.fQNameStackDepth -= 3;
            String string = this.fQNameStringStack[this.fQNameStackDepth];
            String string2 = this.fQNameStringStack[this.fQNameStackDepth + 1];
            String string3 = this.fQNameStringStack[this.fQNameStackDepth + 2];
            try {
                this.fContentHandler.endElement(string, string2, string3);
                this.endPrefixMappings(this.fNamespaceDecls);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void characters(XMLString xMLString) {
        if (this.fContentHandler != null) {
            if (xMLString.bytes != null || xMLString.firstBuffer == xMLString.lastBuffer || xMLString.firstBuffer.next == xMLString.lastBuffer) {
                this.fCharBufferOffset[0] = 0;
                xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
                try {
                    this.fContentHandler.characters(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
                }
                catch (SAXException sAXException) {
                    throw new SAXExceptionWrapper(sAXException);
                }
            } else {
                this.processCharactersInPieces(xMLString);
            }
        }
    }

    private final void processCharactersInPieces(XMLString xMLString) {
        if (this.fPartialContent == null) {
            this.fPartialContent = new XMLString();
        }
        this.fPartialContent.flags = xMLString.flags;
        boolean bl = (this.fPartialContent.flags & 4) != 0;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        int n = xMLString.startOffset;
        DataBuffer dataBuffer2 = dataBuffer.next;
        boolean bl2 = bl && dataBuffer2.bytes[dataBuffer2.endOffset - 1] == 13;
        int n2 = dataBuffer2.endOffset - (bl2 ? 1 : 0);
        this.setPartialContentValues(dataBuffer, dataBuffer2, n, n2);
        while (true) {
            this.fCharBufferOffset[0] = 0;
            this.fPartialContent.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fContentHandler.characters(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
            if (dataBuffer2 == xMLString.lastBuffer) break;
            if (bl2) {
                dataBuffer = dataBuffer2;
                n = dataBuffer.endOffset;
            } else {
                dataBuffer = dataBuffer2.next;
                n = dataBuffer.startOffset;
            }
            if (dataBuffer != xMLString.lastBuffer) {
                dataBuffer2 = dataBuffer.next;
                if (dataBuffer2 != xMLString.lastBuffer) {
                    bl2 = bl && dataBuffer2.bytes[dataBuffer2.endOffset - 1] == 13;
                    n2 = dataBuffer2.endOffset - (bl2 ? 1 : 0);
                } else {
                    n2 = xMLString.endOffset;
                }
            } else {
                dataBuffer2 = dataBuffer;
                n2 = xMLString.endOffset;
            }
            this.setPartialContentValues(dataBuffer, dataBuffer2, n, n2);
        }
        this.setPartialContentValues(null, null, 0, 0);
    }

    private final void setPartialContentValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        this.fPartialContent.firstBuffer = dataBuffer;
        this.fPartialContent.lastBuffer = dataBuffer2;
        this.fPartialContent.startOffset = n;
        this.fPartialContent.endOffset = n2;
    }

    public void whitespace(XMLString xMLString) {
        if (this.fContentHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fContentHandler.ignorableWhitespace(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void character(int n, boolean bl) {
        if (this.fContentHandler != null) {
            int n2;
            if (n < 65536) {
                this.fCharBuffer[0][0] = (char)n;
                n2 = 1;
            } else {
                int n3 = n - 65536;
                this.fCharBuffer[0][0] = (char)(55296 + (n3 >> 10));
                this.fCharBuffer[0][1] = (char)(56320 + (n3 & 0x3FF));
                n2 = 2;
            }
            try {
                this.fContentHandler.characters(this.fCharBuffer[0], 0, n2);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void processingInstruction(XMLString xMLString, XMLString xMLString2) {
        if (this.fContentHandler != null) {
            int n = this.fSymbolTable.addSymbol(xMLString);
            try {
                this.fContentHandler.processingInstruction(this.handleToString(n), xMLString2.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void startEntity(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endEntity(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endEntity(xMLString.toString());
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void startCDATASection() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.startCDATA();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void endCDATASection() {
        if (this.fLexicalHandler != null) {
            try {
                this.fLexicalHandler.endCDATA();
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void comment(XMLString xMLString) {
        if (this.fLexicalHandler != null) {
            this.fCharBufferOffset[0] = 0;
            xMLString.getChars(this.fCharBuffer, this.fCharBufferOffset);
            try {
                this.fLexicalHandler.comment(this.fCharBuffer[0], 0, this.fCharBufferOffset[0]);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportWarning(String string, int n, int n2, XMLString[] xMLStringArray) {
        if (this.fErrorHandler != null) {
            try {
                MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string);
                String string2 = messageProvider.createMessage(null, n, xMLStringArray);
                SAXParseException sAXParseException = new SAXParseException(string2, this);
                this.fErrorHandler.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportRecoverableError(String string, int n, int n2, XMLString[] xMLStringArray) {
        if (this.fErrorHandler != null) {
            try {
                MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string);
                String string2 = messageProvider.createMessage(null, n, xMLStringArray);
                SAXParseException sAXParseException = new SAXParseException(string2, this);
                this.fErrorHandler.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXExceptionWrapper(sAXException);
            }
        }
    }

    public void reportFatalError(String string, int n, int n2, XMLString[] xMLStringArray) {
        try {
            MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(string);
            String string2 = messageProvider.createMessage(null, n, xMLStringArray);
            SAXParseException sAXParseException = new SAXParseException(string2, this);
            if (this.fErrorHandler != null) {
                this.fErrorHandler.fatalError(sAXParseException);
            }
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
    }

    private void calculateAttrCount() {
        this.fAttrOffset = this.fNamespacePrefixes ? this.fNamespaceDecls.nsDeclCount() : 0;
        this.fAttrCount = this.fAttrOffset + this.fAttributes.attributeCount();
    }

    public int getLength() {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        return this.fAttrCount;
    }

    public String getURI(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.handleToString(this.fAttributes.attributeName((int)(n - this.fAttrOffset)).nsHandle);
            }
        } else if (n >= 0) {
            return "";
        }
        return null;
    }

    public String getLocalName(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.handleToString(this.fAttributes.attributeName((int)(n - this.fAttrOffset)).localHandle);
            }
        } else if (n >= 0) {
            return "";
        }
        return null;
    }

    public String getQName(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.handleToString(this.fAttributes.attributeName((int)(n - this.fAttrOffset)).handle);
            }
        } else if (n >= 0) {
            return this.handleToString(this.fNamespaceDecls.nsDeclQName(n));
        }
        return null;
    }

    public String getType(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                int n2 = this.fAttributes.attributeType(n - this.fAttrOffset);
                if (n2 == -1) {
                    return "NMTOKEN";
                }
                if (n2 == 0) {
                    return "CDATA";
                }
                return this.handleToString(n2);
            }
        } else if (n >= 0) {
            return "CDATA";
        }
        return null;
    }

    public String getValue(int n) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (n >= this.fAttrOffset) {
            if (n < this.fAttrCount) {
                return this.fAttributes.normalizedAttributeValue(n -= this.fAttrOffset).toString();
            }
        } else if (n >= 0) {
            return this.handleToString(this.fNamespaceDecls.nsDeclURI(n));
        }
        return null;
    }

    public int getIndex(String string, String string2) {
        int n;
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if ((n = this.fAttrCount - this.fAttrOffset) > 0) {
            int n2 = this.fSymbolStringMappings.addSymbol(string2);
            int n3 = -1;
            int n4 = 0;
            while (n4 < n) {
                QName qName = this.fAttributes.attributeName(n4);
                if (n2 == qName.localHandle) {
                    if (n3 == -1) {
                        n3 = this.fSymbolStringMappings.addSymbol(string);
                    }
                    if (n3 == qName.nsHandle) {
                        return this.fAttrOffset + n4;
                    }
                }
                ++n4;
            }
        }
        return -1;
    }

    public int getIndex(String string) {
        if (this.fAttrCount == -1) {
            this.calculateAttrCount();
        }
        if (this.fAttrCount > 0) {
            int n = this.fSymbolStringMappings.addSymbol(string);
            int n2 = this.fAttrCount - this.fAttrOffset;
            int n3 = 0;
            while (n3 < n2) {
                if (n == this.fAttributes.attributeName((int)n3).handle) {
                    return this.fAttrOffset + n3;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.fAttrOffset) {
                if (n == this.fNamespaceDecls.nsDeclQName(n3)) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.getType(n);
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        return this.getType(n);
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.getValue(n);
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        return this.getValue(n);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    protected boolean getValidation(String string) {
        return false;
    }

    protected void setValidation(String string, boolean bl) throws SAXNotSupportedException {
        if (bl) {
            throw new SAXNotSupportedException(string);
        }
    }

    protected boolean getGrammarCachingEnabled(String string) {
        return false;
    }

    protected void setGrammarCachingEnabled(String string, boolean bl) throws SAXNotSupportedException {
        if (bl) {
            throw new SAXNotSupportedException(string);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("namespaces")) {
                return this.fNamespaces;
            }
            if (string2.equals("namespace-prefixes")) {
                return this.fNamespacePrefixes;
            }
            if (string2.equals("string-interning")) {
                return false;
            }
            if (string2.equals("validation")) {
                return this.getValidation(string);
            }
            if (string2.equals("validation/grammar-caching-enabled")) {
                return this.getGrammarCachingEnabled(string);
            }
            if (string2.equals("external-general-entities")) {
                return this.getScanExternalGeneralEntities(string);
            }
            if (string2.equals("external-parameter-entities")) {
                return this.getScanExternalParameterEntities(string);
            }
            if (string2.equals("lexical-handler/parameter-entities")) {
                return false;
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("namespaces")) {
                this.fNamespaces = bl;
                return;
            }
            if (string2.equals("namespace-prefixes")) {
                this.fNamespacePrefixes = bl;
                return;
            }
            if (string2.equals("string-interning")) {
                if (bl) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string2.equals("validation")) {
                this.setValidation(string, bl);
                return;
            }
            if (string2.equals("validation/grammar-caching-enabled")) {
                this.setGrammarCachingEnabled(string, bl);
                return;
            }
            if (string2.equals("external-general-entities")) {
                this.setScanExternalGeneralEntities(string, bl);
                return;
            }
            if (string2.equals("external-parameter-entities")) {
                this.setScanExternalParameterEntities(string, bl);
                return;
            }
            if (string2.equals("lexical-handler/parameter-entities") && bl) {
                throw new SAXNotSupportedException(string);
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("xml-string")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("lexical-handler")) {
                return this.fLexicalHandler;
            }
            if (string2.equals("declaration-handler")) {
                return this.getDeclHandler();
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("dom-node")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("xml-string")) {
                throw new SAXNotSupportedException(string);
            }
            if (string2.equals("lexical-handler")) {
                try {
                    this.fLexicalHandler = (LexicalHandler)object;
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
            if (string2.equals("declaration-handler")) {
                try {
                    this.setDeclHandler((DeclHandler)object);
                    return;
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    private void parseEntity(InputSource inputSource) throws SAXException, IOException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        try {
            if (this.fContentHandler != null) {
                this.fContentHandler.setDocumentLocator(this);
                this.fContentHandler.startDocument();
            }
            this.parseEvents(inputSource);
            if (this.fContentHandler != null) {
                this.fContentHandler.endDocument();
            }
        }
        catch (IOExceptionWrapper iOExceptionWrapper) {
            throw iOExceptionWrapper.getIOException();
        }
        catch (SAXExceptionWrapper sAXExceptionWrapper) {
            throw sAXExceptionWrapper.getSAXException();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception.getMessage());
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.fInputSource.setPublicId(inputSource.getPublicId());
        this.fInputSource.setSystemId(inputSource.getSystemId());
        this.fInputSource.setEncoding(inputSource.getEncoding());
        this.fInputSource.setByteStream(inputSource.getByteStream());
        this.fInputSource.setCharacterStream(inputSource.getCharacterStream());
        this.parseEntity(this.fInputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.fInputSource.setSystemId(string);
        this.fInputSource.setPublicId(null);
        this.fInputSource.setEncoding(null);
        this.fInputSource.setByteStream(null);
        this.fInputSource.setCharacterStream(null);
        this.parseEntity(this.fInputSource);
    }
}

