/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.util.ArrayList;
import java.util.List;

public class TransferEncodingValues
extends GenericKeys {
    private static final int NUM_REQUIRED = 2;
    private static int numDefined = 2;
    private static List allKeys = new ArrayList();
    private boolean undefined = false;

    public TransferEncodingValues(String string) {
        super(string, numDefined);
        ++numDefined;
        allKeys.add(this);
    }

    public TransferEncodingValues(String string, int n) {
        super(string, n);
        if (n > 2) {
            throw new IllegalArgumentException("Illegal input ordinal " + n);
        }
    }

    private TransferEncodingValues(TransferEncodingValues transferEncodingValues) {
        super(transferEncodingValues.getName(), transferEncodingValues.getOrdinal());
    }

    public static TransferEncodingValues makeUndefinedValue(byte[] byArray) {
        TransferEncodingValues transferEncodingValues = new TransferEncodingValues(HttpConstants.TRANSFER_ENCODING_UNDEF);
        transferEncodingValues.byteArray = byArray;
        transferEncodingValues.name = HttpChannelUtils.getEnglishString(byArray);
        transferEncodingValues.hashcode = transferEncodingValues.ordinal + transferEncodingValues.name.hashCode();
        transferEncodingValues.undefined = true;
        return transferEncodingValues;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public static List getAllKeys() {
        return allKeys;
    }

    public static TransferEncodingValues getByOrdinal(int n) {
        if (0 > n || n >= numDefined) {
            throw new IndexOutOfBoundsException("TransferEncodingValues index " + n + " is out of bounds");
        }
        return (TransferEncodingValues)allKeys.get(n - 2);
    }

    public int compareTo(TransferEncodingValues transferEncodingValues) {
        return null == transferEncodingValues ? -1 : this.getOrdinal() - transferEncodingValues.getOrdinal();
    }
}

