/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.urimap.Prefix;
import com.ibm.ws.wsaddressing.urimap.WebserviceDescriptionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleData {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.urimap.ModuleData";
    private static TraceComponent _tc = Tr.register(ModuleData.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    public static final String TRANSPORT_HTTP = "http";
    public static final String TRANSPORT_HTTPS = "https";
    public static final String TRANSPORT_JMS = "jms";
    public static final String TRANSPORT_EJB = "ejb";
    private String name;
    private String defaultPrefix;
    private String virtualHostName;
    private String contextRoot;
    private String applicationName;
    private String defaultJMSPrefix;
    private boolean hasHTTPRouter = false;
    private boolean hasJMSRouter = false;
    private String defaultEJBPrefix;
    private boolean intermediaryPresent = false;
    private Set modulesWsdlFiles;
    private List prefixList = new LinkedList();
    private Set virtualHostPorts = new HashSet();
    private Set virtualHostAliases = new HashSet();
    private boolean isWebModule;
    private List webservicesDescriptions = new ArrayList();

    public boolean isIntermediaryPresent() {
        return this.intermediaryPresent;
    }

    public void setVirtualHost(VirtualHost virtualHost) {
        Object object;
        Iterator iterator;
        Object object2;
        if (virtualHost != null) {
            this.virtualHostName = virtualHost.getName();
            object2 = virtualHost.getAliases();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (HostAlias)iterator.next();
                this.virtualHostPorts.add(object.getPort());
                this.virtualHostAliases.add(object);
            }
        } else {
            this.virtualHostName = "";
        }
        if (_tc.isDebugEnabled()) {
            object2 = "null";
            if (virtualHost != null) {
                object2 = virtualHost.getName();
            }
            Tr.debug(_tc, "setVirtualHost: for module \"" + this.name + "\" the virtualHost is \"" + (String)object2 + "\" and its ports are:");
            iterator = this.virtualHostPorts.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Tr.debug(_tc, (String)object);
            }
            Tr.debug(_tc, "\n");
        }
    }

    public boolean addPrefix(Prefix prefix) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addPrefix", new Object[]{prefix});
        }
        boolean bl = false;
        String string = prefix.getHost();
        String string2 = prefix.getPort();
        Iterator iterator = this.virtualHostAliases.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = true;
            HostAlias hostAlias = (HostAlias)iterator.next();
            String string3 = hostAlias.getHostname();
            String string4 = hostAlias.getPort();
            if (!string3.equals("*")) {
                bl2 = string3.equals(string);
            }
            if (bl2 && !string4.equals("*")) {
                bl2 = string4.equals(string2);
            }
            if (!bl2) continue;
            bl = true;
            this.prefixList.add(prefix);
            break;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addPrefix", new Boolean(bl));
        }
        return bl;
    }

    public List getPrefixList() {
        if (this.prefixList.size() == 0) {
            this.prefixList.add(new Prefix("", "", ""));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((Prefix)iterator.next()).toString());
        }
        return linkedList;
    }

    public String getDefaultPrefix() {
        if (this.defaultPrefix == null) {
            this.defaultPrefix = "";
            if (this.prefixList != null) {
                Iterator iterator = this.prefixList.iterator();
                while (iterator.hasNext()) {
                    Prefix prefix = (Prefix)iterator.next();
                    this.defaultPrefix = prefix.toString();
                    if (!prefix.protocol.equals(TRANSPORT_HTTP)) continue;
                    break;
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "default http prefix is: " + this.defaultPrefix);
        }
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String string) {
        this.defaultPrefix = string;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public void addWebservicesDescription(WebserviceDescriptionInfo webserviceDescriptionInfo) {
        this.webservicesDescriptions.add(webserviceDescriptionInfo);
    }

    public List getWebservicesDescritions() {
        return this.webservicesDescriptions;
    }

    public Map getMergedQNameToUrlPatternMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        Iterator iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            Map map2 = webserviceDescriptionInfo.getQNameToUrlPatternMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public Map getMergedQNameToPortComponentNameMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        Iterator iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            Map map2 = webserviceDescriptionInfo.getQnameToPortComponentNameMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public Map getMergedQNameToEJBUrlPrefixMap(String string) {
        HashMap hashMap = new HashMap();
        Map map = null;
        Iterator iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            Map map2 = webserviceDescriptionInfo.getQNameToEJBUrlPrefixMap();
            if (string != null && webserviceDescriptionInfo.getWebserviceDescriptionName().equals(string)) {
                map = map2;
            }
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n");
        stringBuffer.append("applicationName=").append(this.applicationName).append("\n");
        stringBuffer.append("name=").append(this.name).append("\n");
        stringBuffer.append("defaultPrefix=").append(this.defaultPrefix).append("\n");
        stringBuffer.append("virtuaHostName=").append(this.virtualHostName).append("\n");
        stringBuffer.append("contextRoot=").append(this.contextRoot).append("\n");
        stringBuffer.append("prefixList contains:\n");
        Iterator iterator = this.prefixList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t").append(iterator.next()).append("\n");
        }
        stringBuffer.append("webServicesDescriptions contains:\n");
        iterator = this.webservicesDescriptions.iterator();
        while (iterator.hasNext()) {
            WebserviceDescriptionInfo webserviceDescriptionInfo = (WebserviceDescriptionInfo)iterator.next();
            stringBuffer.append(webserviceDescriptionInfo.toString());
        }
        stringBuffer.append("virtualHostPorts contains:\n");
        iterator = this.virtualHostPorts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        stringBuffer.append("modulesWsdlFiles contains:\n");
        iterator = this.modulesWsdlFiles.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    public void setIsWebModule(boolean bl) {
        this.isWebModule = bl;
    }

    public boolean isWebModule() {
        return this.isWebModule;
    }

    public void setModulesWsdlFiles(Set set) {
        this.modulesWsdlFiles = set;
    }

    public Set getModulesWsdlFiles() {
        return this.modulesWsdlFiles;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getDefaultJMSPrefix() {
        return this.defaultJMSPrefix;
    }

    public void setDefaultJMSPrefix(String string) {
        this.defaultJMSPrefix = string;
    }

    public boolean hasHTTPRouter() {
        return this.hasHTTPRouter;
    }

    public void setHasHTTPRouter(boolean bl) {
        this.hasHTTPRouter = bl;
    }

    public boolean hasJMSRouter() {
        return this.hasJMSRouter;
    }

    public void setHasJMSRouter(boolean bl) {
        this.hasJMSRouter = bl;
    }

    public String getDefaultEJBPrefix() {
        return this.defaultEJBPrefix;
    }

    public void setDefaultEJBPrefix(String string) {
        this.defaultEJBPrefix = string;
    }

    public void setIntermediary(boolean bl) {
        this.intermediaryPresent = bl;
    }
}

