/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.BooleanHolder;

public class JavaTestCaseWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    private int counter = 1;

    protected JavaTestCaseWriter(Emitter emitter, ServiceEntry serviceEntry, SymbolTable symbolTable) {
        super(emitter, serviceEntry.getName() + "TestCase", "testCase");
        this.sEntry = serviceEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends junit.framework.TestCase ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        printWriter.print("    public ");
        printWriter.print(this.getClassName());
        printWriter.println("(java.lang.String name) {");
        printWriter.println("        super(name);");
        printWriter.println("    }");
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            PortEntry portEntry = this.sEntry.getPort(i);
            Port port2 = portEntry.getPort();
            Binding binding = port2.getBinding();
            BindingEntry bindingEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry.getBindingType() != 0) continue;
            String string = JavaUtils.xmlNameToJavaClass(portEntry.getName());
            PortType portType = binding.getPortType();
            PortTypeEntry portTypeEntry = this.symbolTable.getPortTypeEntry(portType.getQName());
            this.writeComment(printWriter, port2.getDocumentationElement());
            this.writeServiceTestCode(printWriter, string, portType, portTypeEntry, binding, bindingEntry);
        }
    }

    private final void writeServiceTestCode(PrintWriter printWriter, String string, PortType portType, PortTypeEntry portTypeEntry, Binding binding, BindingEntry bindingEntry) throws IOException {
        Iterator iterator = portType.getOperations().iterator();
        while (iterator.hasNext()) {
            Object object;
            Entry entry;
            int n;
            Operation operation = (Operation)iterator.next();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
            String string2 = (String)bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
            BooleanHolder booleanHolder = new BooleanHolder(false);
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println("    " + string2);
                continue;
            }
            String string3 = bindingOperationEntry.getName();
            String string4 = "test" + this.counter++ + string + string3;
            printWriter.println("    public void " + string4 + "() throws Exception {");
            String string5 = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
            this.writeBindingAssignment(printWriter, string5, string);
            printWriter.println("        // Test operation");
            String string6 = "";
            if (bindingOperationEntry.numFaults() > 0) {
                printWriter.println("        try {");
                string6 = "    ";
            }
            if (bindingOperationEntry.getReturn() != null) {
                String string7 = (String)bindingOperationEntry.getReturn().getDynamicVar("parameterType");
                printWriter.print("        " + string6);
                printWriter.print(string7 + " value = ");
                if (bindingOperationEntry.getReturn().getMIMEType() == null && Utils.isPrimitiveType(string7)) {
                    if ("boolean".equals(string7)) {
                        printWriter.println("false;");
                    } else {
                        printWriter.println("-3;");
                    }
                } else {
                    printWriter.println("null;");
                }
            }
            printWriter.print("        " + string6);
            if (bindingOperationEntry.getReturn() != null) {
                printWriter.print("value = ");
            }
            printWriter.print("binding.");
            printWriter.print(bindingOperationEntry.getName());
            printWriter.print("(");
            for (n = 0; n < bindingOperationEntry.numParameters(); ++n) {
                if (n > 0) {
                    printWriter.print(", ");
                }
                if (((BindingParamEntry)(entry = bindingOperationEntry.getParameter(n))).getMode() != 1) {
                    printWriter.print("new " + entry.getDynamicVar("parameterSignatureType") + "(");
                }
                if (((BindingParamEntry)entry).getMode() != 2) {
                    object = Utils.getConstructorForParam((BindingParamEntry)entry, this.symbolTable, booleanHolder);
                    printWriter.print((String)object);
                }
                if (((BindingParamEntry)entry).getMode() == 1) continue;
                printWriter.print(")");
            }
            printWriter.println(");");
            if (bindingOperationEntry.numFaults() > 0) {
                printWriter.println("        }");
            }
            for (n = 0; n < bindingOperationEntry.numFaults(); ++n) {
                entry = bindingOperationEntry.getFault(n);
                object = ((BindingFaultRefEntry)entry).getMessageEntry();
                SymTabEntry symTabEntry = (SymTabEntry)((Entry)object).getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
                printWriter.print("        catch (");
                printWriter.print(symTabEntry.getName());
                printWriter.println(" e" + n + ") {");
                printWriter.print("            ");
                printWriter.println("throw new junit.framework.AssertionFailedError(\"" + symTabEntry.getName() + " Exception caught: \" + e" + n + ");");
                printWriter.println("        }");
            }
            printWriter.println("        " + string6 + "// TBD - validate results");
            printWriter.println("    }");
            printWriter.println();
        }
    }

    public final void writeBindingAssignment(PrintWriter printWriter, String string, String string2) throws IOException {
        printWriter.println("        " + string + " binding;");
        printWriter.println("        try {");
        printWriter.print("            binding = new " + this.sEntry.getName());
        printWriter.println("Locator().get" + string2 + "();");
        printWriter.println("        }");
        printWriter.println("        catch (" + ServiceException.class.getName() + " jre) {");
        printWriter.println("            if(jre.getLinkedCause()!=null)");
        printWriter.println("                jre.getLinkedCause().printStackTrace();");
        printWriter.println("            throw new junit.framework.AssertionFailedError(\"JAX-RPC ServiceException caught: \" + jre);");
        printWriter.println("        }");
        printWriter.println("        assertTrue(\"" + Messages.getMessage("null00", "binding") + "\", binding != null);");
        printWriter.println();
    }
}

