/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.enumtype.Scope;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.Parser;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.GeneratedFileInfo;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.JavaSearchCriteria;
import com.ibm.ws.webservices.wsdl.toJava.Namespaces;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Scenario;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Emitter
extends Parser {
    private static String binaryCopyright = Version.getBinaryCopyright();
    protected static Log log = LogFactory.getLog(Emitter.class.getName());
    protected HashMap namespaceMap = new HashMap();
    protected String typeMappingVersion = "1.1";
    protected BaseTypeMapping baseTypeMapping = null;
    protected Namespaces namespaces = null;
    protected String NStoPkgFilename = "NStoPkg.properties";
    protected File NStoPkgFile = null;
    MappingMetaData inputMMD = null;
    MappingMetaData outputMMD = null;
    private CustomRegistry customRegistry;
    private String inputMappingFile = null;
    private String altOutputMappingFile = null;
    private Role role = Role.DEVELOP_CLIENT;
    private Container container = Container.NONE;
    private GenCriteria genJava = GenCriteria.IFNOTEXISTS;
    private GenCriteria genXML = GenCriteria.IFNOTEXISTS;
    private JavaSearchCriteria javaSearch = JavaSearchCriteria.FILE;
    private Scenario scenario = Scenario.NORMAL;
    private boolean bEmitTestCase = false;
    private boolean bResolver = false;
    private boolean bGenerateAll = false;
    private Scope scope = null;
    private GeneratedFileInfo fileInfo = null;
    private HashMap delayedNamespacesMap = new HashMap();
    private String outputDir = null;
    private String javaOutputDir = null;
    private boolean noDataBinding = false;
    private boolean noWrappedArrays = false;
    private boolean noWrappedOperations = false;
    private LinkedHashSet servicesToWrite = null;
    private HashMap dynamicVars = new HashMap();
    private boolean introspect = false;
    private boolean allowRelativeNamespace = false;
    private String classpath = null;
    private boolean genEquals = false;
    private boolean genImplSer = false;
    boolean jsr101v11 = true;
    private static final String EXT_OPT_DELIMITERS = " ,;{}";
    private static final String REL_NS = "allowRelativeNamespace";
    private Properties XProperties = null;
    protected String propertiesFilename = "extraOptions.properties";
    private static HashMap validOptions = new HashMap();

    public Emitter() {
        this.outputMMD = new MappingMetaData();
        this.fileInfo = new GeneratedFileInfo();
        this.setFactory(new JavaGeneratorFactory(this));
    }

    public Emitter(boolean bl) {
        if (!bl) {
            this.outputMMD = new MappingMetaData();
            this.fileInfo = new GeneratedFileInfo();
        }
        this.setFactory(new JavaGeneratorFactory(this, bl));
    }

    public Object getDynamicVar(Object object) {
        return this.dynamicVars.get(object);
    }

    public void setDynamicVar(Object object, Object object2) {
        this.dynamicVars.put(object, object2);
    }

    public void addServicesToBeWritten(String string) {
        if (this.servicesToWrite == null) {
            this.servicesToWrite = new LinkedHashSet();
        }
        this.servicesToWrite.add(string);
    }

    public void setServicesToBeWritten(Set set) {
        this.servicesToWrite = set == null ? null : new LinkedHashSet(set);
    }

    public void setMETA_INF_Only(boolean bl) {
        if (bl) {
            this.setGenJava("No");
            this.setGenXML("IfNotExists");
        }
    }

    public boolean getMETA_INF_Only() {
        return this.getGenJava() == GenCriteria.NO && this.getGenXML() == GenCriteria.IFNOTEXISTS;
    }

    public void setTestCaseWanted(boolean bl) {
        this.bEmitTestCase = bl;
    }

    public boolean isTestCaseWanted() {
        return this.bEmitTestCase;
    }

    public void setGenerateResolver(boolean bl) {
        if (this.getResolver() == null) {
            this.bResolver = bl;
        }
    }

    public boolean generateResolver() {
        return this.bResolver;
    }

    public void setResolver(String string, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!this.bResolver) {
            super.setResolver(string, bl);
        }
    }

    public void setAllWanted(boolean bl) {
        this.bGenerateAll = bl;
    }

    public boolean isAllWanted() {
        return this.bGenerateAll;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(HashMap hashMap) {
        this.namespaces = new Namespaces(this.getJavaOutputDir(), this.env);
        this.namespaces.putAll((Map)hashMap);
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public boolean setJavaSearch(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = JavaSearchCriteria.isValid(string);
        this.javaSearch = JavaSearchCriteria.getJavaSearchCriteria(string, JavaSearchCriteria.FILE);
        return bl;
    }

    public JavaSearchCriteria getJavaSearch() {
        return this.javaSearch;
    }

    public void setJavaOutputDir(String string) {
        this.javaOutputDir = string;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getJavaOutputDir() {
        if (this.javaOutputDir != null) {
            return this.javaOutputDir;
        }
        return this.outputDir;
    }

    public void setNoDataBinding(boolean bl) {
        this.noDataBinding = bl;
    }

    public boolean getNoDataBinding() {
        return this.noDataBinding;
    }

    public void setNoWrappedArrays(boolean bl) {
        this.noWrappedArrays = bl;
    }

    public boolean getNoWrappedArrays() {
        return this.noWrappedArrays;
    }

    public void setNoWrappedOperations(boolean bl) {
        this.noWrappedOperations = bl;
    }

    public boolean getNoWrappedOperations() {
        return this.noWrappedOperations;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setNStoPkg(String string) {
        if (string != null) {
            this.NStoPkgFilename = string;
        }
    }

    public void setNStoPkg(File file) {
        this.NStoPkgFile = file;
    }

    public void setNamespaceMap(HashMap hashMap) {
        this.delayedNamespacesMap = hashMap;
    }

    public HashMap getNamespaceMap() {
        return this.delayedNamespacesMap;
    }

    public void setFactory(String string) {
        try {
            this.setFactory((GeneratorFactory)ClassUtils.forName(string).newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean setContainer(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.equalsIgnoreCase("Bean") || string.equalsIgnoreCase("servlet")) {
            string = "WEB";
        }
        boolean bl = Container.isValid(string);
        this.container = Container.getContainer(string, Container.NONE);
        return bl;
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean setRole(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = Role.isValid(string);
        this.role = Role.getRole(string, Role.DEVELOP_CLIENT);
        return bl;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean setGenJava(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = GenCriteria.isValid(string);
        this.genJava = GenCriteria.getGenCriteria(string, GenCriteria.IFNOTEXISTS);
        return bl;
    }

    public GenCriteria getGenJava() {
        return this.genJava;
    }

    public boolean setGenXML(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = GenCriteria.isValid(string);
        this.genXML = GenCriteria.getGenCriteria(string, GenCriteria.IFNOTEXISTS);
        return bl;
    }

    public GenCriteria getGenXML() {
        return this.genXML;
    }

    public void setInputMappingFile(String string) {
        if (string != null && string.length() > 0) {
            this.inputMappingFile = string;
        }
    }

    public void setInputMapping(MappingMetaData mappingMetaData) {
        this.inputMMD = mappingMetaData;
    }

    public void setAltOutputMappingFile(String string) {
        if (string != null && string.length() > 0) {
            this.altOutputMappingFile = string;
        }
    }

    public String getAltOutputMappingFile() {
        return this.altOutputMappingFile;
    }

    public GeneratedFileInfo getGeneratedFileInfo() {
        return this.fileInfo;
    }

    public List getGeneratedClassNames() {
        return this.fileInfo.getClassNames();
    }

    public List getGeneratedFileNames() {
        return this.fileInfo.getFileNames();
    }

    public String getPackage(String string) {
        return this.namespaces.getCreate(string);
    }

    public String getPackage(QName qName) {
        return this.getPackage(qName.getNamespaceURI());
    }

    public String getJavaName(QName qName) {
        if (qName.getLocalPart().indexOf("[") > 0) {
            String string = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["));
            QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), string);
            return this.getJavaName(qName2) + "[]";
        }
        if (qName.getLocalPart().indexOf("(nillable)") > 0) {
            String string = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("(nillable)"));
            QName qName3 = QNameTable.createQName(qName.getNamespaceURI(), string);
            String string2 = this.getJavaName(qName3);
            return Utils.getWrapperType(string2);
        }
        if (qName.getNamespaceURI().equalsIgnoreCase("java")) {
            return qName.getLocalPart();
        }
        String string = this.getFactory().getBaseTypeMapping().getBaseName(qName);
        if (string != null) {
            return string;
        }
        if (this.noDataBinding) {
            return "javax.xml.soap.SOAPElement";
        }
        String string3 = this.getPackage(qName.getNamespaceURI());
        string = string3 != null && string3 != "" ? string3 + "." + JavaUtils.xmlNameToJavaClass(qName.getLocalPart()) : JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        return string;
    }

    public void run(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.setup();
        super.run(string, document);
    }

    public void run(String string, Document document, Definition definition) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.setup();
        super.run(string, document, definition);
    }

    protected void setup() throws IOException {
        boolean bl;
        if (!(this.getRole() != Role.DEVELOP_SERVER && this.getRole() != Role.SERVER || this.getContainer() != Container.CLIENT && this.getContainer() != Container.NONE)) {
            this.getToolEnv().reportWarning(Messages.getMessage("badRoleContainer00"));
            this.container = Container.WEB;
        }
        if (this.servicesToWrite != null) {
            this.metaInfo.setProperty("servicesToWrite", this.servicesToWrite);
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        if (this.classpath != null) {
            this.env.setIntrospectionClassPath(this.classpath);
        }
        this.env.setJavaOutputDir(this.getJavaOutputDir());
        this.env.setJavaSearch(this.javaSearch);
        this.env.allowRelativeNamespace(this.allowRelativeNamespace);
        if (this.baseTypeMapping == null) {
            this.setTypeMappingVersion(this.typeMappingVersion);
        }
        this.getFactory().setBaseTypeMapping(this.baseTypeMapping);
        this.namespaces = new Namespaces(this.getJavaOutputDir(), this.env);
        this.metaInfo.setNamespaces(this.namespaces);
        this.getNStoPkgFromPropsFile(this.namespaces);
        if (this.delayedNamespacesMap != null) {
            this.namespaces.putAll((Map)this.delayedNamespacesMap);
        }
        if (this.inputMappingFile != null) {
            this.inputMMD = MappingMetaData.loadFromFile(this.inputMappingFile, this.getToolEnv());
        }
        if (this.inputMMD != null) {
            this.namespaces.putAll((Map)this.inputMMD.getPackageMappings());
            this.inputMMD.preSymbolTable(this.metaInfo);
        }
        boolean bl2 = bl = this.metaInfo.getProperty("noDataBinding") == null ? false : (Boolean)this.metaInfo.getProperty("noDataBinding");
        if (this.getNoDataBinding() || bl) {
            this.metaInfo.setProperty("noDataBinding", Boolean.TRUE);
            this.setNoDataBinding(true);
            this.setNoWrappedArrays(true);
            this.setNoWrappedOperations(true);
        }
        if (this.getNoWrappedArrays()) {
            this.metaInfo.setProperty("noWrappedArrays", Boolean.TRUE);
        }
        if (this.getNoWrappedOperations()) {
            this.metaInfo.setProperty("noWrappedOperations", Boolean.TRUE);
        }
        this.initCustomBindingRegistry();
        this.metaInfo.setCustomRegistry(this.customRegistry);
    }

    private void initCustomBindingRegistry() {
        if (this.customRegistry == null) {
            this.customRegistry = new CustomRegistry();
            List list = null;
            try {
                list = this.env.getCustomBindingProviders(this.classpath);
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            if (list != null) {
                this.customRegistry.populate(list);
            }
        }
    }

    private void getNStoPkgFromPropsFile(HashMap hashMap) {
        try {
            Object object;
            Properties properties = new Properties();
            if (this.NStoPkgFile != null) {
                properties.load(new FileInputStream(this.NStoPkgFile));
            } else {
                object = null;
                try {
                    object = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return Emitter.this.env.getInputStream(Emitter.this.NStoPkgFilename);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exception thrown from AccessController" + privilegedActionException);
                    }
                    throw new RuntimeException(privilegedActionException);
                }
                properties.load((InputStream)object);
            }
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                try {
                    String string = (String)object.nextElement();
                    hashMap.put(string, properties.getProperty(string));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setTypeMappingVersion(String string) {
        this.baseTypeMapping = string.equals("1.1") ? new BaseTypeMapping(){
            final TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

            public String getBaseName(QName qName) {
                QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
                Class clazz = this.defaultTM.getClassForQName(qName2);
                if (clazz == null) {
                    return null;
                }
                if (!Emitter.this.noDataBinding) {
                    return JavaUtils.getTextClassName(clazz.getName());
                }
                return "javax.xml.soap.SOAPElement";
            }

            public TypeMapping getTypeMapping() {
                return this.defaultTM;
            }
        } : new BaseTypeMapping(){
            final TypeMapping defaultTM = DefaultSOAP12TypeMappingImpl.getSingleton();

            public String getBaseName(QName qName) {
                QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
                Class clazz = this.defaultTM.getClassForQName(qName2);
                if (clazz == null) {
                    return null;
                }
                if (!Emitter.this.noDataBinding) {
                    return JavaUtils.getTextClassName(clazz.getName());
                }
                return "javax.xml.soap.SOAPElement";
            }

            public TypeMapping getTypeMapping() {
                return this.defaultTM;
            }
        };
    }

    public GeneratorFactory getWriterFactory() {
        return this.getFactory();
    }

    public void emit(String string) throws Exception {
        this.run(string);
    }

    public void emit(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.run(string, document);
    }

    public void debug(boolean bl) {
        this.setDebug(bl);
    }

    public boolean getDebug() {
        return this.isDebug();
    }

    public void verbose(boolean bl) {
        this.setVerbose(bl);
    }

    public boolean getVerbose() {
        return this.isVerbose();
    }

    public void generateTestCase(boolean bl) {
        this.setTestCaseWanted(bl);
    }

    public void generateAll(boolean bl) {
        this.setAllWanted(bl);
    }

    public void setIntrospect(boolean bl) {
        this.introspect = bl;
    }

    public void allowRelativeNamespace(boolean bl) {
        this.allowRelativeNamespace = bl;
    }

    public boolean isIntrospect() {
        return this.introspect;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setGenEquals(boolean bl) {
        this.genEquals = bl;
    }

    public boolean isGenEquals() {
        return this.genEquals;
    }

    public void setGenImplSer(boolean bl) {
        this.genImplSer = bl;
    }

    public boolean isGenImplSer() {
        return this.genImplSer;
    }

    public CustomRegistry getCustomRegistry() {
        return this.customRegistry;
    }

    public void setCustomRegistry(CustomRegistry customRegistry) {
        this.customRegistry = customRegistry;
    }

    public boolean setScenario(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = Scenario.isValid(string);
        this.scenario = Scenario.getScenario(string, Scenario.NORMAL);
        return bl;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public void setPropertiesFile(String string) {
        if (string != null) {
            this.propertiesFilename = string;
        }
        try {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Emitter.this.getToolEnv().getInputStream(Emitter.this.propertiesFilename);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception thrown from AccessController" + privilegedActionException);
                }
                throw new RuntimeException(privilegedActionException);
            }
            properties.load(inputStream);
            if (properties.size() > 0) {
                this.setProperties(properties.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setProperties(String string) {
        if (string != null) {
            this.XProperties = new Properties();
            StringTokenizer stringTokenizer = new StringTokenizer(string, EXT_OPT_DELIMITERS);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    this.XProperties.setProperty(string2, "");
                    continue;
                }
                this.XProperties.setProperty(string2.substring(0, n), string2.substring(n + 1));
            }
            this.validateANDsetExtraOptions();
        }
    }

    private void validateANDsetExtraOptions() {
        Enumeration<?> enumeration = this.XProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)validOptions.get(string);
            if (string2 == null) {
                this.getToolEnv().reportWarning(Messages.getMessage("unkownOption", string));
                continue;
            }
            if (!REL_NS.equals(string)) continue;
            String string3 = this.XProperties.getProperty(string);
            if ("TRUE".equalsIgnoreCase(string3) || "".equalsIgnoreCase(string3)) {
                this.allowRelativeNamespace(true);
                continue;
            }
            this.allowRelativeNamespace(false);
        }
    }

    static {
        validOptions.put(REL_NS, "false");
        Protocols.init();
    }
}

