/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import javax.xml.soap.SOAPException;

class ProtectionChecker {
    ProtectionChecker() {
    }

    static void protectionCheck_changeNamespaces(SOAPElement sOAPElement) {
        if (ProtectionChecker.isProtect(sOAPElement) && ProtectionChecker.atOrAboveParameterElement(sOAPElement)) {
            ProtectionChecker.setProtectionViolation(sOAPElement);
        }
    }

    static void protectionCheck_removeChildElement(SOAPElement sOAPElement) {
        if (ProtectionChecker.isProtect(sOAPElement) && ProtectionChecker.atOrAboveOperationElement(sOAPElement)) {
            ProtectionChecker.setProtectionViolation(sOAPElement);
        }
    }

    static void protectionCheck_addChildElement(SOAPElement sOAPElement) {
        if (ProtectionChecker.isProtect(sOAPElement) && ProtectionChecker.atOrAboveOperationElement(sOAPElement)) {
            ProtectionChecker.setProtectionViolation(sOAPElement);
        }
    }

    static void protectionCheck_removeElement(SOAPElement sOAPElement) {
        if (ProtectionChecker.isProtect(sOAPElement) && ProtectionChecker.atOrAboveParameterElement(sOAPElement)) {
            ProtectionChecker.setProtectionViolation(sOAPElement);
        }
    }

    static void protectionCheck_changeAttributes(SOAPElement sOAPElement) {
        if (ProtectionChecker.isProtect(sOAPElement) && ProtectionChecker.atOrAboveParameterElement(sOAPElement)) {
            ProtectionChecker.setProtectionViolation(sOAPElement);
        }
    }

    static void protectionCheck_accessAttributes(SOAPElement sOAPElement) {
    }

    static void protectionCheck_setAlternateContent(SOAPElement sOAPElement) {
        if (ProtectionChecker.isProtect(sOAPElement) && ProtectionChecker.atOrAboveParameterElement(sOAPElement)) {
            ProtectionChecker.setProtectionViolation(sOAPElement);
        }
    }

    private static boolean isProtect(SOAPElement sOAPElement) {
        return sOAPElement.isProtect && !sOAPElement.inAsSOAPElement && sOAPElement.getSOAPFactory().getProtectState();
    }

    private static boolean atOrAboveParameterElement(SOAPElement sOAPElement) {
        if (!ProtectionChecker.attachedToEnvelope(sOAPElement)) {
            return false;
        }
        if (sOAPElement instanceof SOAPEnvelope || sOAPElement instanceof SOAPBody || sOAPElement instanceof SOAPHeader || sOAPElement instanceof SOAPBodyElement || sOAPElement instanceof SOAPHeaderElement) {
            return true;
        }
        if ((sOAPElement = (SOAPElement)sOAPElement.getParentElement()) == null || sOAPElement instanceof SOAPEnvelope || sOAPElement instanceof SOAPBody || sOAPElement instanceof SOAPHeader) {
            return true;
        }
        return sOAPElement.getParentElement() instanceof SOAPBody && ((SOAPElement)sOAPElement.getParentElement()).getChildElement(0) == sOAPElement;
    }

    private static boolean atOrAboveOperationElement(SOAPElement sOAPElement) {
        if (!ProtectionChecker.attachedToEnvelope(sOAPElement)) {
            return false;
        }
        if (sOAPElement instanceof SOAPEnvelope || sOAPElement instanceof SOAPBody || sOAPElement instanceof SOAPBodyElement) {
            return true;
        }
        return (sOAPElement = (SOAPElement)sOAPElement.getParentElement()) == null || sOAPElement instanceof SOAPEnvelope || sOAPElement instanceof SOAPBody;
    }

    private static boolean attachedToEnvelope(SOAPElement sOAPElement) {
        while (sOAPElement != null && !(sOAPElement instanceof SOAPEnvelope)) {
            sOAPElement = (SOAPElement)sOAPElement.getParentElement();
        }
        return sOAPElement != null;
    }

    private static void setProtectionViolation(SOAPElement sOAPElement) {
        SOAPFactory sOAPFactory = sOAPElement.getSOAPFactory();
        sOAPFactory.setProtectionViolation(true);
        try {
            SOAPEnvelope sOAPEnvelope = sOAPFactory.getSOAPEnvelope();
            SOAPBody sOAPBody = (SOAPBody)sOAPEnvelope.getBody();
            sOAPBody.isProtect = false;
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }
}

