/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.session.Session;
import com.ibm.ws.webservices.engine.session.SimpleSession;
import com.ibm.ws.webservices.engine.transport.http.SimpleWebServicesWorker;
import com.ibm.ws.webservices.engine.utils.Options;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class SimpleServerEngine
implements Runnable {
    protected static Log log = LogFactory.getLog(SimpleServerEngine.class.getName());
    private Hashtable sessions = new Hashtable();
    private static boolean doThreads = true;
    private static boolean doSessions = true;
    public static int sessionIndex = 0;
    private static ServerEngine myServerEngine = null;
    private boolean stopped = false;
    private ServerSocket serverSocket;

    protected boolean isSessionUsed() {
        return doSessions;
    }

    public void setDoThreads(boolean bl) {
        doThreads = bl;
    }

    public boolean getDoThreads() {
        return doThreads;
    }

    protected Session createSession(String string) {
        Session session = null;
        if (this.sessions.containsKey(string)) {
            session = (Session)this.sessions.get(string);
        } else {
            session = new SimpleSession();
            this.sessions.put(string, session);
        }
        return session;
    }

    protected static synchronized ServerEngine getServerEngine() {
        if (myServerEngine == null) {
            myServerEngine = new ServerEngine();
        }
        return myServerEngine;
    }

    public void run() {
        log.info(Messages.getMessage("start00", "SimpleServerEngine", new Integer(this.getServerSocket().getLocalPort()).toString()));
        while (!this.stopped) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                FFDCFilter.processException((Throwable)interruptedIOException, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.run", "164", this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.run", "166", this);
                if (!log.isDebugEnabled()) break;
                log.debug(Messages.getMessage("exception00"), exception);
                break;
            }
            if (socket == null) continue;
            SimpleWebServicesWorker simpleWebServicesWorker = new SimpleWebServicesWorker(this, socket);
            if (doThreads) {
                Thread thread = new Thread(simpleWebServicesWorker);
                thread.setDaemon(true);
                thread.start();
                continue;
            }
            simpleWebServicesWorker.run();
        }
        log.info(Messages.getMessage("quit00", "SimpleServerEngine"));
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void start(boolean bl) throws Exception {
        if (doThreads) {
            Thread thread = new Thread(this);
            thread.setDaemon(bl);
            thread.start();
        } else {
            this.run();
        }
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void stop() throws Exception {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.stop", "241", this);
            log.info(Messages.getMessage("exception00"), exception);
        }
        log.info(Messages.getMessage("quit00", "SimpleServerEngine"));
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        SimpleServerEngine simpleServerEngine = new SimpleServerEngine();
        Options options = null;
        try {
            options = new Options(stringArray);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException(malformedURLException, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.main", "262");
            log.error(Messages.getMessage("malformedURLException00"), malformedURLException);
            return;
        }
        try {
            doThreads = options.isFlagSet('t') > 0;
            int n = options.getPort();
            ServerSocket serverSocket = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    serverSocket = new ServerSocket(n);
                    break;
                }
                catch (BindException bindException) {
                    FFDCFilter.processException(bindException, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.main", "278");
                    if (log.isDebugEnabled()) {
                        log.debug(Messages.getMessage("exception00"), bindException);
                    }
                    if (i >= 4) {
                        throw new Exception(Messages.getMessage("unableToStartServer00", Integer.toString(n)));
                    }
                    Thread.sleep(3000L);
                    continue;
                }
            }
            simpleServerEngine.setServerSocket(serverSocket);
            simpleServerEngine.start();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine.main", "292");
            log.error(Messages.getMessage("exception00"), exception);
            return;
        }
    }
}

