/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionGroup;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;

public final class OutboundConnectionCache {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(OutboundConnectionCache.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc2 = Tr.register(CleanupTask.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static int REFRESHTIME = 0;
    private static final int DELAYTIME = 1000;
    private static int CONN_TIMEOUT = 0;
    private static int MAX_CONN = 0;
    private static int EIGHTY_PERCENT = 0;
    private HashMap chainlist = null;
    private LinkedList tempPool = null;
    private static int reqCounter = 0;
    private static OutboundConnectionCache cache = null;
    private static Timer _timer = null;

    private OutboundConnectionCache() {
        _timer = new Timer(true);
        _timer.schedule((TimerTask)new CleanupTask(), 1000L, (long)REFRESHTIME);
        this.chainlist = new HashMap();
        this.tempPool = new LinkedList();
        EIGHTY_PERCENT = Math.round(MAX_CONN * 4 / 5);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionTimeout: " + CONN_TIMEOUT + " ms, " + "com.ibm.websphere.webservices.http.connectionPoolCleanUpTime" + ": " + REFRESHTIME + " ms, " + "com.ibm.websphere.webservices.http.maxConnection" + ": " + MAX_CONN);
        }
    }

    public static int maxConnection() {
        return MAX_CONN;
    }

    public static int connTimeout() {
        return CONN_TIMEOUT;
    }

    public static synchronized OutboundConnectionCache getInstance() {
        if (cache == null) {
            cache = new OutboundConnectionCache();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSOutboundConnection findConnectionAndInvalidate(WSAddress wSAddress) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        OutboundConnectionGroup outboundConnectionGroup = null;
        String string = wSAddress.keyValueforPool();
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string);
            if (outboundConnectionGroup != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "true"));
                }
                wSOutboundConnection = outboundConnectionGroup.invalidateConnection(wSAddress);
            }
            WSOutboundConnection wSOutboundConnection2 = null;
            ListIterator listIterator = this.tempPool.listIterator(0);
            if (listIterator != null) {
                while (listIterator.hasNext()) {
                    wSOutboundConnection2 = (WSOutboundConnection)listIterator.next();
                    if (!wSOutboundConnection2.groupID().equals(string)) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, Messages.getMessage("invalidatedConnObject01", wSAddress.toString(), wSOutboundConnection2.toString()));
                    }
                    wSOutboundConnection2.release(null);
                    listIterator.remove();
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        return wSOutboundConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSOutboundConnection findGroupAndGetConnection(WSAddress wSAddress) throws WebServicesFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        }
        WSOutboundConnection wSOutboundConnection = null;
        OutboundConnectionGroup outboundConnectionGroup = null;
        String string = wSAddress.keyValueforPool();
        int n = 0;
        int n2 = 0;
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            if (!this.chainlist.containsKey(string)) {
                outboundConnectionGroup = new OutboundConnectionGroup();
                this.chainlist.put(string, outboundConnectionGroup);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("outConnGroupCreated", string));
                }
            } else {
                outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "true"));
                }
            }
        }
        hashMap = this.chainlist;
        synchronized (hashMap) {
            while (wSOutboundConnection == null) {
                n = this.poolSize() + this.tempPool.size();
                n2 = this.connectionsInUse();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("enter00", Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
                }
                if (n < MAX_CONN) {
                    if (outboundConnectionGroup.currPoolSize() > outboundConnectionGroup.totalInUse()) {
                        wSOutboundConnection = outboundConnectionGroup.getConnection(wSAddress);
                    }
                    if (wSOutboundConnection != null) break;
                    wSOutboundConnection = outboundConnectionGroup.createConnection(wSAddress);
                    break;
                }
                if (n == MAX_CONN) {
                    long l = CONN_TIMEOUT;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
                    }
                    if (this.tempPool.size() > 0) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Local pool is available for faster access.");
                        }
                        try {
                            wSOutboundConnection = (WSOutboundConnection)this.tempPool.removeFirst();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            wSOutboundConnection = null;
                        }
                        if (wSOutboundConnection != null) {
                            wSOutboundConnection = outboundConnectionGroup.addConnection(wSAddress, wSOutboundConnection, string);
                            break;
                        }
                    } else {
                        int n3;
                        int n4 = outboundConnectionGroup.currPoolSize();
                        if (n4 > (n3 = outboundConnectionGroup.totalInUse())) {
                            wSOutboundConnection = outboundConnectionGroup.getConnection(wSAddress);
                        } else if (n4 == n3) {
                            if (this.purgeUnused()) {
                                wSOutboundConnection = outboundConnectionGroup.createConnection(wSAddress);
                            }
                        } else {
                            throw new WebServicesFault(Messages.getMessage("connectionPoolIntegrity00"));
                        }
                        if (wSOutboundConnection != null) break;
                    }
                    if (CONN_TIMEOUT == 0) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("connectionWait00", Thread.currentThread().toString()));
                        }
                        this.chainlist.wait();
                        if (!_tc.isEventEnabled()) continue;
                        Tr.event(_tc, Messages.getMessage("connectionNotify01", Thread.currentThread().toString()));
                        continue;
                    }
                    long l2 = 0L;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("connectionWait01", Thread.currentThread().toString(), String.valueOf(l)));
                    }
                    long l3 = System.currentTimeMillis();
                    this.chainlist.wait(l);
                    l2 = System.currentTimeMillis() - l3;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("connectionNotify01", Thread.currentThread().toString()));
                    }
                    if (l - l2 > 0L) continue;
                    throw new WebServicesFault(Messages.getMessage("connectionTimedOut"));
                }
                throw new WebServicesFault(Messages.getMessage("connectionPoolIntegrity00"));
            }
        }
        if (_tc.isEventEnabled()) {
            n = this.poolSize() + this.tempPool.size();
            n2 = this.connectionsInUse();
            Tr.event(_tc, Messages.getMessage("exit00", Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "Unused objects in findGroupAndGetConnection::tempPool: " + this.tempPool.size());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        }
        return wSOutboundConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findGroupAndReturnConnection(WSOutboundConnection wSOutboundConnection) throws ChainException, ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
        String string = wSOutboundConnection.getTargetAddress().keyValueforPool();
        OutboundConnectionGroup outboundConnectionGroup = null;
        outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(string);
        if (outboundConnectionGroup == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "false"));
            }
            return;
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("connTableKeyFound", string, "true"));
        }
        HashMap hashMap = this.chainlist;
        synchronized (hashMap) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Unused objects in findGroupAndReturnConnection::tempPool size: " + this.tempPool.size());
            }
            int n = this.poolSize() + this.tempPool.size();
            int n2 = this.connectionsInUse();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("enter00", "findGroupAndReturnConnection() - " + Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
            }
            if (n == MAX_CONN && n2 > EIGHTY_PERCENT) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "The default object pool is close to be full. Place the object in a local pool for faster access.");
                }
                outboundConnectionGroup.returnConnection(wSOutboundConnection, true);
                this.tempPool.add(wSOutboundConnection);
            } else {
                outboundConnectionGroup.returnConnection(wSOutboundConnection, false);
            }
            this.chainlist.notify();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("connectionNotify00"));
            }
            if (_tc.isEventEnabled()) {
                n = this.poolSize() + this.tempPool.size();
                n2 = this.connectionsInUse();
                Tr.event(_tc, Messages.getMessage("exit00", "findGroupAndReturnConnection() - " + Messages.getMessage("connPoolStatus00", String.valueOf(n), String.valueOf(n2), String.valueOf(MAX_CONN))));
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Unused objects in findGroupAndReturnConnection::tempPool: " + this.tempPool.size());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
    }

    private boolean purgeUnused() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeUnused()");
        }
        boolean bl = false;
        Iterator iterator = this.chainlist.keySet().iterator();
        OutboundConnectionGroup outboundConnectionGroup = null;
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            if (outboundConnectionGroup.currPoolSize() > outboundConnectionGroup.totalInUse()) {
                bl = outboundConnectionGroup.findUnused();
            }
            if (!bl) continue;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeUnused()");
        }
        return bl;
    }

    protected int poolSize() {
        int n = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "poolSize()");
        }
        Iterator iterator = this.chainlist.keySet().iterator();
        OutboundConnectionGroup outboundConnectionGroup = null;
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            n += outboundConnectionGroup.currPoolSize();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "poolSize()");
        }
        return n;
    }

    protected int connectionsInUse() {
        int n = 0;
        OutboundConnectionGroup outboundConnectionGroup = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "connectionsInUse()");
        }
        Iterator iterator = this.chainlist.keySet().iterator();
        while (iterator.hasNext()) {
            outboundConnectionGroup = (OutboundConnectionGroup)this.chainlist.get(iterator.next());
            n += outboundConnectionGroup.totalInUse();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "connectionsInUse()");
        }
        return n;
    }

    static {
        CONN_TIMEOUT = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionTimeout", "300")) * 1000;
        REFRESHTIME = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionPoolCleanUpTime", "180")) * 1000;
        MAX_CONN = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.maxConnection", "25"));
        if (MAX_CONN < 5) {
            MAX_CONN = 5;
        }
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                OutboundConnectionGroup outboundConnectionGroup = null;
                try {
                    if (_tc2.isEntryEnabled()) {
                        Tr.entry(_tc2, "CleanupTask.run()");
                    }
                    HashMap hashMap = OutboundConnectionCache.this.chainlist;
                    synchronized (hashMap) {
                        if (OutboundConnectionCache.this.chainlist.size() > 0) {
                            Iterator iterator = OutboundConnectionCache.this.chainlist.keySet().iterator();
                            Object var4_5 = null;
                            while (iterator.hasNext()) {
                                var4_5 = iterator.next();
                                outboundConnectionGroup = (OutboundConnectionGroup)OutboundConnectionCache.this.chainlist.get(var4_5);
                                outboundConnectionGroup.cleanup();
                                if (!outboundConnectionGroup.isEmpty()) continue;
                                if (_tc2.isDebugEnabled()) {
                                    Tr.debug(_tc2, "OutboundConnectionGroup.isEmpty(): true");
                                }
                                outboundConnectionGroup.release();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache", "162", this);
                    if (!_tc2.isEventEnabled()) break block9;
                    Tr.event(_tc2, Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
                }
            }
        }
    }
}

