/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Namespaces;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;

public class ServiceFactory
extends javax.xml.rpc.ServiceFactory
implements ObjectFactory {
    public static final String SERVICE_CLASSNAME = "service classname";
    public static final String WSDL_LOCATION = "WSDL location";
    public static final String MAINTAIN_SESSION = "maintain session";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    protected static Log log = LogFactory.getLog(ServiceFactory.class.getName());
    private static final String PACKAGE_SEPERATOR = ".";

    public static Service getService(Map map) {
        Service service = null;
        InitialContext initialContext = null;
        EngineConfiguration engineConfiguration = (EngineConfiguration)map.get("engineConfig");
        if (engineConfiguration == null) {
            engineConfiguration = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        }
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (initialContext != null) {
            String string = (String)map.get("jndiName");
            if (string == null) {
                string = "webServicesServiceName";
            }
            try {
                service = (Service)initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                service = new Service(engineConfiguration);
                try {
                    initialContext.bind(string, (Object)service);
                }
                catch (NamingException namingException2) {
                    FFDCFilter.processException(namingException2, "com.ibm.ws.webservices.engine.client.ServiceFactory.getService", "181");
                }
            }
        } else {
            service = new Service(engineConfiguration);
        }
        return service;
    }

    public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws Exception {
        Object var5_5 = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            RefAddr refAddr = reference.get(SERVICE_CLASSNAME);
            Object object2 = null;
            if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                var5_5 = ClassUtils.forName((String)object2).newInstance();
            } else {
                refAddr = reference.get(WSDL_LOCATION);
                if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                    URL uRL = new URL((String)object2);
                    refAddr = reference.get(SERVICE_NAMESPACE);
                    if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                        String string = (String)object2;
                        refAddr = reference.get(SERVICE_LOCAL_PART);
                        if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                            String string2 = (String)object2;
                            QName qName = QNameTable.createQName(string, string2);
                            Class[] classArray = new Class[]{URL.class, QName.class};
                            Object[] objectArray = new Object[]{uRL, qName};
                            Constructor constructor = Service.class.getDeclaredConstructor(classArray);
                            var5_5 = constructor.newInstance(objectArray);
                        }
                    }
                }
            }
            refAddr = reference.get(MAINTAIN_SESSION);
            if (refAddr != null && var5_5 instanceof Service) {
                ((Service)var5_5).setMaintainSession(true);
            }
        }
        return var5_5;
    }

    public javax.xml.rpc.Service createService(URL uRL, QName qName) throws ServiceException {
        return new Service(uRL, qName);
    }

    public javax.xml.rpc.Service createService(QName qName) throws ServiceException {
        return new Service(qName);
    }

    public javax.xml.rpc.Service loadService(Class clazz) throws ServiceException {
        return this.findGeneratedServiceLocator(clazz.getName(), clazz);
    }

    public javax.xml.rpc.Service loadService(URL uRL, Class clazz, Properties properties) throws ServiceException {
        return this.findGeneratedServiceLocator(clazz.getName(), clazz);
    }

    public javax.xml.rpc.Service loadService(URL uRL, QName qName, Properties properties) throws ServiceException {
        Namespaces namespaces = this.getNs2PkgMapping(properties);
        String string = namespaces.getCreate(qName.getNamespaceURI());
        String string2 = string + PACKAGE_SEPERATOR + qName.getLocalPart();
        return this.findGeneratedServiceLocator(string2, null);
    }

    private Namespaces getNs2PkgMapping(Properties properties) {
        Namespaces namespaces = new Namespaces(null, PACKAGE_SEPERATOR.charAt(0));
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)properties.get(string);
                namespaces.put(string, string2);
            }
        }
        return namespaces;
    }

    private Service findGeneratedServiceLocator(String string, Class clazz) throws ServiceException {
        String string2;
        String string3;
        String string4 = string + "Locator";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz2 = null;
        Service service = null;
        try {
            clazz2 = classLoader.loadClass(string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string3 = Messages.getMessage("noClassForService00", string4);
            log.error(string3, classNotFoundException);
        }
        if (clazz == null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string3 = Messages.getMessage("noClassForService00", string);
                log.error(string3, classNotFoundException);
            }
        }
        if (clazz2 != null) {
            if (!javax.xml.rpc.Service.class.isAssignableFrom(clazz)) {
                string2 = Messages.getMessage("mustSubclassService", clazz.getName());
                log.error(string2);
                throw new ServiceException(string2);
            }
            if (!clazz.isAssignableFrom(clazz2)) {
                string2 = Messages.getMessage("mustSubclassServiceInterface", clazz.getName(), clazz2.getName());
                log.error(string2);
                throw new ServiceException(string2);
            }
            try {
                service = (Service)clazz2.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.client.ServiceFactory.findGeneratedServiceLocator", "421", this);
                string3 = Messages.getMessage("cantInstantiateClass", clazz2.getName());
                log.error(string3, exception);
                throw new ServiceException(string3, exception);
            }
            return service;
        }
        string2 = Messages.getMessage("noClassForService00", string4);
        log.error(string2);
        throw new ServiceException(string2);
    }
}

