/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.client;

import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.DefaultEngineConfigurationFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class ClientEngineFactory {
    protected static Log log = LogFactory.getLog(ClientEngineFactory.class.getName());
    private static HashMap engines = new HashMap();
    private static int CACHE_THRESHOLD = 5;

    public static synchronized ClientEngine getManagedEngine() {
        EngineConfiguration engineConfiguration = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        return ClientEngineFactory.getEngine(engineConfiguration);
    }

    public static synchronized ClientEngine getEngine(EngineConfiguration engineConfiguration) {
        ClientEngine clientEngine = (ClientEngine)engines.get(engineConfiguration);
        if (clientEngine == null) {
            clientEngine = new ClientEngine(engineConfiguration);
            if (log.isDebugEnabled()) {
                log.debug("Registering new engine: " + clientEngine.toString());
            }
            ClientEngineFactory.registerEngine(engineConfiguration, clientEngine);
        } else if (log.isDebugEnabled()) {
            log.debug("Cache hit! - Found engine : " + clientEngine.toString());
        }
        return clientEngine;
    }

    public static synchronized ClientEngine getUnmanagedEngine() {
        EngineConfiguration engineConfiguration = DefaultEngineConfigurationFactory.newFactory(null).getClientEngineConfig();
        return ClientEngineFactory.getEngine(engineConfiguration);
    }

    static synchronized void registerEngine(EngineConfiguration engineConfiguration, ClientEngine clientEngine) {
        ClientEngineFactory.checkCache();
        engines.put(engineConfiguration, clientEngine);
    }

    private static synchronized void checkCache() {
        if (engines.size() > CACHE_THRESHOLD) {
            if (log.isDebugEnabled()) {
                log.debug("Cache threshold exceeded - clearing cache.");
            }
            engines.clear();
        }
    }
}

