/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.activation.DataSource;
import javax.xml.transform.stream.StreamSource;

public class SourceDataSource
implements DataSource {
    public static final String CONTENT_TYPE = "text/xml";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayInputStream is;
    private ByteArrayOutputStream os;

    public SourceDataSource(String string, StreamSource streamSource) {
        this(string, CONTENT_TYPE, streamSource);
    }

    public SourceDataSource(String string, String string2, StreamSource streamSource) {
        this.name = string;
        this.contentType = string2 == null ? CONTENT_TYPE : string2;
        this.os = new ByteArrayOutputStream();
        try {
            if (streamSource != null) {
                Reader reader = streamSource.getReader();
                if (reader != null) {
                    int n;
                    Reader reader2 = null;
                    if (reader.markSupported()) {
                        reader.mark(Integer.MAX_VALUE);
                        reader2 = reader;
                    }
                    reader = new BufferedReader(reader);
                    while ((n = reader.read()) != -1) {
                        this.os.write(n);
                    }
                    if (reader2 != null) {
                        reader2.reset();
                    }
                } else {
                    Object object;
                    Object object2;
                    InputStream inputStream = streamSource.getInputStream();
                    if (inputStream == null && (object2 = streamSource.getSystemId()) != null) {
                        object = new URL((String)object2);
                        inputStream = ((URL)object).openStream();
                    }
                    if (inputStream != null) {
                        int n;
                        object2 = null;
                        if (inputStream.markSupported()) {
                            inputStream.mark(Integer.MAX_VALUE);
                            object2 = inputStream;
                        }
                        inputStream = new BufferedInputStream(inputStream);
                        object = null;
                        while ((n = inputStream.available()) > 0) {
                            if (object == null || n > ((URL)object).length) {
                                object = new byte[n];
                            }
                            inputStream.read((byte[])object, 0, n);
                            this.os.write((byte[])object, 0, n);
                        }
                        if (object2 != null) {
                            ((InputStream)object2).reset();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.attachments.SourceDataSource.SourceDataSource", "98", this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

