/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.X509KeyManager;

public class CertMappingKeyManager
implements X509KeyManager,
KeyManagerExtendedInfo {
    private static final TraceComponent tc = Tr.register(CertMappingKeyManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    public static final String PROTOCOL_HTTPS_CERT_MAPPING_FILE = "com.ibm.ssl.cert.mapping.file";
    public static final String PROTOCOL_HTTPS_CERT_DEFAULT_LABEL = "com.ibm.ssl.cert.default.label";
    private static final String PROTOCOL_HTTPS_CERT_TAG = "SSLServerCert";
    private static final String SINGLE_QUOTE_STRING = "'";
    private static final char[] DOUBLE_QUOTE = new char[]{'\"'};
    private static final String DOUBLE_QUOTE_STRING = new String(DOUBLE_QUOTE);
    private Properties certMapping;
    private Properties customProperties;
    private String certDefaultLabel;
    private X509KeyManager defaultX509KeyManager;
    private Map connectionInfo;

    public CertMappingKeyManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.certMapping = new Properties();
        this.certDefaultLabel = null;
        this.defaultX509KeyManager = null;
        this.parseSSLCertFile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return null;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return null;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        String[] stringArray = this.certMapping.values().toArray(new String[0]);
        return stringArray;
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chooseServerAlias", new Object[]{string, principalArray, socket});
        }
        String string2 = null;
        String string3 = null;
        Map map = JSSEHelper.getInstance().getInboundConnectionInfo();
        if (map != null) {
            string3 = (String)map.get(JSSEHelper.CONNECTION_INFO_CERT_MAPPING_HOST);
            string2 = this.certMapping.getProperty(string3, this.certDefaultLabel);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chooseServerAlias", string2);
        }
        return string2;
    }

    public X509Certificate[] getCertificateChain(String string) {
        return null;
    }

    public PrivateKey getPrivateKey(String string) {
        return null;
    }

    public void setCustomProperties(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCustomProperties", properties);
        }
        this.customProperties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCustomProperties");
        }
    }

    public void setSSLConfig(Properties properties) {
    }

    public void setDefaultX509KeyManager(X509KeyManager x509KeyManager) {
        this.defaultX509KeyManager = x509KeyManager;
    }

    public void setKeyStore(KeyStore keyStore) {
    }

    public void setKeyStoreServerAlias(String string) {
    }

    public void setKeyStoreClientAlias(String string) {
    }

    public String getProperty(String string) {
        String string2 = null;
        if (this.customProperties != null) {
            string2 = this.customProperties.getProperty(string);
        }
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        if (string2 == null) {
            string2 = SSLConfigManager.getInstance().getGlobalProperty(string);
        }
        return string2;
    }

    private void parseSSLCertFile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSSLCertFile");
        }
        String string = null;
        String string2 = null;
        BufferedReader bufferedReader = null;
        this.certDefaultLabel = this.getProperty(PROTOCOL_HTTPS_CERT_DEFAULT_LABEL);
        try {
            string = this.getProperty(PROTOCOL_HTTPS_CERT_MAPPING_FILE);
            if (string != null && !string.equals("")) {
                bufferedReader = new BufferedReader(new FileReader(string));
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    this.extractSSLServerCert(string2.trim());
                    string2 = bufferedReader.readLine();
                }
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "The following exception occurred in parseSSLCertFile().", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.CustomX509KeyManager.getProperties", "280", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSSLCertFile");
        }
    }

    private void extractSSLServerCert(String string) {
        String string2;
        char c;
        String string3;
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractSSLServerCert", string);
        }
        if (string.startsWith(PROTOCOL_HTTPS_CERT_TAG) && ((string4 = string.substring(PROTOCOL_HTTPS_CERT_TAG.length()).trim()).startsWith(SINGLE_QUOTE_STRING) || string4.startsWith(DOUBLE_QUOTE_STRING)) && (string3 = string4.substring(1, string4.lastIndexOf(c = string4.charAt(0)))) != null && string3.length() != 0 && (string2 = string4.substring(string4.lastIndexOf(c) + 1).trim()) != null && string2.length() != 0) {
            this.certMapping.setProperty(string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractSSLServerCert");
        }
    }
}

