/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.keystoreutil.KeyStoreUtil;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.properties.DescriptiveProperty;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class WSKeyStore
extends Properties {
    private static final TraceComponent tc = Tr.register(WSKeyStore.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static final WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private String name = null;
    private KeyStore ks = null;
    public static boolean defaultKeyStoreWarningIssued = false;

    public WSKeyStore(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyStore <init>");
        }
        this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        this.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        this.setProperty("com.ibm.ssl.keyStoreType", "PKCS12");
        this.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
        this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
        this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
        if (SSLConfigManager.getInstance().isServerProcess()) {
            this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
        }
        boolean bl = false;
        String string = null;
        Object var4_4 = null;
        if (keyStore != null && keyStore.getLocation() != null) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7 = keyStore.getProvider();
            if (string7 != null) {
                if (string7.equals("IBMPKCS11Impl")) {
                    bl = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
                this.setProperty("com.ibm.ssl.keyStoreProvider", string7);
            }
            if ((string6 = keyStore.getName()) != null) {
                string = string6;
                this.setProperty("com.ibm.ssl.keyStoreName", string6);
            }
            if ((string5 = keyStore.getPassword()) != null) {
                if (!defaultKeyStoreWarningIssued && string5.equals("WebAS")) {
                    Tr.warning(tc, "ssl.default.password.in.use.CWPKI0041W");
                    defaultKeyStoreWarningIssued = true;
                }
                this.setProperty("com.ibm.ssl.keyStorePassword", string5);
            }
            if ((string4 = keyStore.getLocation()) != null) {
                this.setProperty("com.ibm.ssl.keyStore", KeyStoreManager.getInstance().expand(string4));
            }
            if ((string3 = keyStore.getType()) != null) {
                this.setProperty("com.ibm.ssl.keyStoreType", string3);
                if (!(string3.equals("JKS") || string3.equals("JCEKS") || string3.equals("PKCS12"))) {
                    this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                }
                if (string3.equals("PKCS11")) {
                    bl = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
            }
            if (bl) {
                string2 = Integer.toString(keyStore.getSlot());
                this.setProperty("com.ibm.ssl.keyStoreSlot", string2);
            }
            if ((string2 = keyStore.getHostList()) != null && !string2.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreHostList", string2);
            }
            if (keyStore.getManagementScope() != null) {
                this.setProperty("com.ibm.ssl.keyStoreScope", keyStore.getManagementScope().getScopeName());
            } else {
                this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
            }
            String string8 = keyStore.getCustomProviderClass();
            if (string8 != null && !string8.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreCustomClass", string8);
            }
            this.setProperty("com.ibm.ssl.keyStoreFileBased", keyStore.isFileBased() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreReadOnly", keyStore.isReadOnly() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", keyStore.isInitializeAtStartup() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", keyStore.isCreateStashFileForCMS() ? "true" : "false");
            this.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", keyStore.isUseForAcceleration() ? "true" : "false");
            EList eList = keyStore.getAdditionalKeyStoreAttrs();
            if (eList != null) {
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    DescriptiveProperty descriptiveProperty = (DescriptiveProperty)iterator.next();
                    if (descriptiveProperty == null) continue;
                    this.setProperty(descriptiveProperty.getName(), descriptiveProperty.getValue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStore(KeyStoreInfo keyStoreInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KeyStoreInfo <init>");
        }
        boolean bl = false;
        String string = null;
        Object var4_4 = null;
        if (keyStoreInfo != null && keyStoreInfo.getLocation() != null) {
            List list;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8 = keyStoreInfo.getProvider();
            if (string8 != null) {
                if (string8.equals("IBMPKCS11Impl")) {
                    bl = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
                this.setProperty("com.ibm.ssl.keyStoreProvider", string8);
            }
            if ((string7 = keyStoreInfo.getName()) != null) {
                string = string7;
                this.setProperty("com.ibm.ssl.keyStoreName", string7);
            }
            if ((string6 = keyStoreInfo.getPassword()) != null) {
                if (!defaultKeyStoreWarningIssued && string6.equals("WebAS")) {
                    Tr.warning(tc, "ssl.default.password.in.use.CWPKI0041W");
                    defaultKeyStoreWarningIssued = true;
                }
                this.setProperty("com.ibm.ssl.keyStorePassword", string6);
            }
            if ((string5 = keyStoreInfo.getLocation()) != null) {
                this.setProperty("com.ibm.ssl.keyStore", KeyStoreManager.getInstance().expand(string5));
            }
            if ((string4 = keyStoreInfo.getType()) != null) {
                this.setProperty("com.ibm.ssl.keyStoreType", string4);
                if (!(string4.equals("JKS") || string4.equals("JCEKS") || string4.equals("PKCS12"))) {
                    this.setProperty("com.ibm.ssl.keyStoreFileBased", "false");
                }
                if (string4.equals("PKCS11")) {
                    bl = true;
                    this.setProperty("com.ibm.ssl.tokenEnabled", "true");
                }
            }
            if (bl) {
                string3 = keyStoreInfo.getSlot().toString();
                this.setProperty("com.ibm.ssl.keyStoreSlot", string3);
            }
            if ((string3 = keyStoreInfo.getHostList()) != null && !string3.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreHostList", string3);
            }
            if (keyStoreInfo.getScopeNameString() != null) {
                this.setProperty("com.ibm.ssl.keyStoreScope", keyStoreInfo.getScopeNameString());
            }
            if ((string2 = keyStoreInfo.getCustomProvider()) != null && !string2.equals("")) {
                this.setProperty("com.ibm.ssl.keyStoreCustomClass", string2);
            }
            if (keyStoreInfo.getFileBased() != null) {
                this.setProperty("com.ibm.ssl.keyStoreFileBased", keyStoreInfo.getFileBased() != false ? "true" : "false");
            }
            if (keyStoreInfo.getReadOnly() != null) {
                this.setProperty("com.ibm.ssl.keyStoreReadOnly", keyStoreInfo.getReadOnly() != false ? "true" : "false");
            }
            if (keyStoreInfo.getInitializeAtStartup() != null) {
                this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", keyStoreInfo.getInitializeAtStartup() != false ? "true" : "false");
            }
            if (keyStoreInfo.getStashFile() != null) {
                this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", keyStoreInfo.getStashFile() != false ? "true" : "false");
            }
            if (keyStoreInfo.getAccelerator() != null) {
                this.setProperty("com.ibm.ssl.keyStoreUseForAcceleration", keyStoreInfo.getAccelerator() != false ? "true" : "false");
            }
            if ((list = keyStoreInfo.getCustomProps()) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DescriptiveProperty descriptiveProperty = (DescriptiveProperty)iterator.next();
                    if (descriptiveProperty == null) continue;
                    this.setProperty(descriptiveProperty.getName(), descriptiveProperty.getValue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStore() {
        this.setProperty("com.ibm.ssl.keyStoreFileBased", "true");
        this.setProperty("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        this.setProperty("com.ibm.ssl.keyStoreType", "PKCS12");
        this.setProperty("com.ibm.ssl.keyStoreReadOnly", "false");
        this.setProperty("com.ibm.ssl.keyStoreInitializeAtStartup", "false");
        this.setProperty("com.ibm.ssl.keyStoreCreateCMSStash", "true");
        if (SSLConfigManager.getInstance().isServerProcess()) {
            this.setProperty("com.ibm.ssl.keyStoreScope", ManagementScopeManager.getInstance().getCellScopeName());
        }
    }

    public String getLocation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocation");
        }
        String string = this.getProperty("com.ibm.ssl.keyStore");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocation -> " + string);
        }
        return string;
    }

    public synchronized KeyStore getKeyStore(boolean bl, boolean bl2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStore");
        }
        if (this.ks == null || bl) {
            String string = this.getProperty("com.ibm.ssl.keyStore");
            final boolean bl3 = bl2;
            try {
                this.ks = (KeyStore)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String string = null;
                        KeyStore keyStore = null;
                        String string2 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Initializing KeyStore " + string2);
                        }
                        string = WSKeyStore.this.getProperty("com.ibm.ssl.keyStore");
                        String string3 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStorePassword");
                        String string4 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreType");
                        String string5 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreFileBased");
                        String string6 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreProvider");
                        String string7 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreSlot");
                        if (string7 == null || string7.length() == 0) {
                            string7 = WSKeyStore.this.getProperty("com.ibm.ssl.tokenSlot");
                        }
                        String string8 = WSKeyStore.this.getProperty("com.ibm.ssl.tokenEnabled");
                        String string9 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
                        String string10 = null;
                        if (string5 != null && string5.equals("true")) {
                            Class<?> clazz;
                            Serializable serializable;
                            try {
                                serializable = new URL(string);
                                string10 = ((URL)serializable).getFile();
                                clazz = System.getProperty("os.name");
                                if (clazz != null && ((String)((Object)clazz)).indexOf("Windows") != -1) {
                                    while (string10.startsWith("/")) {
                                        string10 = string10.substring(1);
                                    }
                                } else {
                                    while (string10.startsWith("//")) {
                                        string10 = string10.substring(1);
                                    }
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                string10 = string;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "File path for OutputStream: " + string10);
                            }
                            if (((File)(serializable = new File(string10))).exists()) {
                                if (string4 != null && (string4.equals("CMSKS") || string4.equals("IBMi5OSKeyStore"))) {
                                    clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                                    Method method = clazz.getMethod("loadCMSKeyStore", class$java$io$File == null ? (class$java$io$File = WSKeyStore.class$("java.io.File")) : class$java$io$File, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String);
                                    keyStore = (KeyStore)method.invoke(clazz.newInstance(), serializable, string10, string3, string4, string6, string9);
                                } else {
                                    clazz = JSSEProviderFactory.getInstance();
                                    keyStore = clazz.getKeyStoreInstance(string4, string6);
                                    File file = new File(string10);
                                    InputStream inputStream = null;
                                    if (file.exists()) {
                                        inputStream = WSKeyStore.openKeyStore(string10);
                                    }
                                    keyStore.load(inputStream, string3.toCharArray());
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "getKeyStore (initialized)");
                                }
                                return keyStore;
                            }
                            if (string4 != null && (string4.equals("CMSKS") || string4.equals("IBMi5OSKeyStore"))) {
                                clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                                Method method = clazz.getMethod("loadCMSKeyStore", class$java$io$File == null ? (class$java$io$File = WSKeyStore.class$("java.io.File")) : class$java$io$File, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WSKeyStore.class$("java.lang.String")) : class$java$lang$String);
                                keyStore = (KeyStore)method.invoke(clazz.newInstance(), null, string10, string3, string4, string6, string9);
                            } else if (bl3 || string2 != null && (string2.endsWith("DefaultKeyStore") || string2.endsWith("DefaultTrustStore") || string2.endsWith("LTPAKeys"))) {
                                clazz = JSSEProviderFactory.getInstance();
                                keyStore = clazz.getKeyStoreInstance(string4, string6);
                                keyStore.load(null, string3.toCharArray());
                            } else {
                                throw new SSLException("KeyStore \"" + string10 + "\" does not exist.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getKeyStore (loaded)");
                            }
                            return keyStore;
                        }
                        if (string8 != null && string8.equals("true")) {
                            boolean bl = false;
                            String string11 = WSKeyStore.this.getProperty("com.ibm.ssl.keyStoreUseForAcceleration");
                            WSPKCSInKeyStore wSPKCSInKeyStore = null;
                            if (string11 != null && string11.equals("true")) {
                                bl = true;
                                wSPKCSInKeyStore = pkcsStoreList.insert(string4, string, null, true, string6, bl);
                            } else {
                                wSPKCSInKeyStore = pkcsStoreList.insert(string4, string, string3, true, string6, bl);
                            }
                            if (wSPKCSInKeyStore != null) {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "getKeyStore (created and initialized)");
                                }
                                keyStore = wSPKCSInKeyStore.getKS();
                                return keyStore;
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "getKeyStore (Could not get KeyStore from pkcsStoreList)");
                            }
                            throw new SSLException("Could not get KeyStore instance for hardware device.");
                        }
                        JSSEProvider jSSEProvider = JSSEProviderFactory.getInstance();
                        keyStore = jSSEProvider.getKeyStoreInstance(string4, string6);
                        char[] cArray = null;
                        if (string3 != null) {
                            cArray = string3.toCharArray();
                        }
                        InputStream inputStream = null;
                        inputStream = WSKeyStore.openKeyStore(string);
                        keyStore.load(inputStream, cArray);
                        if (tc.isDebugEnabled()) {
                            Enumeration<String> enumeration = keyStore.aliases();
                            while (enumeration.hasMoreElements()) {
                                Tr.debug(tc, "alias: " + enumeration.nextElement());
                            }
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getKeyStore (initialized)");
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        return keyStore;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                String string2 = this.getProperty("com.ibm.ssl.keyStoreType");
                if (string2.equals("JCERACFKS") || string2.equals("JCECCARACFKS")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot open keystore URL and since this is a RACFKS, we will return null: ", new Object[]{exception});
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot open keystore URL: " + string, new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.getKeyStore", "527", this);
                Tr.error(tc, "ssl.keystore.load.error.CWPKI0033E", new Object[]{string, exception.getMessage()});
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore (from cache)");
        }
        return this.ks;
    }

    public void store(String string) throws Exception {
        if (string != null) {
            this.setProperty("com.ibm.ssl.keyStorePassword", string);
        }
        this.store();
    }

    public void store() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "store");
        }
        try {
            String[] stringArray;
            Class<?> clazz;
            String string = this.getProperty("com.ibm.ssl.keyStoreName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Storing KeyStore " + string);
            }
            String string2 = this.getProperty("com.ibm.ssl.keyStore");
            String string3 = this.getProperty("com.ibm.ssl.keyStorePassword");
            String string4 = this.getProperty("com.ibm.ssl.keyStoreType");
            String string5 = this.getProperty("com.ibm.ssl.keyStoreReadOnly");
            boolean bl = string5 != null && string5.equals("true");
            String string6 = this.getProperty("com.ibm.ssl.keyStoreFileBased");
            boolean bl2 = string6 != null && string6.equals("true");
            String string7 = this.getProperty("com.ibm.ssl.keyStoreCreateCMSStash");
            boolean bl3 = string7 != null && string7.equals("true");
            String string8 = this.getProperty("com.ibm.ssl.tokenEnabled");
            KeyStore keyStore = this.getKeyStore(false, false);
            if (keyStore != null && !bl && bl2) {
                if (string4 != null && (string4.equals("CMSKS") || string4.equals("IBMi5OSKeyStore"))) {
                    clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
                    stringArray = clazz.getMethod("storeCMSKeyStore", KeyStore.class, String.class, String.class, String.class, String.class);
                    stringArray.invoke(clazz.newInstance(), keyStore, string2, string3, string4, string7);
                } else {
                    clazz = this.getProperty("com.ibm.ssl.keyStore");
                    stringArray = this.getProperty("com.ibm.ssl.keyStorePassword");
                    FileOutputStream fileOutputStream = new FileOutputStream((String)((Object)clazz));
                    keyStore.store(fileOutputStream, stringArray.toCharArray());
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
            }
            if ((clazz = PlatformHelperFactory.getPlatformHelper()).isOS400()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OS400 changing file authority for " + string2);
                }
                try {
                    stringArray = new String[]{"system", "CHGAUT", "OBJ('" + string2 + "')", "USER(*PUBLIC)", "DTAAUT(*RX)", "OBJAUT(*NONE)"};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command to execute on OS400 " + stringArray);
                    }
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during file authority setting on OS400", new Object[]{exception});
                    }
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception storing KeyStore.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.store", "595", this);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "store");
        }
    }

    public void initializeKeyStore(boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeyStore");
        }
        try {
            String string = this.getProperty("com.ibm.ssl.keyStoreInitializeAtStartup");
            if (string != null && string.equals("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing keystore at startup.");
                }
                this.getKeyStore(bl, false);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing KeyStore.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.initializeKeyStore", "619", this);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeyStore");
        }
    }

    public void provideExpirationWarnings(int n, String string) throws Exception {
        KeyStore keyStore;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "provideExpirationWarnings", new Integer(n));
        }
        if ((keyStore = this.getKeyStore(false, false)) != null) {
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        Certificate[] certificateArray;
                        String string2 = enumeration.nextElement();
                        if (string2 == null || (certificateArray = keyStore.getCertificateChain(string2)) == null) continue;
                        for (int i = 0; i < certificateArray.length; ++i) {
                            this.printWarning(n, string, string2, (X509Certificate)certificateArray[i]);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception validating KeyStore expirations.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.provideExpirationWarnings", "663", this);
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "provideExpirationWarnings");
        }
    }

    public void printWarning(int n, String string, String string2, X509Certificate x509Certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printWarning", new Object[]{new Integer(n), string, string2});
        }
        try {
            long l = (long)n * 24L * 60L * 60L * 1000L;
            long l2 = x509Certificate.getNotAfter().getTime() - System.currentTimeMillis();
            long l3 = l2 / 1000L / 60L / 60L / 24L;
            if (x509Certificate != null && l2 < 0L) {
                Tr.error(tc, "ssl.expiration.expired.CWPKI0017E", new Object[]{string2, string});
            } else if (x509Certificate != null && l2 < l) {
                Tr.warning(tc, "ssl.expiration.warning.CWPKI0016E", (Object)new Object[]{string2, string, new Long(l3)});
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate with alias " + string2 + " from keyStore " + string + " has " + l3 + " days left before expiring.");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception reading KeyStore certificates during expiration check.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.printWarning", "727", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "printWarning");
        }
    }

    public static InputStream openKeyStore(String string) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openKeyStore", string);
        }
        InputStream inputStream = null;
        URL uRL = null;
        File file = new File(string);
        if (file.exists() && file.length() == 0L) {
            throw new IOException("Keystore file exists, but is empty: " + string);
        }
        uRL = !file.exists() ? new URL(string) : new URL("file:" + file.getCanonicalPath());
        inputStream = uRL.openStream();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openKeyStore");
        }
        return inputStream;
    }

    public static ArrayList getKeyStoreTypes() {
        ArrayList<String> arrayList;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreTypes");
        }
        if ((n = (arrayList = new ArrayList<String>(Security.getAlgorithms("KeyStore"))).indexOf("IBMCMSKS")) >= 0) {
            arrayList.set(n, "CMSKS");
        }
        if ((n = arrayList.indexOf("CASEEXACTJKS")) != -1) {
            arrayList.remove(n);
        }
        if ((n = arrayList.indexOf("PKCS12S2")) != -1) {
            arrayList.remove(n);
        }
        if ((n = arrayList.indexOf("PKCS12JARSIGNER")) != -1) {
            arrayList.remove(n);
        }
        if ((n = arrayList.indexOf("JCA4758KS")) != -1) {
            arrayList.remove(n);
        }
        if (PlatformHelperFactory.getPlatformHelper().isOS400()) {
            n = arrayList.indexOf("IBMi5OSKeyStore".toUpperCase());
            if (n != -1) {
                arrayList.set(n, "IBMi5OSKeyStore");
            }
            if ((n = arrayList.indexOf("IbmISeriesKeyStore".toUpperCase())) != -1) {
                arrayList.set(n, "IbmISeriesKeyStore");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStoreTypes: " + arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStoreTypes");
        }
        return arrayList;
    }

    public String toString() {
        Enumeration<?> enumeration = this.propertyNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WSKeyStore.toString() {");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            if (string.toLowerCase().indexOf("password") != -1) {
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                stringBuffer.append(SSLConfigManager.mask(string2));
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Object[] invokeKeyStoreCommand(String string, Object[] objectArray) throws KeyException {
        return this.invokeKeyStoreCommand(string, objectArray, Boolean.FALSE);
    }

    public Object[] invokeKeyStoreCommand(String string, Object[] objectArray, Boolean bl) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeKeyStoreCommand", new Object[]{string, this.printParms(objectArray)});
        }
        try {
            String string2 = this.getProperty("com.ibm.ssl.keyStore");
            KeyStore keyStore = this.getKeyStore(false, bl);
            if (keyStore == null) {
                String string3 = this.getProperty("com.ibm.ssl.keyStoreType");
                if (string3.equals("JCERACFKS") || string3.equals("JCECCARACFKS")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Suppressing Exception since KS type is RACF. Trying another CR/SR." + string2);
                    }
                    if (string.equals("isKeyEntry") | string.equals("isCertificateEntry") | string.equals("containsAlias")) {
                        return new Object[]{new Boolean(Boolean.FALSE)};
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot load the Java keystore at location \"" + string2 + "\" on the local node.");
                }
                throw new KeyException("Cannot load the Java keystore at location \"" + string2 + "\" on the local node.");
            }
            if (string.equals("aliases")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                return stringArray;
            }
            if (string.equals("containsAlias")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string4 = (String)objectArray[0];
                boolean bl2 = keyStore.containsAlias(string4);
                return new Object[]{new Boolean(bl2)};
            }
            if (string.equals("deleteEntry")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string5 = (String)objectArray[0];
                keyStore.deleteEntry(string5);
                this.store();
                return null;
            }
            if (string.equals("getCertificate")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string6 = (String)objectArray[0];
                Certificate certificate = keyStore.getCertificate(string6);
                return new Object[]{certificate};
            }
            if (string.equals("getCertificateAlias")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                Certificate certificate = (Certificate)objectArray[0];
                String string7 = keyStore.getCertificateAlias(certificate);
                return new Object[]{string7};
            }
            if (string.equals("getCertificateChain")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string8 = (String)objectArray[0];
                Certificate[] certificateArray = keyStore.getCertificateChain(string8);
                return new Object[]{certificateArray};
            }
            if (string.equals("getCreationDate")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string9 = (String)objectArray[0];
                Date date = keyStore.getCreationDate(string9);
                return new Object[]{date};
            }
            if (string.equals("getDefaultType")) {
                String string10 = KeyStore.getDefaultType();
                return new Object[]{string10};
            }
            if (string.equals("getKey")) {
                if (objectArray == null || objectArray.length != 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string11 = (String)objectArray[0];
                char[] cArray = (char[])objectArray[1];
                Key key = keyStore.getKey(string11, cArray);
                return new Object[]{key};
            }
            if (string.equals("getProvider")) {
                Provider provider = keyStore.getProvider();
                return new Object[]{provider};
            }
            if (string.equals("getType")) {
                String string12 = keyStore.getType();
                return new Object[]{string12};
            }
            if (string.equals("isCertificateEntry")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string13 = (String)objectArray[0];
                boolean bl3 = keyStore.isCertificateEntry(string13);
                return new Object[]{new Boolean(bl3)};
            }
            if (string.equals("isKeyEntry")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string14 = (String)objectArray[0];
                boolean bl4 = keyStore.isKeyEntry(string14);
                return new Object[]{new Boolean(bl4)};
            }
            if (string.equals("setCertificateEntry")) {
                if (objectArray == null || objectArray.length != 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string15 = (String)objectArray[0];
                Certificate certificate = (Certificate)objectArray[1];
                boolean bl5 = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certificate, keyStore);
                String string16 = null;
                if (!bl5 && !keyStore.containsAlias(string15)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + string15 + "\" to keystore.");
                    }
                    keyStore.setCertificateEntry(string15, certificate);
                    string16 = string15;
                } else if (!bl5) {
                    int n = 1;
                    String string17 = null;
                    while (keyStore.containsAlias(string17 = string15 + "_" + n++)) {
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + string17 + "\" to keystore.");
                    }
                    if (!keyStore.containsAlias(string17)) {
                        keyStore.setCertificateEntry(string17, certificate);
                        string16 = string17;
                    }
                }
                this.store();
                return new Object[]{string16};
            }
            if (string.equals("setKeyEntry") && objectArray != null && objectArray.length == 3) {
                if (objectArray == null || objectArray.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string18 = (String)objectArray[0];
                byte[] byArray = (byte[])objectArray[1];
                Certificate[] certificateArray = (Certificate[])objectArray[2];
                String string19 = null;
                if (!keyStore.containsAlias(string18)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + string18 + "\" to keystore.");
                    }
                    keyStore.setKeyEntry(string18, byArray, certificateArray);
                    string19 = string18;
                } else {
                    int n = 1;
                    String string20 = null;
                    while (keyStore.containsAlias(string20 = string18 + "_" + n++)) {
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + string20 + "\" to keystore.");
                    }
                    if (!keyStore.containsAlias(string20)) {
                        keyStore.setKeyEntry(string20, byArray, certificateArray);
                        string19 = string20;
                    }
                }
                this.store();
                return new Object[]{string19};
            }
            if (string.equals("setKeyEntry") && objectArray != null && objectArray.length == 4) {
                if (objectArray == null || objectArray.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string21 = (String)objectArray[0];
                Key key = (Key)objectArray[1];
                char[] cArray = (char[])objectArray[2];
                Certificate[] certificateArray = (Certificate[])objectArray[3];
                String string22 = null;
                if (!keyStore.containsAlias(string21)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + string21 + "\" to keystore.");
                    }
                    keyStore.setKeyEntry(string21, key, cArray, certificateArray);
                    string22 = string21;
                } else {
                    int n = 1;
                    String string23 = null;
                    while (keyStore.containsAlias(string23 = string21 + "_" + n++)) {
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding alias \"" + string23 + "\" to keystore.");
                    }
                    if (!keyStore.containsAlias(string23)) {
                        keyStore.setKeyEntry(string23, key, cArray, certificateArray);
                        string22 = string23;
                    }
                }
                this.store();
                return new Object[]{string22};
            }
            if (string.equals("setKeyEntryOverwrite") && objectArray != null && objectArray.length == 3) {
                if (objectArray == null || objectArray.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string24 = (String)objectArray[0];
                byte[] byArray = (byte[])objectArray[1];
                Certificate[] certificateArray = (Certificate[])objectArray[2];
                String string25 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding alias \"" + string24 + "\" to keystore.");
                }
                keyStore.setKeyEntry(string24, byArray, certificateArray);
                string25 = string24;
                this.store();
                return new Object[]{string25};
            }
            if (string.equals("setKeyEntryOverwrite") && objectArray != null && objectArray.length == 4) {
                if (objectArray == null || objectArray.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string26 = (String)objectArray[0];
                Key key = (Key)objectArray[1];
                char[] cArray = (char[])objectArray[2];
                Certificate[] certificateArray = (Certificate[])objectArray[3];
                String string27 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding alias \"" + string26 + "\" to keystore.");
                }
                keyStore.setKeyEntry(string26, key, cArray, certificateArray);
                string27 = string26;
                this.store();
                return new Object[]{string27};
            }
            if (string.equals("size")) {
                int n = keyStore.size();
                return new Object[]{new Integer(n)};
            }
            if (string.equals("personalCertificateExtract") && objectArray != null && objectArray.length == 4) {
                if (objectArray == null || objectArray.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                KeyStoreInfo keyStoreInfo = (KeyStoreInfo)objectArray[0];
                String string28 = (String)objectArray[1];
                String string29 = (String)objectArray[2];
                Boolean bl6 = (Boolean)objectArray[3];
                WSKeyStore wSKeyStore = new WSKeyStore(keyStoreInfo);
                KeyStore keyStore2 = wSKeyStore.getKeyStore(false, false);
                FileOutputStream fileOutputStream = new FileOutputStream(string28);
                KeyStoreUtil.exportCertificate((OutputStream)fileOutputStream, (KeyStore)keyStore2, (String)string29, (boolean)bl6);
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                return null;
            }
            if (string.equals("receiveCertificate") && objectArray != null && objectArray.length == 3) {
                if (objectArray == null || objectArray.length != 3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                KeyStoreInfo keyStoreInfo = (KeyStoreInfo)objectArray[0];
                String string30 = (String)objectArray[1];
                String string31 = (String)objectArray[2];
                WSKeyStore wSKeyStore = new WSKeyStore(keyStoreInfo);
                KeyStore keyStore3 = wSKeyStore.getKeyStore(false, false);
                FileInputStream fileInputStream = new FileInputStream(string30);
                KeyStoreUtil.importCertificate((InputStream)fileInputStream, (KeyStore)keyStore3, (String)string31);
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                wSKeyStore.store();
                return null;
            }
            if (string.equals("getCertificateChainFromUnManagedKeyStore") && objectArray != null && objectArray.length == 4) {
                if (objectArray == null || objectArray.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string32 = (String)objectArray[0];
                String string33 = (String)objectArray[1];
                char[] cArray = (char[])objectArray[2];
                String string34 = (String)objectArray[3];
                KeyStore keyStore4 = WSKeyStore.loadKeyStore(string32, string33, new String(cArray));
                Certificate[] certificateArray = keyStore4.getCertificateChain(string34);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (success)");
                }
                return new Object[]{certificateArray};
            }
            if (string.equals("getKeyFromUnManagedKeyStore") && objectArray != null && objectArray.length == 4) {
                if (objectArray == null || objectArray.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string35 = (String)objectArray[0];
                String string36 = (String)objectArray[1];
                char[] cArray = (char[])objectArray[2];
                String string37 = (String)objectArray[3];
                KeyStore keyStore5 = WSKeyStore.loadKeyStore(string35, string36, new String(cArray));
                Key key = keyStore5.getKey(string37, cArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (success)");
                }
                return new Object[]{key};
            }
            if (string.equals("containsAliasFromUnManagedKeyStore") && objectArray != null && objectArray.length == 4) {
                if (objectArray == null || objectArray.length != 4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string38 = (String)objectArray[0];
                String string39 = (String)objectArray[1];
                char[] cArray = (char[])objectArray[2];
                String string40 = (String)objectArray[3];
                KeyStore keyStore6 = WSKeyStore.loadKeyStore(string38, string39, new String(cArray));
                boolean bl7 = keyStore6.containsAlias(string40);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (exists -> " + bl7 + ")");
                }
                return new Object[]{new Boolean(bl7)};
            }
            if (string.equals("setKeyEntryFromUnManagedKeyStore") && objectArray != null && objectArray.length == 6) {
                if (objectArray == null || objectArray.length != 6) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string41 = (String)objectArray[0];
                String string42 = (String)objectArray[1];
                char[] cArray = (char[])objectArray[2];
                String string43 = (String)objectArray[3];
                Certificate[] certificateArray = (Certificate[])objectArray[4];
                Key key = (Key)objectArray[5];
                KeyStore keyStore7 = WSKeyStore.loadKeyStore(string41, string42, new String(cArray));
                keyStore7.setKeyEntry(string43, key, cArray, certificateArray);
                FileOutputStream fileOutputStream = new FileOutputStream(string41);
                keyStore7.store(fileOutputStream, cArray);
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invokeKeyStoreCommand (success)");
                }
                return null;
            }
            if (string.equals("store")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                String string44 = (String)objectArray[0];
                this.store(string44);
                return null;
            }
            if (string.equals("checkIfSignerAlreadyExists")) {
                if (objectArray == null || objectArray.length != 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid parameters for the KeyStore method.", new Object[]{this.printParms(objectArray)});
                    }
                    throw new KeyException("Invalid parameters for the KeyStore method: " + this.printParms(objectArray));
                }
                Certificate certificate = (Certificate)objectArray[0];
                boolean bl8 = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore((X509Certificate)certificate, keyStore);
                return new Object[]{new Boolean(bl8)};
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid or unknown method: " + string);
            }
            throw new KeyException("Invalid or unknown method: " + string);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception executing KeyStore method.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.config.WSKeyStore.invokeKeyStoreCommand", "1332", this);
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(exception.getMessage(), exception);
        }
    }

    public static KeyStore loadKeyStore(String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadKeyStore");
        }
        KeyStore keyStore = null;
        InputStream inputStream = null;
        if (string2 != null && (string2.equals("CMSKS") || string2.equals("IBMi5OSKeyStore"))) {
            String string4 = null;
            string4 = string2.equals("IBMi5OSKeyStore") ? "IBMi5OSJSSEProvider" : "IBMCMSProvider";
            File file = new File(string);
            Class<?> clazz = Class.forName("com.ibm.ws.ssl.config.CMSKeyStoreUtility");
            Method method = clazz.getMethod("loadCMSKeyStore", File.class, String.class, String.class, String.class, String.class, String.class);
            keyStore = (KeyStore)method.invoke(clazz.newInstance(), file, string, string3, string2, string4, "true");
        } else {
            JSSEProvider jSSEProvider = JSSEProviderFactory.getInstance();
            keyStore = jSSEProvider.getKeyStoreInstance(string2, jSSEProvider.getKeyStoreProvider());
            if (string2.equals("JCERACFKS") || string2.equals("JCECCARACFKS")) {
                inputStream = WSKeyStore.openKeyStore(string);
            } else {
                File file = new File(string);
                if (file.exists()) {
                    inputStream = WSKeyStore.openKeyStore(string);
                }
            }
            keyStore.load(inputStream, string3.toCharArray());
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadKeyStore");
        }
        return keyStore;
    }

    private String printParms(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray == null || objectArray.length == 0) {
            stringBuffer.append("null or empty parms");
            return stringBuffer.toString();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null && (objectArray[i] instanceof byte[] || objectArray[i] instanceof char[] || objectArray[i] instanceof Key)) continue;
            stringBuffer.append("parm ");
            stringBuffer.append(i);
            stringBuffer.append(": ");
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(", ");
        }
        String string = stringBuffer.toString();
        if (string.endsWith(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }
}

