/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.cmskeystore.CMSLoadStoreParameterFactory;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.security.KeyStore;

public class CMSKeyStoreUtility {
    private static final TraceComponent tc = Tr.register(CMSKeyStoreUtility.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public void storeCMSKeyStore(KeyStore keyStore, String string, String string2, String string3, String string4) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeCMSKeyStore");
        }
        KeyStore.LoadStoreParameter loadStoreParameter = null;
        File file = new File(string);
        if (PlatformHelperFactory.getPlatformHelper().isOS400() && System.getProperty("java.vm.name").equals("Classic VM")) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                clazz = classLoader != null ? classLoader.loadClass("com.ibm.i5os.keystore.i5OSLoadStoreParameter") : Class.forName("com.ibm.i5os.keystore.i5OSLoadStoreParameter");
                KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string2.toCharArray());
                Constructor<?> constructor = clazz.getConstructor(File.class, KeyStore.PasswordProtection.class);
                loadStoreParameter = (KeyStore.LoadStoreParameter)constructor.newInstance(file, passwordProtection);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not load iSeries LoadStoreParameter to store the CMS keystore.", new Object[]{exception});
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        } else if (string3.equals("CMSKS") && string4 != null && string4.equals("true")) {
            loadStoreParameter = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)file, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(string2.toCharArray()), (boolean)true);
        } else if (string3.equals("CMSKS")) {
            loadStoreParameter = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)file, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(string2.toCharArray()), (boolean)false);
        }
        if (loadStoreParameter != null) {
            try {
                keyStore.store(loadStoreParameter);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not store the keystore.", new Object[]{exception});
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeCMSKeyStore");
        }
    }

    public KeyStore loadCMSKeyStore(File file, String string, String string2, String string3, String string4, String string5) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCMSKeyStore");
        }
        KeyStore keyStore = null;
        try {
            Object object;
            KeyStore.LoadStoreParameter loadStoreParameter = null;
            if (PlatformHelperFactory.getPlatformHelper().isOS400() && System.getProperty("java.vm.name").equals("Classic VM")) {
                object = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                clazz = object != null ? ((ClassLoader)object).loadClass("com.ibm.i5os.keystore.i5OSLoadStoreParameter") : Class.forName("com.ibm.i5os.keystore.i5OSLoadStoreParameter");
                KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string2.toCharArray());
                Constructor<?> constructor = clazz.getConstructor(File.class, KeyStore.PasswordProtection.class);
                loadStoreParameter = (KeyStore.LoadStoreParameter)constructor.newInstance(file, passwordProtection);
            } else if (string3.equals("CMSKS") && string5 != null && string5.equals("true")) {
                loadStoreParameter = CMSLoadStoreParameterFactory.newCMSLoadParameter((File)file, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(string2.toCharArray()));
            } else if (string3.equals("CMSKS")) {
                loadStoreParameter = CMSLoadStoreParameterFactory.newCMSLoadParameter((File)file, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(string2.toCharArray()));
            }
            if (loadStoreParameter != null) {
                object = JSSEProviderFactory.getInstance(string4);
                keyStore = object.getKeyStoreInstance(string3, string4);
                keyStore.load(loadStoreParameter);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception loading the CMS keystore.", new Object[]{exception});
            }
            throw new SSLException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCMSKeyStore");
        }
        return keyStore;
    }
}

