/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.jsse2.SSLContext;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLChannel;
import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.ws.ssl.channel.impl.SSLConnectionContextImpl;
import com.ibm.ws.ssl.channel.impl.SSLDiscriminatorState;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLReadServiceContext;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.ws.ssl.channel.impl.SSLWriteServiceContext;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.OutboundConnectionLink;
import com.ibm.wsspi.channel.base.OutboundProtocolLink;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ReadOnlyBufferException;
import java.util.Map;
import javax.net.ssl.SSLException;

public class SSLConnectionLink
extends OutboundProtocolLink
implements InboundConnectionLink,
TCPConnectionContext {
    protected static final TraceComponent tc = Tr.register(SSLConnectionLink.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.imp.SSLConnectionLink";
    private SSLChannel sslChannel = null;
    private SSLChannelData sslConfig = null;
    private ProtoSSLEngine sslEngine = null;
    private SSLReadServiceContext readInterface = null;
    private SSLWriteServiceContext writeInterface = null;
    private TCPConnectionContext deviceServiceContext = null;
    protected TCPReadRequestContext deviceReadInterface = null;
    private TCPWriteRequestContext deviceWriteInterface = null;
    private SSLConnectionContext sslConnectionContext = null;
    private SSLDiscriminatorState discState = null;
    private boolean connected = false;
    private boolean closed = false;
    protected int vcHashCode = 0;
    private ThreadPool threadPool = null;
    protected SSLContext sslContext = null;
    protected TCPConnectRequestContext targetAddress = null;
    private boolean queuedHandshake = false;

    public SSLConnectionLink(SSLChannel sSLChannel) {
        this.sslChannel = sSLChannel;
        this.sslConfig = sSLChannel.getConfig();
    }

    public void init(VirtualConnection virtualConnection) {
        this.vcHashCode = virtualConnection.hashCode();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init, vc=" + this.vcHashCode);
        }
        this.sslConnectionContext = new SSLConnectionContextImpl(this, !this.sslConfig.isInbound());
        super.init(virtualConnection);
        this.readInterface = new SSLReadServiceContext(this);
        this.writeInterface = new SSLWriteServiceContext(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close, vc=" + this.vcHashCode);
        }
        this.closed = true;
        this.cleanup();
        if (this.getDeviceLink() != null) {
            this.getDeviceLink().close(virtualConnection, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy, vc=" + this.vcHashCode);
        }
        this.cleanup();
        super.destroy(exception);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void cleanup() {
        if (null != this.writeInterface) {
            this.writeInterface.close();
        }
        if (null != this.readInterface) {
            this.readInterface.close();
        }
        if (null != this.getSSLEngine()) {
            WsByteBuffer wsByteBuffer = SSLUtils.allocateByteBuffer(this.getSSLEngine().getPacketBufferSize(), false);
            SSLUtils.shutDownSSLEngine(this.getSSLEngine(), wsByteBuffer, this.deviceWriteInterface);
            wsByteBuffer.release();
        }
        this.connected = false;
        this.queuedHandshake = false;
    }

    public Object getChannelAccessor() {
        return this;
    }

    public void setDeviceLink(ConnectionLink connectionLink) {
        super.setDeviceLink(connectionLink);
        this.deviceServiceContext = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        this.deviceReadInterface = this.deviceServiceContext.getReadInterface();
        this.deviceWriteInterface = this.deviceServiceContext.getWriteInterface();
    }

    public void ready(VirtualConnection virtualConnection) {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ready, vc=" + this.vcHashCode);
            }
            if (!this.closed) {
                try {
                    if (this.sslConfig.isInbound()) {
                        Map map = virtualConnection.getStateMap();
                        this.discState = (SSLDiscriminatorState)map.remove("SSLDiscState");
                        if (this.discState != null) {
                            this.sslEngine = this.discState.getEngine();
                            this.sslContext = this.discState.getSSLContext();
                        } else if (this.sslContext == null || this.getSSLEngine() == null) {
                            this.sslContext = this.getChannel().getSSLContextForInboundLink(virtualConnection);
                            this.sslEngine = SSLUtils.getSSLEngine(this.sslContext, this.sslConfig.getFlowType(), this.sslConfig);
                        }
                    } else if (this.sslContext == null || this.getSSLEngine() == null) {
                        this.sslContext = this.getChannel().getSSLContextForOutboundLink(virtualConnection, this.targetAddress);
                        this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.sslConfig, this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSL engine hc=" + this.getSSLEngine().hashCode() + " associated with vc=" + this.vcHashCode);
                    }
                    this.connected = true;
                    if (this.sslConfig.isInbound()) {
                        this.readyInbound(virtualConnection);
                        break block16;
                    }
                    this.readyOutbound(virtualConnection, true);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception during ready, " + exception, exception);
                    }
                    FFDCFilter.processException((Throwable)exception, CLASS_NAME, "238", this);
                    this.close(virtualConnection, exception);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ready called after close so do nothing");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ready");
        }
    }

    protected ThreadPool getThreadPool() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool");
        }
        if (this.threadPool == null) {
            String string = (String)this.vc.getStateMap().get("TCP_THREADPOOL_NAME");
            ChannelFramework channelFramework = this.sslConfig.getChannelFramework();
            if (string != null) {
                this.threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(string);
                if (this.threadPool == null) {
                    String string2 = "Could not obtain named thread pool from the Channel Framework, thread pool name: " + string;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, string2);
                    }
                    throw new ChannelException(string2);
                }
            } else {
                this.threadPool = channelFramework.getDefaultThreadPool();
                if (this.threadPool == null) {
                    String string3 = "Could not obtain default thread pool from the Channel Framework";
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, string3);
                    }
                    throw new ChannelException(string3);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool");
        }
        return this.threadPool;
    }

    private void readyInbound(VirtualConnection virtualConnection) throws ChannelException {
        WsByteBuffer wsByteBuffer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readyInbound, vc=" + this.vcHashCode);
        }
        if ((wsByteBuffer = this.deviceReadInterface.getBuffer()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received null buffer so closing connection.");
            }
            this.close(virtualConnection, null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readyInbound, vc=" + this.vcHashCode);
            }
            return;
        }
        wsByteBuffer.flip();
        WsByteBuffer wsByteBuffer2 = null;
        WsByteBuffer wsByteBuffer3 = null;
        WsByteBuffer wsByteBuffer4 = null;
        ProtoSSLEngineResult protoSSLEngineResult = null;
        boolean bl = this.sslConfig.getDecryptBuffersDirect();
        boolean bl2 = false;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Initial read bytes: " + wsByteBuffer.limit());
        }
        if (this.discState == null) {
            wsByteBuffer2 = SSLUtils.allocateByteBuffer(this.getSSLEngine().getApplicationBufferSize(), bl);
        } else {
            protoSSLEngineResult = this.discState.getEngineResult();
            wsByteBuffer2 = this.discState.getDecryptedNetBuffer();
            wsByteBuffer.position(this.discState.getNetBufferPosition());
            wsByteBuffer.limit(this.discState.getNetBufferLimit());
        }
        wsByteBuffer3 = SSLUtils.allocateByteBuffer(this.getSSLEngine().getApplicationBufferSize(), false);
        wsByteBuffer4 = SSLUtils.allocateByteBuffer(this.getSSLEngine().getPacketBufferSize(), true);
        try {
            WsByteBuffer[] wsByteBufferArray;
            if (this.discState == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Before unwrap\r\nnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\ndecryptedNetBuf:" + SSLUtils.getBufferTraceInfo(wsByteBuffer2));
                }
                wsByteBufferArray = new WsByteBuffer[]{wsByteBuffer};
                int[] nArray = SSLUtils.adjustBuffersForJSSE(wsByteBufferArray, this.getSSLEngine().getPacketBufferSize());
                protoSSLEngineResult = this.getSSLEngine().unwrap(wsByteBuffer.getWrappedByteBuffer(), wsByteBuffer2.getWrappedByteBuffer());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "After unwrap\r\nnetBuf: " + SSLUtils.getBufferTraceInfo(wsByteBuffer) + "\r\ndecryptedNetBuf:" + SSLUtils.getBufferTraceInfo(wsByteBuffer2) + "\r\nstatus=" + protoSSLEngineResult.getStatus() + " consumed=" + protoSSLEngineResult.inBytesConsumed() + " produced=" + protoSSLEngineResult.outBytesProduced());
                }
                if (nArray != null) {
                    SSLUtils.resetBuffersAfterJSSE(wsByteBufferArray, nArray);
                }
                if (wsByteBuffer.remaining() == 0) {
                    wsByteBuffer.clear();
                }
            }
            if ((protoSSLEngineResult = SSLUtils.handleHandshake(this, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, protoSSLEngineResult, (SSLHandshakeCompletedCallback)(wsByteBufferArray = new MyHandshakeCompletedCallback(this, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, FlowType.INBOUND)), false)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "readyInbound");
                }
                return;
            }
            this.readyInboundPostHandshake(wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, protoSSLEngineResult.getStatus());
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during unwrap, " + iOException);
            }
            bl2 = true;
            this.getChannel().getHandshakeErrorTracker().noteHandshakeError(iOException);
            this.close(virtualConnection, iOException);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during unwrap, " + readOnlyBufferException);
            }
            FFDCFilter.processException((Throwable)readOnlyBufferException, CLASS_NAME, "359", this);
            bl2 = true;
            this.close(virtualConnection, readOnlyBufferException);
        }
        if (bl2) {
            if (wsByteBuffer2 != null) {
                wsByteBuffer2.release();
                wsByteBuffer2 = null;
            }
            if (wsByteBuffer3 != null) {
                wsByteBuffer3.release();
                wsByteBuffer3 = null;
            }
            if (wsByteBuffer != null) {
                wsByteBuffer.release();
                wsByteBuffer = null;
                this.deviceReadInterface.setBuffers(null);
            }
            if (wsByteBuffer4 != null) {
                wsByteBuffer4.release();
                wsByteBuffer4 = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readyInbound");
        }
    }

    protected void readyInboundPostHandshake(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4, ProtoSSLEngineResult.Status status) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readyInboundPostHandshake, vc=" + this.vcHashCode);
        }
        wsByteBuffer3.release();
        wsByteBuffer3 = null;
        wsByteBuffer4.release();
        wsByteBuffer4 = null;
        if (status == ProtoSSLEngineResult.Status.HS_FINISHED) {
            this.getChannel().onHandshakeFinish(this.sslEngine);
            if (wsByteBuffer.remaining() == 0 || wsByteBuffer.position() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Releasing netBuffer: " + wsByteBuffer.hashCode());
                }
                wsByteBuffer.release();
                wsByteBuffer = null;
                this.deviceReadInterface.setBuffers(null);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App data exists in netBuffer after handshake: " + wsByteBuffer.remaining());
            }
            this.readInterface.setBuffer(wsByteBuffer2);
            MyReadCompletedCallback myReadCompletedCallback = new MyReadCompletedCallback(wsByteBuffer2);
            if (null != this.readInterface.read(1L, myReadCompletedCallback, false, 0)) {
                this.determineNextChannel();
            }
        } else {
            wsByteBuffer.release();
            wsByteBuffer = null;
            this.deviceReadInterface.setBuffers(null);
            wsByteBuffer2.release();
            wsByteBuffer2 = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unhandled result from SSL engine: " + status);
            }
            SSLException sSLException = new SSLException("Unhandled result from SSL engine: " + status);
            FFDCFilter.processException((Throwable)sSLException, CLASS_NAME, "401", this);
            this.close(this.vc, sSLException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readyInboundPostHandshake");
        }
    }

    private void readyOutbound(VirtualConnection virtualConnection, boolean bl) throws IOException, ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readyOutbound, vc=" + this.vcHashCode);
        }
        boolean bl2 = this.sslConfig.getEncryptBuffersDirect();
        boolean bl3 = this.sslConfig.getDecryptBuffersDirect();
        WsByteBuffer wsByteBuffer = SSLUtils.allocateByteBuffer(this.getSSLEngine().getPacketBufferSize(), bl2);
        WsByteBuffer wsByteBuffer2 = SSLUtils.allocateByteBuffer(this.getSSLEngine().getApplicationBufferSize(), bl3);
        WsByteBuffer wsByteBuffer3 = SSLUtils.allocateByteBuffer(this.getSSLEngine().getApplicationBufferSize(), false);
        WsByteBuffer wsByteBuffer4 = SSLUtils.allocateByteBuffer(this.getSSLEngine().getPacketBufferSize(), true);
        ProtoSSLEngineResult protoSSLEngineResult = null;
        MyHandshakeCompletedCallback myHandshakeCompletedCallback = null;
        IOException iOException = null;
        if (bl) {
            myHandshakeCompletedCallback = new MyHandshakeCompletedCallback(this, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, FlowType.OUTBOUND);
        }
        try {
            protoSSLEngineResult = SSLUtils.handleHandshake(this, wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, protoSSLEngineResult, myHandshakeCompletedCallback, false);
            if (protoSSLEngineResult != null) {
                this.readyOutboundPostHandshake(wsByteBuffer, wsByteBuffer2, wsByteBuffer3, wsByteBuffer4, protoSSLEngineResult.getStatus(), bl);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            iOException = new IOException("Caught exception: " + readOnlyBufferException);
        }
        if (iOException != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during handshake after connect, " + iOException);
            }
            if (wsByteBuffer != null) {
                wsByteBuffer.release();
                wsByteBuffer = null;
                this.deviceReadInterface.setBuffers(null);
            }
            if (wsByteBuffer2 != null) {
                wsByteBuffer2.release();
                wsByteBuffer2 = null;
            }
            if (wsByteBuffer3 != null) {
                wsByteBuffer3.release();
                wsByteBuffer3 = null;
            }
            if (wsByteBuffer4 != null) {
                wsByteBuffer4.release();
                wsByteBuffer4 = null;
            }
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "540", this);
            if (bl) {
                this.close(virtualConnection, iOException);
            } else {
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readyOutbound");
        }
    }

    protected void readyOutboundPostHandshake(WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4, ProtoSSLEngineResult.Status status, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readyOutboundPostHandshake, vc=" + this.vcHashCode);
        }
        IOException iOException = null;
        if (status != ProtoSSLEngineResult.Status.HS_FINISHED) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected results of handshake after connect, " + status);
            }
            iOException = new IOException("Unexpected results of handshake after connect, " + status);
        }
        this.getChannel().onHandshakeFinish(this.sslEngine);
        wsByteBuffer.release();
        wsByteBuffer = null;
        this.deviceReadInterface.setBuffers(null);
        wsByteBuffer2.release();
        wsByteBuffer2 = null;
        wsByteBuffer3.release();
        wsByteBuffer3 = null;
        wsByteBuffer4.release();
        wsByteBuffer4 = null;
        if (bl) {
            if (iOException != null) {
                this.close(this.vc, iOException);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling ready method.");
                }
                super.ready(this.vc);
            }
        } else if (iOException != null) {
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readyOutboundPostHandshake");
        }
    }

    private void handleRedundantConnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRedundantConnect, vc=" + this.vcHashCode);
        }
        this.cleanup();
        this.connected = false;
        this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.sslConfig, this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRedundantConnect");
        }
    }

    public void connectAsynch(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectAsynch, vc=" + this.vcHashCode);
        }
        if (this.connected) {
            this.handleRedundantConnect();
        }
        this.targetAddress = (TCPConnectRequestContext)object;
        ((OutboundConnectionLink)this.getDeviceLink()).connectAsynch(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectAsynch");
        }
    }

    public void connect(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connect, vc=" + this.vcHashCode);
        }
        if (this.connected) {
            this.handleRedundantConnect();
        }
        this.targetAddress = (TCPConnectRequestContext)object;
        ((OutboundConnectionLink)this.getDeviceLink()).connect(object);
        this.connected = true;
        if (this.sslContext == null || this.getSSLEngine() == null) {
            this.sslContext = this.getChannel().getSSLContextForOutboundLink(this.vc, object);
            this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.sslConfig, this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL engine hc=" + this.getSSLEngine().hashCode() + " associated with vc=" + this.vcHashCode);
        }
        this.readyOutbound(this.vc, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connect");
        }
    }

    protected void determineNextChannel() {
        ConnectionReadyCallback connectionReadyCallback;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineNextChannel, vc=" + this.vcHashCode);
        }
        if ((connectionReadyCallback = this.getApplicationCallback()) != null) {
            connectionReadyCallback.ready(this.vc);
        } else {
            int n = 1;
            try {
                n = this.getChannel().getDiscriminationProcess().discriminate(this.vc, this.readInterface.getBuffers(), this);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught doing discriminate, " + exception);
                }
                FFDCFilter.processException((Throwable)exception, CLASS_NAME, "346", this);
                throw new RuntimeException("Exception caught doing discriminate, " + exception);
            }
            switch (n) {
                case 1: {
                    this.getApplicationCallback().ready(this.vc);
                    break;
                }
                case 0: {
                    WsByteBufferUtils.releaseBufferArray(this.deviceReadInterface.getBuffers());
                    this.close(this.vc, new Exception("Failure response from discrimination process."));
                    break;
                }
                case 2: {
                    this.readInterface.setBuffer(this.readInterface.getBuffer());
                    MoreDataNeededCallback moreDataNeededCallback = new MoreDataNeededCallback();
                    if (null == this.readInterface.read(1L, moreDataNeededCallback, false, 0)) break;
                    this.determineNextChannel();
                    break;
                }
                default: {
                    WsByteBufferUtils.releaseBufferArray(this.deviceReadInterface.getBuffers());
                    this.close(this.vc, new Exception("Unknown response from discrimination process, " + n));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineNextChannel");
        }
    }

    public void postConnectProcessing(VirtualConnection virtualConnection) {
    }

    public SSLChannel getChannel() {
        return this.sslChannel;
    }

    public ProtoSSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public TCPReadRequestContext getDeviceReadInterface() {
        return this.deviceReadInterface;
    }

    public TCPWriteRequestContext getDeviceWriteInterface() {
        return this.deviceWriteInterface;
    }

    public TCPReadRequestContext getReadInterface() {
        return this.readInterface;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writeInterface;
    }

    public InetAddress getRemoteAddress() {
        return this.deviceServiceContext.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.deviceServiceContext.getRemotePort();
    }

    public InetAddress getLocalAddress() {
        return this.deviceServiceContext.getLocalAddress();
    }

    public int getLocalPort() {
        return this.deviceServiceContext.getLocalPort();
    }

    public SSLConnectionContext getSSLContext() {
        return this.sslConnectionContext;
    }

    public void setQueuedHandshake(boolean bl) {
        this.queuedHandshake = bl;
    }

    public boolean isQueuedHandshake() {
        return this.queuedHandshake;
    }

    public class MoreDataNeededCallback
    implements TCPReadCompletedCallback {
        public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
            SSLConnectionLink.this.determineNextChannel();
        }

        public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception reading more data to determine next channel, " + iOException);
            }
            FFDCFilter.processException((Throwable)iOException, SSLConnectionLink.CLASS_NAME, "2360", this);
            SSLConnectionLink.this.close(virtualConnection, iOException);
        }
    }

    public class MyReadCompletedCallback
    implements TCPReadCompletedCallback {
        private WsByteBuffer decryptedNetBuffer;

        public MyReadCompletedCallback(WsByteBuffer wsByteBuffer) {
            this.decryptedNetBuffer = wsByteBuffer;
        }

        public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "complete (read), vc=" + SSLConnectionLink.this.vcHashCode);
            }
            SSLConnectionLink.this.determineNextChannel();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete (read), vc=" + SSLConnectionLink.this.vcHashCode);
            }
        }

        public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "error (read), vc=" + SSLConnectionLink.this.vcHashCode);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught IOException during read, " + iOException);
            }
            if (this.decryptedNetBuffer != null) {
                this.decryptedNetBuffer.release();
            }
            this.decryptedNetBuffer = null;
            SSLConnectionLink.this.close(virtualConnection, iOException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "error (read), vc=" + SSLConnectionLink.this.vcHashCode);
            }
        }
    }

    class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private SSLConnectionLink connLink;
        private WsByteBuffer netBuffer;
        private WsByteBuffer decryptedNetBuffer;
        private WsByteBuffer appBuffer;
        private WsByteBuffer encryptedAppBuffer;
        private FlowType flowType;

        public MyHandshakeCompletedCallback(SSLConnectionLink sSLConnectionLink2, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4, FlowType flowType) {
            this.connLink = sSLConnectionLink2;
            this.netBuffer = wsByteBuffer;
            this.decryptedNetBuffer = wsByteBuffer2;
            this.appBuffer = wsByteBuffer3;
            this.encryptedAppBuffer = wsByteBuffer4;
            this.flowType = flowType;
        }

        public void complete(ProtoSSLEngineResult protoSSLEngineResult) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "complete (handshake), vc=" + SSLConnectionLink.this.vcHashCode);
            }
            ProtoSSLEngineResult.Status status = protoSSLEngineResult.getStatus();
            if (this.flowType == FlowType.INBOUND) {
                this.connLink.readyInboundPostHandshake(this.netBuffer, this.decryptedNetBuffer, this.appBuffer, this.encryptedAppBuffer, status);
            } else {
                try {
                    this.connLink.readyOutboundPostHandshake(this.netBuffer, this.decryptedNetBuffer, this.appBuffer, this.encryptedAppBuffer, status, true);
                }
                catch (IOException iOException) {
                    SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), iOException);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "complete (handshake), vc=" + SSLConnectionLink.this.vcHashCode);
            }
        }

        public void error(IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "error (handshake), vc=" + SSLConnectionLink.this.vcHashCode);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during unwrap, " + iOException);
            }
            if (this.decryptedNetBuffer != null) {
                this.decryptedNetBuffer.release();
                this.decryptedNetBuffer = null;
            }
            if (this.appBuffer != null) {
                this.appBuffer.release();
                this.appBuffer = null;
            }
            if (this.netBuffer != null) {
                this.netBuffer.release();
                this.netBuffer = null;
                SSLConnectionLink.this.deviceReadInterface.setBuffers(null);
            }
            if (this.encryptedAppBuffer != null) {
                this.encryptedAppBuffer.release();
                this.encryptedAppBuffer = null;
            }
            if (this.flowType == FlowType.INBOUND) {
                SSLConnectionLink.this.close(this.connLink.getVirtualConnection(), iOException);
            } else if (iOException == null) {
                SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), null);
            } else {
                SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), iOException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "error (handshake), vc=" + SSLConnectionLink.this.vcHashCode);
            }
        }
    }
}

