/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import java.util.Arrays;
import java.util.HashSet;

public class RestrictedAccess {
    private static final String security_xml = "/security.xml";
    private static final String security_xml_noSlash = "security.xml";
    private static final String ws_security_xml = "/ws-security.xml";
    private static final String ws_security_xml_noSlash = "ws-security.xml";
    private static final String admin_authz_xml = "/admin-authz.xml";
    private static final String admin_authz_xml_noSlash = "admin-authz.xml";
    private static final String srv_sec_signature = "/servers/";
    private static final String filter_policy = "filter.policy";
    private static final String app_policy = "app.policy";
    private static final String spi_policy = "spi.policy";
    private static final String security_class_name = "com.ibm.websphere.models.config.security.Security";
    private static final String ltpa_class_name = "com.ibm.websphere.models.config.security.LTPA";
    private static final String user_registry_class_name = "com.ibm.websphere.models.config.security.UserRegistry";
    private static final String localos_user_registry_class_name = "com.ibm.websphere.models.config.security.LocalOSUserRegistry";
    private static final String ldap_user_registry_class_name = "com.ibm.websphere.models.config.security.LDAPUserRegistry";
    private static final String custom_user_registry_class_name = "com.ibm.websphere.models.config.security.CustomUserRegistry";
    private static final String secure_socket_layer_class_name = "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer";
    private static final String jaas_auth_data_class_name = "com.ibm.websphere.models.config.jaaslogin.JAASAuthData";
    private static final String per_srv_sec_attr = "com.ibm.websphere.models.config.security.Security.enforceJava2Security";
    private static final String[] names = new String[]{"com.ibm.websphere.models.config.security.Security.enabled", "com.ibm.websphere.models.config.security.Security.enforceJava2Security", "com.ibm.websphere.models.config.security.Security.properties", "com.ibm.websphere.models.config.security.LTPA.password", "com.ibm.websphere.models.config.security.LTPA.private", "com.ibm.websphere.models.config.security.LTPA.public", "com.ibm.websphere.models.config.security.LTPA.shared", "com.ibm.websphere.models.config.security.UserRegistry.serverPassword", "com.ibm.websphere.models.config.security.UserRegistry.serverId", "com.ibm.websphere.models.config.security.LocalOSUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LocalOSUserRegistry.serverId", "com.ibm.websphere.models.config.security.LDAPUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LDAPUserRegistry.serverId", "com.ibm.websphere.models.config.security.CustomUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.CustomUserRegistry.serverId"};
    private static final HashSet attributes = new HashSet<String>(Arrays.asList(names));
    private static final String[] class_names = new String[]{"com.ibm.websphere.models.config.security.Security", "com.ibm.websphere.models.config.security.LTPA", "com.ibm.websphere.models.config.security.UserRegistry", "com.ibm.websphere.models.config.security.LocalOSUserRegistry", "com.ibm.websphere.models.config.security.LDAPUserRegistry", "com.ibm.websphere.models.config.security.CustomUserRegistry"};
    private static final HashSet classes = new HashSet<String>(Arrays.asList(class_names));
    private static final String[] sensitive_class_names = new String[]{"com.ibm.websphere.models.config.security.Security", "com.ibm.websphere.models.config.security.LTPA", "com.ibm.websphere.models.config.security.UserRegistry", "com.ibm.websphere.models.config.security.LocalOSUserRegistry", "com.ibm.websphere.models.config.security.LDAPUserRegistry", "com.ibm.websphere.models.config.security.CustomUserRegistry", "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer", "com.ibm.websphere.models.config.jaaslogin.JAASAuthData"};
    private static final HashSet sensitive_classes = new HashSet<String>(Arrays.asList(sensitive_class_names));
    private static final String[] sensitive_names = new String[]{"com.ibm.websphere.models.config.security.LTPA.password", "com.ibm.websphere.models.config.security.LTPA.private", "com.ibm.websphere.models.config.security.LTPA.public", "com.ibm.websphere.models.config.security.LTPA.shared", "com.ibm.websphere.models.config.security.UserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LocalOSUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LDAPUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.CustomUserRegistry.serverPassword", "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer.keyFilePassword", "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer.trustFilePassword", "com.ibm.websphere.models.config.jaaslogin.JAASAuthData.password"};
    private static final HashSet sensitive_attributes = new HashSet<String>(Arrays.asList(sensitive_names));

    public static boolean isRestricted(String string) {
        return string.endsWith(security_xml) || string.equals(security_xml_noSlash) || string.endsWith(ws_security_xml) || string.equals(ws_security_xml_noSlash) || string.endsWith(admin_authz_xml) || string.equals(admin_authz_xml_noSlash);
    }

    public static boolean isRestricted(String string, String string2, String string3) {
        boolean bl = false;
        if (string.endsWith(security_xml) || string.equals(security_xml_noSlash) || string.endsWith(ws_security_xml) || string.equals(ws_security_xml_noSlash)) {
            if (string.indexOf(srv_sec_signature) > 1) {
                if (per_srv_sec_attr.equals(string2 + "." + string3)) {
                    bl = true;
                }
            } else if (attributes.contains(string2 + "." + string3)) {
                bl = true;
            }
        } else if (string.endsWith(admin_authz_xml) || string.equals(admin_authz_xml_noSlash)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isRestricted(String string, String string2) {
        boolean bl = false;
        if (string.endsWith(security_xml) || string.equals(security_xml_noSlash) || string.endsWith(ws_security_xml) || string.equals(ws_security_xml_noSlash)) {
            if (string.indexOf(srv_sec_signature) > 1) {
                if (string2.equals(security_class_name)) {
                    bl = true;
                }
            } else if (classes.contains(string2)) {
                bl = true;
            }
        } else if (string.endsWith(admin_authz_xml) || string.equals(admin_authz_xml_noSlash)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isReadable(String string) {
        return !string.endsWith(security_xml) && !string.equals(security_xml_noSlash);
    }

    public static boolean isReadable(String string, String string2) {
        boolean bl = true;
        if (string.endsWith(security_xml) || string.equals(security_xml_noSlash) || string.endsWith(ws_security_xml) || string.equals(ws_security_xml_noSlash)) {
            bl = !sensitive_classes.contains(string2);
        }
        return bl;
    }

    public static boolean isReadable(String string, String string2, String string3) {
        boolean bl = true;
        if (string.endsWith(security_xml) || string.equals(security_xml_noSlash) || string.endsWith(ws_security_xml) || string.equals(ws_security_xml_noSlash)) {
            bl = !sensitive_attributes.contains(string2 + "." + string3);
        }
        return bl;
    }
}

