/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.CORBA.transport.TransportConnectionBase;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.ConnectionKey;
import com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class WSTCPTransportConnection
extends TransportConnectionBase {
    private static int jniReadTimeout = 0;
    private static boolean readTimeOutInitialized = false;
    private static boolean enableKeepAlive = false;
    private static boolean keepAliveInitialized = false;
    protected ConnectionData connectionData = null;
    protected ConnectionInterceptor connectionInterceptor = null;
    ConnectionInformation connectionInformation = null;

    public WSTCPTransportConnection(ConnectionTable connectionTable, Socket socket, ReaderPool readerPool, ORBForTransports oRBForTransports, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor, boolean bl) {
        super(connectionTable, socket, readerPool, oRBForTransports);
        boolean bl2;
        int n = WSTCPTransportConnection.getReadTimeout(readerPool, oRBForTransports);
        if (n > 0) {
            try {
                socket.setSoTimeout(n);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "The read timeout for this connection has been set to " + n + " milliseconds.");
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", exception);
            }
        }
        if (bl2 = WSTCPTransportConnection.getKeepAlive(oRBForTransports)) {
            try {
                socket.setKeepAlive(bl2);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "Server-side KeepAlive for this connection has been set to " + bl2 + " .");
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "the socket for this connection is: " + socket);
        }
        this.connectionData = connectionData;
        this.connectionInterceptor = connectionInterceptor;
        this.connectionInformation = new ConnectionInformationImpl(connectionData, null, System.currentTimeMillis(), socket.getInetAddress().getHostName(), socket.getPort());
        if (!bl) {
            this.activateServer();
        }
    }

    public WSTCPTransportConnection(ORBForTransports oRBForTransports, ConnectionTable connectionTable, ConnectionKey connectionKey, ORBConnection oRBConnection, ReaderPool readerPool, Profile profile, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor) {
        super(oRBForTransports, connectionTable, (com.ibm.CORBA.transport.ConnectionKey)connectionKey, oRBConnection, readerPool, profile);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ORBForTransports, ConnectionTable, ConnectionKey, ORBConnection, ReaderPool, Profile, ConnectionData, ConnectionInterceptor", "the connection key for this connection is: " + connectionKey);
        }
        this.connectionData = connectionData;
        this.connectionInterceptor = connectionInterceptor;
        this.connectionInformation = new ConnectionInformationImpl(connectionData, null, System.currentTimeMillis(), null, -1);
    }

    public void removeConnection() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "removeConnection)", "");
        }
        this.connectionInterceptor.notifyBrokenConnection(this.connectionInformation);
        super.removeConnection();
    }

    public com.ibm.CORBA.transport.ConnectionKey createKey(String string, int n) {
        ConnectionKey connectionKey = new ConnectionKey(string, n);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createKey(host,port)", "for input parameters host=" + string + ", port=" + n + ", the returned ConnectionKey=" + connectionKey);
        }
        return connectionKey;
    }

    public Socket createSocket(String string, int n) throws Exception {
        int n2 = this.getConnectTimeout();
        Socket socket = null;
        if (n2 == 0) {
            socket = new Socket(string, n);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host,port)", "for input parameters host=" + string + ", port=" + n + ", the returned socket=" + socket);
            }
        } else {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(0);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host,port)", "connecting client=" + inetSocketAddress2 + " to server=" + inetSocketAddress + ", timeout=" + n2 + "ms");
            }
            socket = new Socket();
            socket.bind(inetSocketAddress2);
            socket.connect(inetSocketAddress, n2);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host,port)", "successfully connected client " + socket);
            }
        }
        return socket;
    }

    public Object getConnectionData() {
        return this.connectionInformation;
    }

    public Socket createSocket(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) throws Exception {
        int n = this.getConnectTimeout();
        Socket socket = null;
        if (n == 0) {
            boolean bl;
            String string = this.getORBForTransports().getProperty("com.ibm.CORBA.LocalHost");
            boolean bl2 = string != null;
            String string2 = this.getORBForTransports().getProperty("com.ibm.ws.orb.transport.useMultiHome");
            boolean bl3 = string2 != null && string2.equalsIgnoreCase("false");
            String string3 = inetSocketAddress.getHostName();
            int n2 = inetSocketAddress.getPort();
            boolean bl4 = bl = bl3 && bl2;
            if (bl) {
                socket = new Socket(string3, n2, InetAddress.getByName(string), 0);
                if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createServerSocket()", "Bind Client Socket To A Specific NIC card=" + bl + ", Remote Host=" + string3 + ", Remote Port=" + n2 + ", LocalHost=" + string + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(string) + ", the returned socket=" + socket);
                }
            } else {
                socket = new Socket(string3, n2);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "for input parameters host=" + string3 + ", port=" + n2 + ", the returned socket=" + socket);
                }
            }
        } else {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "connecting client=" + inetSocketAddress2 + " to server=" + inetSocketAddress + ", timeout=" + n + "ms");
            }
            socket = new Socket();
            socket.bind(inetSocketAddress2);
            socket.connect(inetSocketAddress, n);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "successfully connected client " + socket);
            }
        }
        return socket;
    }

    private static synchronized int getReadTimeout(ReaderPool readerPool, ORBForTransports oRBForTransports) {
        if (!readTimeOutInitialized && readerPool instanceof JNIReaderPoolImpl) {
            String string = oRBForTransports.getProperty("com.ibm.CORBA.JNIReadTimeout");
            try {
                jniReadTimeout = Integer.parseInt(string);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, WSTCPTransportConnection.class.getName(), "getReadTimeOut", "com.ibm.CORBA.JNIReadTimeout = " + jniReadTimeout);
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(8L, WSTCPTransportConnection.class.getName(), "getReadTimeOut", exception);
            }
            readTimeOutInitialized = true;
        }
        return jniReadTimeout;
    }

    private static synchronized boolean getKeepAlive(ORBForTransports oRBForTransports) {
        if (!keepAliveInitialized) {
            String string = oRBForTransports.getProperty("com.ibm.CORBA.EnableServerKeepAlive");
            enableKeepAlive = Boolean.valueOf(string);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, WSTCPTransportConnection.class.getName(), "getKeepAlive", "com.ibm.CORBA.EnableServerKeepAlive = " + enableKeepAlive);
            }
            keepAliveInitialized = true;
        }
        return enableKeepAlive;
    }
}

