/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orb.transport;

import com.ibm.CORBA.iiop.CodeSetComponentInfo;
import com.ibm.CORBA.iiop.GIOPConnectionProfile;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ws.orb.transport.BaseConnectionDataImpl;
import com.ibm.ws.orb.transport.ConnectionData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class IIOPEndpointProfile
implements GIOPConnectionProfile {
    private static final String ME = IIOPEndpointProfile.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.iiop.channel.resources.IIOPMsgs");
    protected ConnectionData connectionData = null;
    protected Profile ior_profile = null;
    protected String chainName = null;
    protected boolean bootstrapIOR = false;

    protected IIOPEndpointProfile() {
    }

    public IIOPEndpointProfile(IOR iOR, String string, String string2, int n) {
        BaseConnectionDataImpl baseConnectionDataImpl = new BaseConnectionDataImpl();
        baseConnectionDataImpl.setRemoteHost(string2);
        baseConnectionDataImpl.setRemotePort(n);
        this.init(iOR, string, baseConnectionDataImpl);
    }

    public IIOPEndpointProfile(IOR iOR, String string, ConnectionData connectionData) {
        this.init(iOR, string, connectionData);
    }

    protected void init(IOR iOR, String string, ConnectionData connectionData) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "init", new Object[]{"Remote type=" + (iOR == null ? "null" : iOR.getTypeId()), "Chain name=" + string, "ConnData=" + connectionData});
        }
        String string2 = null;
        int n = 0;
        if (iOR == null) {
            string2 = "IIOPEndpointProfile can not be initialized with a null IOR.";
            n = 1229066493;
        } else if (string == null) {
            string2 = "IIOPEndpointProfile can not be initialized with a null chain name";
            n = 1229066494;
        } else if (connectionData == null || connectionData.getConnectionType() == 4L && connectionData.getAltConnectionData() == null) {
            string2 = "IIOPEndpointProfile can not be initialized without connection data(cd=" + connectionData + ")";
            n = 1229066497;
        } else if (connectionData.getConnectionType() != 4L) {
            if (connectionData.getRemoteHost() == null) {
                string2 = "IIOPEndpointProfile can not be initialized without a specified target host name";
                n = 1229066495;
            } else if (connectionData.getRemotePort() == 0) {
                string2 = "IIOPEndpointProfile can not be initialized without a valid target port number";
                n = 1229066496;
            }
        }
        if (string2 != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, string2, new Object[]{iOR, connectionData});
            }
            throw new COMM_FAILURE(string2, n, CompletionStatus.COMPLETED_NO);
        }
        this.ior_profile = iOR.getProfile();
        this.connectionData = connectionData;
        this.chainName = string;
        boolean bl = this.bootstrapIOR = iOR.getTypeId().equals("") && this.ior_profile.getTaggedComponents().length == 0;
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "init");
        }
    }

    public void setChainName(String string) {
        this.chainName = string;
    }

    public String getChainName() {
        return this.chainName;
    }

    public String getHost() {
        return this.connectionData.getRemoteHost();
    }

    public int getPort() {
        return this.connectionData.getRemotePort();
    }

    public byte getMajor() {
        return this.ior_profile.getMajor();
    }

    public byte getMinor() {
        return this.ior_profile.getMinor();
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.ior_profile.getCodeSetComponentInfo();
    }

    public int getPartnerVersion() {
        return this.ior_profile.getPartnerVersion();
    }

    public short getPartnerExtended() {
        return this.ior_profile.getPartnerExtended();
    }

    public ConnectionData getConnectionData() {
        return this.connectionData;
    }

    public boolean isBootstrapIOR() {
        return this.bootstrapIOR;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@" + this.hashCode() + "," + this.chainName + "," + this.connectionData + (this.isBootstrapIOR() ? ",bootstrap IOR" : "") + "]";
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        IIOPEndpointProfile iIOPEndpointProfile = (IIOPEndpointProfile)object;
        String string = iIOPEndpointProfile.chainName;
        String string2 = this.chainName;
        if (string2 == null && string != null || string2 != null && string == null || string2 != null && string != null && !string2.equals(string)) {
            return false;
        }
        if (this.bootstrapIOR != iIOPEndpointProfile.bootstrapIOR) {
            return false;
        }
        ConnectionData connectionData = this.connectionData;
        ConnectionData connectionData2 = iIOPEndpointProfile.connectionData;
        return !(connectionData == null && connectionData2 != null || connectionData != null && connectionData2 == null) && (connectionData == null || connectionData2 == null || connectionData.equals(connectionData2));
    }
}

