/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.compression.WsByteBufferCompression;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericStreamServiceContextImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpTrailersImpl;
import com.ibm.ws.http.channel.impl.IgnoredReadCallback;
import com.ibm.ws.http.channel.impl.IgnoredWriteCallback;
import com.ibm.ws.http.channel.impl.TrailerCallback;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public abstract class HttpServiceContextImpl
extends GenericStreamServiceContextImpl
implements HttpServiceContext {
    private static final TraceComponent tc = Tr.register(HttpServiceContextImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int NOT_ENOUGH_DATA = -1;
    private static final int NO_MORE_DATA = -1;
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected static final byte[] CHUNK_TRAILER_DATA = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private static final int PENDING_BUFFER_INITIAL_SIZE = 10;
    private static final int PENDING_BUFFER_MIN_GROWTH_SIZE = 4;
    private static final int STORAGE_BUFFER_SIZE = 5;
    private static final int STATE_NONE = 0;
    private static final int STATE_FULL_HEADERS = 1;
    private static final int STATE_PARTIAL_BODY = 2;
    private static final int STATE_FULL_MESSAGE = 3;
    private static final ContentEncodingValues DEFAULT_ENCODING = HttpConstants.CONTENT_ENCODING_IDENTITY;
    private TCPConnectionContext myTSC = null;
    private VirtualConnection myVC = null;
    private InterChannelCallback appWriteCB = null;
    private InterChannelCallback appReadCB = null;
    private WsByteBuffer[] myPendingBuffers = new WsByteBuffer[10];
    private int pendingBufferStart = 0;
    private int pendingBufferStop = 0;
    private WsByteBuffer[] myParseBuffers = null;
    private int parseBufferIndex = -1;
    private boolean bIsJITRead = true;
    private int msgParsedState = 0;
    private int msgSentState = 0;
    private boolean bIsPersistent = true;
    private boolean bIsPartialBody = false;
    private boolean bIsOutgoingBodyValid = true;
    private boolean bIsIncomingBodyValid = false;
    private boolean bIsRawBody = false;
    private boolean bIsResponseOwner = true;
    private boolean bIsRequestOwner = true;
    private boolean bForceAsync = false;
    private boolean bParsingTrailers = false;
    private int unparsedDataRemaining = -1;
    private boolean bIsChunked = false;
    private int myContentLength = -1;
    private TCPReadCompletedCallback myBodyRC = null;
    private WsByteBuffer[] storageBuffers = new WsByteBuffer[5];
    private WsByteBuffer[] tempBuffers = new WsByteBuffer[5];
    private int storageIndex = 0;
    private int tempBufferLastIndex = 0;
    private int storageCounter = 0;
    private boolean bIsMultiRead = false;
    private int amountBeingRead = 0;
    private int numBytesWritten = 0;
    private int incomingMsgSize = 0;
    private int savedChunkLength = -1;
    private int oldLimit = 0;
    private int oldPosition = -1;
    private boolean shouldModify = true;
    private WsByteBuffer buffChunkHeader = null;
    private WsByteBuffer buffChunkTrailer = null;
    private HttpChannelConfig myChannelConfig = null;
    private int myReadTimeout = 0;
    private int myWriteTimeout = 0;
    private HttpRequestMessageImpl myRequest = null;
    private HttpResponseMessageImpl myResponse = null;
    private WsByteBuffer currentReadBB = null;
    private VersionValues reqVersion = null;
    private MethodValues reqMethod = null;
    private boolean bIsBodyExpected = false;
    private int chunkLengthParseState = 0;
    private ContentEncodingValues incomingMsgEncoding = DEFAULT_ENCODING;
    private ContentEncodingValues outgoingMsgEncoding = DEFAULT_ENCODING;
    private boolean bCanceledRead = false;
    private boolean bCanceledWrite = false;

    protected HttpServiceContextImpl() {
    }

    public final void resetMsgSentState() {
        this.msgSentState = 0;
    }

    public final void resetMsgParsedState() {
        this.msgParsedState = 0;
    }

    protected final boolean isBodyComplete() {
        return 3 == this.msgParsedState;
    }

    private void setBodyComplete() {
        this.msgParsedState = 3;
    }

    public final boolean isPartialBodySendState() {
        return 2 == this.msgSentState;
    }

    public final boolean isMessageSent() {
        return 3 == this.msgSentState;
    }

    protected final void setMessageSent() {
        this.msgSentState = 3;
    }

    public boolean isIncomingMessageFullyRead() {
        if (null != this.storageBuffers[this.storageIndex]) {
            return false;
        }
        if (!this.isBodyComplete()) {
            return !this.isIncomingBodyValid();
        }
        return true;
    }

    public final boolean headersSent() {
        return 1 <= this.msgSentState;
    }

    protected final void setHeadersSent() {
        this.msgSentState = 1;
    }

    public final boolean isHeadersSentState() {
        return 1 == this.msgSentState;
    }

    public final boolean headersParsed() {
        return 1 <= this.msgParsedState;
    }

    public final void setHeadersParsed() {
        this.msgParsedState = 1;
    }

    protected boolean incomingBuffersReady() {
        return 0 < this.storageCounter;
    }

    protected final void setBodyRC(TCPReadCompletedCallback tCPReadCompletedCallback) {
        this.myBodyRC = tCPReadCompletedCallback;
    }

    private TCPReadCompletedCallback getBodyRC() {
        return this.myBodyRC;
    }

    public final boolean isPersistent() {
        return this.bIsPersistent;
    }

    public final void setPersistent(boolean bl) {
        this.bIsPersistent = bl;
    }

    public boolean isSecure() {
        return null != this.getSSLContext();
    }

    public abstract boolean isInboundConnection();

    private void setIncomingMsgEncoding(ContentEncodingValues contentEncodingValues) {
        this.incomingMsgEncoding = contentEncodingValues;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Incoming msg encoding: " + contentEncodingValues.getName());
        }
    }

    private boolean isIncomingMsgEncoded() {
        return this.myChannelConfig.isAutoDecompressionEnabled() && !DEFAULT_ENCODING.equals(this.incomingMsgEncoding);
    }

    private void setOutgoingMsgEncoding(ContentEncodingValues contentEncodingValues) {
        this.outgoingMsgEncoding = contentEncodingValues;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Outgoing msg encoding: " + contentEncodingValues.getName());
        }
    }

    private boolean isOutgoingMsgEncoded() {
        return !DEFAULT_ENCODING.equals(this.outgoingMsgEncoding);
    }

    public boolean isZlibEncoded() {
        return HttpConstants.CONTENT_ENCODING_DEFLATE.equals(this.outgoingMsgEncoding);
    }

    public boolean setZlibEncoded(boolean bl) {
        if (this.headersSent()) {
            return false;
        }
        if (bl) {
            this.setOutgoingMsgEncoding(HttpConstants.CONTENT_ENCODING_DEFLATE);
        } else if (this.isZlibEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    public boolean isZlibEncodingSupported() {
        return true;
    }

    public boolean isGZipEncoded() {
        return HttpConstants.CONTENT_ENCODING_GZIP.equals(this.outgoingMsgEncoding);
    }

    public boolean setGZipEncoded(boolean bl) {
        if (this.headersSent()) {
            return false;
        }
        if (bl) {
            this.setOutgoingMsgEncoding(HttpConstants.CONTENT_ENCODING_GZIP);
        } else if (this.isGZipEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    public boolean isGZipEncodingSupported() {
        return true;
    }

    public boolean isXGZipEncoded() {
        return HttpConstants.CONTENT_ENCODING_XGZIP.equals(this.outgoingMsgEncoding);
    }

    public boolean setXGZipEncoded(boolean bl) {
        if (this.headersSent()) {
            return false;
        }
        if (bl) {
            this.setOutgoingMsgEncoding(HttpConstants.CONTENT_ENCODING_XGZIP);
        } else if (this.isXGZipEncoded()) {
            this.setOutgoingMsgEncoding(DEFAULT_ENCODING);
        }
        return true;
    }

    public boolean isXGZipEncodingSupported() {
        return true;
    }

    protected final boolean isRawBody() {
        return this.bIsRawBody;
    }

    protected final void setRawBody(boolean bl) {
        this.bIsRawBody = bl;
    }

    public final boolean isPartialBody() {
        return this.bIsPartialBody;
    }

    protected final void setPartialBody(boolean bl) {
        this.bIsPartialBody = bl;
    }

    protected final boolean isOutgoingBodyValid() {
        return this.bIsOutgoingBodyValid;
    }

    private void setOutgoingBodyValid(boolean bl) {
        this.bIsOutgoingBodyValid = bl;
    }

    protected final boolean isForceAsync() {
        return this.bForceAsync;
    }

    protected final void setForceAsync(boolean bl) {
        this.bForceAsync = bl;
    }

    protected final boolean isResponseOwner() {
        return this.bIsResponseOwner;
    }

    protected final void setResponseOwner(boolean bl) {
        this.bIsResponseOwner = bl;
    }

    protected final void setMyResponse(HttpResponseMessageImpl httpResponseMessageImpl) {
        this.myResponse = httpResponseMessageImpl;
    }

    protected final HttpResponseMessageImpl getMyResponse() {
        return this.myResponse;
    }

    protected final boolean isRequestOwner() {
        return this.bIsRequestOwner;
    }

    protected final void setRequestOwner(boolean bl) {
        this.bIsRequestOwner = bl;
    }

    protected final void setMyRequest(HttpRequestMessageImpl httpRequestMessageImpl) {
        this.myRequest = httpRequestMessageImpl;
    }

    protected final HttpRequestMessageImpl getMyRequest() {
        return this.myRequest;
    }

    public void resetRequestOwnership() {
        if (null != this.getMyRequest()) {
            this.getMyRequest().setOwner(this);
        }
    }

    public void resetResponseOwnership() {
        if (null != this.getMyResponse()) {
            this.getMyResponse().setOwner(this);
        }
    }

    private int getChunkLengthParsingState() {
        return this.chunkLengthParseState;
    }

    private void setChunkLengthParsingState(int n) {
        this.chunkLengthParseState = n;
    }

    protected void init(TCPConnectionContext tCPConnectionContext, HttpChannelConfig httpChannelConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.setHttpConfig(httpChannelConfig);
        if (null != tCPConnectionContext) {
            this.setTSC(tCPConnectionContext);
            this.setLocalPort(this.getTSC().getLocalPort());
            this.setRemotePort(this.getTSC().getRemotePort());
            this.setLocalAddr(this.getTSC().getLocalAddress());
            this.setRemoteAddr(this.getTSC().getRemoteAddress());
            this.myReadTimeout = this.getHttpConfig().getReadTimeout();
            this.myWriteTimeout = this.getHttpConfig().getWriteTimeout();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        super.destroy();
        if (null != this.getMyRequest() && this.isRequestOwner()) {
            this.getMyRequest().destroy();
        }
        this.setMyRequest(null);
        if (null != this.getMyResponse() && this.isResponseOwner()) {
            this.getMyResponse().destroy();
        }
        this.setMyResponse(null);
        this.setTSC(null);
        this.setVC(null);
        this.setAppWriteCallback(null);
        this.setAppReadCallback(null);
        this.releaseReadBuffers();
        if (null != this.buffChunkHeader) {
            this.buffChunkHeader.release();
            this.buffChunkHeader = null;
        }
        if (null != this.buffChunkTrailer) {
            this.buffChunkTrailer.release();
            this.buffChunkTrailer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        super.clear();
        if (null != this.myRequest) {
            if (this.bIsRequestOwner) {
                this.myRequest.clear();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Request not mine, skipping clear()");
                }
                this.myRequest = null;
            }
        }
        this.bIsRequestOwner = true;
        if (null != this.myResponse) {
            if (this.bIsResponseOwner) {
                this.myResponse.clear();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Response not mine, skipping clear()");
                }
                this.myResponse = null;
            }
        }
        this.bIsResponseOwner = true;
        this.msgSentState = 0;
        this.msgParsedState = 0;
        this.bIsPersistent = true;
        this.bIsOutgoingBodyValid = true;
        this.bIsIncomingBodyValid = false;
        this.bIsBodyExpected = false;
        this.bIsPartialBody = false;
        this.outgoingMsgEncoding = DEFAULT_ENCODING;
        this.incomingMsgEncoding = DEFAULT_ENCODING;
        this.bIsRawBody = false;
        this.unparsedDataRemaining = -1;
        this.bIsChunked = false;
        this.myContentLength = -1;
        this.clearStorage();
        this.clearTempStorage();
        this.amountBeingRead = 0;
        this.numBytesWritten = 0;
        this.incomingMsgSize = 0;
        this.savedChunkLength = -1;
        this.oldLimit = 0;
        this.shouldModify = true;
        this.clearPendingByteBuffers();
        this.bIsJITRead = false;
        this.reqMethod = null;
        this.reqVersion = null;
        this.chunkLengthParseState = 0;
        this.bParsingTrailers = false;
        this.bCanceledRead = false;
        this.bCanceledWrite = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public VersionValues getRequestVersion() {
        if (null == this.reqVersion) {
            return this.getRequest().getVersionValue();
        }
        return this.reqVersion;
    }

    public final void setRequestVersion(VersionValues versionValues) {
        this.reqVersion = versionValues;
    }

    public MethodValues getRequestMethod() {
        if (null == this.reqMethod) {
            return this.getRequest().getMethodValue();
        }
        return this.reqMethod;
    }

    public final void setRequestMethod(MethodValues methodValues) {
        this.reqMethod = methodValues;
    }

    public void setReadTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout too low (" + n + ")");
        }
        this.myReadTimeout = n;
    }

    public void setWriteTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout too low (" + n + ")");
        }
        this.myWriteTimeout = n;
    }

    public final int getReadTimeout() {
        return this.myReadTimeout;
    }

    public final int getWriteTimeout() {
        return this.myWriteTimeout;
    }

    protected void updatePersistence(HttpBaseMessageImpl httpBaseMessageImpl) {
        String string;
        if (!this.isPersistent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updatePersistence: already false");
            }
            return;
        }
        if (httpBaseMessageImpl.isIncoming() && this.getHttpConfig().isServantRegion() && "false".equalsIgnoreCase(string = (String)this.getVC().getStateMap().get("SessionPersistence"))) {
            this.setPersistent(false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "z/OS CR forced non-persistence");
            }
            return;
        }
        if (httpBaseMessageImpl.isCloseSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message contains Close value");
            }
            this.setPersistent(false);
        } else if (!httpBaseMessageImpl.isKeepAliveSet()) {
            if (httpBaseMessageImpl.isIncoming()) {
                if (httpBaseMessageImpl.getVersionValue().equals(HttpConstants.HTTP_VERSION_10)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Incoming 1.0 msg has no connection header");
                    }
                    this.setPersistent(false);
                }
            } else {
                this.setPersistent(this.getHttpConfig().isKeepAliveEnabled());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting persistence based on configuration: " + this.isPersistent());
                }
            }
        }
        if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Connection persistence updated to " + this.isPersistent(), (HttpServiceContext)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updatePersistence updated: " + this.isPersistent());
        }
    }

    private void updateBodyFlags(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (!httpBaseMessageImpl.isIncoming()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updateBodyFlags skipping outgoing message: " + httpBaseMessageImpl);
            }
            return;
        }
        this.setIsChunkedEncoding(httpBaseMessageImpl.isChunkedEncodingSet());
        if (this.isChunkedEncoding() && -1 != httpBaseMessageImpl.getContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Content-Length header of " + httpBaseMessageImpl.getContentLength() + " and only using chunked-encoding");
            }
            httpBaseMessageImpl.removeHeader(HttpConstants.HDR_CONTENT_LENGTH);
            this.setPersistent(false);
        }
        this.setContentLength(httpBaseMessageImpl.getContentLength());
        if (0 == this.getContentLength()) {
            this.setBodyComplete();
        }
        this.bIsIncomingBodyValid = httpBaseMessageImpl.isBodyAllowed();
        this.bIsBodyExpected = httpBaseMessageImpl.isBodyExpected();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updateBodyFlags: CL: " + this.getContentLength() + " isChunked: " + this.isChunkedEncoding() + " bodyValid: " + this.isIncomingBodyValid() + " bodyExpected: " + this.bIsBodyExpected);
        }
    }

    protected void updateBodyLengthHeaders(HttpBaseMessageImpl httpBaseMessageImpl) {
        if (!httpBaseMessageImpl.shouldUpdateBodyHeaders()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg not allowing body header changes: " + httpBaseMessageImpl);
            }
            return;
        }
        if (0 != httpBaseMessageImpl.getContentLength()) {
            httpBaseMessageImpl.setContentLength(0);
        }
        if (httpBaseMessageImpl.isChunkedEncodingSet()) {
            httpBaseMessageImpl.removeTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
            httpBaseMessageImpl.commitTransferEncoding();
        }
    }

    private void updateIncomingEncodingFlags(HttpBaseMessageImpl httpBaseMessageImpl) {
        ContentEncodingValues contentEncodingValues = httpBaseMessageImpl.getOutermostEncoding();
        if (null != contentEncodingValues) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg outermost encoding: " + contentEncodingValues);
            }
            if (HttpConstants.CONTENT_ENCODING_DEFLATE.equals(contentEncodingValues) || HttpConstants.CONTENT_ENCODING_GZIP.equals(contentEncodingValues) || HttpConstants.CONTENT_ENCODING_XGZIP.equals(contentEncodingValues)) {
                this.setIncomingMsgEncoding(contentEncodingValues);
            } else {
                this.setIncomingMsgEncoding(DEFAULT_ENCODING);
            }
        } else {
            this.setIncomingMsgEncoding(DEFAULT_ENCODING);
        }
    }

    public boolean isChunkedEncoding() {
        return this.bIsChunked;
    }

    private void setIsChunkedEncoding(boolean bl) {
        this.bIsChunked = bl;
    }

    public boolean isContentLength() {
        return -1 != this.getContentLength();
    }

    protected final int getContentLength() {
        return this.myContentLength;
    }

    private void setContentLength(int n) {
        this.myContentLength = n;
    }

    protected final boolean isIncomingBodyValid() {
        return this.bIsIncomingBodyValid;
    }

    protected final boolean isIncomingBodyExpected() {
        return this.bIsBodyExpected;
    }

    private boolean loadReadBuffers() {
        boolean bl = false;
        WsByteBuffer[] wsByteBufferArray = this.getTSC().getReadInterface().getBuffers();
        if (null != wsByteBufferArray && 0 != wsByteBufferArray.length) {
            this.parseBufferIndex = 0;
            this.myParseBuffers = wsByteBufferArray;
            bl = true;
        } else {
            this.parseBufferIndex = -1;
            this.myParseBuffers = null;
        }
        this.getTSC().getReadInterface().setBuffers(null);
        return bl;
    }

    protected WsByteBuffer getNextReadBuffer() {
        if (-1 == this.parseBufferIndex) {
            if (!this.loadReadBuffers()) {
                this.setReadBuffer(null);
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read " + this.myParseBuffers.length + " buffers from device.");
            }
        }
        this.setReadBuffer(this.myParseBuffers[this.parseBufferIndex]);
        this.configurePostReadBuffer(this.getReadBuffer());
        if (this.isJITRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving JIT buffer");
            }
            this.addToCreatedBuffer(this.getReadBuffer());
        }
        ++this.parseBufferIndex;
        if (this.parseBufferIndex == this.myParseBuffers.length) {
            this.parseBufferIndex = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read buffer: " + this.getReadBuffer());
        }
        return this.getReadBuffer();
    }

    public boolean isReadDataAvailable() {
        if (null != this.getReadBuffer() && this.getReadBuffer().hasRemaining()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Data exists in buffer: " + this.getReadBuffer());
            }
            this.disableBufferModification();
            return true;
        }
        if (-1 == this.parseBufferIndex) {
            return false;
        }
        if (this.parseBufferIndex < this.myParseBuffers.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Secondary read buffers exist.");
            }
            this.getNextReadBuffer();
            return true;
        }
        return false;
    }

    public boolean isReadSpaceAvailable(int n) {
        if (null != this.getReadBuffer()) {
            int n2;
            int n3 = this.getReadBuffer().capacity();
            int n4 = n3 - this.getReadBuffer().limit();
            if (0 == n4) {
                return false;
            }
            if (n3 < n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring smaller buffer, capacity=" + n3 + " target size=" + n);
                }
                return false;
            }
            int n5 = n2 = 1024 > n ? n : 1024;
            if (n2 > n4) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring buffer with too little free: " + n4);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public WsByteBuffer getReadBuffer() {
        return this.currentReadBB;
    }

    public void setReadBuffer(WsByteBuffer wsByteBuffer) {
        this.currentReadBB = wsByteBuffer;
    }

    public void configurePostReadBuffer(WsByteBuffer wsByteBuffer) {
        if (!this.shouldModify) {
            return;
        }
        if (0 < this.getOldLimit()) {
            wsByteBuffer.limit(wsByteBuffer.position());
            wsByteBuffer.position(this.getOldLimit());
            this.setOldLimit(0);
        } else {
            wsByteBuffer.flip();
        }
        this.disableBufferModification();
    }

    public void configurePreReadBuffer(WsByteBuffer wsByteBuffer) {
        this.setOldLimit(wsByteBuffer.limit());
        wsByteBuffer.position(this.getOldLimit());
        wsByteBuffer.limit(wsByteBuffer.capacity());
    }

    private void releaseReadBuffers() {
        if (-1 != this.parseBufferIndex) {
            for (int i = this.parseBufferIndex; i < this.myParseBuffers.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Releasing read buffer: " + this.myParseBuffers[i]);
                }
                this.myParseBuffers[i].release();
            }
            this.myParseBuffers = null;
            this.parseBufferIndex = -1;
        }
    }

    public final boolean isJITRead() {
        return this.bIsJITRead;
    }

    public void setupJITRead(int n) {
        this.bIsJITRead = true;
        this.enableBufferModification();
        this.setOldLimit(0);
        this.getTSC().getReadInterface().setJITAllocateSize(n);
        this.getTSC().getReadInterface().setBuffers(null);
        this.setReadBuffer(null);
    }

    public void setupNonJITRead() {
        this.bIsJITRead = false;
        this.enableBufferModification();
        this.getTSC().getReadInterface().setJITAllocateSize(0);
        this.getTSC().getReadInterface().setBuffer(this.getReadBuffer());
    }

    public final void disableBufferModification() {
        this.shouldModify = false;
    }

    public final void enableBufferModification() {
        this.shouldModify = true;
    }

    private void clearPendingByteBuffers() {
        for (int i = 0; i < this.pendingBufferStop; ++i) {
            this.myPendingBuffers[i] = null;
        }
        this.pendingBufferStart = 0;
        this.pendingBufferStop = 0;
    }

    protected final WsByteBuffer[] getPendingBuffers() {
        return this.myPendingBuffers;
    }

    protected final void setPendingBuffers(WsByteBuffer[] wsByteBufferArray) {
        this.myPendingBuffers = wsByteBufferArray;
    }

    protected final int getPendingStart() {
        return this.pendingBufferStart;
    }

    protected final void setPendingStart(int n) {
        this.pendingBufferStart = n;
    }

    protected final int getPendingStop() {
        return this.pendingBufferStop;
    }

    protected final void setPendingStop(int n) {
        this.pendingBufferStop = n;
    }

    public int getNumBytesWritten() {
        return this.numBytesWritten;
    }

    protected final void addBytesWritten(int n) {
        this.numBytesWritten += n;
    }

    protected final void resetBytesWritten() {
        this.numBytesWritten = 0;
    }

    protected final int queryIncomingMsgSize() {
        return this.incomingMsgSize;
    }

    protected final void addToIncomingMsgSize(int n) {
        this.incomingMsgSize += n;
    }

    protected final void resetIncomingMsgSize() {
        this.incomingMsgSize = 0;
    }

    protected void checkIncomingMessageLimit(int n) throws MessageTooLargeException {
    }

    private void growPendingArray(int n) {
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n];
        System.arraycopy(this.myPendingBuffers, 0, wsByteBufferArray, 0, this.pendingBufferStop);
        this.myPendingBuffers = wsByteBufferArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Increased pending list to " + n);
        }
    }

    private void addToPendingByteBuffer(WsByteBuffer wsByteBuffer) {
        if (this.pendingBufferStop == this.myPendingBuffers.length) {
            this.growPendingArray(this.pendingBufferStop + 4);
        }
        this.myPendingBuffers[this.pendingBufferStop] = wsByteBuffer;
        ++this.pendingBufferStop;
    }

    private void addToPendingByteBuffer(WsByteBuffer[] wsByteBufferArray, int n) {
        int n2 = this.pendingBufferStop + n;
        if (n2 >= this.myPendingBuffers.length) {
            if (n < 4) {
                n2 = this.myPendingBuffers.length + 4;
            }
            this.growPendingArray(n2);
        }
        System.arraycopy(wsByteBufferArray, 0, this.myPendingBuffers, this.pendingBufferStop, n);
        this.pendingBufferStop += n;
    }

    private void formatBody(WsByteBuffer[] wsByteBufferArray, HttpBaseMessageImpl httpBaseMessageImpl) {
        Object object;
        boolean bl;
        int n;
        if (null == wsByteBufferArray || null == httpBaseMessageImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Leaving formatBody, wsbb: " + wsByteBufferArray + " msg: " + httpBaseMessageImpl);
            }
            return;
        }
        int n2 = 0;
        for (n = 0; n < wsByteBufferArray.length && null != wsByteBufferArray[n]; ++n) {
            n2 += wsByteBufferArray[n].remaining();
        }
        if (0 == n2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring empty body buffers");
            }
            return;
        }
        boolean bl2 = bl = !this.isRawBody() && httpBaseMessageImpl.isChunkedEncodingSet();
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a chunk of length " + n2);
            }
            object = this.asChunkedLength(n2);
            this.addBytesWritten(((byte[])object).length + BNFHeaders.EOL.length);
            this.addToPendingByteBuffer(this.createChunkHeader((byte[])object));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "formatBody: Adding " + n + " app buffers to write queue");
        }
        this.addToPendingByteBuffer(wsByteBufferArray, n);
        if (bl) {
            object = this.createChunkTrailer();
            object.limit(BNFHeaders.EOL.length);
            this.addToPendingByteBuffer((WsByteBuffer)object);
            this.addBytesWritten(BNFHeaders.EOL.length);
        }
        this.addBytesWritten(n2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "formatBody: total bytes now : " + this.getNumBytesWritten());
        }
    }

    private void formatHeaders(HttpBaseMessageImpl httpBaseMessageImpl) {
        WsByteBuffer[] wsByteBufferArray;
        if (this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Headers were already sent but formatHeaders was called.");
            }
            return;
        }
        if (this.isZlibEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Outgoing body is zlib encoded");
            }
            if (!httpBaseMessageImpl.isDeflateOutermostEncoding()) {
                httpBaseMessageImpl.appendContentEncoding(HttpConstants.CONTENT_ENCODING_DEFLATE);
            }
        } else if (this.isGZipEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Outgoing body is gzip encoded");
            }
            if (!httpBaseMessageImpl.isGZipOutermostEncoding()) {
                httpBaseMessageImpl.appendContentEncoding(HttpConstants.CONTENT_ENCODING_GZIP);
            }
        } else if (this.isXGZipEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Outgoing body is x-gzip encoded");
            }
            if (!httpBaseMessageImpl.isXGZipOutermostEncoding()) {
                httpBaseMessageImpl.appendContentEncoding(HttpConstants.CONTENT_ENCODING_XGZIP);
            }
        }
        this.updatePersistence(httpBaseMessageImpl);
        this.setOutgoingBodyValid(httpBaseMessageImpl.isBodyAllowed());
        if (!this.isOutgoingBodyValid()) {
            this.updateBodyLengthHeaders(httpBaseMessageImpl);
        }
        try {
            wsByteBufferArray = this.getHttpConfig().isBinaryTransportEnabled() ? httpBaseMessageImpl.marshallBinaryMessage() : httpBaseMessageImpl.marshallMessage();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".formatHeaders", "1859", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "marshallMessage returned " + exception);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "formatHeaders: Adding " + wsByteBufferArray.length + " buffers to be written");
        }
        this.addToPendingByteBuffer(wsByteBufferArray, wsByteBufferArray.length);
        this.setHeadersSent();
        if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Sending headers to client", (HttpServiceContext)this);
        }
    }

    protected final void sendHeaders(HttpBaseMessageImpl httpBaseMessageImpl) throws IOException {
        this.formatHeaders(httpBaseMessageImpl);
        this.synchWrite();
    }

    protected final VirtualConnection sendHeaders(HttpBaseMessageImpl httpBaseMessageImpl, TCPWriteCompletedCallback tCPWriteCompletedCallback) {
        this.formatHeaders(httpBaseMessageImpl);
        return this.asynchWrite(tCPWriteCompletedCallback);
    }

    protected boolean isCompressionAllowed() {
        return true;
    }

    private boolean isAutoCompression(HttpBaseMessageImpl httpBaseMessageImpl) {
        String string;
        boolean bl = this.isOutgoingMsgEncoded();
        if (!bl && null != (string = httpBaseMessageImpl.getHeaderAsString(HttpConstants.HDR_$WSZIP))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header requests compression: [" + string + "]");
            }
            if ("gzip".equalsIgnoreCase(string)) {
                this.setGZipEncoded(true);
                bl = true;
            } else if ("x-gzip".equalsIgnoreCase(string)) {
                this.setXGZipEncoded(true);
                bl = true;
            } else if ("zlib".equalsIgnoreCase(string) || "deflate".equalsIgnoreCase(string)) {
                this.setZlibEncoded(true);
                bl = true;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid WSZIP compression: " + string);
                }
                this.setOutgoingMsgEncoding(HttpConstants.CONTENT_ENCODING_IDENTITY);
            }
            httpBaseMessageImpl.removeSpecialHeader(HttpConstants.HDR_$WSZIP);
        }
        if (bl && !(bl = this.isCompressionAllowed())) {
            this.setOutgoingMsgEncoding(HttpConstants.CONTENT_ENCODING_IDENTITY);
        }
        return bl;
    }

    private void prepareOutgoing(WsByteBuffer[] wsByteBufferArray, HttpBaseMessageImpl httpBaseMessageImpl) {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Preparing to send message");
        }
        boolean bl2 = bl = this.isOutgoingBodyValid() && !this.headersSent() && !this.isPartialBody();
        if (!bl && this.isOutgoingMsgEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing disallowed encoding request flag: " + this.outgoingMsgEncoding);
            }
            this.outgoingMsgEncoding = DEFAULT_ENCODING;
        }
        if (null != wsByteBufferArray && !this.isRawBody() && bl && this.isAutoCompression(httpBaseMessageImpl)) {
            if (this.isZlibEncoded()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Outgoing body is zlib encoded");
                }
                wsByteBufferArray = WsByteBufferCompression.deflateCompress(wsByteBufferArray);
                this.addToCreatedBuffer(wsByteBufferArray);
            } else if (this.isGZipEncoded() || this.isXGZipEncoded()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Outgoing body is gzip encoded");
                }
                wsByteBufferArray = WsByteBufferCompression.gzipCompress(wsByteBufferArray);
                this.addToCreatedBuffer(wsByteBufferArray);
            }
            if (!this.headersSent()) {
                httpBaseMessageImpl.removeHeader(HttpConstants.HDR_CONTENT_LENGTH);
            }
        }
        if (!this.headersSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "prepareOutgoing: partial: " + this.isPartialBody() + " chunked: " + httpBaseMessageImpl.isChunkedEncodingSet() + " cl: " + httpBaseMessageImpl.getContentLength());
            }
            if (!this.isPartialBody() && httpBaseMessageImpl.shouldUpdateBodyHeaders()) {
                httpBaseMessageImpl.setContentLength(GenericUtils.sizeOf(wsByteBufferArray));
                if (httpBaseMessageImpl.isChunkedEncodingSet()) {
                    httpBaseMessageImpl.removeTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
                    httpBaseMessageImpl.commitTransferEncoding();
                }
            }
            this.formatHeaders(httpBaseMessageImpl);
        }
        if (null != wsByteBufferArray) {
            if (this.isOutgoingBodyValid()) {
                this.formatBody(wsByteBufferArray, httpBaseMessageImpl);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring invalid body data (" + wsByteBufferArray.length + "): " + wsByteBufferArray);
            }
        }
    }

    protected final void sendOutgoing(WsByteBuffer[] wsByteBufferArray, HttpBaseMessageImpl httpBaseMessageImpl) throws IOException {
        this.prepareOutgoing(wsByteBufferArray, httpBaseMessageImpl);
        this.synchWrite();
    }

    protected final VirtualConnection sendOutgoing(WsByteBuffer[] wsByteBufferArray, HttpBaseMessageImpl httpBaseMessageImpl, TCPWriteCompletedCallback tCPWriteCompletedCallback) {
        this.prepareOutgoing(wsByteBufferArray, httpBaseMessageImpl);
        return this.asynchWrite(tCPWriteCompletedCallback);
    }

    protected final void sendFullOutgoing(WsByteBuffer[] wsByteBufferArray, HttpBaseMessageImpl httpBaseMessageImpl) throws IOException {
        this.prepareOutgoing(wsByteBufferArray, httpBaseMessageImpl);
        if (this.isOutgoingBodyValid() && httpBaseMessageImpl.isChunkedEncodingSet()) {
            this.createEndOfBodyChunk();
        }
        this.setMessageSent();
        this.synchWrite();
    }

    protected final VirtualConnection sendFullOutgoing(WsByteBuffer[] wsByteBufferArray, HttpBaseMessageImpl httpBaseMessageImpl, TCPWriteCompletedCallback tCPWriteCompletedCallback) {
        this.prepareOutgoing(wsByteBufferArray, httpBaseMessageImpl);
        if (this.isOutgoingBodyValid() && httpBaseMessageImpl.isChunkedEncodingSet()) {
            this.createEndOfBodyChunk();
        }
        this.setMessageSent();
        return this.asynchWrite(tCPWriteCompletedCallback);
    }

    protected WsByteBuffer createChunkHeader(byte[] byArray) {
        if (null == this.buffChunkHeader) {
            this.buffChunkHeader = this.newBuffer(32);
            this.buffChunkHeader.removeFromLeakDetection();
        } else {
            this.buffChunkHeader.clear();
        }
        this.buffChunkHeader.put(byArray);
        this.buffChunkHeader.put(BNFHeaders.EOL);
        this.buffChunkHeader.flip();
        return this.buffChunkHeader;
    }

    protected WsByteBuffer createChunkTrailer() {
        if (null == this.buffChunkTrailer) {
            this.buffChunkTrailer = this.newBuffer(32);
            this.buffChunkTrailer.removeFromLeakDetection();
            this.buffChunkTrailer.put(CHUNK_TRAILER_DATA);
            this.buffChunkTrailer.flip();
        } else {
            this.buffChunkTrailer.position(0);
        }
        return this.buffChunkTrailer;
    }

    private void createEndOfBodyChunk() {
        if (this.isRawBody()) {
            WsByteBuffer[] wsByteBufferArray = this.marshallOutgoingTrailers();
            if (null != wsByteBufferArray) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding trailers after raw body.");
                }
                this.addToPendingByteBuffer(wsByteBufferArray, wsByteBufferArray.length);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating end of body chunk");
        }
        WsByteBuffer wsByteBuffer = null;
        if (null == this.buffChunkTrailer) {
            wsByteBuffer = this.createChunkTrailer();
            wsByteBuffer.position(2);
            this.addToPendingByteBuffer(wsByteBuffer);
        } else {
            wsByteBuffer = this.buffChunkTrailer;
            int n = wsByteBuffer.position();
            if (0 != n) {
                if (2 != n) {
                    wsByteBuffer.position(2);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Zero chunk adding to pending list");
                }
                this.addToPendingByteBuffer(wsByteBuffer);
            }
        }
        WsByteBuffer[] wsByteBufferArray = this.marshallOutgoingTrailers();
        if (null != wsByteBufferArray) {
            wsByteBuffer.limit(5);
            this.addBytesWritten(3);
            this.addToPendingByteBuffer(wsByteBufferArray, wsByteBufferArray.length);
        } else {
            wsByteBuffer.limit(7);
            this.addBytesWritten(5);
        }
    }

    private WsByteBuffer[] marshallOutgoingTrailers() {
        HttpTrailersImpl httpTrailersImpl = this.getMessageBeingSent().getTrailersImpl();
        WsByteBuffer[] wsByteBufferArray = null;
        if (null != httpTrailersImpl) {
            httpTrailersImpl.computeRemainingTrailers();
            if (0 < httpTrailersImpl.getNumberOfHeaders()) {
                wsByteBufferArray = this.getHttpConfig().isBinaryTransportEnabled() ? httpTrailersImpl.marshallBinaryHeaders(null) : httpTrailersImpl.marshallHeaders(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trailers marshalled into " + wsByteBufferArray.length + " buffers.");
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: no actual trailers to marshall.");
            }
        }
        return wsByteBufferArray;
    }

    protected final VirtualConnection asynchWrite(TCPWriteCompletedCallback tCPWriteCompletedCallback) {
        WsByteBuffer[] wsByteBufferArray = this.getBuffList();
        if (null != wsByteBufferArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing (async) " + wsByteBufferArray.length + " buffers.");
            }
            this.getTSC().getWriteInterface().setBuffers(wsByteBufferArray);
            return this.getTSC().getWriteInterface().write(-1L, tCPWriteCompletedCallback, this.isForceAsync(), this.getWriteTimeout());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Async write has no data to send.");
        }
        if (this.isForceAsync()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "App channel forcing callback usage.");
            }
            this.getAppWriteCallback().complete(this.getVC());
            return null;
        }
        return this.getVC();
    }

    private void synchWrite() throws IOException {
        WsByteBuffer[] wsByteBufferArray = this.getBuffList();
        if (null != wsByteBufferArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing (sync) " + wsByteBufferArray.length + " buffers.");
            }
            this.getTSC().getWriteInterface().setBuffers(wsByteBufferArray);
            try {
                this.getTSC().getWriteInterface().write(-1L, this.getWriteTimeout());
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "IOException during sync write: " + iOException.getMessage());
                }
                this.setPersistent(false);
                throw iOException;
            }
            finally {
                this.getTSC().getWriteInterface().setBuffers(null);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sync write has no data to send.");
        }
    }

    protected WsByteBuffer[] getBuffList() {
        int n = this.pendingBufferStop - this.pendingBufferStart;
        if (0 == n) {
            return null;
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n];
        System.arraycopy(this.myPendingBuffers, this.pendingBufferStart, wsByteBufferArray, 0, n);
        this.clearPendingByteBuffers();
        return wsByteBufferArray;
    }

    protected abstract boolean reconnectAllowed();

    protected abstract HttpBaseMessageImpl getMessageBeingParsed();

    protected abstract HttpBaseMessageImpl getMessageBeingSent();

    public boolean parseMessage() throws Exception {
        if (null == this.getReadBuffer() && null == this.getNextReadBuffer()) {
            this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
            return false;
        }
        HttpBaseMessageImpl httpBaseMessageImpl = this.getMessageBeingParsed();
        boolean bl = false;
        boolean bl2 = false;
        if (-1 == httpBaseMessageImpl.getBuffersIndex()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "First buffer of message: " + this.getReadBuffer());
            }
            if (this.getHttpConfig().isErrorLoggingEnabled()) {
                if (this.isSecure()) {
                    this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_INFO, "Connection is secure", (HttpServiceContext)this);
                }
                this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Starting to parse the message", (HttpServiceContext)this);
            }
            bl2 = true;
        } else if (this.isJITRead()) {
            bl2 = true;
        }
        do {
            if (bl2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Msg saving buffer: " + this.getReadBuffer());
                }
                httpBaseMessageImpl.addParseBuffer(this.getReadBuffer());
            }
            this.configurePostReadBuffer(this.getReadBuffer());
            bl = httpBaseMessageImpl.parseMessage(this.getReadBuffer(), this.getHttpConfig().shouldExtractValue());
            if (bl) {
                this.parsingComplete();
                continue;
            }
            if (!this.isReadDataAvailable()) break;
            bl2 = true;
        } while (!bl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseMessage() returning " + bl + " for " + httpBaseMessageImpl);
        }
        return bl;
    }

    protected void parsingComplete() throws Exception {
        this.setHeadersParsed();
        this.setLastHeaderBufferIndex();
        this.updatePersistence(this.getMessageBeingParsed());
        this.updateBodyFlags(this.getMessageBeingParsed());
        this.updateIncomingEncodingFlags(this.getMessageBeingParsed());
        if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Finished parsing the message", (HttpServiceContext)this);
        }
    }

    public boolean setupReadBuffers(int n, boolean bl) {
        if (this.isReadDataAvailable()) {
            return true;
        }
        if (this.getHttpConfig().isJITOnlyReads()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config forcing a JIT read.");
            }
            this.setupJITRead(n);
        } else if (this.isReadSpaceAvailable(n)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading into existing buffer: " + this.getReadBuffer());
            }
            this.configurePreReadBuffer(this.getReadBuffer());
            this.setupNonJITRead();
        } else if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Allocating read buffer, size=" + n);
            }
            this.setOldLimit(0);
            this.setReadBuffer(this.newBuffer(n));
            this.setupNonJITRead();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting up a JIT read, size=" + n);
            }
            this.setupJITRead(n);
        }
        return false;
    }

    public void resetRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting parsing variables");
        }
        this.resetMsgParsedState();
        this.getMessageBeingParsed().clear();
    }

    public void resetWrite() {
        this.resetMsgSentState();
        VersionValues versionValues = this.getMessageBeingSent().getVersionValue();
        this.getMessageBeingSent().clear();
        this.getMessageBeingSent().setVersion(versionValues);
    }

    public String getFFDCDumpData() {
        StringBuffer stringBuffer = new StringBuffer();
        HttpBaseMessageImpl httpBaseMessageImpl = this.getMessageBeingParsed();
        if (null != httpBaseMessageImpl) {
            stringBuffer.append("**********Headers  Number:" + httpBaseMessageImpl.getAllHeaders().size() + HTTPChannelDM.LINE_SEPARATOR);
            Vector vector = httpBaseMessageImpl.getAllHeaders();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.get(i);
                Iterator iterator = httpBaseMessageImpl.getHeaderStringValues(string).iterator();
                while (iterator.hasNext()) {
                    HTTPChannelDM.formatFFDCString(string, (String)iterator.next(), stringBuffer);
                }
            }
            stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        } else {
            HTTPChannelDM.formatFFDCString("HttpBaseMessageImpl msg", "null", stringBuffer);
        }
        if (null != this.getReadBuffer()) {
            HTTPChannelDM.formatFFDCString("**********currentReadBB ", ((Object)this.getReadBuffer()).toString(), stringBuffer);
        } else {
            HTTPChannelDM.formatFFDCString("currentReadBB", "null", stringBuffer);
        }
        stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        stringBuffer.append("**********fillBuffers Diagnostic Information " + HTTPChannelDM.LINE_SEPARATOR);
        HTTPChannelDM.formatFFDCString("HttpConfig:ReadBufferSize", String.valueOf(this.getHttpConfig().getIncomingBodyBufferSize()), stringBuffer);
        HTTPChannelDM.formatFFDCString("myReadTimeout", String.valueOf(this.getReadTimeout()), stringBuffer);
        HTTPChannelDM.formatFFDCString("unparsedDataRemaining", String.valueOf(this.getDataLength()), stringBuffer);
        if (null != this.tempBuffers) {
            HTTPChannelDM.formatFFDCString("tempBuffers.length", String.valueOf(this.tempBuffers.length), stringBuffer);
            HTTPChannelDM.formatFFDCString("tempBufferLastIndex", String.valueOf(this.tempBufferLastIndex), stringBuffer);
        }
        stringBuffer.append(HTTPChannelDM.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    public final InterChannelCallback getAppWriteCallback() {
        return this.appWriteCB;
    }

    public final InterChannelCallback getAppReadCallback() {
        return this.appReadCB;
    }

    protected final void setAppWriteCallback(InterChannelCallback interChannelCallback) {
        this.appWriteCB = interChannelCallback;
    }

    protected final void setAppReadCallback(InterChannelCallback interChannelCallback) {
        this.appReadCB = interChannelCallback;
    }

    public abstract HttpObjectFactory getObjectFactory();

    public final void setHttpConfig(HttpChannelConfig httpChannelConfig) {
        this.myChannelConfig = httpChannelConfig;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myChannelConfig;
    }

    private void setTSC(TCPConnectionContext tCPConnectionContext) {
        this.myTSC = tCPConnectionContext;
    }

    public final TCPConnectionContext getTSC() {
        return this.myTSC;
    }

    protected final VirtualConnection getVC() {
        return this.myVC;
    }

    protected final void setVC(VirtualConnection virtualConnection) {
        this.myVC = virtualConnection;
    }

    private byte[] asChunkedLength(int n) {
        int n2 = 16;
        byte[] byArray = new byte[n2];
        int n3 = byArray.length;
        for (int i = n; 0 < i; i >>= 4) {
            int n4 = i & 0xF;
            byArray[--n3] = HEX_BYTES[n4];
        }
        byte[] byArray2 = new byte[n2 - n3];
        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private WsByteBuffer newBuffer(int n) {
        return this.getHttpConfig().isDirectBufferType() ? WsByteBufferPoolManagerImpl.getRef().allocateDirect(n) : WsByteBufferPoolManagerImpl.getRef().allocate(n);
    }

    protected WsByteBuffer allocateBuffer(int n) {
        WsByteBuffer wsByteBuffer = this.newBuffer(n);
        this.addToCreatedBuffer(wsByteBuffer);
        return wsByteBuffer;
    }

    private void setDataLength(int n) {
        this.unparsedDataRemaining = n;
    }

    private int getDataLength() {
        return this.unparsedDataRemaining;
    }

    private boolean doTrailersFollow() throws IllegalHttpBodyException {
        if (this.getMessageBeingParsed().containsHeader(HttpConstants.HDR_TRAILER)) {
            return true;
        }
        int n = this.getReadBuffer().remaining();
        if (0 == n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No data present, assuming no trailers exist");
            }
            return false;
        }
        byte by = this.getReadBuffer().get();
        boolean bl = true;
        if (13 == by) {
            this.addToIncomingMsgSize(1);
            if (1 < n) {
                by = this.getReadBuffer().get();
                if (10 == by) {
                    this.addToIncomingMsgSize(1);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error: Received " + by + " after the CR");
                    }
                    throw new IllegalHttpBodyException("Missing chunk LF: " + by);
                }
            }
            bl = false;
        } else if (10 == by) {
            this.addToIncomingMsgSize(1);
            bl = false;
        } else {
            int n2 = this.getReadBuffer().position() - 1;
            this.getReadBuffer().position(n2);
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Peek ahead for trailers rc->" + bl);
        }
        return bl;
    }

    private void parseChunkCRLF(int n) throws IllegalHttpBodyException {
        if (0 == n) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing past chunk CRLF, excess=" + n);
        }
        byte by = this.getReadBuffer().get();
        this.addToIncomingMsgSize(1);
        if (13 == by) {
            if (1 == n) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "LF char not read yet.");
                }
                return;
            }
            by = this.getReadBuffer().get();
            this.addToIncomingMsgSize(1);
        }
        if (10 != by) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Char expected to be LF but is ->" + by);
            }
            throw new IllegalHttpBodyException("Missing chunk LF: " + by);
        }
    }

    private boolean findBodyLength(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (this.isChunkedEncoding()) {
            if (0 == this.getChunkLengthParsingState()) {
                this.setChunkLengthParsingState(15);
            }
            this.setDataLength(this.readChunkLength(this.getReadBuffer()));
            while (-1 == this.getDataLength()) {
                if (!this.isReadDataAvailable()) {
                    if (this.fillABuffer(3, bl, true)) {
                        return true;
                    }
                    if (this.isBodyComplete()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to read chunk length");
                        }
                        throw new BodyCompleteException("Failed to read chunk length");
                    }
                }
                this.setDataLength(this.readChunkLength(this.getReadBuffer()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Read chunk size " + this.getDataLength());
            }
            this.checkIncomingMessageLimit(this.getDataLength());
            if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
                this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Parsed chunk size of " + this.getDataLength(), (HttpServiceContext)this);
            }
            if (0 == this.getDataLength()) {
                this.setBodyComplete();
                if (this.doTrailersFollow()) {
                    return this.parseTrailers(httpBaseMessageImpl, bl);
                }
                return false;
            }
        } else if (this.isContentLength()) {
            this.setDataLength(this.getContentLength());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got CL size " + this.getDataLength());
            }
            if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
                this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Parsed message content-length of " + this.getDataLength(), (HttpServiceContext)this);
            }
            if (0 == this.getDataLength()) {
                this.setBodyComplete();
                throw new BodyCompleteException("No more body to read");
            }
        }
        if (0 > this.getDataLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid negative body length: " + this.getDataLength());
            }
            this.setDataLength(0);
            throw new IllegalHttpBodyException("Invalid body length");
        }
        return false;
    }

    private boolean findRawChunkLength(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws IllegalHttpBodyException, IOException {
        if (0 == this.getChunkLengthParsingState()) {
            this.setChunkLengthParsingState(15);
        }
        if (null == this.getReadBuffer() && this.fillABuffer(3, bl, true)) {
            return true;
        }
        this.setDataLength(this.readChunkLength(this.getReadBuffer()));
        while (-1 == this.getDataLength()) {
            if (!this.isReadDataAvailable()) {
                if (this.fillABuffer(3, bl, true)) {
                    return true;
                }
                if (this.isBodyComplete()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to read chunk length");
                    }
                    throw new IllegalHttpBodyException("IOException while reading chunk");
                }
            }
            this.setDataLength(this.readChunkLength(this.getReadBuffer()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read raw chunk size " + this.getDataLength());
        }
        this.checkIncomingMessageLimit(this.getDataLength());
        if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Parsed chunk size of " + this.getDataLength(), (HttpServiceContext)this);
        }
        if (0 == this.getDataLength()) {
            this.setBodyComplete();
            boolean bl2 = this.doTrailersFollow();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slicing body up to zero chunk, trailers=" + bl2);
            }
            int n = this.getReadBuffer().position();
            int n2 = this.getReadBuffer().limit();
            this.getReadBuffer().position(this.oldPosition);
            if (n == n2) {
                this.storeBuffer(this.getReadBuffer().slice());
            } else {
                this.getReadBuffer().limit(n);
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(n2);
            }
            this.getReadBuffer().position(n);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Post-slice: " + this.getReadBuffer());
            }
            if (bl2) {
                return this.parseTrailers(httpBaseMessageImpl, bl);
            }
            return false;
        }
        return false;
    }

    private boolean readRawChunk(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading raw chunk buffer, len->" + this.getDataLength());
        }
        if (this.isBodyComplete()) {
            return false;
        }
        if (null == this.getReadBuffer()) {
            this.getNextReadBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current buffer: " + this.getReadBuffer());
        }
        if (null == this.getReadBuffer() || this.getReadBuffer().position() == this.getReadBuffer().capacity()) {
            this.oldPosition = 0;
        } else if (-1 == this.oldPosition) {
            this.oldPosition = this.getReadBuffer().position();
        }
        if (-1 == this.getDataLength() && this.findRawChunkLength(httpBaseMessageImpl, bl)) {
            return true;
        }
        if (0 == this.getDataLength()) {
            return false;
        }
        if (!this.isReadDataAvailable()) {
            if (this.fillABuffer(this.getDataLength(), bl, true)) {
                return true;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error while reading body data");
                }
                throw new IllegalHttpBodyException("Error while reading chunk body.");
            }
        }
        int n = this.getReadBuffer().position();
        int n2 = this.getReadBuffer().limit();
        int n3 = n2 - n;
        int n4 = n3 - this.getDataLength();
        if (0 < n4) {
            n3 = this.getDataLength();
            this.unparsedDataRemaining = 0;
        } else {
            this.unparsedDataRemaining -= n3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unparsed data remaining: " + this.getDataLength());
        }
        if (0 >= n4 && n2 == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Buffer is full, position: " + this.oldPosition);
            }
            this.getReadBuffer().position(this.oldPosition);
            if (0 == this.oldPosition) {
                this.storeBuffer(this.returnLastBuffer());
            } else {
                this.storeBuffer(this.getReadBuffer().slice());
            }
            this.setReadBuffer(null);
            this.oldPosition = -1;
            if (0 == this.getDataLength()) {
                this.setDataLength(-1);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slicing part of a buffer");
            }
            this.getReadBuffer().position(this.oldPosition);
            if (n4 > 0) {
                byte by;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing CRLF for raw chunk, excess=" + n4);
                }
                if (13 == (by = this.getReadBuffer().get(n2 - n4)) && 0 < --n4) {
                    by = this.getReadBuffer().get(n2 - n4);
                }
                if (10 == by) {
                    --n4;
                }
                this.getReadBuffer().limit(n2 - n4);
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(n2);
                this.getReadBuffer().position(n2 - n4);
            } else {
                this.storeBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().position(n2);
            }
            this.oldPosition = this.getReadBuffer().position();
            if (0 == this.getDataLength()) {
                this.setDataLength(-1);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Post-slice: " + this.getReadBuffer());
            }
        }
        return false;
    }

    private boolean readSingleBlock(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        if (!this.isMultiRead() && 0 < this.tempBufferLastIndex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Buffer already available");
            }
            return false;
        }
        if (this.isBodyComplete()) {
            throw new BodyCompleteException("No more body to read");
        }
        if (null == this.getReadBuffer()) {
            this.getNextReadBuffer();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current buffer: " + this.getReadBuffer());
        }
        if (-1 == this.getDataLength() && this.findBodyLength(httpBaseMessageImpl, bl)) {
            return true;
        }
        if (0 == this.getDataLength()) {
            return false;
        }
        if (!this.isReadDataAvailable()) {
            if (this.fillABuffer(this.getDataLength(), bl, true)) {
                return true;
            }
            if (this.isBodyComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "End of body found during fillABuffer");
                }
                return false;
            }
        }
        int n = this.getReadBuffer().position();
        int n2 = this.getReadBuffer().limit();
        int n3 = n2 - n;
        int n4 = n3 - this.getDataLength();
        if (0 < n4) {
            if (this.isContentLength() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Excess data received: " + n4);
            }
            n3 = this.getDataLength();
            this.unparsedDataRemaining = 0;
        } else {
            this.unparsedDataRemaining -= n3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unparsed data remaining: " + this.getDataLength());
        }
        if (this.isContentLength() && 0 == this.getDataLength()) {
            this.setBodyComplete();
        }
        if (n3 == this.getReadBuffer().capacity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning full buffer");
            }
            this.storeTempBuffer(this.returnLastBuffer());
            this.getNextReadBuffer();
        } else {
            int n5;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Slicing part of a buffer");
            }
            if ((n5 = n + n3) == n2) {
                this.storeTempBuffer(this.getReadBuffer().slice());
            } else {
                this.getReadBuffer().limit(n5);
                this.storeTempBuffer(this.getReadBuffer().slice());
                this.getReadBuffer().limit(n2);
            }
            this.getReadBuffer().position(n5);
            if (this.isChunkedEncoding() && 0 < n4) {
                this.parseChunkCRLF(n4);
            }
        }
        return false;
    }

    protected final boolean readBodyBuffer(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws IllegalHttpBodyException, BodyCompleteException, IOException {
        boolean bl2 = false;
        if (this.isIncomingMsgEncoded() && !this.isRawBody()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading encoded body.");
            }
            this.setMultiRead(true);
            return this.readBodyBuffers(httpBaseMessageImpl, bl);
        }
        if (this.isContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading body, content-length");
            }
            bl2 = this.readSingleBlock(httpBaseMessageImpl, bl);
        } else if (this.isChunkedEncoding()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading body, chunked");
            }
            if (0 == this.getDataLength()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reached end of chunk previously");
                }
                this.setDataLength(-1);
            }
            bl2 = !this.isRawBody() ? this.readSingleBlock(httpBaseMessageImpl, bl) : this.readRawChunk(httpBaseMessageImpl, bl);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading until closure");
            }
            bl2 = this.readUntilEnd(bl);
        }
        if (!bl2 && 0 != this.tempBufferLastIndex) {
            this.storeBuffers(this.tempBuffers);
            this.clearTempStorage();
        }
        return bl2;
    }

    protected final boolean readBodyBuffers(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws IllegalHttpBodyException, BodyCompleteException, IOException {
        if (this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "BodyComplete is true, exiting");
            }
            return false;
        }
        boolean bl2 = false;
        if (this.isChunkedEncoding()) {
            if (this.isRawBody()) {
                bl2 = this.readRawChunk(httpBaseMessageImpl, bl);
                while (!bl2 && !this.isBodyComplete()) {
                    bl2 = this.readRawChunk(httpBaseMessageImpl, bl);
                }
            } else {
                bl2 = this.readFullChunk(httpBaseMessageImpl, bl);
                while (!bl2 && !this.isBodyComplete()) {
                    bl2 = this.readFullChunk(httpBaseMessageImpl, bl);
                }
            }
        } else {
            bl2 = this.isContentLength() ? this.readFullCL(httpBaseMessageImpl, bl) : this.readFullBody(bl);
        }
        if (!bl2) {
            this.setBodyComplete();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readBodyBuffers returning " + bl2);
        }
        return bl2;
    }

    protected boolean readUntilEnd(boolean bl) throws IllegalHttpBodyException, BodyCompleteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Inbound request sending non-length delimited body, async:" + bl + ", throwing exception");
        }
        if (this.getHttpConfig().isErrorLoggingEnabled()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "Invalid non-delimited message body", (HttpServiceContext)this);
        }
        this.prepareClosure();
        throw new IllegalHttpBodyException("Non-length delimited body on request");
    }

    private void moveBuffers() throws IllegalHttpBodyException {
        if (0 == this.tempBufferLastIndex) {
            return;
        }
        WsByteBuffer[] wsByteBufferArray = this.tempBuffers;
        if (this.isIncomingMsgEncoded() && !this.isRawBody()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing encoding...");
            }
            HttpBaseMessageImpl httpBaseMessageImpl = this.getMessageBeingParsed();
            ContentEncodingValues contentEncodingValues = this.incomingMsgEncoding;
            boolean bl = true;
            try {
                if (HttpConstants.CONTENT_ENCODING_DEFLATE.equals(contentEncodingValues)) {
                    wsByteBufferArray = WsByteBufferCompression.deflateDecompress(this.tempBuffers);
                } else if (HttpConstants.CONTENT_ENCODING_GZIP.equals(contentEncodingValues) || HttpConstants.CONTENT_ENCODING_XGZIP.equals(contentEncodingValues)) {
                    wsByteBufferArray = WsByteBufferCompression.gzipDecompress(this.tempBuffers);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unexpected body encoding: " + contentEncodingValues);
                    }
                    bl = false;
                }
            }
            catch (Exception exception) {
                throw new IllegalHttpBodyException(exception.getMessage());
            }
            if (bl && !httpBaseMessageImpl.containsHeader(HttpConstants.HDR_$WSZIP)) {
                httpBaseMessageImpl.removeOutermostEncoding();
                if (this.isContentLength()) {
                    int n = GenericUtils.sizeOf(wsByteBufferArray);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating Content-Length based on decompressed values: " + this.getContentLength() + " new: " + n);
                    }
                    httpBaseMessageImpl.setHeader((HeaderKeys)HttpConstants.HDR_$WSORIGCL, httpBaseMessageImpl.getHeaderAsByteArray(HttpConstants.HDR_CONTENT_LENGTH));
                    httpBaseMessageImpl.setContentLength(n);
                    this.setContentLength(n);
                }
            }
        }
        this.storeBuffers(wsByteBufferArray);
        this.clearTempStorage();
    }

    private boolean readFullCL(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        boolean bl2 = false;
        if (-1 == this.getDataLength()) {
            bl2 = this.readSingleBlock(httpBaseMessageImpl, bl);
        }
        while (0 < this.getDataLength() && !bl2) {
            bl2 = this.readSingleBlock(httpBaseMessageImpl, bl);
        }
        if (!bl2) {
            this.moveBuffers();
        }
        return bl2;
    }

    private boolean readFullBody(boolean bl) throws IllegalHttpBodyException, BodyCompleteException {
        boolean bl2 = false;
        while (!bl2 && !this.isBodyComplete()) {
            bl2 = this.readUntilEnd(bl);
        }
        if (!bl2 && !this.isBodyComplete()) {
            this.moveBuffers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readFullBody returning " + bl2);
        }
        return bl2;
    }

    private boolean readFullChunk(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) throws BodyCompleteException, IllegalHttpBodyException, IOException {
        boolean bl2 = false;
        if (0 == this.getDataLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reached end of chunk");
            }
            this.setDataLength(-1);
        }
        if (-1 == this.getDataLength()) {
            bl2 = this.readSingleBlock(httpBaseMessageImpl, bl);
        }
        while (0 < this.getDataLength() && !bl2) {
            bl2 = this.readSingleBlock(httpBaseMessageImpl, bl);
        }
        if (!bl2) {
            if (this.isIncomingMsgEncoded()) {
                if (this.isBodyComplete() || this.isRawBody()) {
                    this.moveBuffers();
                }
            } else {
                this.moveBuffers();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readFullChunk returning " + bl2);
        }
        return bl2;
    }

    private boolean parseTrailers(HttpBaseMessageImpl httpBaseMessageImpl, boolean bl) {
        try {
            this.bParsingTrailers = true;
            boolean bl2 = false;
            while (!bl2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing a buffer for trailer headers");
                }
                HttpTrailersImpl httpTrailersImpl = httpBaseMessageImpl.createTrailers();
                this.addToIncomingMsgSize(this.getReadBuffer().remaining());
                bl2 = this.getHttpConfig().isBinaryTransportEnabled() ? httpTrailersImpl.parseBinaryHeaders(this.getReadBuffer(), HttpConstants.HDR_$WSAT) : httpTrailersImpl.parseHeaders(this.getReadBuffer(), true);
                if (bl2 || this.isReadDataAvailable()) continue;
                this.setBodyRC(TrailerCallback.getRef());
                if (!this.fillABuffer(1, bl, false)) continue;
                return true;
            }
            int n = this.getReadBuffer().remaining();
            if (0 < n) {
                this.addToIncomingMsgSize(-n);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".parseTrailers", "1915", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "parseTrailers caught exception: " + exception);
            }
            this.setPersistent(false);
        }
        this.bParsingTrailers = false;
        return false;
    }

    private int convertCharToLength(int n, int n2) throws IllegalHttpBodyException {
        int n3;
        if (-1 == n2) {
            n2 = 0;
        }
        if (48 <= n && 57 >= n) {
            n3 = n - 48;
        } else if (97 <= n && 102 >= n) {
            n3 = n - 97 + 10;
        } else if (65 <= n && 70 >= n) {
            n3 = n - 65 + 10;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Client sent a bad chunk: " + n);
            }
            throw new IllegalHttpBodyException("Illegal chunk length: 0x" + n);
        }
        n2 <<= 4;
        return n2 += n3;
    }

    private int getSavedChunkLength() {
        return this.savedChunkLength;
    }

    private void setSavedChunkLength(int n) {
        this.savedChunkLength = n;
    }

    private int readChunkLength(WsByteBuffer wsByteBuffer) throws IllegalHttpBodyException {
        int n;
        if (null == wsByteBuffer) {
            return -1;
        }
        int n2 = this.getSavedChunkLength();
        int n3 = wsByteBuffer.limit();
        byte by = 0;
        if (15 == this.getChunkLengthParsingState()) {
            for (n = wsByteBuffer.position(); n < n3; ++n) {
                by = wsByteBuffer.get();
                this.addToIncomingMsgSize(1);
                if (13 == by || 10 == by) {
                    if (-1 == n2) continue;
                    this.setChunkLengthParsingState(17);
                    break;
                }
                if (59 == by || 32 == by || 9 == by) {
                    this.setChunkLengthParsingState(16);
                    break;
                }
                n2 = this.convertCharToLength(by, n2);
            }
            ++n;
        }
        if (16 == this.getChunkLengthParsingState()) {
            if (-1 == n2) {
                throw new IllegalHttpBodyException("Missing chunk length");
            }
            while (n < n3) {
                by = wsByteBuffer.get();
                this.addToIncomingMsgSize(1);
                if (13 == by || 10 == by) {
                    this.setChunkLengthParsingState(17);
                    break;
                }
                ++n;
            }
            ++n;
        }
        if (17 == this.getChunkLengthParsingState() && n < n3) {
            by = wsByteBuffer.get();
            this.addToIncomingMsgSize(1);
            if (13 != by && 10 != by) {
                wsByteBuffer.position(n);
            }
            this.setChunkLengthParsingState(0);
            this.setSavedChunkLength(-1);
            return n2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "readChunkLength: Not enough data, storing [" + n2 + "]");
        }
        this.setSavedChunkLength(n2);
        return -1;
    }

    public final int getOldLimit() {
        return this.oldLimit;
    }

    public final void setOldLimit(int n) {
        this.oldLimit = n;
    }

    private int getAmountBeingRead() {
        return this.amountBeingRead;
    }

    private void setAmountBeingRead(int n) {
        this.amountBeingRead = n;
    }

    protected final boolean fillABuffer(int n, boolean bl, boolean bl2) throws IOException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "fillABuffer(i,b) " + n + " " + bl);
        }
        int n2 = this.getHttpConfig().getIncomingBodyBufferSize();
        if (n < 1024) {
            n2 = 1024;
        } else if (n < n2) {
            n2 = n;
        }
        if (this.getHttpConfig().isJITOnlyReads()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Config forcing JIT read");
            }
            if (null != this.getReadBuffer() && !this.lastBufferContainsHeaders()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returning non-header buffer before JIT read: " + this.getReadBuffer());
                }
                this.returnLastBuffer().release();
            }
            this.setupJITRead(n2);
        } else {
            object = this.getReadBuffer();
            if (null == object || object.limit() == object.capacity()) {
                if (null != object && !this.lastBufferContainsHeaders()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning non-header buffer: " + object);
                    }
                    this.returnLastBuffer().release();
                }
                this.setReadBuffer(this.allocateBuffer(n2));
                this.getReadBuffer().clear();
                this.setOldLimit(0);
            } else {
                this.configurePreReadBuffer((WsByteBuffer)object);
            }
            n2 = this.getReadBuffer().capacity() - this.getOldLimit();
            this.setupNonJITRead();
        }
        this.setAmountBeingRead(n > n2 ? n2 : n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Filling buffer " + this.getReadBuffer() + " with amount " + this.getAmountBeingRead());
        }
        if (bl) {
            object = this.getTSC().getReadInterface().read(this.getAmountBeingRead(), this.getBodyRC(), this.isForceAsync(), this.getReadTimeout());
            if (null == object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "fillABuffer(i,b): async read in progress");
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "fillABuffer(i,b) read() returned immediately");
            }
        } else {
            try {
                this.getTSC().getReadInterface().read(this.getAmountBeingRead(), this.getReadTimeout());
                this.setAmountBeingRead(0);
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "IOException, closing the reads: " + iOException);
                }
                this.prepareClosure();
                if (bl2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing exception back to caller.");
                    }
                    throw iOException;
                }
                return false;
            }
        }
        this.getNextReadBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "fillABuffer(i,b) data ready in " + this.getReadBuffer());
        }
        return false;
    }

    protected final void clearStorage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing buffer storage");
        }
        for (int i = this.storageBuffers.length - 1; 0 <= i; --i) {
            if (null == this.storageBuffers[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing: " + this.storageBuffers[i]);
            }
            this.storageBuffers[i].release();
            this.storageBuffers[i] = null;
        }
        this.storageIndex = 0;
        this.storageCounter = 0;
    }

    protected final void clearTempStorage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing temp storage");
        }
        int n = this.tempBufferLastIndex;
        for (int i = 0; i < n; ++i) {
            if (null == this.tempBuffers[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing: " + this.tempBuffers[i]);
            }
            this.tempBuffers[i].release();
            this.tempBuffers[i] = null;
        }
        this.tempBufferLastIndex = 0;
    }

    protected final void debugPrintStorage(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                Tr.debug(tc, "debug: buffers[" + i + "]: " + (null != wsByteBufferArray[i] ? WsByteBufferUtils.asString(wsByteBufferArray[i]) : "null"));
            }
        }
    }

    protected final WsByteBuffer[] getAllStorageBuffers() {
        WsByteBuffer[] wsByteBufferArray = null;
        int n = this.storageCounter;
        if (0 < n) {
            wsByteBufferArray = new WsByteBuffer[n];
            int n2 = 0;
            int n3 = this.storageIndex;
            while (n2 < n) {
                wsByteBufferArray[n2] = this.storageBuffers[n3];
                this.storageBuffers[n3] = null;
                ++n2;
                ++n3;
            }
            this.storageIndex = 0;
            this.storageCounter = 0;
        }
        return wsByteBufferArray;
    }

    protected final WsByteBuffer[] queryAllStorageBuffers() {
        WsByteBuffer[] wsByteBufferArray = null;
        if (0 < this.storageCounter) {
            wsByteBufferArray = new WsByteBuffer[this.storageCounter];
            System.arraycopy(this.storageBuffers, this.storageIndex, wsByteBufferArray, 0, wsByteBufferArray.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "queryAllStorageBuffers: size=" + this.storageCounter);
        }
        return wsByteBufferArray;
    }

    public final void prepareClosure() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Preparing connection for closure");
        }
        this.setPersistent(false);
        this.setBodyComplete();
        this.setDataLength(0);
        this.setAmountBeingRead(0);
        this.getTSC().getReadInterface().setBuffers(null);
        try {
            this.moveBuffers();
        }
        catch (IllegalHttpBodyException illegalHttpBodyException) {
            // empty catch block
        }
    }

    protected final WsByteBuffer getNextBuffer() {
        WsByteBuffer wsByteBuffer = this.storageBuffers[this.storageIndex];
        if (null != wsByteBuffer) {
            this.storageBuffers[this.storageIndex] = null;
            ++this.storageIndex;
            --this.storageCounter;
            if (this.storageIndex >= this.storageBuffers.length) {
                this.storageIndex = 0;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "storage length " + this.storageBuffers.length + ", index " + this.storageIndex + ", number " + this.storageCounter);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getNextBuffer returning " + wsByteBuffer);
        }
        return wsByteBuffer;
    }

    protected final void storeTempBuffer(WsByteBuffer wsByteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Storing buffer: " + wsByteBuffer);
        }
        if (!this.isIncomingMsgEncoded() || this.isRawBody()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Temp buffer does not need to change");
            }
            this.storeBuffer(wsByteBuffer);
        } else if (null != wsByteBuffer) {
            if (this.tempBuffers.length <= this.tempBufferLastIndex) {
                this.tempBuffers = WsByteBufferUtils.expandBufferArray(this.tempBuffers, wsByteBuffer);
            } else {
                this.tempBuffers[this.tempBufferLastIndex] = wsByteBuffer;
            }
            ++this.tempBufferLastIndex;
        }
    }

    private void storeBuffer(WsByteBuffer wsByteBuffer) {
        int n = this.storageIndex + this.storageCounter;
        wsByteBuffer.setReadOnly(true);
        if (n == this.storageBuffers.length) {
            this.storageBuffers = WsByteBufferUtils.expandBufferArray(this.storageBuffers, wsByteBuffer);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Expanding the storage buffers to length " + this.storageBuffers.length);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing buffer at location " + n);
            }
            this.storageBuffers[n] = wsByteBuffer;
        }
        ++this.storageCounter;
    }

    private void storeBuffers(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Storing all buffers");
        }
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (null == wsByteBufferArray[i]) continue;
            this.storeBuffer(wsByteBufferArray[i]);
            wsByteBufferArray[i] = null;
        }
    }

    protected final void setMultiRead(boolean bl) {
        this.bIsMultiRead = bl;
    }

    private boolean isMultiRead() {
        return this.bIsMultiRead;
    }

    public final void continueRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Continuing read...");
        }
        if (this.bParsingTrailers) {
            if (!this.parseTrailers(this.getMessageBeingParsed(), true)) {
                this.getAppReadCallback().complete(this.getVC());
            }
            return;
        }
        if (!this.incomingBuffersReady() && this.isBodyComplete()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Nothing to read");
            }
            return;
        }
        this.getNextReadBuffer();
        try {
            boolean bl;
            boolean bl2 = bl = this.isMultiRead() ? this.readBodyBuffers(this.getMessageBeingParsed(), true) : this.readBodyBuffer(this.getMessageBeingParsed(), true);
            if (!bl) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling complete on application channel.");
                }
                this.getAppReadCallback().complete(this.getVC());
            }
        }
        catch (IOException iOException) {
            this.getAppReadCallback().error(this.getVC(), iOException);
            return;
        }
        catch (BodyCompleteException bodyCompleteException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception: " + bodyCompleteException);
            }
            this.getAppReadCallback().error(this.getVC(), bodyCompleteException);
            return;
        }
    }

    public SSLConnectionContext getSSLContext() {
        return this.myTSC.getSSLContext();
    }

    public boolean cancelOutstandingRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Attempting to cancel an outstanding read");
        }
        this.bCanceledRead = true;
        try {
            this.myTSC.getReadInterface().read(1L, new IgnoredReadCallback(), false, -2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingRead: tcp layer does not support");
            }
            return false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName() + ".cancelOutstandingRead", "1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingRead: unexpected exception from tcp: " + throwable);
            }
            return false;
        }
        return true;
    }

    public boolean cancelOutstandingWrite() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Attempting to cancel an outstanding write");
        }
        this.bCanceledWrite = true;
        try {
            this.myTSC.getWriteInterface().write(1L, new IgnoredWriteCallback(), false, -2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingWrite: tcp layer does not support");
            }
            return false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName() + ".cancelOutstandingWrite", "1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cancelOutstandingWrite: unexpected exception from tcp: " + throwable);
            }
            return false;
        }
        return true;
    }

    public boolean canceledRead() {
        return this.bCanceledRead;
    }

    public boolean canceledWrite() {
        return this.bCanceledWrite;
    }

    public void resetCanceledRead() {
        this.bCanceledRead = false;
        if (null != this.getReadBuffer()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset after canceled read is updating buffer: " + this.getReadBuffer());
            }
            this.getReadBuffer().limit(this.getReadBuffer().position());
        }
    }

    public void resetCanceledWrite() {
        this.bCanceledWrite = false;
    }
}

