/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.models.config.ipc.ssl.WSSchedule;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class WSScheduler
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WSScheduler.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String name = null;
    int frequency = 90;
    int dayOfWeek = 7;
    int hour = 23;
    int minute = 0;
    long timeout = -1L;
    long nextStartLong = 0L;
    AlarmListener alarmListener = null;
    private static HashMap alarmMap = new HashMap();

    public WSScheduler(WSSchedule wSSchedule, AlarmListener alarmListener) {
        this.WSSchedulerInit(wSSchedule, alarmListener, null);
    }

    public WSScheduler(WSSchedule wSSchedule, AlarmListener alarmListener, String string) {
        this.WSSchedulerInit(wSSchedule, alarmListener, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void WSSchedulerInit(WSSchedule wSSchedule, AlarmListener alarmListener, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSScheduler");
        }
        this.name = wSSchedule.getName();
        this.frequency = wSSchedule.getFrequency();
        this.dayOfWeek = wSSchedule.getDayOfWeek();
        this.hour = wSSchedule.getHour();
        this.minute = wSSchedule.getMinute();
        this.nextStartLong = wSSchedule.getNextStartDate();
        this.alarmListener = alarmListener;
        long l = System.currentTimeMillis();
        try {
            Date date;
            block13: {
                if (this.nextStartLong > 0L) {
                    date = new Date(this.nextStartLong);
                    if (this.nextStartLong < l) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Kicking off alarm and resetting schedule.");
                        }
                        alarmListener.alarm(null);
                        break block13;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Next alarm scheduled for: " + date);
                        }
                        this.timeout = date.getTime() - l;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
                        }
                        this.cancelAlarm(string);
                        Alarm alarm = AlarmManager.createDeferrable(this.timeout, this, string);
                        this.setAlarm(string, alarm);
                        return;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Time could not be read from the configuration.");
                }
            }
            date = this.getNextEventDateFromNow();
            this.timeout = date.getTime() - l;
            this.nextStartLong = date.getTime();
            this.cancelAlarm(string);
            Alarm alarm = AlarmManager.createDeferrable(this.timeout, this, string);
            this.setAlarm(string, alarm);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Next alarm generated from today's date, scheduled for: " + date);
            }
            this.updateNextStartDate(this.name, new Long(date.getTime()));
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.exchangeSigners", "1054", this, new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception generating schedule.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.schedule.init.error.CWPKI0034E", new Object[]{exception.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
        }
    }

    public WSScheduler(int n, int n2, int n3, int n4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSScheduler");
        }
        this.frequency = n;
        this.dayOfWeek = n2;
        this.hour = n3;
        this.minute = n4;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSScheduler", new Object[]{this.toString()});
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        try {
            String string = null;
            if (object != null && object instanceof String) {
                string = (String)object;
                alarmMap.remove(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "alarm removed... alarmMap size:" + alarmMap.size());
                }
            }
            this.alarmListener.alarm(object);
            if (string == null || !alarmMap.containsKey(string)) {
                Date date = this.getNextEventDateFromNow();
                this.timeout = date.getTime() - System.currentTimeMillis();
                this.nextStartLong = date.getTime();
                Alarm alarm = AlarmManager.createDeferrable(this.timeout, this, string);
                this.setAlarm(string, alarm);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next alarm generated from today's date, scheduled for: " + date);
                }
                this.updateNextStartDate(this.name, new Long(date.getTime()));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.config.KeyStoreManager.exchangeSigners", "1054", this, new Object[]{exception});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception generating schedule.", new Object[]{exception});
            }
            Tr.error(tc, "ssl.schedule.init.error.CWPKI0034E", new Object[]{exception.getMessage()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public Date getNextEventDateFromNow() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextEventDateFromNow");
        }
        Calendar calendar = Calendar.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextEventDateFromNow", new Object[]{calendar.getTime()});
        }
        return this.computeDate(calendar);
    }

    public Date getNextEventDateFromDate(Date date) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextEventDateFromDate");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextEventDateFromDate", new Object[]{calendar.getTime()});
        }
        return this.computeDate(calendar);
    }

    public Date computeDate(Calendar calendar) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "computeDate");
        }
        if (this.hour < 24) {
            calendar.set(11, this.hour);
        }
        if (this.minute < 60) {
            calendar.set(12, this.minute);
        }
        int n2 = calendar.get(6);
        int n3 = calendar.get(1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentDay = " + n2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentYear = " + n3);
        }
        if ((n = n2 + this.frequency) > 365) {
            calendar.set(6, n -= 365);
            calendar.set(1, ++n3);
        } else {
            calendar.set(6, n);
        }
        if (this.dayOfWeek > 0 && this.dayOfWeek < 8) {
            int n4 = 0;
            int n5 = calendar.get(7);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dayOfWeek (preferred) = " + this.dayOfWeek);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentDayOfWeek = " + n5);
            }
            if (n5 != this.dayOfWeek) {
                n4 = n5 - this.dayOfWeek;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delta (dayOfWeek) = " + n4);
                }
                if (n - n4 <= 0) {
                    n = n - n4 + 365;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + n);
                    }
                    calendar.set(6, n);
                    --n3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + n3);
                    }
                    calendar.set(1, n3);
                } else if (n - n4 > 365) {
                    n = n - n4 - 365;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + n);
                    }
                    calendar.set(6, n);
                    ++n3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + n3);
                    }
                    calendar.set(1, n3);
                } else {
                    n -= n4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nextDay (w/delta) = " + n);
                    }
                    calendar.set(6, n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentYear = " + n3);
                    }
                }
            }
        }
        Date date = calendar.getTime();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "computeDate", new Object[]{date});
        }
        return date;
    }

    public void updateNextStartDate(String string, Long l) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateNextStartDate");
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.ssl.utils.SchedulerCommandHelper");
                Method method = clazz.getMethod("updateNextStartDate", String.class, Long.class);
                method.invoke(clazz.newInstance(), string, l);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSScheduler.updateNextStartDate", "263", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception updating next start date.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNextStartDate");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WSScheduler.toString() {\n");
        stringBuffer.append("name = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("frequency = ");
        stringBuffer.append(this.frequency);
        stringBuffer.append("\n");
        stringBuffer.append("dayOfWeek = ");
        stringBuffer.append(this.dayOfWeek);
        stringBuffer.append("\n");
        stringBuffer.append("hour = ");
        stringBuffer.append(this.hour);
        stringBuffer.append("\n");
        stringBuffer.append("minute = ");
        stringBuffer.append(this.minute);
        stringBuffer.append("\n");
        stringBuffer.append("nextStartLong = ");
        stringBuffer.append(this.nextStartLong);
        stringBuffer.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }

    public void cancelAlarm(String string) {
        Alarm alarm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelAlarm  key:" + string);
        }
        if (string != null && (alarm = (Alarm)alarmMap.get(string)) != null) {
            boolean bl = AlarmManager.disableAlarm(alarm);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "disableAlarm:" + bl);
            }
            alarmMap.remove(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "disableAlarm:" + bl + "  size:" + alarmMap.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelAlarm");
        }
    }

    public void setAlarm(String string, Alarm alarm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAlarm  key:" + string + "  Alarm:" + alarm);
        }
        if (string != null && alarm != null) {
            alarmMap.put(string, alarm);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "store Alarm.. size:" + alarmMap.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAlarm");
        }
    }
}

