/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSScheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WSKeySetGroup
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WSKeySetGroup.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String name = null;
    boolean autoGenerate = true;
    WSScheduler scheduler = null;
    List keySetList = null;
    String scope = ManagementScopeManager.getInstance().getCellScopeName();

    public WSKeySetGroup(KeySetGroup keySetGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySetGroup");
        }
        this.name = keySetGroup.getName();
        this.autoGenerate = keySetGroup.isAutoGenerate();
        this.keySetList = this.convertToWSKeySets(keySetGroup.getKeySet());
        this.scope = keySetGroup.getManagementScope().getScopeName();
        if (this.autoGenerate && (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") || ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess"))) {
            this.scheduler = new WSScheduler(keySetGroup.getWsSchedule(), this, this.name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySetGroup", new Object[]{this.toString()});
        }
    }

    public void alarm(Object object) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm", object);
            }
            try {
                StartAlarm startAlarm = new StartAlarm(this);
                Class<?> clazz = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                Method method = clazz.getMethod("getInstance", null);
                Object object2 = method.invoke(null, null);
                Class<?> clazz2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                Method method2 = clazz2.getMethod("runAsSystem", PrivilegedExceptionAction.class);
                method2.invoke(object2, startAlarm);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSKeySetGroup.alarm", "99", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "WSKeySetGroup alarm did not execute.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    private List convertToWSKeySets(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToWSKeySets");
        }
        ArrayList<WSKeySet> arrayList = new ArrayList<WSKeySet>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                KeySet keySet = (KeySet)list.get(i);
                WSKeySet wSKeySet = KeySetManager.getInstance().getKeySet(keySet.getName());
                if (wSKeySet == null) continue;
                arrayList.add(wSKeySet);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToWSKeySets");
        }
        return arrayList;
    }

    public TreeMap getAllKeysByVersion() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeysByVersion");
        }
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.keySetList.size(); ++i) {
            KeyReference[] keyReferenceArray;
            WSKeySet wSKeySet = (WSKeySet)this.keySetList.get(i);
            if (wSKeySet == null || (keyReferenceArray = wSKeySet.getAllKeyReferences()) == null) continue;
            for (int j = 0; j < keyReferenceArray.length; ++j) {
                String string = "version_" + keyReferenceArray[j].getVersion();
                if (!treeMap.containsKey(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding versionSort key: " + string);
                    }
                    treeMap.put(string, new HashMap());
                }
                Map map = (Map)treeMap.get(string);
                if (keyReferenceArray[j] instanceof WSKeyReference) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Key alias " + keyReferenceArray[j].getKeyAlias() + " to keyMap " + string);
                    }
                    map.put(keyReferenceArray[j].getKeyAlias(), ((WSKeyReference)keyReferenceArray[j]).getKey());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding KeyPair alias " + keyReferenceArray[j].getKeyAlias() + " to keyMap " + string);
                }
                map.put(keyReferenceArray[j].getKeyAlias(), ((WSKeyPairReference)keyReferenceArray[j]).getKeyPair());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysByVersion (size: " + treeMap.size() + ")");
        }
        return treeMap;
    }

    public Map getAllKeysByKeySetName(String string) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyByKeySetName", new Object[]{string});
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.keySetList.size(); ++i) {
            WSKeySet wSKeySet = (WSKeySet)this.keySetList.get(i);
            if (!wSKeySet.getName().equalsIgnoreCase(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllKeysByKeySetName (found)");
            }
            return wSKeySet.getAllKeys();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysByKeySetName (not found)");
        }
        return null;
    }

    public Object getLatestKeyByKeySetName(String string) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyByKeySetName", new Object[]{string});
        }
        for (int i = 0; i < this.keySetList.size(); ++i) {
            WSKeySet wSKeySet = (WSKeySet)this.keySetList.get(i);
            if (!wSKeySet.getName().equalsIgnoreCase(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLatestKeyByKeySetName (found)");
            }
            return wSKeySet.getLatestKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeyByKeySetName (not found)");
        }
        return null;
    }

    public WSKeySet[] getAllKeySets() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeySets");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeySets (total: " + this.keySetList.size() + ")");
        }
        return this.keySetList.toArray(new WSKeySet[this.keySetList.size()]);
    }

    public Map getLatestKeys() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeys");
        }
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        for (int i = 0; i < this.keySetList.size(); ++i) {
            WSKeySet wSKeySet = (WSKeySet)this.keySetList.get(i);
            KeyReference keyReference = wSKeySet.getLatestKeyReference();
            if (keyReference instanceof WSKeyReference) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key with alias " + keyReference.getKeyAlias() + " of type java.security.Key.");
                }
                hashMap.put(keyReference.getKeyAlias(), ((WSKeyReference)keyReference).getKey());
                continue;
            }
            if (!(keyReference instanceof WSKeyPairReference)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding key with alias " + keyReference.getKeyAlias() + " of type com.ibm.websphere.crypto.KeyPair.");
            }
            hashMap.put(keyReference.getKeyAlias(), ((WSKeyPairReference)keyReference).getKeyPair());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeys");
        }
        return hashMap;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAutoGenerate() {
        return this.autoGenerate;
    }

    public void cancelAlarm() {
        if (this.scheduler != null) {
            this.scheduler.cancelAlarm(this.name);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cleared WSScheduler..");
            }
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WSKeySetGroup.toString() {\n");
        stringBuffer.append("name = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("autoGenerate = ");
        stringBuffer.append(this.autoGenerate);
        stringBuffer.append("\n");
        stringBuffer.append("scope = ");
        stringBuffer.append(this.scope);
        stringBuffer.append("scheduler = ");
        stringBuffer.append(this.scheduler);
        stringBuffer.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }

    class StartAlarm
    implements PrivilegedExceptionAction {
        private WSKeySetGroup thisKeySetGroup = null;

        public StartAlarm(WSKeySetGroup wSKeySetGroup2) {
            this.thisKeySetGroup = wSKeySetGroup2;
        }

        public Object run() throws Exception {
            Class<?> clazz = Class.forName("com.ibm.ws.ssl.utils.KeySetGroupCommandActivator");
            Method method = clazz.getMethod("invokeCreateKeyReferenceCommand", class$com$ibm$ws$crypto$config$WSKeySetGroup == null ? (class$com$ibm$ws$crypto$config$WSKeySetGroup = WSKeySetGroup.class$("com.ibm.ws.crypto.config.WSKeySetGroup")) : class$com$ibm$ws$crypto$config$WSKeySetGroup);
            method.invoke(clazz.newInstance(), this.thisKeySetGroup);
            return null;
        }
    }
}

