/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ConcernImpl
implements Concern {
    private static final TraceComponent tc = Tr.register(ConcernImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = 7888542107438194487L;
    private int interest = Integer.MAX_VALUE;

    public ConcernImpl() {
    }

    public ConcernImpl(int n) {
        this.interest = n;
    }

    public int getInterest() {
        return this.interest;
    }

    public boolean hasInterest(int n) {
        return (n & this.interest) != 0;
    }

    public void addInterest(int n) {
        this.interest |= n;
    }

    public void removeInterest(int n) {
        this.interest ^= n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeInt(this.interest);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readByte();
        this.interest = objectInput.readInt();
    }

    public boolean equals(Object object) {
        try {
            return this.interest == ((Concern)object).getInterest();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.interest;
    }

    public String toString() {
        return ConcernImpl.class.getName() + "[" + String.valueOf(this.interest) + "]";
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.3 ");
        }
    }
}

