/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.ws.wlm.WLMConstants;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public final class RuleEtiquette
implements RuleArbitrator,
DescriptionModificationListener {
    private static final TraceComponent tc;
    protected static final DescriptionManager descMgr;
    private final ClusterDescription cluster;
    private final SelectionRule[] rules;
    private final String[] ruleIdentifier;
    private final StringBuffer reason;
    private final WeightBasedFeedback feedback;
    private boolean tryAgain;
    private Map registeredNotifications = new HashMap();
    private boolean timerRunning = false;
    private Integer syncObject = new Integer(42);
    private static int waitTime;
    private boolean beingRemoved = false;

    public RuleEtiquette(DescriptionKey descriptionKey, SelectionRule[] selectionRuleArray, StringBuffer stringBuffer, WeightBasedFeedback weightBasedFeedback) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{descriptionKey, weightBasedFeedback});
        }
        this.rules = selectionRuleArray;
        this.ruleIdentifier = new String[selectionRuleArray.length];
        this.reason = stringBuffer;
        this.feedback = weightBasedFeedback;
        this.cluster = (ClusterDescription)descMgr.getDescription(descriptionKey);
        if (this.cluster == null) {
            throw new IllegalStateException("The cluster, " + descriptionKey + " should have already been fluffed up.");
        }
        this.cluster.registerNotificationListener(this, "type.memento.updated", null);
        for (n = 0; n < selectionRuleArray.length; ++n) {
            selectionRuleArray[n].registerRuleArbitrator(this);
        }
        for (n = 0; n < selectionRuleArray.length; ++n) {
            this.ruleIdentifier[n] = selectionRuleArray[n].toString();
        }
        this.tryAgain = true;
        this.triggerRuleUpdate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public RuleEtiquette(DescriptionKey descriptionKey, SelectionRule[] selectionRuleArray, StringBuffer stringBuffer, WeightBasedFeedback weightBasedFeedback, Map map) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{descriptionKey, weightBasedFeedback, map, String.valueOf(selectionRuleArray.length)});
        }
        this.rules = selectionRuleArray;
        this.ruleIdentifier = new String[selectionRuleArray.length];
        this.reason = stringBuffer;
        this.feedback = weightBasedFeedback;
        this.cluster = (ClusterDescription)descMgr.getDescription(descriptionKey);
        if (this.cluster == null) {
            throw new IllegalStateException("The cluster, " + descriptionKey + " should have already been fluffed up.");
        }
        if (!map.containsKey("affinity.key")) {
            this.cluster.registerNotificationListener(this, "type.memento.updated", null);
            for (n = 0; n < selectionRuleArray.length; ++n) {
                selectionRuleArray[n].registerRuleArbitrator(this);
            }
        }
        for (n = 0; n < selectionRuleArray.length; ++n) {
            this.ruleIdentifier[n] = selectionRuleArray[n].toString();
        }
        this.tryAgain = true;
        this.triggerRuleUpdate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void triggerRuleUpdate() {
        block4: {
            List list = this.runRules();
            Identity[] identityArray = new Identity[list.size()];
            list.toArray(identityArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "triggerRuleUpdate", this.reason);
            }
            try {
                this.feedback.applyStructuralUpdate(identityArray);
                this.tryAgain = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "triggerRuleUpdate: caught IllegalArgumentException ", illegalArgumentException);
                }
                if (!this.tryAgain) break block4;
                this.tryAgain = false;
                this.triggerRuleUpdate();
            }
        }
    }

    private List runRules() {
        Map map = ((ClusterDescription.Memento)this.cluster.getMemento()).getMembers();
        ArrayList arrayList = new ArrayList(map.keySet());
        this.reason.setLength(0);
        this.reason.append("Removal (");
        if (!arrayList.isEmpty()) {
            for (int i = 0; i < this.rules.length; ++i) {
                this.reason.append(this.ruleIdentifier[i]);
                this.reason.append("[");
                this.rules[i].subset(arrayList, this.reason);
                this.reason.append("] ");
            }
        }
        this.reason.append(")\n  Applicable Targets ").append(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotificationType(SelectionRule selectionRule, Identity identity, String string) {
        Set<SelectionRule> set;
        HashMap<Identity, Set<SelectionRule>> hashMap = (HashMap<Identity, Set<SelectionRule>>)this.registeredNotifications.get(string);
        if (hashMap != null && (set = (Set)hashMap.get(identity)) != null && set.contains(selectionRule)) {
            return;
        }
        set = this.registeredNotifications;
        synchronized (set) {
            hashMap = (Map)this.registeredNotifications.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<Identity, Set<SelectionRule>>();
                this.registeredNotifications.put(string, hashMap);
            }
        }
        Object object = hashMap;
        synchronized (object) {
            set = (Set)hashMap.get(identity);
            if (set == null) {
                set = Collections.synchronizedSet(new HashSet(3));
                hashMap.put(identity, set);
            }
        }
        if (set.contains(selectionRule)) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerNotificationType", new Object[]{selectionRule, identity, string});
        }
        if ((object = descMgr.getDescription((DescriptionKey)identity)) != null) {
            set.add(selectionRule);
            object.registerNotificationListener(this, string, null);
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Failed to register for " + string + " for description " + identity + " the description is not yet available.");
        }
    }

    public void deregisterNotificationType(SelectionRule selectionRule, Identity identity, String string) {
        Map map = (Map)this.registeredNotifications.get(string);
        if (map == null) {
            return;
        }
        Set set = (Set)map.get(identity);
        if (set == null) {
            return;
        }
        if (!set.contains(selectionRule)) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deregisterNotificationType", new Object[]{selectionRule, identity, string});
        }
        set.remove(selectionRule);
        Description description = descMgr.getDescription((DescriptionKey)identity);
        description.deregisterNotificationListener(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
        }
        if (!this.beingRemoved) {
            if (waitTime > 0) {
                boolean bl = false;
                Object object3 = this.syncObject;
                synchronized (object3) {
                    bl = this.timerRunning;
                    this.timerRunning = true;
                }
                if (!bl) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "creating a timer for " + super.toString());
                    }
                    object3 = new Timer();
                    ((Timer)object3).schedule((TimerTask)new NotificationTimer(), waitTime);
                }
            } else {
                this.triggerRuleUpdate();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "beingRemoved");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public Identity getClusterIdentity() {
        return this.cluster.getKey();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[");
        stringBuffer.append(this.cluster.getKey());
        stringBuffer.append(" restrict{");
        for (int i = 0; i < this.rules.length; ++i) {
            stringBuffer.append(this.rules[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("}]");
        return stringBuffer.toString();
    }

    public void beingRemoved() {
        this.beingRemoved = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set beingRemoved = true");
        }
    }

    static {
        block5: {
            tc = Tr.register(RuleEtiquette.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
            descMgr = DescriptionManagerFactory.getDescriptionManager();
            waitTime = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "version : ", "1.20 ");
            }
            ProcessProperties processProperties = ProcessProperties.getInstance();
            String string = (String)processProperties.get(WLMConstants.IBM_CLUSTER_RUNRULES_TIMER_TIME);
            try {
                if (string != null) {
                    waitTime = Integer.valueOf(string);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "waitTime set to " + waitTime);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Custom Property IBM_CLUSTER_RUNRULES_TIMER_TIME is not set properly; received NumberFormatException. Defaulting to no waiting.", numberFormatException);
            }
        }
    }

    private final class NotificationTimer
    extends TimerTask {
        private NotificationTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "NotificationTimer running", super.toString());
            }
            Integer n = RuleEtiquette.this.syncObject;
            synchronized (n) {
                RuleEtiquette.this.timerRunning = false;
            }
            RuleEtiquette.this.triggerRuleUpdate();
        }
    }
}

