/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.feedback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.ws.cluster.selection.feedback.WeightBasedFeedback;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DesiredWeightFeedback
implements WeightBasedFeedback,
ClusterObserver {
    private static final TraceComponent tc = Tr.register(DesiredWeightFeedback.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private static final ClusterManagement clusterManagement = ClusterManagementFactory.getClusterManagement();
    private Identity clusterIdentity;
    private SelectionAlgorithm selectionAlgorithm;
    private Map members = Collections.EMPTY_MAP;

    public void init(Identity identity, SelectionAlgorithm selectionAlgorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{identity, selectionAlgorithm});
        }
        this.clusterIdentity = identity;
        this.selectionAlgorithm = selectionAlgorithm;
        clusterService.registerInterest(this, this.clusterIdentity, "type.cluster.weight.update");
        this.applyStructuralUpdate(clusterService.getMemberIdentities(identity));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void applyStructuralUpdate(Identity[] identityArray) {
        HashMap<Identity, MemberData> hashMap = new HashMap<Identity, MemberData>(identityArray.length * 2);
        int[] nArray = new int[identityArray.length];
        for (int i = 0; i < identityArray.length; ++i) {
            MemberData memberData = (MemberData)this.members.get(identityArray[i]);
            if (memberData == null) {
                memberData = new MemberData(identityArray[i]);
            }
            memberData.desired = DesiredWeightFeedback.clusterManagement.getDesiredWeight(this.clusterIdentity, identityArray[i]);
            nArray[i] = memberData.desired;
            hashMap.put(identityArray[i], memberData);
        }
        this.members = hashMap;
        this.execute();
    }

    public void applyWorkloadUpdate(Identity identity, int n) {
    }

    public void applyExceptionUpdate(Identity identity, int n) {
    }

    private int[] modifyWeights(MemberData[] memberDataArray) {
        int[] nArray = new int[memberDataArray.length];
        for (int i = 0; i < memberDataArray.length; ++i) {
            nArray[i] = memberDataArray[i].desired;
        }
        return nArray;
    }

    private void execute() {
        MemberData[] memberDataArray = new MemberData[this.members.size()];
        this.members.values().toArray(memberDataArray);
        int[] nArray = this.modifyWeights(memberDataArray);
        if (nArray != null) {
            Identity[] identityArray = new Identity[memberDataArray.length];
            for (int i = 0; i < memberDataArray.length; ++i) {
                identityArray[i] = memberDataArray[i].memberIdentity;
            }
            this.selectionAlgorithm.prepare(identityArray, nArray);
        }
    }

    public void notify(Identity identity, String string, Object object) {
        MemberData memberData;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "notify", new Object[]{identity, string, object});
        }
        if ((memberData = (MemberData)this.members.get(object)) != null) {
            memberData.desired = DesiredWeightFeedback.clusterManagement.getDesiredWeight(this.clusterIdentity, (Identity)object);
        }
        this.execute();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version", "1.1");
        }
    }

    private final class MemberData {
        private final Identity memberIdentity;
        private int desired;

        private MemberData(Identity identity) {
            this.memberIdentity = identity;
        }

        public String toString() {
            return "FeedbackData [" + this.memberIdentity + ":" + this.desired + "]";
        }
    }
}

