/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.cluster.selection.NoAvailableTargetExceptionImpl;
import com.ibm.ws.cluster.selection.SelectionAdvisor;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectionCriteriaImpl
implements SelectionCriteria,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(SelectionCriteriaImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private final Map strategyCache = Collections.synchronizedMap(new HashMap());
    private final Map targetCache = Collections.synchronizedMap(new HashMap());
    private final ClusterDescription cluster;
    private final Identity identity;
    private final Map context;
    private boolean affinityMapping;

    public SelectionCriteriaImpl(Identity identity, Map map) {
        try {
            this.identity = identity;
            this.cluster = (ClusterDescription)descMgr.getDescription((DescriptionKey)identity, ClusterDescription.class.getName());
            this.context = map;
            this.affinityMapping = this.context.containsKey("affinity.key");
            if (!this.affinityMapping) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "affinityMapping is " + this.affinityMapping);
                }
                this.cluster.registerNotificationListener(this, "member.added", null);
                this.cluster.registerNotificationListener(this, "member.removed", null);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The criteria may have been incorrect.");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Map getAttributes() {
        return this.context;
    }

    public void match(List list) {
    }

    public Target select() throws NoAvailableTargetException {
        Object object;
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", this);
        }
        ArrayList<DescriptionKey> arrayList = new ArrayList<DescriptionKey>(3);
        ClusterMemberDescription clusterMemberDescription = this.cluster;
        ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        while (!memento.isLeaf()) {
            descriptionKey = clusterMemberDescription.getKey();
            arrayList.add(descriptionKey);
            object = (SelectionAdvisor)this.strategyCache.get(descriptionKey);
            if (object == null) {
                object = new SelectionAdvisor(descriptionKey, this.context);
                if (!this.affinityMapping) {
                    this.strategyCache.put(descriptionKey, object);
                }
            }
            if ((clusterMemberDescription = ((SelectionAdvisor)object).select()) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select - null member from select.");
                }
                throw new NoAvailableTargetExceptionImpl(this, ((SelectionAdvisor)object).getReason());
            }
            memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
        }
        descriptionKey = clusterMemberDescription.getKey();
        object = (TargetImpl)this.targetCache.get(descriptionKey);
        if (object == null) {
            ArrayList arrayList2 = new ArrayList(memento.getExtrinsicData().values());
            if (tc.isDebugEnabled()) {
                if (arrayList2 != null) {
                    Tr.debug(tc, "Number of Endpoints in Memento: " + String.valueOf(arrayList2.size()));
                }
                Tr.debug(tc, "Endpoint List", arrayList2);
            }
            EndPoint[] endPointArray = arrayList2.iterator();
            while (endPointArray.hasNext()) {
                if (endPointArray.next() instanceof EndPoint) continue;
                endPointArray.remove();
            }
            endPointArray = new EndPoint[arrayList2.size()];
            arrayList2.toArray(endPointArray);
            Identity[] identityArray = new Identity[arrayList.size()];
            arrayList.toArray(identityArray);
            if (tc.isDebugEnabled()) {
                if (endPointArray != null) {
                    Tr.debug(tc, "Number of Endpoints in array: " + String.valueOf(endPointArray.length));
                }
                Tr.debug(tc, "Endpoint array", endPointArray);
            }
            object = new TargetImpl(identityArray, descriptionKey, endPointArray);
            if (identityArray.length <= 1) {
                this.targetCache.put(descriptionKey, object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", object);
        }
        return object;
    }

    public boolean isAffinityKeyPresent() {
        return this.affinityMapping;
    }

    public String toString() {
        return super.toString() + "[" + this.identity + ":" + this.context + "]";
    }

    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        SelectionAdvisor selectionAdvisor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
        }
        DescriptionKey descriptionKey2 = null;
        try {
            descriptionKey2 = ((Description)object).getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterMember is: " + descriptionKey2);
            }
        }
        catch (ClassCastException classCastException) {
            Tr.debug(tc, "ClassCastException in handleNotification:", classCastException);
            FFDCFilter.processException(classCastException, SelectionCriteriaImpl.class.getName() + "handleNotification()", "237");
        }
        Target target = (Target)this.targetCache.remove(descriptionKey2);
        if (string.equals("member.removed") && (selectionAdvisor = (SelectionAdvisor)this.strategyCache.remove(this.cluster.getKey())) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set beingRemoved in SelectionAdvisor ", this.cluster.getKey());
            }
            selectionAdvisor.beingRemoved();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification", target == null ? null : target.getMemberIdentity());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.25 ");
        }
    }
}

