/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.model.validation.fast.basic;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.validation.HierarchicalRule;
import com.ibm.cic.common.core.model.validation.IValidationRule;
import com.ibm.cic.common.core.model.validation.IValidator;
import com.ibm.cic.common.core.model.validation.ValidationUtil;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.model.validation.fast.basic.Messages;
import com.ibm.cic.common.model.validation.fast.internal.util.AbstractAsmValidationRule;
import com.ibm.cic.common.model.validation.fast.internal.util.StatusModelValidationUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class AssemblyValidator
implements IValidator {
    public String getDisplayName() {
        return Messages.AssemblyValidator_DisplayName;
    }

    public IStatus validate(IContent content, IRepositoryGroup repositoryGroup, IProgressMonitor progressMonitor) {
        IAssembly asm = this.getAssembly(content, progressMonitor);
        if (asm != null) {
            HierarchicalAsmValidationRule masterRule = new HierarchicalAsmValidationRule();
            masterRule.addNestedRule(this.ruleUniqueShareableEntities(asm));
            masterRule.addNestedRule(this.ruleSimilarShareableEntitiesAreWithinRange(asm));
            masterRule.addNestedRule(this.ruleSimilarShareableEntitiesHaveSameSelectors(asm));
            masterRule.addNestedRule(this.ruleSelectorsRequireShareableEntitiesWithinRange(asm));
            return this.executeRule(asm, masterRule, progressMonitor);
        }
        return Status.OK_STATUS;
    }

    private IAssembly getAssembly(IContent content, IProgressMonitor progressMonitor) {
        if (content instanceof IAssembly) {
            return (IAssembly)content;
        }
        if (content instanceof IOfferingOrFix) {
            return this.findAssembly((IOfferingOrFix)content, progressMonitor);
        }
        return null;
    }

    protected IAssembly findAssembly(IOfferingOrFix offeringOrFix, IProgressMonitor progressMonitor) {
        IAssembly asm = offeringOrFix.getAssembly();
        if (asm == null) {
            Logger.getGlobalLogger().statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)offeringOrFix, (IProgressMonitor)progressMonitor));
            asm = offeringOrFix.getAssembly();
        }
        return asm;
    }

    protected IShareableEntity findShareableEntity(IIncludedShareableEntity ise, IProgressMonitor progressMonitor) {
        return ise.getShareableEntity();
    }

    private AbstractAsmValidationRule ruleUniqueShareableEntities(IAssembly asm) {
        return new ShareableEntityValidationRule(){
            private Set shareableEntitiesSet;
            private final Stack state = new Stack();

            @Override
            public void initialize() {
                if (this.shareableEntitiesSet != null) {
                    this.state.push(this.shareableEntitiesSet);
                }
                this.shareableEntitiesSet = new HashSet();
            }

            @Override
            public void complete() {
                this.shareableEntitiesSet = this.state.isEmpty() ? null : (Set)this.state.pop();
            }

            @Override
            protected int getRule() {
                return 5;
            }

            @Override
            public IStatus doExecute(IAssembly currAsm, IIncludedShareableEntity ise, IShareableEntity se) {
                String key = this.getSignature(se);
                if (this.shareableEntitiesSet.contains(key)) {
                    String errMsg = ValidationUtil.formatMessage((String)Messages.AssemblyValidator_AsmHasDupShareableEntity, (Object)ValidationUtil.getContentName((IContent)currAsm), (Object)ValidationUtil.getContentName((IContent)se));
                    return StatusModelValidationUtils.newFailedStatus(errMsg, this.getRule());
                }
                this.shareableEntitiesSet.add(key);
                return Status.OK_STATUS;
            }
        };
    }

    private AbstractAsmValidationRule ruleSimilarShareableEntitiesAreWithinRange(IAssembly asm) {
        return new ShareableEntityValidationRule(){
            private final Map shareableEntitiesMap = new HashMap();

            @Override
            protected int getRule() {
                return 6;
            }

            @Override
            public IStatus doExecute(IAssembly currAsm, IIncludedShareableEntity ise, IShareableEntity se) {
                String key = se.getIdentity().getId();
                IIncludedShareableEntity prev_ise = (IIncludedShareableEntity)this.shareableEntitiesMap.get(key);
                if (prev_ise == null) {
                    this.shareableEntitiesMap.put(key, ise);
                } else if (this.haveIncompatibleVersions(prev_ise, ise)) {
                    String errMsg = ValidationUtil.formatMessage((String)Messages.AssemblyValidator_AsmHasSimilarShareableEntitiesWithDiffTolerance, (Object[])new String[]{ValidationUtil.getContentName((IContent)currAsm), ValidationUtil.getContentName((IContent)se), ise.toString(), prev_ise.toString()});
                    return Statuses.WARNING.get(this.getRule(), errMsg, new Object[0]);
                }
                return Status.OK_STATUS;
            }

            private boolean haveIncompatibleVersions(IIncludedShareableEntity prev_ise, IIncludedShareableEntity ise) {
                return !prev_ise.getTolerance().isIncluded(ise.getVersion()) || !ise.getTolerance().isIncluded(prev_ise.getVersion());
            }
        };
    }

    private AbstractAsmValidationRule ruleSimilarShareableEntitiesHaveSameSelectors(IAssembly asm) {
        return new ShareableEntityValidationRule(){
            private final Map se2Tol2SelsMap = new HashMap();

            @Override
            protected int getRule() {
                return 8;
            }

            @Override
            public IStatus doExecute(IAssembly currAsm, IIncludedShareableEntity ise, IShareableEntity se) {
                if (se == null) {
                    return Status.OK_STATUS;
                }
                String key = String.valueOf(ise.getIdentity().getId()) + ise.getTolerance().toString();
                HashSet selectors = (HashSet)this.se2Tol2SelsMap.get(key);
                if (selectors == null) {
                    selectors = new HashSet(se.getSelectors());
                    this.se2Tol2SelsMap.put(key, selectors);
                } else if (!selectors.equals(se.getSelectors())) {
                    String errMsg = ValidationUtil.formatMessage((String)Messages.AssemblyValidator_AsmHasSimilarShareableEntitiesWithDiffSelectors, (Object[])new Object[]{ValidationUtil.getContentName((IContent)currAsm), ValidationUtil.getContentName((IContent)se), selectors, se.getSelectors()});
                    return Statuses.WARNING.get(this.getRule(), errMsg, new Object[0]);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private AbstractAsmValidationRule ruleSelectorsRequireShareableEntitiesWithinRange(IAssembly asm) {
        return new SelectorValidationRule(){
            private final Map reqdSEsMap = new HashMap();

            @Override
            protected int getRule() {
                return 7;
            }

            @Override
            public IStatus doExecute(IShareableEntity currSE, IContentSelector sel) {
                LinkedList<IStatus> statusList = new LinkedList<IStatus>();
                for (IRequiredShareableEntity ire : sel.getRequiredShareableEntities()) {
                    VersionRange currTolerance = ire.getTolerance();
                    String key = ire.getShareableId().getId();
                    VersionRange prevTolerance = (VersionRange)this.reqdSEsMap.get(key);
                    if (prevTolerance == null) {
                        this.reqdSEsMap.put(key, currTolerance);
                        continue;
                    }
                    if (this.isIntersecting(currTolerance, prevTolerance)) continue;
                    String msg = ValidationUtil.formatMessage((String)Messages.AssemblyValidator_SEHasSelectorReqdShareableEntitiesWithDisjointTolerance, (Object[])new Object[]{ValidationUtil.getContentName((IContent)currSE), sel.getIdentity().getId(), ire.getShareableId().getId(), prevTolerance.toString(), currTolerance.toString()});
                    statusList.add(StatusModelValidationUtils.newFailedStatus(msg, this.getRule()));
                }
                return AssemblyValidator.this.cumulativeStatus(statusList);
            }

            private boolean isIntersecting(VersionRange range1, VersionRange range2) {
                return this.isOverlapping(range1, range2) || this.isOverlapping(range2, range1);
            }

            private boolean isOverlapping(VersionRange range1, VersionRange range2) {
                if (range1.isIncluded(range2.getMinimum())) {
                    if (range2.getIncludeMinimum()) {
                        return true;
                    }
                    return Comparators.compare((Version)range1.getRight(), (Version)range2.getMinimum()) > 0;
                }
                if (VersionUtil.isIncluded((VersionRange)range1, (Version)range2.getRight())) {
                    if (range2.getIncludeMaximum()) {
                        return true;
                    }
                    return Comparators.compare((Version)range1.getMinimum(), (Version)range2.getRight()) < 0;
                }
                return false;
            }
        };
    }

    private IStatus executeRule(IAssembly asm, AbstractAsmValidationRule rule, IProgressMonitor progressMonitor) {
        LinkedList statusList = new LinkedList();
        IStatus s = Status.OK_STATUS;
        rule.initialize();
        for (IContentSelector sel : asm.getSelectors()) {
            s = rule.execute((IShareableEntity)asm, sel);
            StatusModelValidationUtils.rememberStatusIfFailed(statusList, s);
        }
        for (Object o : asm.getChildren()) {
            IIncludedShareableEntity ise;
            IShareableEntity se;
            if (!(o instanceof IIncludedShareableEntity) || (se = this.findShareableEntity(ise = (IIncludedShareableEntity)o, progressMonitor)) == null) continue;
            s = rule.execute(asm, ise, se);
            StatusModelValidationUtils.rememberStatusIfFailed(statusList, s);
            if (se instanceof IAssembly) {
                s = this.executeRule((IAssembly)se, rule, progressMonitor);
                StatusModelValidationUtils.rememberStatusIfFailed(statusList, s);
                continue;
            }
            for (IContentSelector sel : se.getSelectors()) {
                s = rule.execute(se, sel);
                StatusModelValidationUtils.rememberStatusIfFailed(statusList, s);
            }
        }
        rule.complete();
        return this.cumulativeStatus(statusList);
    }

    private IStatus cumulativeStatus(List statusList) {
        return StatusModelValidationUtils.cumulativeStatus(this, statusList);
    }

    protected static class HierarchicalAsmValidationRule
    extends AbstractAsmValidationRule {
        private final HierarchicalRule rules = new HierarchicalRule();

        protected HierarchicalAsmValidationRule() {
        }

        @Override
        public void initialize() {
            this.rules.initializeSubRules();
        }

        @Override
        public void complete() {
            this.rules.completeSubRules();
        }

        @Override
        public IStatus execute(final IShareableEntity currSE, final IContentSelector sel) {
            return this.rules.invokeSubRules(new HierarchicalRule.ICallable(){

                public IStatus invoke(IValidationRule rule) {
                    AbstractAsmValidationRule asmRule = (AbstractAsmValidationRule)rule;
                    return asmRule.execute(currSE, sel);
                }
            });
        }

        @Override
        public IStatus execute(final IAssembly currAsm, final IIncludedShareableEntity ise, final IShareableEntity se) {
            return this.rules.invokeSubRules(new HierarchicalRule.ICallable(){

                public IStatus invoke(IValidationRule rule) {
                    AbstractAsmValidationRule asmRule = (AbstractAsmValidationRule)rule;
                    return asmRule.execute(currAsm, ise, se);
                }
            });
        }

        public void addNestedRule(AbstractAsmValidationRule asmRule) {
            this.rules.addNestedRule((IValidationRule)asmRule);
        }

        @Override
        protected int getRule() {
            return 0;
        }
    }

    protected static abstract class SelectorValidationRule
    extends AbstractAsmValidationRule {
        protected SelectorValidationRule() {
        }

        @Override
        public IStatus execute(IAssembly currAsm, IIncludedShareableEntity ise, IShareableEntity se) {
            return Status.OK_STATUS;
        }

        @Override
        public final IStatus execute(IShareableEntity currSE, IContentSelector sel) {
            if (this.isSuppressed()) {
                return Status.OK_STATUS;
            }
            return this.doExecute(currSE, sel);
        }

        protected abstract IStatus doExecute(IShareableEntity var1, IContentSelector var2);
    }

    protected static abstract class ShareableEntityValidationRule
    extends AbstractAsmValidationRule {
        protected ShareableEntityValidationRule() {
        }

        @Override
        public final IStatus execute(IAssembly currAsm, IIncludedShareableEntity ise, IShareableEntity se) {
            if (this.isSuppressed()) {
                return Status.OK_STATUS;
            }
            return this.doExecute(currAsm, ise, se);
        }

        protected abstract IStatus doExecute(IAssembly var1, IIncludedShareableEntity var2, IShareableEntity var3);

        @Override
        public final IStatus execute(IShareableEntity currSE, IContentSelector sel) {
            return Status.OK_STATUS;
        }

        protected String getSignature(IShareableEntity se) {
            return String.valueOf(se.getIdentity().getId()) + se.getVersion().toString();
        }
    }
}

