/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.nativeAdapterData.win32.internal;

import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ICommonTopAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.nativeAdapterData.win32.DesktopIconWin32NativeData;
import com.ibm.cic.common.nativeAdapterData.win32.EnvironmentNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.NativeWin32AdapterData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryKeyNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryValueNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.ShortcutNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.SpecialFileNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.internal.IXMLConstants;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class NativeWin32AdapterDataParser
extends ICommonNativeAdapterDataParser
implements IXMLConstants {
    private NativeWin32AdapterData nativeData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void initialize(IInstallableUnit iu, IErrorReporter errorReporter) {
        this.nativeData = new NativeWin32AdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(iu, (ICommonTopAdapterData)this.nativeData, this.elemStack, errorReporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        String type = attributes.getValue("", "type");
        if (type == null || type.equals("zip")) {
            return this.handleZipAttributes(key, attributes);
        }
        this.reporter.invalidAttributeValue(name, "type", type);
        return null;
    }

    public void endArtifact() {
        this.elemStack.pop();
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("shortcut")) {
                this.handleShortcutAttributes(attributes);
            } else if (name.equals("desktopIcon_win32")) {
                this.handleDesktopIconWin32Attributes(attributes);
            } else if (name.equals("registry")) {
                this.handleRegistryAttributes(attributes);
            } else if (name.equals("key")) {
                this.handleRegistryKeyAttributes(attributes);
            } else if (name.equals("value")) {
                this.handleRegistryValueAttributes(attributes);
            } else if (name.equals("specialFile")) {
                this.handleSpecialFileAttributes(attributes);
            } else if (name.equals("environment")) {
                this.handleEnvironmentAttributes(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.elemStack.pop();
    }

    public void characters(String chars) {
        String name = this.elemStack.top().name;
        boolean processed = this.processCommonCharacters(name, chars);
        if (!processed) {
            this.reporter.unexpectedCharacterData(chars);
        }
    }

    public IAdapterData getAdapterData() {
        return this.nativeData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.nativeAdapterData.win32");
        Path path = new Path("schema/nativeAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }

    private void handleShortcutAttributes(Attributes attributes) {
        String workingDirectory;
        String description;
        String targetPath;
        String path;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("shortcut", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "shortcut", new String[]{"path", "targetPath", "arguments", "iconPath", "iconIndex", "description", "workingDirectory"})) {
            hasErrors = true;
        }
        if ((path = attributes.getValue("path")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "path", (Object)path);
            hasErrors = true;
        }
        if ((targetPath = attributes.getValue("targetPath")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "targetPath", (Object)targetPath);
            hasErrors = true;
        }
        String arguments = attributes.getValue("arguments");
        String iconPath = attributes.getValue("iconPath");
        if (iconPath == null) {
            this.reporter.checkRequiredAttribute("shortcut", "iconPath", (Object)iconPath);
            hasErrors = true;
        }
        String iconIndexStr = attributes.getValue("iconIndex");
        int iconIndex = 0;
        if (iconIndexStr != null) {
            try {
                iconIndex = Integer.parseInt(iconIndexStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.reporter.invalidAttributeValue("shortcut", "iconIndex", iconIndexStr);
                hasErrors = true;
            }
        }
        if ((description = attributes.getValue("description")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "description", (Object)description);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "workingDirectory", (Object)workingDirectory);
            hasErrors = true;
        }
        if (!hasErrors) {
            ShortcutNativeData data = new ShortcutNativeData(path, targetPath, arguments, iconPath, iconIndex, description, workingDirectory);
            this.nativeData.addData(data);
        }
    }

    private void handleDesktopIconWin32Attributes(Attributes attributes) {
        String context;
        String command;
        String workingDirectory;
        String name;
        String folder;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("desktopIcon_win32", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "desktopIcon_win32", new String[]{"folder", "name", "workingDirectory", "command", "arguments", "iconPath", "iconIndex", "context", "description"})) {
            hasErrors = true;
        }
        if ((folder = attributes.getValue("folder")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "folder", (Object)folder);
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "name", (Object)name);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "workingDirectory", (Object)workingDirectory);
            hasErrors = true;
        }
        if ((command = attributes.getValue("command")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "command", (Object)command);
            hasErrors = true;
        }
        String arguments = attributes.getValue("arguments");
        String iconPath = attributes.getValue("iconPath");
        String iconIndexStr = attributes.getValue("iconIndex");
        int iconIndex = 0;
        if (iconIndexStr != null) {
            try {
                iconIndex = Integer.parseInt(iconIndexStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.reporter.invalidAttributeValue("desktopIcon_win32", "iconIndex", iconIndexStr);
                hasErrors = true;
            }
        }
        if ((context = attributes.getValue("context")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "context", (Object)context);
            hasErrors = true;
        } else if (!context.equals("ALL_USER") && !context.equals("CURR_USER")) {
            this.reporter.invalidAttributeValue("desktopIcon_win32", "context", context);
            hasErrors = true;
        }
        String description = attributes.getValue("description");
        if (!hasErrors) {
            DesktopIconWin32NativeData data = new DesktopIconWin32NativeData(folder, name, workingDirectory, command, arguments, iconPath, iconIndex, context, description);
            this.nativeData.addData(data);
        }
    }

    private void handleRegistryAttributes(Attributes attributes) {
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("registry", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "registry", new String[]{"name", "value", "type", "replace"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("registry", "name", (Object)name);
            hasErrors = true;
        }
        String value = attributes.getValue("value");
        String type = attributes.getValue("type");
        if (!RegistryValueNativeData.validType(type)) {
            this.reporter.invalidAttributeValue("registry", "type", type);
            hasErrors = true;
        }
        String replaceStr = attributes.getValue("replace");
        boolean replace = false;
        if (replaceStr != null) {
            replace = new Boolean(replaceStr);
        }
        if (!hasErrors) {
            RegistryNativeData data = new RegistryNativeData(name, value, type, replace);
            this.nativeData.addData(data);
            this.elemStack.top().data = data;
        }
    }

    private void handleRegistryKeyAttributes(Attributes attributes) {
        String name;
        boolean hasErrors = false;
        if (!this.isRegistrySubElement()) {
            this.reporter.unexpectedElement("key", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "key", new String[]{"name", "value", "type"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("key", "name", (Object)name);
            hasErrors = true;
        }
        String value = attributes.getValue("value");
        String type = attributes.getValue("type");
        if (!RegistryValueNativeData.validType(type)) {
            this.reporter.invalidAttributeValue("key", "type", type);
            hasErrors = true;
        }
        if (!hasErrors) {
            RegistryKeyNativeData data = new RegistryKeyNativeData(name, value, type);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleRegistryValueAttributes(Attributes attributes) {
        String type;
        String value;
        String name;
        boolean hasErrors = false;
        if (!this.isRegistrySubElement()) {
            this.reporter.unexpectedElement("value", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "value", new String[]{"name", "value", "type"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("value", "name", (Object)name);
            hasErrors = true;
        }
        if ((value = attributes.getValue("value")) == null) {
            this.reporter.checkRequiredAttribute("value", "value", (Object)value);
            hasErrors = true;
        }
        if (!RegistryValueNativeData.validType(type = attributes.getValue("type"))) {
            this.reporter.invalidAttributeValue("value", "type", type);
            hasErrors = true;
        }
        if (!hasErrors) {
            RegistryValueNativeData data = new RegistryValueNativeData(name, value, type);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
        }
    }

    private void handleSpecialFileAttributes(Attributes attributes) {
        String path;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("specialFile", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "specialFile", new String[]{"path", "types"})) {
            hasErrors = true;
        }
        if ((path = attributes.getValue("path")) == null) {
            this.reporter.checkRequiredAttribute("specialFile", "path", (Object)path);
            hasErrors = true;
        }
        String typesStr = attributes.getValue("types");
        List types = null;
        if (typesStr == null) {
            this.reporter.checkRequiredAttribute("specialFile", "types", (Object)typesStr);
            hasErrors = true;
        } else {
            types = SpecialFileNativeData.parseTypes(typesStr);
            if (types == null) {
                this.reporter.invalidAttributeValue("specialFile", "types", typesStr);
                hasErrors = true;
            }
        }
        if (!hasErrors) {
            SpecialFileNativeData data = new SpecialFileNativeData(path, types);
            this.nativeData.addData(data);
        }
    }

    private void handleEnvironmentAttributes(Attributes attributes) {
        String context;
        String value;
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("environment", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "environment", new String[]{"name", "value", "append", "prepend", "context"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("environment", "name", (Object)name);
            hasErrors = true;
        }
        if ((value = attributes.getValue("value")) == null) {
            this.reporter.checkRequiredAttribute("environment", "value", (Object)value);
            hasErrors = true;
        }
        String appendStr = attributes.getValue("append");
        boolean append = false;
        if (appendStr != null) {
            append = this.isAttributeTrue(appendStr);
        }
        String prependStr = attributes.getValue("prepend");
        boolean prepend = false;
        if (prependStr != null) {
            prepend = this.isAttributeTrue(prependStr);
        }
        if ((context = attributes.getValue("context")) == null) {
            this.reporter.checkRequiredAttribute("environment", "context", (Object)context);
            hasErrors = true;
        } else if (!context.equals("ALL_USER") && !context.equals("CURR_USER")) {
            this.reporter.invalidAttributeValue("environment", "context", context);
            hasErrors = true;
        }
        if (!hasErrors) {
            EnvironmentNativeData data = new EnvironmentNativeData(name, value, append, prepend, context);
            this.nativeData.addData(data);
        }
    }

    private boolean isRegistrySubElement() {
        ICommonNativeAdapterDataParser.ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("registry") || entry.name.equals("key");
    }
}

