/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.missingPluginsFixup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class FixupMissingPlugins {
    private char pre11AgentUiMicroVersion = '\u0000';

    public void run(String[] args) throws IOException {
        this.doFixups(args[0]);
    }

    private void doFixups(String installLocation) throws IOException {
        File installDir = new File(installLocation);
        File pluginsDir = new File(installLocation, "plugins");
        if (!this.isPre11Installed(pluginsDir)) {
            return;
        }
        this.workaroundForRATLC00302031(installDir, pluginsDir);
        this.workaroundForRATLC00149389(installDir, pluginsDir);
        if (this.pre11AgentUiMicroVersion >= '4') {
            this.workaroundForRATLC00149477(installDir);
        }
    }

    private void workaroundForRATLC00302031(File installDir, File pluginsDir) throws IOException {
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.common.nativeAdapterData.win32", "1.0.0.v20060808");
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.common.nativeAdapterData.win32.nl1", "1.0.0.v20061019");
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.common.nativeAdapterData.win32.nl2", "1.0.0.v20060917");
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.common.nativeAdapterData.linux", "1.0.0.v20061110");
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.common.nativeAdapterData.linux.nl1", "1.0.0.v20061019");
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.common.nativeAdapterData.linux.nl2", "1.0.0.v20060917");
    }

    private void workaroundForRATLC00149389(File installDir, File pluginsDir) throws IOException {
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.licensing.lum.win32.nl1", "7.0.0.v20061019", true);
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.licensing.lum.win32.nl2", "7.0.0.v20060917", true);
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.licensing.lum.linux.nl1", "7.0.0.v20061019", true);
        this.doWorkaround(installDir, pluginsDir, "com.ibm.cic.licensing.lum.linux.nl2", "7.0.0.v20060917", true);
    }

    private void doWorkaround(File installDir, File pluginsDir, String id, String version) throws IOException {
        this.doWorkaround(installDir, pluginsDir, id, version, false);
    }

    private void doWorkaround(File installDir, File pluginsDir, String id, String version, boolean exploded) throws IOException {
        String pluginName = String.valueOf(id) + '_' + version;
        if (!exploded) {
            pluginName = String.valueOf(pluginName) + ".jar";
        }
        File src = new File(installDir, pluginName);
        File dest = new File(pluginsDir, pluginName);
        if (dest.exists()) {
            return;
        }
        if (!src.renameTo(dest)) {
            throw new IOException("rename of \"" + src.getPath() + "\" to \"" + dest.getPath() + "\" failed");
        }
    }

    private void workaroundForRATLC00149477(File installDir) {
        File featureDir = new File(installDir, "features");
        File platformLaunchersFeatureDir = new File(featureDir, "org.eclipse.platform.launchers_3.2.1.v3236");
        if (!platformLaunchersFeatureDir.isDirectory()) {
            platformLaunchersFeatureDir.mkdirs();
        }
    }

    private boolean isPre11Installed(File pluginsDir) throws IOException {
        String pluginPrefix = "com.ibm.cic.agent.ui_";
        String[] plugins = pluginsDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!name.startsWith("com.ibm.cic.agent.ui_")) {
                    return false;
                }
                String version = name.substring("com.ibm.cic.agent.ui_".length());
                if (!version.startsWith("1.0.")) {
                    return false;
                }
                if (version.length() > 4) {
                    FixupMissingPlugins.this.pre11AgentUiMicroVersion = version.charAt(4);
                }
                return true;
            }
        });
        if (plugins == null) {
            throw new IOException("plugin search of \"" + pluginsDir.getPath() + "\" failed");
        }
        return plugins.length != 0;
    }
}

