<?xml version="1.0" encoding="UTF-8"?>
<!--
    Licensed Materials - Property of IBM
    (c) Copyright IBM Corporation 2009. All Rights Reserved.
    
    Note to U.S. Government Users Restricted Rights:  
    Use, duplication or disclosure restricted by GSA ADP Schedule 
    Contract with IBM Corp. 
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<xsl:template match="/">
  <html>
  <head>
  
  <style type="text/css">
     body        {background-color: beige;}
     tr.hStyle1  {font-style: bold;font-size:12pt;background-color:#9acd32}
     div.time    {font-style: bold;font-size:14pt;float:left}
     div.threads {font-family:courier; font-size: 50%}
     div.links   {text-align: right; float:right} 
     div.clear   {clear:both} 
  </style>
  
  <script language="JavaScript" type="text/javascript">
      function runGC() {
        var dest = "/api/admin?";
        var params = "action=displaySystemStatus&amp;statusAction=runGC";
        var request = dest + params;
      
        window.location.href = request;
      }
      
      function heapDump() {
        var dest = "/api/admin?";
        var params = "action=displaySystemStatus&amp;statusAction=heapDump";
        var request = dest + params;
      
        window.location.href = request;
      }
      
      function collectionDetails() {
        var dest = "/api/monitor?";
        var params = "action=displaySystemStatus&amp;collectionDetails=true";
        var request = dest + params;
      
        window.location.href = request;
      }
  </script>
  <title>Status @ <xsl:value-of select="status/time"/></title>
  
  </head>
  <body>
    <div class="time"><xsl:value-of select="status/time"/></div>

    <div class="links">
    <a href="#docQueueContents">Document Queue Contents</a> | <a href="#webCrawlerStatus">Web Crawler Status</a> | <a href="#jvmStatus">JVM Status</a>
     | <a href="#help">Help</a>
    </div>
    <div class="clear"></div>
    
    <h3>Document Queue</h3>
    Number of documents on queue: <a href="#docQueueContents"><xsl:value-of select="format-number(status/doc_queue/num_docs_on_queue, '#,##0')"/></a> <br />
    Total number of documents processed: <xsl:value-of select="format-number(status/doc_queue/total_docs_processed, '#,##0') "/>
   
  
    <h3>Collections</h3>
    <input type="button" value="Show Error Document Count" onclick="collectionDetails()" ></input>  
    <table border="1">
    <colgroup span="1" > </colgroup>
    <colgroup span="2" align="right"> </colgroup>
    <colgroup span="3" align="center"> </colgroup>

    <tr class="hStyle1">
      <th align="left">Name</th>
      <th align="left">Num Documents</th>
      <th align="left">Size (bytes)</th>
      <th align="left">State</th>
      <th align="left">Crawlers</th>
    </tr>
    <xsl:for-each select="status/collections/collection">
    <tr>
      <td><xsl:value-of select="id"/></td>
      <td>Active: <xsl:value-of select="format-number(num_docs, '#,##0') "/> 
          <br /> Deleted: <xsl:value-of select="format-number(num_deleted_docs, '#,##0') "/> 
          <xsl:if test="num_error_docs &gt; -1">
              <br /> Error Docs: <xsl:value-of select="format-number(num_error_docs, '#,##0') "/>
          </xsl:if>
      </td>
      <td><xsl:value-of select="format-number(byte_size, '#,##0') "/></td>
      <td><xsl:value-of select="state"/></td>
      <td>
      <xsl:for-each select="crawlers/crawler">
        <xsl:value-of select="name"/> 
        <br />
        <xsl:for-each select="crawlspaces/crawlspace">
           ..<xsl:value-of select="name"/>:  
           <xsl:value-of select="state"/> 
           <br />
        </xsl:for-each>
        <br />
      </xsl:for-each>
      </td>
    </tr>
    </xsl:for-each>
    </table>
    <br />
    <br />

    <h3>Indexer Pool</h3>
    <table border="1">

    <tr class="hStyle1">
      <th align="left">Collection</th>
      <th align="left">Document Status</th>
    </tr>
    <xsl:for-each select="status/indexer_pool/indexer">
    <tr>
      <td><xsl:value-of select="collection"/></td>
      <td><xsl:value-of select="doc"/></td>
    </tr>
    </xsl:for-each>
    </table>
    
    <br />  <br />
    <h3 id="releaseStatus">Release Info</h3>
    Release Name: <xsl:value-of select="status/releaseName"/> <br />
    Release definition loaded from file <code> <xsl:value-of select="status/releaseFile"/></code> 
    <xsl:if test="normalize-space(status/releaseJarFile)">
        from jar <code><xsl:value-of select="status/releaseJarFile"/></code>
    </xsl:if>
     
    <br /> <br />
    <h3 id="jvmStatus">JVM Heap</h3>
    Total heap size: <xsl:value-of select="format-number(status/jvm/heap_size, '#,##0') "/> bytes <br />
    Total used heap: <xsl:value-of select="format-number(status/jvm/heap_used, '#,##0') "/> bytes <br /> 
    
   <input type="button" value="Run Garbage Collector" onclick="runGC()" ></input>  
   <input type="button" value="Take Heap Dump" onclick="heapDump()" ></input>  
   
    <br /> <br />
    <h3 id="threadStacks">JVM Threads</h3>    
    <code>
    <xsl:for-each select="status/jvm/threads/thread">
      <xsl:sort select="name"/>
      <xsl:value-of select="name"/> <br />
      <xsl:for-each select="stack/sf"> 
        ..<xsl:value-of select="txt"/> <br />
      </xsl:for-each>
      <br />
    </xsl:for-each>
    </code>
    
    
    
    <h3 id="docQueueContents">Document Queue Contents</h3>
    <table border="1">
    <colgroup span="1">  </colgroup>
    <colgroup span="3" align="left"> </colgroup>

    <tr class="hStyle1">
      <th align="left">URI</th>
      <th align="left">Type</th>
      <th align="left">Collection</th>
      <th align="left">In Batch</th>
    </tr>
    <xsl:for-each select="status/doc_queue/contents/doc">
    <tr>
      <td><xsl:value-of select="uri"/></td>
      <td><xsl:value-of select="type"/></td>
      <td><xsl:value-of select="collection"/></td>
      <td><xsl:value-of select="in_batch"/></td>
    </tr>
    </xsl:for-each>
    </table>
    
    <h3 id="webCrawlerStatus">Web Crawler Status</h3>
    <code>
    <xsl:for-each select="status/web_crawler/l1">
      <xsl:value-of select="l2"/><br/>
    </xsl:for-each>
    </code>
    
    <h3 id="help">Help</h3>
     The following is a list of special parameters:
     <table border="1">
       <colgroup span="1">  </colgroup>
       <colgroup span="3" align="left"> </colgroup>

       <tr class="hStyle1">
         <th align="left">Parameter</th>
         <th align="left">Description</th>
         <th align="left">Example</th>
       </tr>
       <tr>
         <td>jvmOnly=true</td>
         <td>This will take just a jvm thread dump and status.  It is useful when some
             other component is hung, which also hangs the ability of the component to
             retrieve its status.  So if the normal status command hangs, or takes a very
             long time, try it again with this option.</td>
         <td>http://localhost:8888/api/monitor?action=displaySystemStatus&amp;jvmOnly=true</td>
       </tr>
     </table>
    
  </body>
  </html>
</xsl:template></xsl:stylesheet>