<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
    xmlns:atom="http://www.w3.org/2005/Atom"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:opensearch="http://a9.com/-/spec/opensearch/1.1/">
    <xsl:output method="html"/>
    <xsl:template match="/">
    <html>
	<head>
        <script type="text/javascript" src="http://localhost:8888/stylesheet/doe.js" />
        <style> <!-- Put a little CSS in -->
		    .content-area {background-color: #dcedcb;}
			.description {font-size: .9em; margin: 0 0 10px 0;}
			.list { font-size: .8em; margin:0 0 0 20px;}
			.list-item {margin: 0 0 5px 0;}
			.list-item a,
			.list-item a:link {
	    	    color: #556655;
			    font-size: 1.1em;
		        font-family: verdana, tahoma, arial;
 				font-wieght: bold;
 				letter-spacing: -1px;
 				line-height: 1.0em;
			}
			.list-item a:active,
			.list-item a:hover {
				color: orange;
			}
			.list-item a:visited {
				color: gray;
			}
			.list-item-date {
				font-size: .8em;
			}
			.list-item-description {
				font-size: .9em;
			}
			.read .title a {
 				color: #aaa;
			}
			.read .content {
 				color: #555;
			}
			div.entry .read .title a {
 				color: gray;
			}
			.header {
 				padding-top: 5px;
 				margin: 0 0 0.2em 0;
			}
			.title {
				color: black;
 				font-size: 1.6em;
 				font-family: arial, verdana, tahoma;
 				font-wieght: bold;
 				letter-spacing: -1px;
 				line-height: 1.1em;
 				padding-bottom: 10px;
			}
			.highlight { 
  				font-family: Verdana; 
  				font-weight: bold; 
  				background-color: #ddff66; 
			} 
        </style>
    </head>
    
    <body onload="go_decoding();">
    <div id="cometestme" style="display:none;">
       <xsl:text disable-output-escaping="yes">&amp;</xsl:text>
    </div>
	<xsl:apply-templates select="/atom:feed"/>
	</body>
	</html>
    </xsl:template>
	
	<xsl:template match="/atom:feed">
	<div class="title">
	    <xsl:value-of select="atom:title"/>
	</div>
	<div class="header">
		HTML Snippet: <a href="{atom:link[@rel='alternate']/@href}"><i>here</i></a>
	</div>
	<div class="header">
		OpenSearch Description: <a href="{atom:link[@rel='search']/@href}"><i>here</i></a>
	</div>
    <div class="header">
		Displaying Results: 
		<xsl:value-of select="opensearch:startIndex"/>
		 - 
		<xsl:value-of select="opensearch:startIndex + opensearch:itemsPerPage - 1"/>
		 of 
		<xsl:value-of select="opensearch:totalResults"/>
	</div>
	<br/>
    <br/>
     		
    <xsl:for-each select="atom:entry">
        <xsl:if test="count(atom:category) = 0">			
  	    <table border="0" width="100%">
      	<tr>
      	<xsl:apply-templates select="atom:link[@rel='alternate']"/>
        </tr>
        <tr>
        <xsl:apply-templates select="atom:link[@rel='via' and not(@type='text/html')]"/>
        </tr>
        <tr>
        <xsl:apply-templates select="atom:link[@rel='via' and @type='text/html']"/>        		
        </tr>
        <tr>
        <div name="decodeable"> 
        <xsl:value-of select="atom:summary" disable-output-escaping="yes"/>
        </div>
        </tr>
		<tr><i>Relevance: </i><xsl:value-of select="opensearch:relevance"/></tr>
		<tr><i>Updated: </i><xsl:value-of select="atom:updated"/></tr>
 		</table>
 		<br/>
 		</xsl:if>
    </xsl:for-each>
    <br/>
    <table align="center" border="1">
        <tr>
		<td>
		<a href="{atom:link[@rel='first']/@href}">first</a>
		</td>
		<td>
		<xsl:choose>
		    <xsl:when test="count(atom:link[@rel='previous']) = 1">
		    <a href="{atom:link[@rel='previous']/@href}">previous</a>
            </xsl:when>
            <xsl:otherwise>
 			previous
            </xsl:otherwise>
		</xsl:choose>
		</td>
		<td>
		<xsl:choose>
		    <xsl:when test="count(atom:link[@rel='next']) = 1">
  		    <a href="{atom:link[@rel='next']/@href}">next</a>
            </xsl:when>
            <xsl:otherwise>
 			next
            </xsl:otherwise>
        </xsl:choose>
		</td>
		<td>
		<a href="{atom:link[@rel='last']/@href}">last</a>
		</td>
		</tr>
		</table>
	</xsl:template>
	
	<xsl:template match="atom:link[@rel='via' and not(@type='text/html')]">
	<a href="{./@href}">Cache</a>
	</xsl:template>
	
	<xsl:template match="atom:link[@rel='via' and @type='text/html']">
	<a href="{./@href}">HTML Cache</a>
	</xsl:template>
	
	<xsl:template match="atom:link[@rel='alternate']">
	<a href="{./@href}">
	<div name="decodeable">
	<xsl:value-of select="../atom:title" disable-output-escaping="yes"/>
	</div>
	</a>
    </xsl:template>
    
</xsl:stylesheet>