package com.ibm.swat.password;
import java.io.*;
import javax.naming.*;
import javax.naming.directory.*;
import java.util.*;

/**
 * This is a class containing methods for searching group membership using threads.
 * This class is not normally used by the enduser
 *
 * @author      Brian Olore
 * @version     1
 */


public class GroupSearcher implements Runnable
{
  ThreadGroup group;
  int depth;
  String groupDN;
  String userDN;
  //Boolean found;
  boolean found[];
  private String bluepages_ldap_server;
  private String bluegroups_ldap_server;
  String ldap_version;

  //public GroupSearcher(ThreadGroup g, int d, String gDN, String uDN, Boolean f, String bp, String bg, String v)
  public GroupSearcher(ThreadGroup g, int d, String gDN, String uDN, boolean f[], String bp, String bg, String v)
  {
    group = g;
    depth=d;
    groupDN = gDN;
    userDN = uDN;
    found = f;
    bluepages_ldap_server = bp;
    bluegroups_ldap_server = bg;
    ldap_version = v;
  }

  public void run() 
  {    
    DirContext bg_ctx = null;
    NamingEnumeration results = null;
    
    if (!found[0])
    {
      //System.out.println("HAVE NOT FOUND IT");
      try
      {        
        bg_ctx = getLdapConnection(bluegroups_ldap_server, ldap_version);

        String attrlist[] = {"cn"};
        String filter = "(uniquemember=" + substitute(userDN, "\\", "\\5c") + ")";
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
        constraints.setReturningAttributes(attrlist);

        //System.out.println("groupDN: >" + groupDN + "<");
        results = bg_ctx.search(groupDN, filter ,constraints);  
        
        //System.out.println("HERE1");
        Enumeration vals;
        if (results.hasMore())
        {
          //userDN is in group .. party!
        //System.out.println("FOUND IT");
          //found = new Boolean(true);
        found[0] = true;
          //can't do this!
          //group.destroy();
          //group.stop();
          return;
        }
        else
        {
          //look in groups below if depth>0
          //search and get all groups in this group
          //System.out.println("checking depth: " + depth);
          if (depth>0)
          {
            String attrlist2[] = { "uniqueGroup" };
            filter = "(objectclass=groupOfUniqueNames)";
            constraints = new SearchControls();
            constraints.setSearchScope(SearchControls.OBJECT_SCOPE);
            constraints.setReturningAttributes(attrlist2);  
            
            //System.out.println("groupDN: >" + groupDN + "<");
            cleanupNamingEnum(results);
            results = bg_ctx.search(groupDN, filter ,constraints);            
    
            //System.out.println("HERE2");
        
            BasicAttribute attr = null;
            NamingEnumeration ne = null;

            SearchResult sr = (SearchResult) results.next();
            Attributes attrs = sr.getAttributes();

            if (attrs != null )
            {
              attr = (BasicAttribute)attrs.get("uniqueGroup");                 
              if ( attr != null) 
              {
                ne = attr.getAll();
                //if it finds something, search that group!
                while ( ne.hasMore() )
                {
                  String grpDN = (String)ne.nextElement();
                  Thread t1 = new Thread(group, new GroupSearcher(group, depth-1, grpDN, userDN, found,bluepages_ldap_server,bluegroups_ldap_server, ldap_version));
                  t1.start();
                }
              }
            }
          }
        }
      }
      catch (NamingException ne)
      {
      } finally {
          cleanupNamingEnum(results);
          cleanupCtx(bg_ctx);          
      }
    }
  }

  /**
  * Substitute a String for a String in a message.
  *
  * @param message  The message where the values are being substituted.
  * @param oldvalue The value being substituted.
  * @param newvalue The value to substitute with.
  * @return The message after substitution.
  */
  private String substitute(String message,
                                                    String oldvalue,
                                                    String newvalue)
  {
          StringBuffer newMsg = new StringBuffer();
          int index = 0;
          int fromIndex = 0;

          while ( (index = message.indexOf(oldvalue, fromIndex)) >= 0 ) {
                  if ( (index - fromIndex) > 0 ) {
                          newMsg.append(message.substring(fromIndex, index));
                  }
                  newMsg.append(newvalue);
                  fromIndex = index + oldvalue.length();
          }

          newMsg.append(message.substring(fromIndex));

          return newMsg.toString();
  }

  /**
    * Creates and returns an LDAP connection
    *
    * @param server The LDAP server - for example: ldap://swatv3.bluepages.ibm.com
    * @param version The LDAP version
    * @return An established DirContext
    * @exception NamingException An error has occurred
    * @throws NamingException An error has occurred
    */
  private DirContext getLdapConnection(String server, String version) throws NamingException {
    DirContext ctx = null;
      
    Properties env = new Properties();
    env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
    env.put("java.naming.ldap.derefAliases", "never");
    env.put(Context.SECURITY_AUTHENTICATION, "simple");    
    env.put(Context.PROVIDER_URL,            server);
    env.put("java.naming.ldap.version",      version);
    env.put(Context.REFERRAL,                "follow");
    env.put("java.naming.ldap.referral.bind","true");

    if (server.startsWith("ldaps://") || server.endsWith("636")) {
        env.put(Context.SECURITY_PROTOCOL, "ssl");                            
    }

    ctx = new InitialDirContext(env);
    
    return ctx;     
  }

  private void cleanupCtx(DirContext ctx) {
      if ( ctx != null )
      {
        try
        {
          ctx.close();
        }
        catch ( Throwable t )
        {
        }
        ctx = null;
      }
  }

  private void cleanupNamingEnum(NamingEnumeration ne) {
      if ( ne != null )
      {
        try
        {
          // Iterate through enumeration
          while (ne.hasMore()) {
              SearchResult sr = (SearchResult)ne.next();
          }
        }
        catch ( Throwable t )
        {
        }

        try
        {
          ne.close();
        }
        catch ( Throwable t )
        {
        }

        ne = null;
      }
  }

}

