/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java.internal;

import com.ibm.json.java.internal.Token;
import java.io.IOException;
import java.io.Reader;

public class Tokenizer {
    private Reader reader;
    private int lineNo;
    private int colNo;
    private int lastChar;

    public Tokenizer(Reader reader) throws IOException {
        this.reader = reader;
        this.lineNo = 0;
        this.colNo = 0;
        this.lastChar = 10;
        this.readChar();
    }

    public Token next() throws IOException {
        while (Character.isWhitespace((char)this.lastChar)) {
            this.readChar();
        }
        switch (this.lastChar) {
            case -1: {
                this.readChar();
                return Token.TokenEOF;
            }
            case 123: {
                this.readChar();
                return Token.TokenBraceL;
            }
            case 125: {
                this.readChar();
                return Token.TokenBraceR;
            }
            case 91: {
                this.readChar();
                return Token.TokenBrackL;
            }
            case 93: {
                this.readChar();
                return Token.TokenBrackR;
            }
            case 58: {
                this.readChar();
                return Token.TokenColon;
            }
            case 44: {
                this.readChar();
                return Token.TokenComma;
            }
            case 34: 
            case 39: {
                String string = this.readString();
                return new Token(string);
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                Number number = this.readNumber();
                return new Token(number);
            }
            case 102: 
            case 110: 
            case 116: {
                String string = this.readIdentifier();
                if (string.equals("null")) {
                    return Token.TokenNull;
                }
                if (string.equals("true")) {
                    return Token.TokenTrue;
                }
                if (string.equals("false")) {
                    return Token.TokenFalse;
                }
                throw new IOException("Unexpected identifier '" + string + "' " + this.onLineCol());
            }
        }
        throw new IOException("Unexpected character '" + (char)this.lastChar + "' " + this.onLineCol());
    }

    private String readString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lastChar;
        int n2 = this.lineNo;
        int n3 = this.colNo;
        this.readChar();
        block16: while (-1 != this.lastChar && n != this.lastChar) {
            int n4;
            StringBuffer stringBuffer2;
            if (this.lastChar != 92) {
                stringBuffer.append((char)this.lastChar);
                this.readChar();
                continue;
            }
            this.readChar();
            switch (this.lastChar) {
                case 98: {
                    this.readChar();
                    stringBuffer.append('\b');
                    continue block16;
                }
                case 102: {
                    this.readChar();
                    stringBuffer.append('\f');
                    continue block16;
                }
                case 110: {
                    this.readChar();
                    stringBuffer.append('\n');
                    continue block16;
                }
                case 114: {
                    this.readChar();
                    stringBuffer.append('\r');
                    continue block16;
                }
                case 116: {
                    this.readChar();
                    stringBuffer.append('\t');
                    continue block16;
                }
                case 39: {
                    this.readChar();
                    stringBuffer.append('\'');
                    continue block16;
                }
                case 34: {
                    this.readChar();
                    stringBuffer.append('\"');
                    continue block16;
                }
                case 92: {
                    this.readChar();
                    stringBuffer.append('\\');
                    continue block16;
                }
                case 47: {
                    this.readChar();
                    stringBuffer.append('/');
                    continue block16;
                }
                case 117: 
                case 120: {
                    stringBuffer2 = new StringBuffer();
                    int n5 = 2;
                    if (this.lastChar == 117) {
                        n5 = 4;
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        this.readChar();
                        if (!this.isHexDigit(this.lastChar)) {
                            throw new IOException("non-hex digit " + this.onLineCol());
                        }
                        stringBuffer2.append((char)this.lastChar);
                    }
                    this.readChar();
                    try {
                        n4 = Integer.parseInt(stringBuffer2.toString(), 16);
                        stringBuffer.append((char)n4);
                        continue block16;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("non-hex digit " + this.onLineCol());
                    }
                }
            }
            if (!this.isOctalDigit(this.lastChar)) {
                throw new IOException("non-hex digit " + this.onLineCol());
            }
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append((char)this.lastChar);
            for (n4 = 0; n4 < 2; ++n4) {
                this.readChar();
                if (!this.isOctalDigit(this.lastChar)) break;
                stringBuffer2.append((char)this.lastChar);
            }
            try {
                n4 = Integer.parseInt(stringBuffer2.toString(), 8);
                stringBuffer.append((char)n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("non-hex digit " + this.onLineCol());
            }
        }
        if (-1 == this.lastChar) {
            throw new IOException("String not terminated " + this.onLineCol(n2, n3));
        }
        this.readChar();
        return stringBuffer.toString();
    }

    private Number readNumber() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lineNo;
        int n2 = this.colNo;
        while (this.isDigitChar(this.lastChar)) {
            stringBuffer.append((char)this.lastChar);
            this.readChar();
        }
        String string = stringBuffer.toString();
        try {
            if (-1 != string.indexOf(46)) {
                return Double.valueOf(string);
            }
            String string2 = "";
            if (string.startsWith("-")) {
                string2 = "-";
                string = string.substring(1);
            }
            if (string.toUpperCase().startsWith("0X")) {
                return Long.valueOf(string2 + string.substring(2), 16);
            }
            if (string.equals("0")) {
                return new Long(0L);
            }
            if (string.startsWith("0") && string.length() > 1) {
                return Long.valueOf(string2 + string.substring(1), 8);
            }
            if (string.indexOf("e") != -1 || string.indexOf("E") != -1) {
                return Double.valueOf(string2 + string);
            }
            return Long.valueOf(string2 + string, 10);
        }
        catch (NumberFormatException numberFormatException) {
            IOException iOException = new IOException("Invalid number literal " + this.onLineCol(n, n2));
            iOException.initCause(numberFormatException);
            throw iOException;
        }
    }

    private boolean isHexDigit(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    private boolean isOctalDigit(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    private boolean isDigitChar(int n) {
        switch (n) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 88: 
            case 101: 
            case 120: {
                return true;
            }
        }
        return false;
    }

    private String readIdentifier() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (-1 != this.lastChar && Character.isLetter((char)this.lastChar)) {
            stringBuffer.append((char)this.lastChar);
            this.readChar();
        }
        return stringBuffer.toString();
    }

    private void readChar() throws IOException {
        if (10 == this.lastChar) {
            this.colNo = 0;
            ++this.lineNo;
        }
        this.lastChar = this.reader.read();
        if (-1 == this.lastChar) {
            return;
        }
        ++this.colNo;
    }

    private String onLineCol(int n, int n2) {
        return "on line " + n + ", column " + n2;
    }

    public String onLineCol() {
        return this.onLineCol(this.lineNo, this.colNo);
    }
}

