/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.internal.common;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class GenericServiceProvider {
    static final Map<String, Class<?>> PRIMITIVE_LOOKUP = new HashMap();

    static {
        PRIMITIVE_LOOKUP.put("boolean", Boolean.TYPE);
        PRIMITIVE_LOOKUP.put("char", Character.TYPE);
        PRIMITIVE_LOOKUP.put("byte", Byte.TYPE);
        PRIMITIVE_LOOKUP.put("short", Short.TYPE);
        PRIMITIVE_LOOKUP.put("int", Integer.TYPE);
        PRIMITIVE_LOOKUP.put("long", Long.TYPE);
        PRIMITIVE_LOOKUP.put("float", Float.TYPE);
        PRIMITIVE_LOOKUP.put("double", Double.TYPE);
        PRIMITIVE_LOOKUP.put("void", Void.TYPE);
    }

    public static String makeCall(Object obj, String method, String[] classNames, String args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        Class[] paramTypes = new Class[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            paramTypes[i] = PRIMITIVE_LOOKUP.get(classNames[i]);
            if (paramTypes[i] == null) {
                paramTypes[i] = Class.forName(classNames[i]);
            }
            ++i;
        }
        Method m = obj.getClass().getMethod(method, paramTypes);
        Object[] objArgs = new Object[classNames.length];
        if (objArgs.length > 0) {
            ObjectInputStream oIn = GenericServiceProvider.getObjectInputStream(args);
            int i2 = 0;
            while (i2 < objArgs.length) {
                objArgs[i2] = GenericServiceProvider.decodeObject(oIn);
                ++i2;
            }
        }
        return GenericServiceProvider.encodeObject(m.invoke(obj, objArgs));
    }

    private static ObjectInputStream getObjectInputStream(String encodedObjects) throws UnsupportedEncodingException, IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode((byte[])encodedObjects.getBytes("UTF-8")));
        return new ObjectInputStream(bIn);
    }

    public static Object decodeObject(String encodedObject) throws IOException, ClassNotFoundException {
        return GenericServiceProvider.decodeObject(GenericServiceProvider.getObjectInputStream(encodedObject));
    }

    private static Object decodeObject(ObjectInputStream oIn) throws IOException, ClassNotFoundException {
        int first = oIn.read();
        if (first == -1) {
            throw new EOFException();
        }
        if (first == 0) {
            return oIn.readObject();
        }
        if (first == 1) {
            int size = oIn.readInt();
            ArrayList<Object> result = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                result.add(GenericServiceProvider.decodeObject(oIn));
                ++i;
            }
            return result;
        }
        if (first == 2) {
            int size = oIn.readInt();
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            int i = 0;
            while (i < size) {
                Object key = GenericServiceProvider.decodeObject(oIn);
                Object value = GenericServiceProvider.decodeObject(oIn);
                result.put(key, value);
                ++i;
            }
            return result;
        }
        if (first == 3) {
            return UUID.valueOf((String)((String)GenericServiceProvider.decodeObject(oIn)));
        }
        throw new IOException("Received unknown marker byte: " + first);
    }

    public static String[] getClassNames(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] result = new String[parameterTypes.length];
        int i = 0;
        while (i < result.length) {
            result[i] = parameterTypes[i].getName();
            ++i;
        }
        return result;
    }

    public static String encodeArgs(Object[] args) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        if (args == null) {
            GenericServiceProvider.encodeObject(oOut, null);
        } else {
            int i = 0;
            while (i < args.length) {
                GenericServiceProvider.encodeObject(oOut, args[i]);
                ++i;
            }
        }
        return GenericServiceProvider.encodeBytes(bOut, false);
    }

    public static String encodeObject(Object object) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        return GenericServiceProvider.encodeObject(bOut, oOut, object, false);
    }

    public static String encodeObject(ByteArrayOutputStream bOut, ObjectOutputStream oOut, Object object, boolean resetByteArray) throws IOException, UnsupportedEncodingException {
        GenericServiceProvider.encodeObject(oOut, object);
        return GenericServiceProvider.encodeBytes(bOut, resetByteArray);
    }

    public static String encodeBytes(ByteArrayOutputStream bOut, boolean resetByteArray) throws UnsupportedEncodingException {
        String result = new String(Base64.encode((byte[])bOut.toByteArray()), "UTF-8");
        if (resetByteArray) {
            bOut.reset();
        }
        return result;
    }

    private static void encodeObject(ObjectOutputStream oOut, Object object) throws IOException, UnsupportedEncodingException {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            oOut.write(1);
            oOut.writeInt(collection.size());
            for (Object o : collection) {
                GenericServiceProvider.encodeObject(oOut, o);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            oOut.write(2);
            oOut.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                GenericServiceProvider.encodeObject(oOut, entry.getKey());
                GenericServiceProvider.encodeObject(oOut, entry.getValue());
            }
        } else if (object instanceof UUID) {
            oOut.write(3);
            GenericServiceProvider.encodeObject(((UUID)object).getUuidValue());
        } else {
            oOut.write(0);
            oOut.writeObject(object);
        }
        oOut.flush();
    }
}

