/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.linker.search.queries;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.search.ResultImpl;
import com.ibm.es.nuvo.search.ResultSetImpl;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Result;
import com.ibm.siapi.search.ResultSet;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.config.GlobalConfig;
import com.ibm.supa.demo.linker.search.LuceneSearchQuery;
import com.ibm.supa.docInfo.DocContents;
import com.ibm.supa.docInfo.DocumentCache;
import com.ibm.supa.linker.search.LuceneLinkerSearchFactory;
import com.ibm.supa.linker.search.queries.CodeQueryCreator;
import com.ibm.supa.linker.util.LinkerSupportInterface;
import com.ibm.supa.search.BaseQueryExecutor;
import com.ibm.supa.search.PenaltyScore;
import com.ibm.supa.search.ResultsProcessor;
import com.ibm.supa.search.SearchUtils;
import com.ibm.supa.search.SearchWrapper;
import com.ibm.supa.search.SpanResultImpl;
import com.ibm.supa.search.SupaQuery;
import com.ibm.supa.search.SupaQueryImpl;
import com.ibm.supa.search.queries.DocLevelQueryUtilities;
import com.ibm.supa.search.spans.SpanResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeQueryExecuter
extends BaseQueryExecutor
implements LinkerSupportInterface {
    private Map<String, CodeQueryCreator> codeLinkerMap;

    public boolean isLinkerSupported(String uri, String collectionId) {
        String lang = this.getLanguage(uri, collectionId);
        return lang != null;
    }

    private String getLanguage(String uri, String collectionId) {
        String string;
        SearchWrapper wrapper = new SearchWrapper(collectionId, null);
        try {
            string = this.getLanguage(uri, wrapper);
        }
        catch (Throwable throwable) {
            try {
                wrapper.close();
                throw throwable;
            }
            catch (SiapiException e) {
                e.printStackTrace();
                return null;
            }
        }
        wrapper.close();
        return string;
    }

    private String getLanguage(String uri, SearchWrapper wrapper) {
        TokenVector categories;
        block7: {
            GlobalConfig config = ConfigurationLoader.getGlobalConfig();
            TokenizedDocument tDoc = config.getDocumentCache().load(wrapper, uri);
            categories = tDoc.getField("categorization");
            if (categories != null) break block7;
            return null;
        }
        try {
            TokenVectorIterator it = categories.iterator(TokenVectorIterator.Mode.INDEXER);
            while (it.next()) {
                String category = it.toString();
                if (this.codeLinkerMap.get(category) != null) {
                    return category;
                }
                int index = category.lastIndexOf("\uf749");
                if (index < 0 || this.codeLinkerMap.get(category = category.substring(index + 1)) == null) continue;
                return category;
            }
            return null;
        }
        catch (SiapiException e) {
            e.printStackTrace();
        }
        catch (ExtendedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setCodeLinkerMap(Map<String, CodeQueryCreator> codeLinkerMap) {
        this.codeLinkerMap = codeLinkerMap;
    }

    public static int getDocNumFromUri(String uri, SearchWrapper wrapper) throws IOException, SiapiException {
        int result = -1;
        TermDocs docs = wrapper.getIndexSearcher(IndexDescriptor.IndexType.Text).getIndexReader().termDocs(new Term("uri", uri));
        try {
            if (docs.next()) {
                result = docs.doc();
            }
        }
        finally {
            docs.close();
        }
        return result;
    }

    protected BaseQueryExecutor.BaseExecutor createBaseExecutor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
        return new Executor(query, processor, wrappers);
    }

    protected SupaQuery subParse(String[] collectionIds, String queryString) throws SiapiException {
        CodeQuery result = (CodeQuery)this.subCreateQuery(collectionIds);
        result.setText(queryString);
        return result;
    }

    protected SupaQuery subCreateQuery(String[] collectionIds) throws SiapiException {
        return new CodeQuery(collectionIds);
    }

    public Class<? extends SupaQuery> getQueryClass() {
        return CodeQuery.class;
    }

    static /* synthetic */ String access$0(CodeQueryExecuter codeQueryExecuter, String string, SearchWrapper searchWrapper) {
        return codeQueryExecuter.getLanguage(string, searchWrapper);
    }

    public static class CodeQuery
    extends SupaQueryImpl {
        private static final long serialVersionUID = -7135719484297900987L;

        public CodeQuery(String ... collectionIds) throws SiapiException {
            super(collectionIds);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Executor
    extends BaseQueryExecutor.BaseExecutor {
        private CodeQuery cQuery;

        Executor(SupaQuery query, ResultsProcessor processor, SearchWrapper[] wrappers) throws SiapiException {
            super(query, processor, wrappers);
            this.cQuery = (CodeQuery)((Object)CodeQuery.class.cast(query));
        }

        /*
         * Unable to fully structure code
         */
        protected ResultSet subExecute() throws SiapiException {
            if (this.wrappers.length == 0) {
                return new ResultSetImpl(null, null, null, null, null, 0L, 0, 0, null, false);
            }
            allQuery = this.cQuery.getText();
            try {
                docLevelUtility = new DocLevelQueryUtilities(this.wrappers[0]);
                docLevelQuery = docLevelUtility.parseQuery(allQuery, "_plain");
                uri = docLevelUtility.getFieldValue("uri");
                mArtifact = uri == null ? null : CodeQueryExecuter.access$0(CodeQueryExecuter.this, uri, this.wrappers[0]);
                moreThenOneWrapper = this.wrappers.length > 1;
                startTime = System.currentTimeMillis();
                spanRequestedResults = new ArrayList<E>();
                totalNumOfResults = 0;
                if (moreThenOneWrapper) {
                    allResults = new TreeSet<SpanResult>();
                    var15_12 = this.wrappers;
                    var14_13 = this.wrappers.length;
                    var13_14 = 0;
                    while (var13_14 < var14_13) {
                        curWrapper = var15_12[var13_14];
                        try {
                            hits = this.getHits(docLevelQuery, uri, mArtifact, curWrapper);
                            allResults.addAll(this.getAllResults(hits, curWrapper));
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        ++var13_14;
                    }
                    totalNumOfResults = allResults.size();
                    allResultsArr = allResults.toArray(new SpanResult[allResults.size()]);
                    i = this.cQuery.getFirstRequestedResult();
                    while (i < this.cQuery.getFirstRequestedResult() + this.cQuery.getNumRequestedResults()) {
                        spanRequestedResults.add(allResultsArr[i]);
                        ++i;
                    }
                } else {
                    curWrapper = this.wrappers[0];
                    try {
                        hits = this.getHits(docLevelQuery, uri, mArtifact, curWrapper);
                        totalNumOfResults = hits.length();
                        spanRequestedResults = this.getRequiredResults(hits, curWrapper, this.cQuery.getFirstRequestedResult(), this.cQuery.getNumRequestedResults());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (spanRequestedResults == null || spanRequestedResults.isEmpty()) {
                    var18_22 = new ResultSetImpl(null, null, null, null, null, 0L, 0, 0, null, false);
                    return var18_22;
                }
                results = SearchUtils.load(spanRequestedResults, (SupaQuery)this.cQuery, (boolean)true, (boolean)true, (SpanResultImpl.Visitor[])new SpanResultImpl.Visitor[]{new SpanResultImpl.Visitor(){

                    public void visit(SpanResultImpl resultImpl) throws IOException, SiapiException {
                        SearchWrapper wrapper = resultImpl.getSpanResult().getSearchWrapper();
                        int lineIndex = Executor.this.docPosToDocLineIndex(resultImpl.getDocId(), resultImpl.start(), wrapper);
                        resultImpl.setStartLine(lineIndex);
                        resultImpl.setEndLine(lineIndex);
                        String desc = resultImpl.getDescription();
                        resultImpl.setDescription(desc);
                        wrapper.updateCachedProperty((ResultImpl)resultImpl);
                    }
                }});
                evalTime = System.currentTimeMillis() - startTime;
                var18_23 = new ResultSetImpl((Result[])results, null, null, null, null, evalTime, totalNumOfResults, totalNumOfResults, null, false);
                return var18_23;
            }
            catch (Exception e) {
                if (e instanceof SiapiException) {
                    throw (SiapiException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                var22_26 = this.wrappers;
                var21_29 = this.wrappers.length;
                var20_32 = 0;
                ** while (var20_32 < var21_29)
            }
lbl-1000:
            // 1 sources

            {
                wrapper = var22_26[var20_32];
                if (wrapper != null) {
                    wrapper.close();
                }
                ++var20_32;
                continue;
            }
lbl73:
            // 1 sources

            throw var17_36;
        }

        private Hits getHits(Query docLevelQuery, String uri, String mArtifact, SearchWrapper curWrapper) throws SiapiException, Exception {
            Query luceneQuery;
            String curCollectionId = curWrapper.getCollectionId();
            if (mArtifact == null) {
                luceneQuery = docLevelQuery;
            } else {
                CodeQueryCreator cToQ = (CodeQueryCreator)CodeQueryExecuter.this.codeLinkerMap.get(mArtifact);
                String codeText = this.extractDocFromUri(uri);
                BooleanQuery query = cToQ.execute(codeText, curCollectionId, null);
                query.add(docLevelQuery, BooleanClause.Occur.SHOULD);
                cToQ.releaseResources();
                luceneQuery = query;
            }
            LuceneSearchQuery searchAlgorithm = (LuceneSearchQuery)new LuceneLinkerSearchFactory().createLinkerSearchQueryAlgorithm(curCollectionId);
            Hits hits = searchAlgorithm.executeWithHitsResult(luceneQuery);
            return hits;
        }

        public String extractDocFromUri(String uri) throws SiapiException {
            try {
                DocumentCache docCache = ConfigurationLoader.getGlobalConfig().getDocumentCache();
                TokenizedDocument tokenizedDoc = null;
                SearchWrapper[] searchWrapperArray = this.wrappers;
                int n = this.wrappers.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchWrapper curWrapper = searchWrapperArray[n2];
                    tokenizedDoc = docCache.load(curWrapper, uri);
                    if (tokenizedDoc != null) break;
                    ++n2;
                }
                GlobalConfig globalConf = ConfigurationLoader.getGlobalConfig();
                DocContents docContent = globalConf.getDocContentsCache().lookup(tokenizedDoc, "_plain");
                String[] allLines = docContent.getLines(0, Integer.MAX_VALUE, true, false);
                return this.linesToDoc(allLines);
            }
            catch (Exception e) {
                if (e instanceof SiapiException) {
                    throw (SiapiException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private String linesToDoc(String[] allLines) {
            StringBuilder doc = new StringBuilder();
            int i = 0;
            while (i < allLines.length) {
                if (!allLines[i].equals("\n")) {
                    doc.append(allLines[i]);
                }
                ++i;
            }
            return doc.toString();
        }

        private ArrayList<SpanResult> getAllResults(Hits hits, SearchWrapper wrapper) {
            return this.getRequiredResults(hits, wrapper, 0, hits.length());
        }

        private ArrayList<SpanResult> getRequiredResults(Hits hits, SearchWrapper wrapper, int offset, int amountOfResults) {
            ArrayList<SpanResult> result = new ArrayList<SpanResult>();
            HashSet<Integer> badDocIds = new HashSet<Integer>();
            try {
                int i = offset;
                while (result.size() < amountOfResults && i < hits.length()) {
                    SpanResult spanResult = this.luceneHitToSpanResult(hits, i, wrapper, badDocIds);
                    if (spanResult != null) {
                        result.add(spanResult);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        private int docPosToDocLineIndex(int docNum, int pos, SearchWrapper wrapper) {
            int ans;
            try {
                DocumentCache docCache = ConfigurationLoader.getGlobalConfig().getDocumentCache();
                TokenizedDocument tokenizedDoc = docCache.load(wrapper, docNum);
                GlobalConfig globalConf = ConfigurationLoader.getGlobalConfig();
                DocContents docContent = globalConf.getDocContentsCache().lookup(tokenizedDoc, "_plain");
                ans = docContent.getLineIndex(pos);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ans;
        }

        private SpanResult luceneHitToSpanResult(Hits hits, int hitIndex, SearchWrapper wrapper, Set<Integer> badDocIds) {
            int docNum;
            float score;
            Document doc;
            SpanResult spanResult;
            block5: {
                Integer docId;
                block4: {
                    spanResult = null;
                    try {
                        docId = new Integer(hits.id(hitIndex));
                        if (!badDocIds.contains(docId)) break block4;
                        return null;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                doc = hits.doc(hitIndex);
                score = hits.score(hitIndex);
                String uri = doc.get("uri");
                docNum = CodeQueryExecuter.getDocNumFromUri(uri, wrapper);
                if (docNum >= 0) break block5;
                badDocIds.add(docId);
                return null;
            }
            int start_position = Integer.valueOf(doc.get("start_position"));
            int last_position = Integer.valueOf(doc.get("end_position"));
            spanResult = new SpanResult(wrapper, start_position, last_position, docNum);
            double penlty = (-score + 1.0f) * 100.0f;
            PenaltyScore ps = new PenaltyScore();
            ps.setPenalty(penlty);
            spanResult.setPenaltyScore(ps);
            return spanResult;
        }
    }
}

