/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.linker.search;

import com.ibm.supa.linker.exceptions.UnReachableCode;
import com.ibm.supa.linker.search.LinkerSearchAlgorithm;
import com.ibm.supa.linker.search.QueryResults;
import com.ibm.supa.linker.search.querys.building.QueryElementVisitor;
import com.ibm.supa.linker.search.querys.elements.ClassCommentQueryElement;
import com.ibm.supa.linker.search.querys.elements.ClassNameQueryElement;
import com.ibm.supa.linker.search.querys.elements.FunctionArgumentQueryElement;
import com.ibm.supa.linker.search.querys.elements.FunctionCommentQueryElement;
import com.ibm.supa.linker.search.querys.elements.FunctionNameQueryElement;
import com.ibm.supa.linker.search.querys.elements.IdentifierQueryElement;
import com.ibm.supa.linker.search.querys.elements.QueryElement;
import com.ibm.supa.linker.search.querys.elements.SubWordQueryElement;
import com.ibm.supa.linker.search.querys.elements.SuperClassNameQueryElement;
import com.ibm.supa.linker.search.querys.elements.SynonymQueryElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearch
implements LinkerSearchAlgorithm,
QueryElementVisitor {
    public static final float BOOST_IdentifierQueryElement = 2.0f;
    public static final float BOOST_SubWordQueryElement = 1.0f;
    public static final float BOOST_FunctionNameQueryElement = 4.0f;
    public static final float BOOST_FunctionCommentQueryElement = 2.0f;
    public static final float BOOST_FunctionArgument = 2.0f;
    public static final float BOOST_ClassNameQueryElement = 6.0f;
    public static final float BOOST_SuperClassNameQueryElement = 2.0f;
    public static final float BOOST_ClassCommentQueryElement = 4.0f;
    public static final float BOOST_SynonymQueryElement = 1.0f;
    public static String inedx_directory_;
    public static String result_directory_;
    public static String result_file_name_directory_;
    Query visit_result;

    public LuceneSearch(String inedx_directory, String result_directory, String result_file_name_directory) {
        inedx_directory_ = inedx_directory;
        result_directory_ = result_directory;
        result_file_name_directory_ = result_file_name_directory;
    }

    private Query buildTermQuery(String word, float boost) {
        Term term = new Term("_plain", word);
        TermQuery result = new TermQuery(term);
        result.setBoost(boost);
        return result;
    }

    private Query handleSubElement(QueryElement sub_element, float factor) {
        this.visit_result = null;
        sub_element.accept(this);
        assert (this.visit_result != null);
        float boost = this.visit_result.getBoost();
        float new_boost = boost - factor;
        this.visit_result.setBoost(new_boost);
        return this.visit_result;
    }

    @Override
    public void execute(Collection<QueryElement> elements) throws Exception {
        BooleanQuery query = this.buildQuery(elements);
        LinkedList<QueryResults> result = this.search(query);
        this.buildOutput(result);
    }

    public Hits executeWithHitsResult(Collection<QueryElement> elements) throws Exception {
        BooleanQuery query = this.buildQuery(elements);
        IndexReader reader = IndexReader.open((String)inedx_directory_);
        IndexSearcher searcher = new IndexSearcher(reader);
        Hits hits = searcher.search((Query)query);
        return hits;
    }

    private void buildOutput(LinkedList<QueryResults> result) throws IOException {
        File output_file = new File(String.valueOf(result_directory_) + result_file_name_directory_);
        FileWriter output_writer = new FileWriter(output_file);
        for (QueryResults current : result) {
            float score = current.getScore();
            String name = current.getFileName();
            int index = name.lastIndexOf("\\");
            String file_name = name.substring(index + 1);
            String output = String.valueOf(file_name) + "   " + score + "\n";
            output_writer.write(output);
        }
        output_writer.close();
    }

    private LinkedList<QueryResults> search(BooleanQuery query) throws CorruptIndexException, IOException {
        IndexReader reader = IndexReader.open((String)inedx_directory_);
        IndexSearcher searcher = new IndexSearcher(reader);
        Hits hits = searcher.search((Query)query);
        LinkedList<QueryResults> result = new LinkedList<QueryResults>();
        int i = 0;
        while (i < hits.length()) {
            Document d = hits.doc(i);
            String name = d.get("path");
            float score = hits.score(i);
            QueryResults current_hit = new QueryResults(new StringBuilder(name), score);
            result.add(current_hit);
            ++i;
        }
        return result;
    }

    private BooleanQuery buildQuery(Collection<QueryElement> elements) {
        BooleanQuery query = new BooleanQuery();
        int number_of_clauses = 0;
        for (QueryElement element : elements) {
            ++number_of_clauses;
            this.visit_result = null;
            element.accept(this);
            assert (this.visit_result != null);
            Query intermediate_query = this.visit_result;
            if (number_of_clauses >= BooleanQuery.getMaxClauseCount()) {
                number_of_clauses = 1;
                BooleanQuery temp2 = new BooleanQuery();
                temp2.add((Query)query, BooleanClause.Occur.SHOULD);
                query = temp2;
            }
            query.add(intermediate_query, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Override
    public void visit(IdentifierQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.buildTermQuery(queryElement.identifier(), 2.0f);
    }

    @Override
    public void visit(SubWordQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.handleSubElement(queryElement.subElement(), 1.0f);
    }

    @Override
    public void visit(FunctionNameQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.buildTermQuery(queryElement.identifier(), 4.0f);
    }

    @Override
    public void visit(FunctionCommentQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.buildTermQuery(queryElement.identifier(), 2.0f);
    }

    @Override
    public void visit(FunctionArgumentQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.buildTermQuery(queryElement.identifier(), 2.0f);
    }

    @Override
    public void visit(ClassNameQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.buildTermQuery(queryElement.identifier(), 6.0f);
    }

    @Override
    public void visit(SuperClassNameQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.buildTermQuery(queryElement.identifier(), 2.0f);
    }

    @Override
    public void visit(ClassCommentQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.buildTermQuery(queryElement.identifier(), 4.0f);
    }

    @Override
    public void visit(SynonymQueryElement queryElement) {
        Query result;
        this.visit_result = result = this.handleSubElement(queryElement.subElement(), 1.0f);
    }

    @Override
    public void visit(QueryElement queryElement) {
        throw new UnReachableCode();
    }
}

