/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.linker.index;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.linker.LinkerFactory;
import com.ibm.supa.linker.index.CreateOutput;
import com.ibm.supa.linker.index.IndexCreator;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndexCreator
implements IndexCreator {
    private Collection<TokenizedDocument> documents_;
    private String field_ = "_plain";
    private CreateOutput sources_creator;
    private boolean previous_was_newline = false;
    private int line_number = 0;
    private int start_section_line_number = 0;
    private int start_position_section_number = 0;
    private static final int MAX_SECTION_BOUNDARY = 1000;
    private static final int max_number_of_next_without_new_line = 5000;
    private int section_line_number = 0;
    private StringBuilder current_section;
    private Section previous_section = null;
    private boolean previous_section_contain_more_then_one_line_section = false;
    private String uri_;

    private TokenVectorIterator getFieldIterator(TokenizedDocument document) {
        return document.getField(this.field_).iterator(TokenVectorIterator.Mode.SUMMARY);
    }

    private int documentEndPosition(TokenizedDocument document) {
        return SUPAUtils.getEndPlainTextPos((Document)document.getDocument(), (Vint8.Position)new Vint8.Position());
    }

    public SimpleIndexCreator(Collection<TokenizedDocument> documents, LinkerFactory linker_factory) throws IOException {
        this.documents_ = documents;
        this.sources_creator = linker_factory.createCreateOutput();
    }

    @Override
    public void execute() throws IOException {
        for (TokenizedDocument document : this.documents_) {
            Field uri_field = document.getDocument().getField("uri");
            this.uri_ = uri_field.toString();
            this.makeIndexFor(document);
        }
    }

    private void makeIndexFor(TokenizedDocument document) throws IOException {
        Collection<Section> sections = this.createSectionsArray(document);
        this.sources_creator.execute(sections);
    }

    private Collection<Section> createSectionsArray(TokenizedDocument document) {
        int end_position = this.documentEndPosition(document);
        TokenVectorIterator document_iterator = this.getFieldIterator(document);
        LinkedList<Section> result = new LinkedList<Section>();
        boolean more_lines = true;
        int number_of_next_without_new_line = 0;
        this.initializeAttributes(document_iterator);
        while (more_lines && this.moreLinesToItrate(end_position, this.line_number)) {
            if (this.endOfLine(document_iterator) || ++number_of_next_without_new_line > 5000) {
                ++this.line_number;
                ++this.section_line_number;
                more_lines = document_iterator.next();
                number_of_next_without_new_line = 0;
                continue;
            }
            boolean is_end_of_section = this.endOfSectionChecking(document_iterator);
            if (is_end_of_section || this.moreThenSectionBoundary(this.section_line_number)) {
                this.handleEndOfSection(document_iterator, result);
                continue;
            }
            this.current_section.append((CharSequence)document_iterator);
            more_lines = document_iterator.next();
        }
        this.addLastSection(result, document_iterator.getPosition());
        return result;
    }

    private void initializeAttributes(TokenVectorIterator document_iterator) {
        this.section_line_number = 0;
        this.start_section_line_number = 0;
        this.start_position_section_number = document_iterator.getPosition();
        this.current_section = new StringBuilder();
        this.previous_was_newline = false;
        this.line_number = 0;
        this.previous_section = null;
        this.previous_section_contain_more_then_one_line_section = false;
    }

    private void addLastSection(List<Section> result, int last_position) {
        result.add(new Section(this.current_section, this.start_section_line_number, this.start_position_section_number, last_position, this.uri_));
    }

    private boolean moreThenSectionBoundary(int section_line_number) {
        return section_line_number > 1000;
    }

    private void minimizedTemporaryTokens(TokenVectorIterator document_iterator) {
        boolean more_lines = true;
        while (!this.isOriginalText(document_iterator) && more_lines) {
            if (this.endOfLine(document_iterator)) {
                ++this.line_number;
            }
            more_lines = document_iterator.next();
        }
    }

    private boolean moreLinesToItrate(int end_position, int line_number) {
        boolean result = line_number < end_position;
        return result;
    }

    private void handleEndOfSection(TokenVectorIterator document_iterator, List<Section> result) {
        int last_position = document_iterator.getPosition();
        this.minimizedTemporaryTokens(document_iterator);
        if (this.previous_section != null) {
            if (this.endOfPreviouseSection()) {
                this.updatePreviousSection(result, last_position);
            } else {
                if (this.morThenOneLine(this.current_section)) {
                    this.previous_section_contain_more_then_one_line_section = true;
                }
                this.appendCurrentToPrevious(last_position);
            }
        } else {
            this.previous_section = new Section(this.current_section, this.start_section_line_number, this.start_position_section_number, last_position, this.uri_);
            if (this.morThenOneLine(this.current_section)) {
                this.previous_section_contain_more_then_one_line_section = true;
            }
        }
        this.start_section_line_number = this.line_number;
        this.start_position_section_number = document_iterator.getPosition();
        this.section_line_number = 1;
        this.current_section = new StringBuilder();
    }

    private boolean endOfPreviouseSection() {
        return this.currentSectionStartwithDotNumber() || this.currentSectionIsWithOneLineAndPreviousSectionContainSectionBiggerThenOneLineSection();
    }

    private boolean currentSectionStartwithDotNumber() {
        int i = 0;
        boolean result = false;
        while (this.isDigitcurrentSectionIndex(i)) {
            ++i;
        }
        if (this.isDotCurrentSectionIndex(i) && this.isDigitcurrentSectionIndex(i + 1)) {
            result = true;
        }
        return result;
    }

    private boolean isDotCurrentSectionIndex(int i) {
        return this.current_section.charAt(i) == '.';
    }

    private boolean isDigitcurrentSectionIndex(int i) {
        return this.current_section.charAt(i) <= '9' && this.current_section.charAt(i) >= '0';
    }

    private void appendCurrentToPrevious(int last_position) {
        int start_line = this.previous_section.getStart_line();
        int start_position = this.previous_section.getStart_position();
        this.previous_section = new Section(this.previous_section.getSection_content().append((CharSequence)this.current_section), start_line, start_position, last_position, this.previous_section.getUri());
    }

    private void updatePreviousSection(List<Section> result, int last_position) {
        result.add(this.previous_section);
        this.previous_section = new Section(this.current_section, this.start_section_line_number, this.start_position_section_number, last_position, this.uri_);
        this.previous_section_contain_more_then_one_line_section = false;
    }

    private boolean currentSectionIsWithOneLineAndPreviousSectionContainSectionBiggerThenOneLineSection() {
        boolean mor_then_one_line = this.morThenOneLine(this.current_section);
        return !mor_then_one_line && this.previous_section_contain_more_then_one_line_section;
    }

    private boolean morThenOneLine(StringBuilder section) {
        int last_index_of_dot;
        int first_index_of_dot = section.indexOf(".");
        boolean mor_then_one_line = first_index_of_dot != (last_index_of_dot = section.lastIndexOf("."));
        return mor_then_one_line;
    }

    private boolean endOfLine(TokenVectorIterator document_iterator) {
        return document_iterator.getType() == TToken.Type.SENTENCE;
    }

    private boolean endOfSectionChecking(TokenVectorIterator document_iterator) {
        boolean result = false;
        if (!this.isOriginalText(document_iterator)) {
            if ("\n".equals(document_iterator.toString()) || "\r\n".equals(document_iterator.toString())) {
                if (this.previous_was_newline) {
                    result = true;
                    this.previous_was_newline = false;
                } else {
                    this.previous_was_newline = true;
                }
            }
        } else {
            this.previous_was_newline = false;
        }
        return result;
    }

    private boolean isOriginalText(TokenVectorIterator document_iterator) {
        return document_iterator.getType() == TToken.Type.ORIGINAL || document_iterator.getType() == TToken.Type.BOTH;
    }

    protected static class Section {
        private StringBuilder section_content_;
        private int start_line_;
        private int start_position_;
        private int last_position_;
        private String uri_;

        Section(StringBuilder section_content, int start_line, int start_position, int last_position, String uri) {
            this.setSection_content(section_content);
            this.setStart_line(start_line);
            this.setStart_position(start_position);
            this.setLast_position(last_position);
            this.setUri(uri);
        }

        public void setStart_line(int start_line) {
            this.start_line_ = start_line;
        }

        public int getStart_line() {
            return this.start_line_;
        }

        private void setSection_content(StringBuilder section_content) {
            this.section_content_ = section_content;
        }

        protected StringBuilder getSection_content() {
            return new StringBuilder(this.section_content_);
        }

        public void setStart_position(int start_position) {
            this.start_position_ = start_position;
        }

        public int getStart_position() {
            return this.start_position_;
        }

        public void setLast_position(int last_position) {
            this.last_position_ = last_position;
        }

        public int getLast_position() {
            return this.last_position_;
        }

        public void setUri(String uri) {
            this.uri_ = uri;
        }

        public String getUri() {
            return this.uri_;
        }
    }
}

