/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.linker.index;

import com.ibm.supa.linker.FullKnowledgeLuceneFactory;
import com.ibm.supa.linker.UnstructuredDocumentsExtractor;
import com.ibm.supa.linker.index.IndexCreator;
import com.ibm.supa.linker.index.Indexer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;

public class LuceneIndexer
implements Indexer {
    public static final String LINKER_SECTION_FIELD_PATH = "path";
    public static final String LINKER_SECTION_URI_FIELD = "uri";
    public static final String LINKER_PLAINTEXT_FIELD_NAME = "_plain";
    public static final String START_POSITION_FIELD = "start_position";
    public static final String LAST_POSITION_FIELD = "end_position";
    private File index_directory_ = new File("../tests/lucene_index/");

    public LuceneIndexer() throws IOException {
        if (!this.index_directory_.exists() || !this.index_directory_.isDirectory()) {
            throw new IOException(this.index_directory_ + "does not exist or is not a directory");
        }
    }

    public void makeLuceneIndexThatIncludeFullSourceKnowledge() throws Exception {
        FullKnowledgeLuceneFactory factory = new FullKnowledgeLuceneFactory();
        UnstructuredDocumentsExtractor unstructured_documents_extractor = factory.createUnstructuredDocumentsExtractor();
        IndexCreator index_creator = factory.createIndexCreator(unstructured_documents_extractor.execute(), factory);
        index_creator.execute();
    }

    public void execute() throws IOException {
        File[] files;
        IndexWriter lucene_writer = null;
        lucene_writer = new IndexWriter(this.index_directory_, (Analyzer)new StopAnalyzer(new File("../tests/common_words/common_words")));
        File source_directory = new File("../tests/SOURCE_DIRECTORY/");
        File[] fileArray = files = source_directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File current = fileArray[n2];
            Document document = new Document();
            document.add((Fieldable)new Field(LINKER_SECTION_FIELD_PATH, current.getPath(), Field.Store.YES, Field.Index.NO));
            FileInputStream is = new FileInputStream(current);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String contents = this.readFileContents(reader);
            document.add((Fieldable)new Field(LINKER_PLAINTEXT_FIELD_NAME, contents, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.YES));
            lucene_writer.addDocument(document);
            ++n2;
        }
        lucene_writer.close();
    }

    private String readFileContents(Reader reader) throws IOException {
        StringBuilder contents = new StringBuilder();
        int ch = reader.read();
        while (ch != -1) {
            contents.appendCodePoint(ch);
            ch = reader.read();
        }
        return contents.toString();
    }
}

