/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.linker.index;

import com.ibm.supa.linker.index.CreateOutput;
import com.ibm.supa.linker.index.SimpleIndexCreator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLuceneIndexOutput
extends CreateOutput {
    @Override
    public void execute(Collection<SimpleIndexCreator.Section> sections) throws IOException {
        IndexWriter lucene_writer = null;
        lucene_writer = new IndexWriter("../tests/lucene_full_knowledge_index/", (Analyzer)new StopAnalyzer(new File("../tests/common_words/common_words")));
        try {
            for (SimpleIndexCreator.Section section : sections) {
                Document document = new Document();
                document.add((Fieldable)new Field("uri", section.getUri(), Field.Store.YES, Field.Index.NO));
                String start_position = new Integer(section.getStart_position()).toString();
                document.add((Fieldable)new Field("start_position", start_position, Field.Store.YES, Field.Index.NO));
                String last_position = new Integer(section.getLast_position()).toString();
                document.add((Fieldable)new Field("end_position", last_position, Field.Store.YES, Field.Index.NO));
                String content = section.getSection_content().toString();
                document.add((Fieldable)new Field("_plain", content, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.YES));
                lucene_writer.addDocument(document);
            }
        }
        finally {
            if (lucene_writer != null) {
                lucene_writer.close();
            }
        }
    }
}

