/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.demo.linker.search.wordextraction;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.demo.linker.search.wordextraction.ExtractCodeQueryElementsFromCas;
import com.ibm.supa.linker.search.querys.elements.QueryElement;
import com.ibm.supa.linker.search.querys.elements.SubWordQueryElement;
import com.ibm.supa.tokenizers.DelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import com.ibm.supa.tokenizers.TokenizationUtils;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FSMatchConstraint;
import com.ibm.uima.cas.FSTypeConstraint;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.AnnotationIndex;
import com.ibm.uima.cas.text.TCAS;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtractQueryElementsFromCas
implements ExtractCodeQueryElementsFromCas {
    private TCAS mTcas;
    private DelegateTokenizer mTokenizer;
    private TokenizationParams mParams;

    public ExtractQueryElementsFromCas(TCAS tcas, String collectionId) {
        this.mTcas = tcas;
        this.mParams = new TokenizationParams(false, collectionId, null, null, null, null);
        AnalysisScopeConfig config = ConfigurationLoader.getAnalysisScopeConfig((String)collectionId);
        this.mTokenizer = config.getTokenizer();
    }

    public ExtractQueryElementsFromCas() {
    }

    @Override
    public void init(TCAS tcas, String collectionId) {
        this.mTcas = tcas;
        this.mParams = new TokenizationParams(false, collectionId, null, null, null, null);
        AnalysisScopeConfig config = ConfigurationLoader.getAnalysisScopeConfig((String)collectionId);
        this.mTokenizer = config.getTokenizer();
    }

    protected SortedSet<AnnotationInfo> getAnnotations(Constraint annotationConstraint) {
        if (annotationConstraint == null) {
            annotationConstraint = new Constraint(null, null, null, null, null, null, null, null);
        }
        TreeSet<AnnotationInfo> annotations = new TreeSet<AnnotationInfo>();
        String type = annotationConstraint.getRequiredType();
        String feature = annotationConstraint.getRequiredFeature();
        String code = this.mTcas.getDocumentText();
        AnnotationIndex idx = (AnnotationIndex)this.mTcas.getAnnotationIndex();
        FSIterator it = idx.iterator();
        if (type != null) {
            FSTypeConstraint constraint = this.mTcas.getConstraintFactory().createTypeConstraint();
            constraint.add(type);
            it = this.mTcas.createFilteredIterator(it, (FSMatchConstraint)constraint);
        }
        FSIterator itA = it;
        while (itA.isValid()) {
            AnnotationFS fs = (AnnotationFS)itA.get();
            boolean con = true;
            if (annotationConstraint != null) {
                con = annotationConstraint.isConstraintTrue(fs);
            }
            if (con) {
                if (feature == null) {
                    if (fs.getEnd() > fs.getBegin()) {
                        String typeRes = code.substring(fs.getBegin(), fs.getEnd());
                        annotations.add(new AnnotationInfo(AnnotationKind.TYPE, typeRes, fs.getBegin(), fs.getEnd()));
                    }
                } else {
                    String featureRes = fs.getFeatureValueAsString(fs.getType().getFeatureByBaseName(feature));
                    if (featureRes != null && !featureRes.equals("")) {
                        annotations.add(new AnnotationInfo(AnnotationKind.FEATURE, featureRes, fs.getBegin(), fs.getEnd()));
                    }
                }
            }
            itA.moveToNext();
        }
        return annotations;
    }

    protected List<String> fragmentToWords(String expression, boolean dotIsAWordNonSep) {
        ArrayList<String> subAnnotations = new ArrayList<String>();
        Pattern englishWord = null;
        if (!dotIsAWordNonSep) {
            englishWord = Pattern.compile("[a-zA-Z_0-9]+([-'][a-zA-Z_0-9]+)*");
        }
        if (dotIsAWordNonSep) {
            englishWord = Pattern.compile("[a-zA-Z_0-9]+([-'.][a-zA-Z_0-9]+)*");
        }
        Matcher matcher = englishWord.matcher(expression);
        while (matcher.find()) {
            subAnnotations.add(expression.substring(matcher.start(), matcher.end()));
        }
        return subAnnotations;
    }

    protected List<String> tokenToSubWords(String word) {
        ArrayList<String> subWords = new ArrayList<String>();
        List<TToken> tokens = this.tokenize(word);
        for (TToken token : tokens) {
            if (!TokenizationUtils.isSubword((String)token.toString())) continue;
            String subWord = TokenizationUtils.makeNonSubWordForm((String)token.toString());
            subWords.add(subWord);
        }
        return subWords;
    }

    private List<TToken> tokenize(String tokenText) {
        TToken tok = TTokenUtils.newToken((CharSequence)tokenText, (TToken.Type)TToken.Type.ORIGINAL);
        return this.mTokenizer.tokenize(this.mParams, tok);
    }

    protected void addAnnotationsAsQueries(LinkedList<QueryElement> queriesList, List<String> annotations, String queryClassName, boolean needToTokenToSubWords, boolean dotIsAWordNonSep) {
        try {
            Constructor<?> ct = Class.forName(queryClassName).getConstructor(String.class);
            for (String annotation : annotations) {
                for (String singleWord : this.fragmentToWords(annotation, dotIsAWordNonSep)) {
                    queriesList.add((QueryElement)ct.newInstance(singleWord));
                    if (!needToTokenToSubWords) continue;
                    for (String subWord : this.tokenToSubWords(singleWord)) {
                        queriesList.add(new SubWordQueryElement((QueryElement)ct.newInstance(subWord)));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected List<String> annotationSetToStringList(SortedSet<AnnotationInfo> annotations) {
        ArrayList<String> annotationAsStrings = new ArrayList<String>();
        for (AnnotationInfo annotationInfo : annotations) {
            annotationAsStrings.add(annotationInfo.getAnnotation());
        }
        return annotationAsStrings;
    }

    protected SortedSet<Interval> annotationSetToIntervalSet(SortedSet<AnnotationInfo> annotations) {
        TreeSet<Interval> newSet = new TreeSet<Interval>();
        for (AnnotationInfo annotationInfo : annotations) {
            newSet.add(new Interval(annotationInfo.getStartLoc(), annotationInfo.getEndLoc()));
        }
        return newSet;
    }

    @Override
    public void releaseResources() {
        this.mTokenizer.releaseResources();
        this.mTokenizer = null;
    }

    @Override
    public abstract LinkedList<QueryElement> getQueries(HashMap<ExtractCodeQueryElementsFromCas.QueriesTypes, Boolean> var1);

    protected class AnnotationInfo
    extends Interval {
        private AnnotationKind mAnnotationKind;
        private String mAnnotation;

        public AnnotationInfo(AnnotationKind annotationKind, String annotation, int typeStartLoc, int typeEndLoc) {
            super(typeStartLoc, typeEndLoc);
            this.mAnnotationKind = annotationKind;
            this.mAnnotation = annotation;
        }

        public AnnotationKind getAnnotationKind() {
            return this.mAnnotationKind;
        }

        public String getAnnotation() {
            return this.mAnnotation;
        }

        public int getTypeStartLoc() {
            return this.mStartLoc;
        }

        public int getTypeEndLoc() {
            return this.mEndLoc;
        }

        public int compareTo(Interval o) {
            AnnotationInfo other = (AnnotationInfo)o;
            int ans = super.compareTo(other);
            if (ans != 0) {
                return ans;
            }
            if (this.mAnnotation.compareTo(other.mAnnotation) != 0) {
                return this.mAnnotation.compareTo(other.mAnnotation);
            }
            if (this.mAnnotationKind == other.mAnnotationKind) {
                return 0;
            }
            if (this.mAnnotationKind == AnnotationKind.TYPE) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AnnotationKind {
        TYPE,
        FEATURE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Constraint {
        private String mRequiredType;
        private String mRequiredFeature;
        private String mFeatureConstraintName;
        private Pattern mFeatureConstraintValues;
        private SortedSet<Interval> mIncludeInIntervals;
        private SortedSet<Interval> mNotIncludeInIntervals;
        private SortedSet<Interval> mNearestIntervalsFromBelow;
        private SortedSet<Interval> mNotNearestIntervalsFromBelow;

        public Constraint(String requiredType, String requiredFeature, String featureConstraintName, String featureConstraintValues, SortedSet<Interval> includeIntervals, SortedSet<Interval> excludeIntervals, SortedSet<Interval> nearestIntervalsFromBelow, SortedSet<Interval> notNearestIntervalsFromBelow) {
            this.checkConstructorArguments(requiredType, requiredFeature, featureConstraintName, featureConstraintValues);
            this.mRequiredType = requiredType;
            this.mRequiredFeature = requiredFeature;
            this.mFeatureConstraintName = featureConstraintName;
            if (featureConstraintValues != null) {
                this.mFeatureConstraintValues = Pattern.compile(featureConstraintValues);
                if (this.mFeatureConstraintValues.matcher("").matches()) {
                    throw new IllegalArgumentException("featureConstraintValues could match an empty string");
                }
            } else {
                this.mFeatureConstraintValues = null;
            }
            this.mIncludeInIntervals = includeIntervals;
            this.mNotIncludeInIntervals = excludeIntervals;
            this.mNearestIntervalsFromBelow = nearestIntervalsFromBelow;
            this.mNotNearestIntervalsFromBelow = notNearestIntervalsFromBelow;
        }

        private void checkConstructorArguments(String requiredType, String requiredFeature, String featureConstraintName, String featureConstraintValues) {
            if (requiredFeature != null && requiredType == null) {
                throw new IllegalArgumentException("Constraint: requiredFeature != null && requiredType == null");
            }
            if (featureConstraintValues != null && featureConstraintName == null) {
                throw new IllegalArgumentException("Constraint: featureConstraintValues != null && featureConstraintName == null");
            }
        }

        public String getRequiredType() {
            return this.mRequiredType;
        }

        public String getRequiredFeature() {
            return this.mRequiredFeature;
        }

        public boolean isConstraintTrue(AnnotationFS fs) {
            int docLength = ExtractQueryElementsFromCas.this.mTcas.getDocumentText().length();
            String featureConstraintValue = null;
            if (this.mFeatureConstraintName != null) {
                featureConstraintValue = fs.getFeatureValueAsString(fs.getType().getFeatureByBaseName(this.mFeatureConstraintName)).trim();
            }
            boolean featureConstraint = this.isFeatureConstraintTrue(featureConstraintValue);
            boolean includeinAllConstraint = this.isIncludeinAll(fs.getBegin(), fs.getEnd());
            boolean notIncludeinAnyConstraint = this.notIncludeInAny(fs.getBegin(), fs.getEnd());
            boolean NearestFromAboveConstraint = this.isNearestFromAbove(fs.getEnd(), docLength);
            return featureConstraint && includeinAllConstraint && notIncludeinAnyConstraint && NearestFromAboveConstraint;
        }

        private boolean isFeatureConstraintTrue(String checkStr) {
            if (this.mFeatureConstraintName == null || this.mFeatureConstraintValues == null) {
                return true;
            }
            return this.mFeatureConstraintValues.matcher(checkStr).find();
        }

        private boolean isIncludeinAll(int begin, int end) {
            if (this.mIncludeInIntervals == null) {
                return true;
            }
            for (Interval constraintInterval : this.mIncludeInIntervals) {
                if (begin >= constraintInterval.getStartLoc() && end <= constraintInterval.getEndLoc()) continue;
                return false;
            }
            return true;
        }

        private boolean notIncludeInAny(int begin, int end) {
            if (this.mNotIncludeInIntervals == null) {
                return true;
            }
            for (Interval constraintInterval : this.mNotIncludeInIntervals) {
                if (begin < constraintInterval.getStartLoc() || end > constraintInterval.getEndLoc()) continue;
                return false;
            }
            return true;
        }

        private boolean isNearestFromAbove(int end, int docLength) {
            int curDistance;
            int maxPossibleDistance;
            if (this.mNearestIntervalsFromBelow == null && this.mNotNearestIntervalsFromBelow == null) {
                return true;
            }
            int DistanceFromGoodGroup = maxPossibleDistance = docLength + 1;
            int DistanceFromBadGroup = maxPossibleDistance;
            if (this.mNearestIntervalsFromBelow != null) {
                for (Interval constraintInterval : this.mNearestIntervalsFromBelow) {
                    curDistance = constraintInterval.getStartLoc() - end;
                    if (curDistance < 0 || DistanceFromGoodGroup <= curDistance) continue;
                    DistanceFromGoodGroup = curDistance;
                }
            }
            if (this.mNotNearestIntervalsFromBelow != null) {
                for (Interval constraintInterval : this.mNotNearestIntervalsFromBelow) {
                    curDistance = constraintInterval.getStartLoc() - end;
                    if (curDistance < 0 || DistanceFromBadGroup <= curDistance) continue;
                    DistanceFromBadGroup = curDistance;
                }
            }
            if (DistanceFromGoodGroup == maxPossibleDistance && DistanceFromBadGroup == maxPossibleDistance) {
                return false;
            }
            return DistanceFromGoodGroup <= DistanceFromBadGroup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Interval
    implements Comparable<Interval> {
        protected int mStartLoc;
        protected int mEndLoc;

        public Interval(int startLoc, int endLoc) {
            this.mStartLoc = startLoc;
            this.mEndLoc = endLoc;
        }

        public int getStartLoc() {
            return this.mStartLoc;
        }

        public int getEndLoc() {
            return this.mEndLoc;
        }

        @Override
        public int compareTo(Interval other) {
            if (this.mStartLoc < other.mStartLoc) {
                return -1;
            }
            if (this.mStartLoc > other.mStartLoc) {
                return 1;
            }
            if (this.mEndLoc < other.mEndLoc) {
                return -1;
            }
            if (this.mEndLoc > other.mEndLoc) {
                return 1;
            }
            return 0;
        }
    }
}

